/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources_Delegate;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableInflater;
import android.util.LruCache;
import android.view.InflateException;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.lang.reflect.Constructor;

public class DrawableInflater_Delegate {
    private static final LruCache<String, Constructor<? extends Drawable>> CONSTRUCTOR_MAP = new LruCache(20);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LayoutlibDelegate
    static Drawable inflateFromClass(DrawableInflater thisInflater, String className2) {
        try {
            Constructor<? extends Drawable> constructor;
            LruCache<String, Constructor<? extends Drawable>> lruCache = CONSTRUCTOR_MAP;
            synchronized (lruCache) {
                constructor = CONSTRUCTOR_MAP.get(className2);
                if (constructor == null) {
                    Class<Drawable> clazz = Resources_Delegate.getLayoutlibCallback(thisInflater.mRes).findClass(className2).asSubclass(Drawable.class);
                    constructor = clazz.getConstructor(new Class[0]);
                    CONSTRUCTOR_MAP.put(className2, constructor);
                }
            }
            return constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            InflateException ie = new InflateException("Error inflating class " + className2);
            ie.initCause(e);
            throw ie;
        }
        catch (ClassCastException e) {
            InflateException ie = new InflateException("Class is not a Drawable " + className2);
            ie.initCause(e);
            throw ie;
        }
        catch (ClassNotFoundException e) {
            InflateException ie = new InflateException("Class not found " + className2);
            ie.initCause(e);
            throw ie;
        }
        catch (Exception e) {
            InflateException ie = new InflateException("Error inflating class " + className2);
            ie.initCause(e);
            throw ie;
        }
    }

    public static void clearConstructorCache() {
        CONSTRUCTOR_MAP.evictAll();
    }
}

