/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.BlendMode;
import android.graphics.BlendModeColorFilter;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ImageDecoder;
import android.graphics.Insets;
import android.graphics.Matrix;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.Gravity;
import com.android.internal.R;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class BitmapDrawable
extends Drawable {
    private static final int DEFAULT_PAINT_FLAGS = 6;
    private static final int TILE_MODE_UNDEFINED = -2;
    private static final int TILE_MODE_DISABLED = -1;
    private static final int TILE_MODE_CLAMP = 0;
    private static final int TILE_MODE_REPEAT = 1;
    private static final int TILE_MODE_MIRROR = 2;
    private final Rect mDstRect = new Rect();
    @UnsupportedAppUsage
    private BitmapState mBitmapState;
    private BlendModeColorFilter mBlendModeFilter;
    private int mTargetDensity = 160;
    private boolean mDstRectAndInsetsDirty = true;
    private boolean mMutated;
    private int mBitmapWidth;
    private int mBitmapHeight;
    private Insets mOpticalInsets = Insets.NONE;
    private Matrix mMirrorMatrix;

    @Deprecated
    public BitmapDrawable() {
        this.init(new BitmapState((Bitmap)null), null);
    }

    @Deprecated
    public BitmapDrawable(Resources res) {
        this.init(new BitmapState((Bitmap)null), res);
    }

    @Deprecated
    public BitmapDrawable(Bitmap bitmap) {
        this.init(new BitmapState(bitmap), null);
    }

    public BitmapDrawable(Resources res, Bitmap bitmap) {
        this.init(new BitmapState(bitmap), res);
    }

    @Deprecated
    public BitmapDrawable(String filepath) {
        this(null, filepath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BitmapDrawable(Resources res, String filepath) {
        Bitmap bitmap = null;
        try {
            try (FileInputStream stream = new FileInputStream(filepath);){
                bitmap = ImageDecoder.decodeBitmap(ImageDecoder.createSource(res, stream), (decoder, info, src) -> decoder.setAllocator(1));
            }
            this.init(new BitmapState(bitmap), res);
            if (this.mBitmapState.mBitmap != null) return;
        }
        catch (Exception exception) {
            this.init(new BitmapState(bitmap), res);
            if (this.mBitmapState.mBitmap != null) return;
            Log.w("BitmapDrawable", "BitmapDrawable cannot decode " + filepath);
            return;
            catch (Throwable throwable) {
                this.init(new BitmapState(bitmap), res);
                if (this.mBitmapState.mBitmap != null) throw throwable;
                Log.w("BitmapDrawable", "BitmapDrawable cannot decode " + filepath);
                throw throwable;
            }
        }
        Log.w("BitmapDrawable", "BitmapDrawable cannot decode " + filepath);
        return;
    }

    @Deprecated
    public BitmapDrawable(InputStream is) {
        this(null, is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BitmapDrawable(Resources res, InputStream is) {
        Bitmap bitmap = null;
        try {
            bitmap = ImageDecoder.decodeBitmap(ImageDecoder.createSource(res, is), (decoder, info, src) -> decoder.setAllocator(1));
        }
        catch (Exception exception) {
        }
        finally {
            this.init(new BitmapState(bitmap), res);
            if (this.mBitmapState.mBitmap == null) {
                Log.w("BitmapDrawable", "BitmapDrawable cannot decode " + is);
            }
        }
    }

    public Paint getPaint() {
        return this.mBitmapState.mPaint;
    }

    public Bitmap getBitmap() {
        return this.mBitmapState.mBitmap;
    }

    private void computeBitmapSize() {
        Bitmap bitmap = this.mBitmapState.mBitmap;
        if (bitmap != null) {
            this.mBitmapWidth = bitmap.getScaledWidth(this.mTargetDensity);
            this.mBitmapHeight = bitmap.getScaledHeight(this.mTargetDensity);
        } else {
            this.mBitmapHeight = -1;
            this.mBitmapWidth = -1;
        }
    }

    public void setBitmap(Bitmap bitmap) {
        if (this.mBitmapState.mBitmap != bitmap) {
            this.mBitmapState.mBitmap = bitmap;
            this.computeBitmapSize();
            this.invalidateSelf();
        }
    }

    public void setTargetDensity(Canvas canvas) {
        this.setTargetDensity(canvas.getDensity());
    }

    public void setTargetDensity(DisplayMetrics metrics) {
        this.setTargetDensity(metrics.densityDpi);
    }

    public void setTargetDensity(int density) {
        if (this.mTargetDensity != density) {
            int n = this.mTargetDensity = density == 0 ? 160 : density;
            if (this.mBitmapState.mBitmap != null) {
                this.computeBitmapSize();
            }
            this.invalidateSelf();
        }
    }

    public int getGravity() {
        return this.mBitmapState.mGravity;
    }

    public void setGravity(int gravity) {
        if (this.mBitmapState.mGravity != gravity) {
            this.mBitmapState.mGravity = gravity;
            this.mDstRectAndInsetsDirty = true;
            this.invalidateSelf();
        }
    }

    public void setMipMap(boolean mipMap) {
        if (this.mBitmapState.mBitmap != null) {
            this.mBitmapState.mBitmap.setHasMipMap(mipMap);
            this.invalidateSelf();
        }
    }

    public boolean hasMipMap() {
        return this.mBitmapState.mBitmap != null && this.mBitmapState.mBitmap.hasMipMap();
    }

    public void setAntiAlias(boolean aa) {
        this.mBitmapState.mPaint.setAntiAlias(aa);
        this.invalidateSelf();
    }

    public boolean hasAntiAlias() {
        return this.mBitmapState.mPaint.isAntiAlias();
    }

    @Override
    public void setFilterBitmap(boolean filter2) {
        this.mBitmapState.mPaint.setFilterBitmap(filter2);
        this.invalidateSelf();
    }

    @Override
    public boolean isFilterBitmap() {
        return this.mBitmapState.mPaint.isFilterBitmap();
    }

    @Override
    public void setDither(boolean dither) {
        this.mBitmapState.mPaint.setDither(dither);
        this.invalidateSelf();
    }

    public Shader.TileMode getTileModeX() {
        return this.mBitmapState.mTileModeX;
    }

    public Shader.TileMode getTileModeY() {
        return this.mBitmapState.mTileModeY;
    }

    public void setTileModeX(Shader.TileMode mode) {
        this.setTileModeXY(mode, this.mBitmapState.mTileModeY);
    }

    public void setTileModeY(Shader.TileMode mode) {
        this.setTileModeXY(this.mBitmapState.mTileModeX, mode);
    }

    public void setTileModeXY(Shader.TileMode xmode, Shader.TileMode ymode) {
        BitmapState state = this.mBitmapState;
        if (state.mTileModeX != xmode || state.mTileModeY != ymode) {
            state.mTileModeX = xmode;
            state.mTileModeY = ymode;
            state.mRebuildShader = true;
            this.mDstRectAndInsetsDirty = true;
            this.invalidateSelf();
        }
    }

    @Override
    public void setAutoMirrored(boolean mirrored) {
        if (this.mBitmapState.mAutoMirrored != mirrored) {
            this.mBitmapState.mAutoMirrored = mirrored;
            this.invalidateSelf();
        }
    }

    @Override
    public boolean isAutoMirrored() {
        return this.mBitmapState.mAutoMirrored;
    }

    @Override
    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mBitmapState.getChangingConfigurations();
    }

    private boolean needMirroring() {
        return this.isAutoMirrored() && this.getLayoutDirection() == 1;
    }

    @Override
    protected void onBoundsChange(Rect bounds2) {
        this.mDstRectAndInsetsDirty = true;
        Bitmap bitmap = this.mBitmapState.mBitmap;
        Shader shader = this.mBitmapState.mPaint.getShader();
        if (bitmap != null && shader != null) {
            this.updateShaderMatrix(bitmap, this.mBitmapState.mPaint, shader, this.needMirroring());
        }
    }

    @Override
    public void draw(Canvas canvas) {
        boolean clearColorFilter;
        int restoreAlpha;
        Bitmap bitmap = this.mBitmapState.mBitmap;
        if (bitmap == null) {
            return;
        }
        BitmapState state = this.mBitmapState;
        Paint paint = state.mPaint;
        if (state.mRebuildShader) {
            Shader.TileMode tmx = state.mTileModeX;
            Shader.TileMode tmy = state.mTileModeY;
            if (tmx == null && tmy == null) {
                paint.setShader(null);
            } else {
                paint.setShader(new BitmapShader(bitmap, tmx == null ? Shader.TileMode.CLAMP : tmx, tmy == null ? Shader.TileMode.CLAMP : tmy));
            }
            state.mRebuildShader = false;
        }
        if (state.mBaseAlpha != 1.0f) {
            Paint p = this.getPaint();
            restoreAlpha = p.getAlpha();
            p.setAlpha((int)((float)restoreAlpha * state.mBaseAlpha + 0.5f));
        } else {
            restoreAlpha = -1;
        }
        if (this.mBlendModeFilter != null && paint.getColorFilter() == null) {
            paint.setColorFilter(this.mBlendModeFilter);
            clearColorFilter = true;
        } else {
            clearColorFilter = false;
        }
        this.updateDstRectAndInsetsIfDirty();
        Shader shader = paint.getShader();
        boolean needMirroring = this.needMirroring();
        if (shader == null) {
            if (needMirroring) {
                canvas.save();
                canvas.translate(this.mDstRect.right - this.mDstRect.left, 0.0f);
                canvas.scale(-1.0f, 1.0f);
            }
            canvas.drawBitmap(bitmap, null, this.mDstRect, paint);
            if (needMirroring) {
                canvas.restore();
            }
        } else {
            this.updateShaderMatrix(bitmap, paint, shader, needMirroring);
            canvas.drawRect(this.mDstRect, paint);
        }
        if (clearColorFilter) {
            paint.setColorFilter(null);
        }
        if (restoreAlpha >= 0) {
            paint.setAlpha(restoreAlpha);
        }
    }

    private void updateShaderMatrix(Bitmap bitmap, Paint paint, Shader shader, boolean needMirroring) {
        boolean needScaling;
        int sourceDensity = bitmap.getDensity();
        int targetDensity = this.mTargetDensity;
        boolean bl = needScaling = sourceDensity != 0 && sourceDensity != targetDensity;
        if (needScaling || needMirroring) {
            Matrix matrix = this.getOrCreateMirrorMatrix();
            matrix.reset();
            if (needMirroring) {
                int dx = this.mDstRect.right - this.mDstRect.left;
                matrix.setTranslate(dx, 0.0f);
                matrix.setScale(-1.0f, 1.0f);
            }
            if (needScaling) {
                float densityScale = (float)targetDensity / (float)sourceDensity;
                matrix.postScale(densityScale, densityScale);
            }
            shader.setLocalMatrix(matrix);
        } else {
            this.mMirrorMatrix = null;
            shader.setLocalMatrix(Matrix.IDENTITY_MATRIX);
        }
        paint.setShader(shader);
    }

    private Matrix getOrCreateMirrorMatrix() {
        if (this.mMirrorMatrix == null) {
            this.mMirrorMatrix = new Matrix();
        }
        return this.mMirrorMatrix;
    }

    private void updateDstRectAndInsetsIfDirty() {
        if (this.mDstRectAndInsetsDirty) {
            if (this.mBitmapState.mTileModeX == null && this.mBitmapState.mTileModeY == null) {
                Rect bounds2 = this.getBounds();
                int layoutDirection = this.getLayoutDirection();
                Gravity.apply(this.mBitmapState.mGravity, this.mBitmapWidth, this.mBitmapHeight, bounds2, this.mDstRect, layoutDirection);
                int left = this.mDstRect.left - bounds2.left;
                int top = this.mDstRect.top - bounds2.top;
                int right2 = bounds2.right - this.mDstRect.right;
                int bottom2 = bounds2.bottom - this.mDstRect.bottom;
                this.mOpticalInsets = Insets.of(left, top, right2, bottom2);
            } else {
                this.copyBounds(this.mDstRect);
                this.mOpticalInsets = Insets.NONE;
            }
        }
        this.mDstRectAndInsetsDirty = false;
    }

    @Override
    public Insets getOpticalInsets() {
        this.updateDstRectAndInsetsIfDirty();
        return this.mOpticalInsets;
    }

    @Override
    public void getOutline(Outline outline) {
        this.updateDstRectAndInsetsIfDirty();
        outline.setRect(this.mDstRect);
        boolean opaqueOverShape = this.mBitmapState.mBitmap != null && !this.mBitmapState.mBitmap.hasAlpha();
        outline.setAlpha(opaqueOverShape ? (float)this.getAlpha() / 255.0f : 0.0f);
    }

    @Override
    public void setAlpha(int alpha) {
        int oldAlpha = this.mBitmapState.mPaint.getAlpha();
        if (alpha != oldAlpha) {
            this.mBitmapState.mPaint.setAlpha(alpha);
            this.invalidateSelf();
        }
    }

    @Override
    public int getAlpha() {
        return this.mBitmapState.mPaint.getAlpha();
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        this.mBitmapState.mPaint.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    @Override
    public ColorFilter getColorFilter() {
        return this.mBitmapState.mPaint.getColorFilter();
    }

    @Override
    public void setTintList(ColorStateList tint) {
        BitmapState state = this.mBitmapState;
        if (state.mTint != tint) {
            state.mTint = tint;
            this.mBlendModeFilter = this.updateBlendModeFilter(this.mBlendModeFilter, tint, this.mBitmapState.mBlendMode);
            this.invalidateSelf();
        }
    }

    @Override
    public void setTintBlendMode(BlendMode blendMode) {
        BitmapState state = this.mBitmapState;
        if (state.mBlendMode != blendMode) {
            state.mBlendMode = blendMode;
            this.mBlendModeFilter = this.updateBlendModeFilter(this.mBlendModeFilter, this.mBitmapState.mTint, blendMode);
            this.invalidateSelf();
        }
    }

    @UnsupportedAppUsage
    private ColorStateList getTint() {
        return this.mBitmapState.mTint;
    }

    @UnsupportedAppUsage
    private PorterDuff.Mode getTintMode() {
        return BlendMode.blendModeToPorterDuffMode(this.mBitmapState.mBlendMode);
    }

    @Override
    public void setXfermode(Xfermode xfermode) {
        this.mBitmapState.mPaint.setXfermode(xfermode);
        this.invalidateSelf();
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mBitmapState = new BitmapState(this.mBitmapState);
            this.mMutated = true;
        }
        return this;
    }

    @Override
    public void clearMutated() {
        super.clearMutated();
        this.mMutated = false;
    }

    @Override
    protected boolean onStateChange(int[] stateSet) {
        BitmapState state = this.mBitmapState;
        if (state.mTint != null && state.mBlendMode != null) {
            this.mBlendModeFilter = this.updateBlendModeFilter(this.mBlendModeFilter, state.mTint, state.mBlendMode);
            return true;
        }
        return false;
    }

    @Override
    public boolean isStateful() {
        return this.mBitmapState.mTint != null && this.mBitmapState.mTint.isStateful() || super.isStateful();
    }

    @Override
    public boolean hasFocusStateSpecified() {
        return this.mBitmapState.mTint != null && this.mBitmapState.mTint.hasFocusStateSpecified();
    }

    @Override
    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        super.inflate(r, parser, attrs, theme);
        TypedArray a = BitmapDrawable.obtainAttributes(r, theme, attrs, R.styleable.BitmapDrawable);
        this.updateStateFromTypedArray(a, this.mSrcDensityOverride);
        this.verifyRequiredAttributes(a);
        a.recycle();
        this.updateLocalState(r);
    }

    private void verifyRequiredAttributes(TypedArray a) throws XmlPullParserException {
        BitmapState state = this.mBitmapState;
        if (state.mBitmap == null && (state.mThemeAttrs == null || state.mThemeAttrs[1] == 0)) {
            throw new XmlPullParserException(a.getPositionDescription() + ": <bitmap> requires a valid 'src' attribute");
        }
    }

    private void updateStateFromTypedArray(TypedArray a, int srcDensityOverride) throws XmlPullParserException {
        int tileModeY;
        int tileModeX;
        ColorStateList tint;
        Resources r = a.getResources();
        BitmapState state = this.mBitmapState;
        state.mChangingConfigurations |= a.getChangingConfigurations();
        state.mThemeAttrs = a.extractThemeAttrs();
        state.mSrcDensityOverride = srcDensityOverride;
        state.mTargetDensity = Drawable.resolveDensity(r, 0);
        int srcResId = a.getResourceId(1, 0);
        if (srcResId != 0) {
            TypedValue value2 = new TypedValue();
            r.getValueForDensity(srcResId, srcDensityOverride, value2, true);
            if (srcDensityOverride > 0 && value2.density > 0 && value2.density != 65535) {
                value2.density = value2.density == srcDensityOverride ? r.getDisplayMetrics().densityDpi : value2.density * r.getDisplayMetrics().densityDpi / srcDensityOverride;
            }
            int density = 0;
            if (value2.density == 0) {
                density = 160;
            } else if (value2.density != 65535) {
                density = value2.density;
            }
            Bitmap bitmap = null;
            try (InputStream is2 = r.openRawResource(srcResId, value2);){
                ImageDecoder.Source source = ImageDecoder.createSource(r, is2, density);
                bitmap = ImageDecoder.decodeBitmap(source, (decoder, info, src) -> decoder.setAllocator(1));
            }
            catch (Exception is2) {
                // empty catch block
            }
            if (bitmap == null) {
                throw new XmlPullParserException(a.getPositionDescription() + ": <bitmap> requires a valid 'src' attribute");
            }
            state.mBitmap = bitmap;
        }
        boolean defMipMap = state.mBitmap != null ? state.mBitmap.hasMipMap() : false;
        this.setMipMap(a.getBoolean(8, defMipMap));
        state.mAutoMirrored = a.getBoolean(9, state.mAutoMirrored);
        state.mBaseAlpha = a.getFloat(7, state.mBaseAlpha);
        int tintMode = a.getInt(10, -1);
        if (tintMode != -1) {
            state.mBlendMode = Drawable.parseBlendMode(tintMode, BlendMode.SRC_IN);
        }
        if ((tint = a.getColorStateList(5)) != null) {
            state.mTint = tint;
        }
        Paint paint = this.mBitmapState.mPaint;
        paint.setAntiAlias(a.getBoolean(2, paint.isAntiAlias()));
        paint.setFilterBitmap(a.getBoolean(3, paint.isFilterBitmap()));
        paint.setDither(a.getBoolean(4, paint.isDither()));
        this.setGravity(a.getInt(0, state.mGravity));
        int tileMode = a.getInt(6, -2);
        if (tileMode != -2) {
            Shader.TileMode mode = BitmapDrawable.parseTileMode(tileMode);
            this.setTileModeXY(mode, mode);
        }
        if ((tileModeX = a.getInt(11, -2)) != -2) {
            this.setTileModeX(BitmapDrawable.parseTileMode(tileModeX));
        }
        if ((tileModeY = a.getInt(12, -2)) != -2) {
            this.setTileModeY(BitmapDrawable.parseTileMode(tileModeY));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyTheme(Resources.Theme t) {
        super.applyTheme(t);
        BitmapState state = this.mBitmapState;
        if (state == null) {
            return;
        }
        if (state.mThemeAttrs != null) {
            TypedArray a = t.resolveAttributes(state.mThemeAttrs, R.styleable.BitmapDrawable);
            try {
                this.updateStateFromTypedArray(a, state.mSrcDensityOverride);
            }
            catch (XmlPullParserException e) {
                BitmapDrawable.rethrowAsRuntimeException((Exception)((Object)e));
            }
            finally {
                a.recycle();
            }
        }
        if (state.mTint != null && state.mTint.canApplyTheme()) {
            state.mTint = state.mTint.obtainForTheme(t);
        }
        this.updateLocalState(t.getResources());
    }

    private static Shader.TileMode parseTileMode(int tileMode) {
        switch (tileMode) {
            case 0: {
                return Shader.TileMode.CLAMP;
            }
            case 1: {
                return Shader.TileMode.REPEAT;
            }
            case 2: {
                return Shader.TileMode.MIRROR;
            }
        }
        return null;
    }

    @Override
    public boolean canApplyTheme() {
        return this.mBitmapState != null && this.mBitmapState.canApplyTheme();
    }

    @Override
    public int getIntrinsicWidth() {
        return this.mBitmapWidth;
    }

    @Override
    public int getIntrinsicHeight() {
        return this.mBitmapHeight;
    }

    @Override
    public int getOpacity() {
        if (this.mBitmapState.mGravity != 119) {
            return -3;
        }
        Bitmap bitmap = this.mBitmapState.mBitmap;
        return bitmap == null || bitmap.hasAlpha() || this.mBitmapState.mPaint.getAlpha() < 255 ? -3 : -1;
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        this.mBitmapState.mChangingConfigurations |= this.getChangingConfigurations();
        return this.mBitmapState;
    }

    private BitmapDrawable(BitmapState state, Resources res) {
        this.init(state, res);
    }

    private void init(BitmapState state, Resources res) {
        this.mBitmapState = state;
        this.updateLocalState(res);
        if (this.mBitmapState != null && res != null) {
            this.mBitmapState.mTargetDensity = this.mTargetDensity;
        }
    }

    private void updateLocalState(Resources res) {
        this.mTargetDensity = BitmapDrawable.resolveDensity(res, this.mBitmapState.mTargetDensity);
        this.mBlendModeFilter = this.updateBlendModeFilter(this.mBlendModeFilter, this.mBitmapState.mTint, this.mBitmapState.mBlendMode);
        this.computeBitmapSize();
    }

    static class BitmapState
    extends Drawable.ConstantState {
        final Paint mPaint;
        int[] mThemeAttrs = null;
        Bitmap mBitmap = null;
        ColorStateList mTint = null;
        BlendMode mBlendMode = Drawable.DEFAULT_BLEND_MODE;
        int mGravity = 119;
        float mBaseAlpha = 1.0f;
        Shader.TileMode mTileModeX = null;
        Shader.TileMode mTileModeY = null;
        int mSrcDensityOverride = 0;
        int mTargetDensity = 160;
        boolean mAutoMirrored = false;
        int mChangingConfigurations;
        boolean mRebuildShader;

        BitmapState(Bitmap bitmap) {
            this.mBitmap = bitmap;
            this.mPaint = new Paint(6);
        }

        BitmapState(BitmapState bitmapState) {
            this.mBitmap = bitmapState.mBitmap;
            this.mTint = bitmapState.mTint;
            this.mBlendMode = bitmapState.mBlendMode;
            this.mThemeAttrs = bitmapState.mThemeAttrs;
            this.mChangingConfigurations = bitmapState.mChangingConfigurations;
            this.mGravity = bitmapState.mGravity;
            this.mTileModeX = bitmapState.mTileModeX;
            this.mTileModeY = bitmapState.mTileModeY;
            this.mSrcDensityOverride = bitmapState.mSrcDensityOverride;
            this.mTargetDensity = bitmapState.mTargetDensity;
            this.mBaseAlpha = bitmapState.mBaseAlpha;
            this.mPaint = new Paint(bitmapState.mPaint);
            this.mRebuildShader = bitmapState.mRebuildShader;
            this.mAutoMirrored = bitmapState.mAutoMirrored;
        }

        @Override
        public boolean canApplyTheme() {
            return this.mThemeAttrs != null || this.mTint != null && this.mTint.canApplyTheme();
        }

        @Override
        public Drawable newDrawable() {
            return new BitmapDrawable(this, null);
        }

        @Override
        public Drawable newDrawable(Resources res) {
            return new BitmapDrawable(this, res);
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConfigurations | (this.mTint != null ? this.mTint.getChangingConfigurations() : 0);
        }
    }
}

