/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.res.AssetManager;
import android.content.res.FontResourcesParser;
import android.graphics.FontFamily;
import android.graphics.Typeface_Builder_Delegate;
import android.graphics.Typeface_Delegate;
import android.graphics.fonts.Font;
import android.graphics.fonts.FontFamily;
import android.graphics.fonts.FontStyle;
import android.graphics.fonts.FontVariationAxis;
import android.graphics.fonts.SystemFonts;
import android.icu.util.ULocale;
import android.os.ParcelFileDescriptor;
import android.os.SharedMemory;
import android.os.SystemProperties;
import android.os.Trace;
import android.provider.FontRequest;
import android.provider.FontsContract;
import android.system.ErrnoException;
import android.system.OsConstants;
import android.text.FontConfig;
import android.util.ArrayMap;
import android.util.Base64;
import android.util.Log;
import android.util.LongSparseArray;
import android.util.LruCache;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import dalvik.annotation.optimization.CriticalNative;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import libcore.util.NativeAllocationRegistry;

public class Typeface {
    private static String TAG;
    public static boolean ENABLE_LAZY_TYPEFACE_INITIALIZATION = true;
    private static NativeAllocationRegistry sRegistry;
    public static Typeface DEFAULT;
    public static Typeface DEFAULT_BOLD;
    public static Typeface SANS_SERIF;
    public static Typeface SERIF;
    public static Typeface MONOSPACE;
    @GuardedBy(value={"SYSTEM_FONT_MAP_LOCK"})
    @UnsupportedAppUsage(trackingBug=123769446L)
    static Typeface[] sDefaults;
    @GuardedBy(value={"sStyledCacheLock"})
    private static LongSparseArray<SparseArray<Typeface>> sStyledTypefaceCache;
    private static Object sStyledCacheLock;
    @GuardedBy(value={"sWeightCacheLock"})
    private static LongSparseArray<SparseArray<Typeface>> sWeightTypefaceCache;
    private static Object sWeightCacheLock;
    @GuardedBy(value={"sDynamicCacheLock"})
    public static LruCache<String, Typeface> sDynamicTypefaceCache;
    private static Object sDynamicCacheLock;
    @GuardedBy(value={"SYSTEM_FONT_MAP_LOCK"})
    static Typeface sDefaultTypeface;
    @GuardedBy(value={"SYSTEM_FONT_MAP_LOCK"})
    @UnsupportedAppUsage(trackingBug=123769347L)
    static Map<String, Typeface> sSystemFontMap;
    static ByteBuffer sSystemFontMapBuffer;
    static SharedMemory sSystemFontMapSharedMemory;
    private static Object SYSTEM_FONT_MAP_LOCK;
    @Deprecated
    @UnsupportedAppUsage(trackingBug=123768928L)
    static Map<String, FontFamily[]> sSystemFallbackMap;
    @UnsupportedAppUsage
    public final long native_instance;
    private final Runnable mCleaner;
    public static int NORMAL = 0;
    public static int BOLD = 1;
    public static int ITALIC = 2;
    public static int BOLD_ITALIC = 3;
    public static int STYLE_MASK = 3;
    @UnsupportedAppUsage
    private final int mStyle;
    private final int mWeight;
    public static int RESOLVE_BY_FONT_TABLE = -1;
    public static String DEFAULT_FAMILY = "sans-serif";
    private static int STYLE_NORMAL = 0;
    private static int STYLE_ITALIC = 1;
    @GuardedBy(value={"this"})
    private int[] mSupportedAxes;
    private static int[] EMPTY_AXES;

    public static SharedMemory getSystemFontMapSharedMemory() {
        Objects.requireNonNull(sSystemFontMapSharedMemory);
        return sSystemFontMapSharedMemory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=28)
    private static void setDefault(Typeface t) {
        Object object = SYSTEM_FONT_MAP_LOCK;
        synchronized (object) {
            sDefaultTypeface = t;
            Typeface.nativeSetDefault(t.native_instance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Typeface getDefault() {
        Object object = SYSTEM_FONT_MAP_LOCK;
        synchronized (object) {
            return sDefaultTypeface;
        }
    }

    public int getWeight() {
        return this.mWeight;
    }

    public int getStyle() {
        return this.mStyle;
    }

    public final boolean isBold() {
        return (this.mStyle & 1) != 0;
    }

    public final boolean isItalic() {
        return (this.mStyle & 2) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasFontFamily(String familyName) {
        Objects.requireNonNull(familyName, "familyName cannot be null");
        Object object = SYSTEM_FONT_MAP_LOCK;
        synchronized (object) {
            return sSystemFontMap.containsKey(familyName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Typeface createFromResources(FontResourcesParser.FamilyResourceEntry entry, AssetManager mgr, String path) {
        if (entry instanceof FontResourcesParser.ProviderResourceEntry) {
            FontRequest request;
            Typeface typeface;
            FontResourcesParser.ProviderResourceEntry providerEntry = (FontResourcesParser.ProviderResourceEntry)entry;
            String systemFontFamilyName = providerEntry.getSystemFontFamilyName();
            if (systemFontFamilyName != null && Typeface.hasFontFamily(systemFontFamilyName)) {
                return Typeface.create(systemFontFamilyName, 0);
            }
            List<List<String>> givenCerts = providerEntry.getCerts();
            ArrayList<List<byte[]>> certs = new ArrayList<List<byte[]>>();
            if (givenCerts != null) {
                for (int i = 0; i < givenCerts.size(); ++i) {
                    List<String> certSet = givenCerts.get(i);
                    ArrayList<byte[]> byteArraySet = new ArrayList<byte[]>();
                    for (int j = 0; j < certSet.size(); ++j) {
                        byteArraySet.add(Base64.decode(certSet.get(j), 0));
                    }
                    certs.add(byteArraySet);
                }
            }
            return (typeface = FontsContract.getFontSync(request = new FontRequest(providerEntry.getAuthority(), providerEntry.getPackage(), providerEntry.getQuery(), certs))) == null ? DEFAULT : typeface;
        }
        Typeface typeface = Typeface.findFromCache(mgr, path);
        if (typeface != null) {
            return typeface;
        }
        FontResourcesParser.FontFamilyFilesResourceEntry filesEntry = (FontResourcesParser.FontFamilyFilesResourceEntry)entry;
        try {
            FontFamily.Builder familyBuilder = null;
            for (FontResourcesParser.FontFileResourceEntry fontFile : filesEntry.getEntries()) {
                Font.Builder fontBuilder = new Font.Builder(mgr, fontFile.getFileName(), false, 0).setTtcIndex(fontFile.getTtcIndex()).setFontVariationSettings(fontFile.getVariationSettings());
                if (fontFile.getWeight() != -1) {
                    fontBuilder.setWeight(fontFile.getWeight());
                }
                if (fontFile.getItalic() != -1) {
                    fontBuilder.setSlant(fontFile.getItalic() == 1 ? 1 : 0);
                }
                if (familyBuilder == null) {
                    familyBuilder = new FontFamily.Builder(fontBuilder.build());
                    continue;
                }
                familyBuilder.addFont(fontBuilder.build());
            }
            if (familyBuilder == null) {
                return DEFAULT;
            }
            android.graphics.fonts.FontFamily family = familyBuilder.build();
            FontStyle normal = new FontStyle(400, 0);
            Font bestFont = family.getFont(0);
            int bestScore = normal.getMatchScore(bestFont.getStyle());
            for (int i = 1; i < family.getSize(); ++i) {
                Font candidate = family.getFont(i);
                int score = normal.getMatchScore(candidate.getStyle());
                if (score >= bestScore) continue;
                bestFont = candidate;
                bestScore = score;
            }
            typeface = new CustomFallbackBuilder(family).setStyle(bestFont.getStyle()).build();
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (IOException e) {
            typeface = DEFAULT;
        }
        Object object = sDynamicCacheLock;
        synchronized (object) {
            String key = Builder.createAssetUid(mgr, path, 0, null, -1, -1, "sans-serif");
            sDynamicTypefaceCache.put(key, typeface);
        }
        return typeface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Typeface findFromCache(AssetManager mgr, String path) {
        Object object = sDynamicCacheLock;
        synchronized (object) {
            String key = Builder.createAssetUid(mgr, path, 0, null, -1, -1, "sans-serif");
            Typeface typeface = sDynamicTypefaceCache.get(key);
            if (typeface != null) {
                return typeface;
            }
        }
        return null;
    }

    public static Typeface create_Original(String familyName, int style2) {
        return Typeface.create(Typeface.getSystemDefaultTypeface(familyName), style2);
    }

    @LayoutlibDelegate
    public static Typeface create(String string2, int n) {
        return Typeface_Delegate.create(string2, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Typeface create_Original(Typeface family, int style2) {
        Typeface typeface;
        if ((style2 & 0xFFFFFFFC) != 0) {
            style2 = 0;
        }
        if (family == null) {
            family = Typeface.getDefault();
        }
        if (family.mStyle == style2) {
            return family;
        }
        long ni = family.native_instance;
        Object object = sStyledCacheLock;
        synchronized (object) {
            SparseArray<Typeface> styles2 = sStyledTypefaceCache.get(ni);
            if (styles2 == null) {
                styles2 = new SparseArray(4);
                sStyledTypefaceCache.put(ni, styles2);
            } else {
                typeface = styles2.get(style2);
                if (typeface != null) {
                    return typeface;
                }
            }
            typeface = new Typeface(Typeface.nativeCreateFromTypeface(ni, style2));
            styles2.put(style2, typeface);
        }
        return typeface;
    }

    @LayoutlibDelegate
    public static Typeface create(Typeface typeface, int n) {
        return Typeface_Delegate.create(typeface, n);
    }

    public static Typeface create_Original(Typeface family, int weight, boolean italic) {
        Preconditions.checkArgumentInRange(weight, 0, 1000, "weight");
        if (family == null) {
            family = Typeface.getDefault();
        }
        return Typeface.createWeightStyle(family, weight, italic);
    }

    @LayoutlibDelegate
    public static Typeface create(Typeface typeface, int n, boolean bl) {
        return Typeface_Delegate.create(typeface, n, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Typeface createWeightStyle(Typeface base, int weight, boolean italic) {
        Typeface typeface;
        int key = weight << 1 | (italic ? 1 : 0);
        Object object = sWeightCacheLock;
        synchronized (object) {
            SparseArray<Typeface> innerCache = sWeightTypefaceCache.get(base.native_instance);
            if (innerCache == null) {
                innerCache = new SparseArray(4);
                sWeightTypefaceCache.put(base.native_instance, innerCache);
            } else {
                typeface = innerCache.get(key);
                if (typeface != null) {
                    return typeface;
                }
            }
            typeface = new Typeface(Typeface.nativeCreateFromTypefaceWithExactStyle(base.native_instance, weight, italic));
            innerCache.put(key, typeface);
        }
        return typeface;
    }

    public static Typeface createFromTypefaceWithVariation(Typeface family, List<FontVariationAxis> axes) {
        Typeface base = family == null ? DEFAULT : family;
        return new Typeface(Typeface.nativeCreateFromTypefaceWithVariation(base.native_instance, axes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Typeface defaultFromStyle(int style2) {
        Object object = SYSTEM_FONT_MAP_LOCK;
        synchronized (object) {
            return sDefaults[style2];
        }
    }

    public static Typeface createFromAsset(AssetManager mgr, String path) {
        Preconditions.checkNotNull(path);
        Preconditions.checkNotNull(mgr);
        Typeface typeface = new Builder(mgr, path).build();
        if (typeface != null) {
            return typeface;
        }
        try {
            InputStream inputStream = mgr.open(path);
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Font asset not found " + path);
        }
        return DEFAULT;
    }

    private static String createProviderUid(String authority, String query) {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("provider:");
        builder2.append(authority);
        builder2.append("-");
        builder2.append(query);
        return builder2.toString();
    }

    public static Typeface createFromFile(File file2) {
        Typeface typeface = new Builder(file2).build();
        if (typeface != null) {
            return typeface;
        }
        if (!file2.exists()) {
            throw new RuntimeException("Font asset not found " + file2.getAbsolutePath());
        }
        return DEFAULT;
    }

    public static Typeface createFromFile(String path) {
        Preconditions.checkNotNull(path);
        return Typeface.createFromFile(new File(path));
    }

    @Deprecated
    @UnsupportedAppUsage(trackingBug=123768928L)
    private static Typeface createFromFamilies(FontFamily[] families) {
        long[] ptrArray = new long[families.length];
        for (int i = 0; i < families.length; ++i) {
            ptrArray[i] = families[i].mNativePtr;
        }
        return new Typeface(Typeface.nativeCreateFromArray(ptrArray, 0L, -1, -1));
    }

    private static Typeface createFromFamilies(android.graphics.fonts.FontFamily[] families) {
        long[] ptrArray = new long[families.length];
        for (int i = 0; i < families.length; ++i) {
            ptrArray[i] = families[i].getNativePtr();
        }
        return new Typeface(Typeface.nativeCreateFromArray(ptrArray, 0L, -1, -1));
    }

    @Deprecated
    @UnsupportedAppUsage(trackingBug=123768395L)
    private static Typeface createFromFamiliesWithDefault(FontFamily[] families, int weight, int italic) {
        return Typeface.createFromFamiliesWithDefault(families, "sans-serif", weight, italic);
    }

    @Deprecated
    @UnsupportedAppUsage(trackingBug=123768928L)
    private static Typeface createFromFamiliesWithDefault(FontFamily[] families, String fallbackName, int weight, int italic) {
        Typeface fallbackTypeface = Typeface.getSystemDefaultTypeface(fallbackName);
        long[] ptrArray = new long[families.length];
        for (int i = 0; i < families.length; ++i) {
            ptrArray[i] = families[i].mNativePtr;
        }
        return new Typeface(Typeface.nativeCreateFromArray(ptrArray, fallbackTypeface.native_instance, weight, italic));
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private Typeface(long ni) {
        if (ni == 0L) {
            throw new RuntimeException("native typeface cannot be made");
        }
        this.native_instance = ni;
        this.mCleaner = sRegistry.registerNativeAllocation(this, this.native_instance);
        this.mStyle = Typeface.nativeGetStyle(ni);
        this.mWeight = Typeface.nativeGetWeight(ni);
    }

    private static Typeface getSystemDefaultTypeface(String familyName) {
        Typeface tf = sSystemFontMap.get(familyName);
        return tf == null ? DEFAULT : tf;
    }

    @VisibleForTesting
    public static void initSystemDefaultTypefaces(Map<String, android.graphics.fonts.FontFamily[]> fallbacks, List<FontConfig.Alias> aliases, Map<String, Typeface> outSystemFontMap) {
        for (Map.Entry<String, android.graphics.fonts.FontFamily[]> entry : fallbacks.entrySet()) {
            outSystemFontMap.put(entry.getKey(), Typeface.createFromFamilies(entry.getValue()));
        }
        for (int i = 0; i < aliases.size(); ++i) {
            Typeface base;
            FontConfig.Alias alias = aliases.get(i);
            if (outSystemFontMap.containsKey(alias.getName()) || (base = outSystemFontMap.get(alias.getOriginal())) == null) continue;
            int weight = alias.getWeight();
            Typeface newFace = weight == 400 ? base : new Typeface(Typeface.nativeCreateWeightAlias(base.native_instance, weight));
            outSystemFontMap.put(alias.getName(), newFace);
        }
    }

    private static void registerGenericFamilyNative(String familyName, Typeface typeface) {
        if (typeface != null) {
            Typeface.nativeRegisterGenericFamily(familyName, typeface.native_instance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SharedMemory serializeFontMap(Map<String, Typeface> fontMap) throws IOException, ErrnoException {
        long[] nativePtrs = new long[fontMap.size()];
        ByteArrayOutputStream namesBytes = new ByteArrayOutputStream();
        int i = 0;
        for (Map.Entry<String, Typeface> entry : fontMap.entrySet()) {
            nativePtrs[i++] = entry.getValue().native_instance;
            Typeface.writeString(namesBytes, entry.getKey());
        }
        int typefacesBytesCount = Typeface.nativeWriteTypefaces(null, nativePtrs);
        SharedMemory sharedMemory = SharedMemory.create("fontMap", 4 + typefacesBytesCount + namesBytes.size());
        ByteBuffer writableBuffer = sharedMemory.mapReadWrite().order(ByteOrder.BIG_ENDIAN);
        try {
            writableBuffer.putInt(typefacesBytesCount);
            int writtenBytesCount = Typeface.nativeWriteTypefaces(writableBuffer.slice(), nativePtrs);
            if (writtenBytesCount != typefacesBytesCount) {
                throw new IOException(String.format("Unexpected bytes written: %d, expected: %d", writtenBytesCount, typefacesBytesCount));
            }
            writableBuffer.position(writableBuffer.position() + writtenBytesCount);
            writableBuffer.put(namesBytes.toByteArray());
        }
        finally {
            SharedMemory.unmap(writableBuffer);
        }
        sharedMemory.setProtect(OsConstants.PROT_READ);
        return sharedMemory;
    }

    public static long[] deserializeFontMap(ByteBuffer buffer, Map<String, Typeface> out) throws IOException {
        int typefacesBytesCount = buffer.getInt();
        long[] nativePtrs = Typeface.nativeReadTypefaces(buffer.slice());
        if (nativePtrs == null) {
            throw new IOException("Could not read typefaces");
        }
        out.clear();
        buffer.position(buffer.position() + typefacesBytesCount);
        for (long nativePtr : nativePtrs) {
            String name = Typeface.readString(buffer);
            out.put(name, new Typeface(nativePtr));
        }
        return nativePtrs;
    }

    private static String readString(ByteBuffer buffer) {
        int length = buffer.getInt();
        byte[] bytes = new byte[length];
        buffer.get(bytes);
        return new String(bytes);
    }

    private static void writeString(ByteArrayOutputStream bos, String value2) throws IOException {
        byte[] bytes = value2.getBytes();
        Typeface.writeInt(bos, bytes.length);
        bos.write(bytes);
    }

    private static void writeInt(ByteArrayOutputStream bos, int value2) {
        bos.write(value2 >> 24 & 0xFF);
        bos.write(value2 >> 16 & 0xFF);
        bos.write(value2 >> 8 & 0xFF);
        bos.write(value2 & 0xFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Typeface> getSystemFontMap() {
        Object object = SYSTEM_FONT_MAP_LOCK;
        synchronized (object) {
            return sSystemFontMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSystemFontMap(SharedMemory sharedMemory) throws IOException, ErrnoException {
        if (sSystemFontMapBuffer != null) {
            if (sharedMemory == null || sharedMemory == sSystemFontMapSharedMemory) {
                return;
            }
            throw new UnsupportedOperationException("Once set, buffer-based system font map cannot be updated");
        }
        sSystemFontMapSharedMemory = sharedMemory;
        Trace.traceBegin(2L, "setSystemFontMap");
        try {
            long[] nativePtrs;
            if (sharedMemory == null) {
                Typeface.loadPreinstalledSystemFontMap();
                return;
            }
            sSystemFontMapBuffer = sharedMemory.mapReadOnly().order(ByteOrder.BIG_ENDIAN);
            ArrayMap<String, Typeface> systemFontMap = new ArrayMap<String, Typeface>();
            for (long ptr : nativePtrs = Typeface.deserializeFontMap(sSystemFontMapBuffer, systemFontMap)) {
                Typeface.nativeAddFontCollections(ptr);
            }
            Typeface.setSystemFontMap(systemFontMap);
        }
        finally {
            Trace.traceEnd(2L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static void setSystemFontMap(Map<String, Typeface> systemFontMap) {
        Object object = SYSTEM_FONT_MAP_LOCK;
        synchronized (object) {
            String[] genericFamilies;
            sSystemFontMap.clear();
            sSystemFontMap.putAll(systemFontMap);
            if (sSystemFontMap.containsKey("sans-serif")) {
                Typeface.setDefault(sSystemFontMap.get("sans-serif"));
            }
            Typeface.nativeForceSetStaticFinalField("DEFAULT", Typeface.create(sDefaultTypeface, 0));
            Typeface.nativeForceSetStaticFinalField("DEFAULT_BOLD", Typeface.create(sDefaultTypeface, 1));
            Typeface.nativeForceSetStaticFinalField("SANS_SERIF", Typeface.create("sans-serif", 0));
            Typeface.nativeForceSetStaticFinalField("SERIF", Typeface.create("serif", 0));
            Typeface.nativeForceSetStaticFinalField("MONOSPACE", Typeface.create("monospace", 0));
            sDefaults = new Typeface[]{DEFAULT, DEFAULT_BOLD, Typeface.create((String)null, 2), Typeface.create((String)null, 3)};
            for (String genericFamily : genericFamilies = new String[]{"serif", "sans-serif", "cursive", "fantasy", "monospace", "system-ui"}) {
                Typeface.registerGenericFamilyNative(genericFamily, systemFontMap.get(genericFamily));
            }
        }
    }

    private static void preloadFontFile(String filePath) {
        File file2 = new File(filePath);
        if (file2.exists()) {
            Log.i(TAG, "Preloading " + file2.getAbsolutePath());
            Typeface.nativeWarmUpCache(filePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static void destroySystemFontMap() {
        Object object = SYSTEM_FONT_MAP_LOCK;
        synchronized (object) {
            for (Typeface typeface : sSystemFontMap.values()) {
                typeface.mCleaner.run();
            }
            sSystemFontMap.clear();
            if (sSystemFontMapBuffer != null) {
                SharedMemory.unmap(sSystemFontMapBuffer);
            }
            sSystemFontMapBuffer = null;
            sSystemFontMapSharedMemory = null;
        }
    }

    public static void loadPreinstalledSystemFontMap() {
        FontConfig fontConfig = SystemFonts.getSystemPreinstalledFontConfig();
        Map<String, android.graphics.fonts.FontFamily[]> fallback = SystemFonts.buildSystemFallback(fontConfig);
        Map<String, Typeface> typefaceMap = SystemFonts.buildSystemTypefaces(fontConfig, fallback);
        Typeface.setSystemFontMap(typefaceMap);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Typeface typeface = (Typeface)o;
        return this.mStyle == typeface.mStyle && this.native_instance == typeface.native_instance;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (int)(this.native_instance ^ this.native_instance >>> 32);
        result = 31 * result + this.mStyle;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSupportedAxes(int axis) {
        Typeface typeface = this;
        synchronized (typeface) {
            if (this.mSupportedAxes == null) {
                this.mSupportedAxes = Typeface.nativeGetSupportedAxes(this.native_instance);
                if (this.mSupportedAxes == null) {
                    this.mSupportedAxes = EMPTY_AXES;
                }
            }
        }
        return Arrays.binarySearch(this.mSupportedAxes, axis) >= 0;
    }

    public List<android.graphics.fonts.FontFamily> getFallback() {
        ArrayList<android.graphics.fonts.FontFamily> families = new ArrayList<android.graphics.fonts.FontFamily>();
        int familySize = Typeface.nativeGetFamilySize(this.native_instance);
        for (int i = 0; i < familySize; ++i) {
            families.add(new android.graphics.fonts.FontFamily(Typeface.nativeGetFamily(this.native_instance, i)));
        }
        return families;
    }

    private static native long nativeCreateFromTypeface(long var0, int var2);

    private static native long nativeCreateFromTypefaceWithExactStyle(long var0, int var2, boolean var3);

    private static native long nativeCreateFromTypefaceWithVariation(long var0, List<FontVariationAxis> var2);

    @UnsupportedAppUsage
    private static native long nativeCreateWeightAlias(long var0, int var2);

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private static native long nativeCreateFromArray(long[] var0, long var1, int var3, int var4);

    private static native int[] nativeGetSupportedAxes(long var0);

    @CriticalNative
    private static native void nativeSetDefault(long var0);

    @CriticalNative
    private static native int nativeGetStyle(long var0);

    @CriticalNative
    private static native int nativeGetWeight(long var0);

    @CriticalNative
    private static native long nativeGetReleaseFunc();

    @CriticalNative
    private static native int nativeGetFamilySize(long var0);

    @CriticalNative
    private static native long nativeGetFamily(long var0, int var2);

    private static native void nativeRegisterGenericFamily(String var0, long var1);

    private static native int nativeWriteTypefaces(ByteBuffer var0, long[] var1);

    private static native long[] nativeReadTypefaces(ByteBuffer var0);

    private static native void nativeForceSetStaticFinalField(String var0, Typeface var1);

    @CriticalNative
    private static native void nativeAddFontCollections(long var0);

    private static native void nativeWarmUpCache(String var0);

    public static void deferredStaticInitializer() {
        TAG = "Typeface";
        sRegistry = NativeAllocationRegistry.createMalloced(Typeface.class.getClassLoader(), Typeface.nativeGetReleaseFunc());
        DEFAULT = null;
        DEFAULT_BOLD = null;
        SANS_SERIF = null;
        SERIF = null;
        MONOSPACE = null;
        sStyledTypefaceCache = new LongSparseArray(3);
        sStyledCacheLock = new Object();
        sWeightTypefaceCache = new LongSparseArray(3);
        sWeightCacheLock = new Object();
        sDynamicTypefaceCache = new LruCache(16);
        sDynamicCacheLock = new Object();
        sSystemFontMap = new ArrayMap<String, Typeface>();
        sSystemFontMapBuffer = null;
        sSystemFontMapSharedMemory = null;
        SYSTEM_FONT_MAP_LOCK = new Object();
        sSystemFallbackMap = Collections.emptyMap();
        EMPTY_AXES = new int[0];
        Typeface.preloadFontFile("/system/fonts/Roboto-Regular.ttf");
        Typeface.preloadFontFile("/system/fonts/RobotoStatic-Regular.ttf");
        String locale = SystemProperties.get("persist.sys.locale", "en-US");
        String script = ULocale.addLikelySubtags(ULocale.forLanguageTag(locale)).getScript();
        FontConfig config = SystemFonts.getSystemPreinstalledFontConfig();
        for (int i = 0; i < config.getFontFamilies().size(); ++i) {
            String fontScript;
            int j;
            FontConfig.FontFamily family = config.getFontFamilies().get(i);
            boolean loadFamily = false;
            for (j = 0; j < family.getLocaleList().size() && !(loadFamily = (fontScript = ULocale.addLikelySubtags(ULocale.forLocale(family.getLocaleList().get(j))).getScript()).equals(script)); ++j) {
            }
            if (!loadFamily) continue;
            for (j = 0; j < family.getFontList().size(); ++j) {
                Typeface.preloadFontFile(family.getFontList().get(j).getFile().getAbsolutePath());
            }
        }
    }

    public static class CustomFallbackBuilder {
        private static final int MAX_CUSTOM_FALLBACK = 64;
        private final ArrayList<android.graphics.fonts.FontFamily> mFamilies = new ArrayList();
        private String mFallbackName = null;
        private FontStyle mStyle;

        public static int getMaxCustomFallbackCount() {
            return 64;
        }

        public CustomFallbackBuilder(android.graphics.fonts.FontFamily family) {
            Preconditions.checkNotNull(family);
            this.mFamilies.add(family);
        }

        public CustomFallbackBuilder setSystemFallback(String familyName) {
            Preconditions.checkNotNull(familyName);
            this.mFallbackName = familyName;
            return this;
        }

        public CustomFallbackBuilder setStyle(FontStyle style2) {
            this.mStyle = style2;
            return this;
        }

        public CustomFallbackBuilder addCustomFallback(android.graphics.fonts.FontFamily family) {
            Preconditions.checkNotNull(family);
            Preconditions.checkArgument(this.mFamilies.size() < CustomFallbackBuilder.getMaxCustomFallbackCount(), "Custom fallback limit exceeded(%d)", CustomFallbackBuilder.getMaxCustomFallbackCount());
            this.mFamilies.add(family);
            return this;
        }

        public Typeface build() {
            int userFallbackSize = this.mFamilies.size();
            Typeface fallbackTypeface = Typeface.getSystemDefaultTypeface(this.mFallbackName);
            long[] ptrArray = new long[userFallbackSize];
            for (int i = 0; i < userFallbackSize; ++i) {
                ptrArray[i] = this.mFamilies.get(i).getNativePtr();
            }
            int weight = this.mStyle == null ? 400 : this.mStyle.getWeight();
            int italic = this.mStyle == null || this.mStyle.getSlant() == 0 ? 0 : 1;
            return new Typeface(Typeface.nativeCreateFromArray(ptrArray, fallbackTypeface.native_instance, weight, italic));
        }
    }

    public static class Builder {
        public static final int NORMAL_WEIGHT = 400;
        public static final int BOLD_WEIGHT = 700;
        private final AssetManager mAssetManager;
        private final String mPath;
        private final Font.Builder mFontBuilder;
        private String mFallbackFamilyName;
        private int mWeight = -1;
        private int mItalic = -1;

        public Builder(File path) {
            this.mFontBuilder = new Font.Builder(path);
            this.mAssetManager = null;
            this.mPath = null;
        }

        public Builder(FileDescriptor fd) {
            Font.Builder builder2;
            try {
                builder2 = new Font.Builder(ParcelFileDescriptor.dup(fd));
            }
            catch (IOException e) {
                builder2 = null;
            }
            this.mFontBuilder = builder2;
            this.mAssetManager = null;
            this.mPath = null;
        }

        public Builder(String path) {
            this.mFontBuilder = new Font.Builder(new File(path));
            this.mAssetManager = null;
            this.mPath = null;
        }

        public Builder(AssetManager assetManager, String path) {
            this(assetManager, path, true, 0);
        }

        public Builder(AssetManager assetManager, String path, boolean isAsset, int cookie) {
            this.mFontBuilder = new Font.Builder(assetManager, path, isAsset, cookie);
            this.mAssetManager = assetManager;
            this.mPath = path;
        }

        public Builder setWeight(int weight) {
            this.mWeight = weight;
            this.mFontBuilder.setWeight(weight);
            return this;
        }

        public Builder setItalic(boolean italic) {
            this.mItalic = italic ? 1 : 0;
            this.mFontBuilder.setSlant(this.mItalic);
            return this;
        }

        public Builder setTtcIndex(int ttcIndex) {
            this.mFontBuilder.setTtcIndex(ttcIndex);
            return this;
        }

        public Builder setFontVariationSettings(String variationSettings) {
            this.mFontBuilder.setFontVariationSettings(variationSettings);
            return this;
        }

        public Builder setFontVariationSettings(FontVariationAxis[] axes) {
            this.mFontBuilder.setFontVariationSettings(axes);
            return this;
        }

        public Builder setFallback(String familyName) {
            this.mFallbackFamilyName = familyName;
            return this;
        }

        static String createAssetUid_Original(AssetManager mgr, String path, int ttcIndex, FontVariationAxis[] axes, int weight, int italic, String fallback) {
            SparseArray<String> pkgs = mgr.getAssignedPackageIdentifiers();
            StringBuilder builder2 = new StringBuilder();
            int size = pkgs.size();
            for (int i = 0; i < size; ++i) {
                builder2.append(pkgs.valueAt(i));
                builder2.append("-");
            }
            builder2.append(path);
            builder2.append("-");
            builder2.append(Integer.toString(ttcIndex));
            builder2.append("-");
            builder2.append(Integer.toString(weight));
            builder2.append("-");
            builder2.append(Integer.toString(italic));
            builder2.append("--");
            builder2.append(fallback);
            builder2.append("--");
            if (axes != null) {
                for (FontVariationAxis axis : axes) {
                    builder2.append(axis.getTag());
                    builder2.append("-");
                    builder2.append(Float.toString(axis.getStyleValue()));
                }
            }
            return builder2.toString();
        }

        @LayoutlibDelegate
        private static String createAssetUid(AssetManager assetManager, String string2, int n, FontVariationAxis[] fontVariationAxisArray, int n2, int n3, String string3) {
            return Typeface_Builder_Delegate.createAssetUid(assetManager, string2, n, fontVariationAxisArray, n2, n3, string3);
        }

        private Typeface resolveFallbackTypeface() {
            int weight;
            if (this.mFallbackFamilyName == null) {
                return null;
            }
            Typeface base = Typeface.getSystemDefaultTypeface(this.mFallbackFamilyName);
            if (this.mWeight == -1 && this.mItalic == -1) {
                return base;
            }
            int n = weight = this.mWeight == -1 ? base.mWeight : this.mWeight;
            boolean italic = this.mItalic == -1 ? (base.mStyle & 2) != 0 : this.mItalic == 1;
            return Typeface.createWeightStyle(base, weight, italic);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Typeface build() {
            if (this.mFontBuilder == null) {
                return this.resolveFallbackTypeface();
            }
            try {
                String key;
                Font font = this.mFontBuilder.build();
                String string2 = this.mAssetManager == null ? null : (key = Builder.createAssetUid(this.mAssetManager, this.mPath, font.getTtcIndex(), font.getAxes(), this.mWeight, this.mItalic, this.mFallbackFamilyName == null ? "sans-serif" : this.mFallbackFamilyName));
                if (key != null) {
                    Object object = sDynamicCacheLock;
                    synchronized (object) {
                        Typeface typeface = (Typeface)sDynamicTypefaceCache.get(key);
                        if (typeface != null) {
                            return typeface;
                        }
                    }
                }
                android.graphics.fonts.FontFamily family = new FontFamily.Builder(font).build();
                int weight = this.mWeight == -1 ? font.getStyle().getWeight() : this.mWeight;
                int slant = this.mItalic == -1 ? font.getStyle().getSlant() : this.mItalic;
                CustomFallbackBuilder builder2 = new CustomFallbackBuilder(family).setStyle(new FontStyle(weight, slant));
                if (this.mFallbackFamilyName != null) {
                    builder2.setSystemFallback(this.mFallbackFamilyName);
                }
                Typeface typeface = builder2.build();
                if (key != null) {
                    Object object = sDynamicCacheLock;
                    synchronized (object) {
                        sDynamicTypefaceCache.put(key, typeface);
                    }
                }
                return typeface;
            }
            catch (IOException | IllegalArgumentException e) {
                return this.resolveFallbackTypeface();
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Style {
    }
}

