/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.ColorSpace;
import android.graphics.Shader;
import libcore.util.NativeAllocationRegistry;

public class RuntimeShader
extends Shader {
    private boolean mIsOpaque;
    private long mNativeInstanceRuntimeShaderBuilder;

    public RuntimeShader(String sksl, boolean isOpaque) {
        super(ColorSpace.get(ColorSpace.Named.SRGB));
        this.mIsOpaque = isOpaque;
        this.mNativeInstanceRuntimeShaderBuilder = RuntimeShader.nativeCreateBuilder(sksl);
        NoImagePreloadHolder.sRegistry.registerNativeAllocation(this, this.mNativeInstanceRuntimeShaderBuilder);
    }

    public void setUniform(String uniformName, float value2) {
        this.setUniform(uniformName, new float[]{value2});
    }

    public void setUniform(String uniformName, float value1, float value2) {
        this.setUniform(uniformName, new float[]{value1, value2});
    }

    public void setUniform(String uniformName, float[] values2) {
        RuntimeShader.nativeUpdateUniforms(this.mNativeInstanceRuntimeShaderBuilder, uniformName, values2);
        this.discardNativeInstance();
    }

    public void setInputShader(String shaderName, Shader shader) {
        RuntimeShader.nativeUpdateShader(this.mNativeInstanceRuntimeShaderBuilder, shaderName, shader.getNativeInstance());
        this.discardNativeInstance();
    }

    @Override
    protected long createNativeInstance(long nativeMatrix, boolean filterFromPaint) {
        return RuntimeShader.nativeCreateShader(this.mNativeInstanceRuntimeShaderBuilder, nativeMatrix, this.mIsOpaque);
    }

    public long getNativeShaderBuilder() {
        return this.mNativeInstanceRuntimeShaderBuilder;
    }

    public boolean isOpaque() {
        return this.mIsOpaque;
    }

    private static native long nativeGetFinalizer();

    private static native long nativeCreateBuilder(String var0);

    private static native long nativeCreateShader(long var0, long var2, boolean var4);

    private static native void nativeUpdateUniforms(long var0, String var2, float[] var3);

    private static native void nativeUpdateShader(long var0, String var2, long var3);

    static /* synthetic */ long access$000() {
        return RuntimeShader.nativeGetFinalizer();
    }

    private static class NoImagePreloadHolder {
        public static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(RuntimeShader.class.getClassLoader(), RuntimeShader.access$000());

        private NoImagePreloadHolder() {
        }
    }
}

