/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap;
import android.graphics.BlendMode;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.Shader;
import libcore.util.NativeAllocationRegistry;

public final class RenderEffect {
    private final long mNativeRenderEffect;

    public static RenderEffect createOffsetEffect(float offsetX, float offsetY) {
        return new RenderEffect(RenderEffect.nativeCreateOffsetEffect(offsetX, offsetY, 0L));
    }

    public static RenderEffect createOffsetEffect(float offsetX, float offsetY, RenderEffect input) {
        return new RenderEffect(RenderEffect.nativeCreateOffsetEffect(offsetX, offsetY, input.getNativeInstance()));
    }

    public static RenderEffect createBlurEffect(float radiusX, float radiusY, RenderEffect inputEffect, Shader.TileMode edgeTreatment) {
        long nativeInputEffect = inputEffect != null ? inputEffect.mNativeRenderEffect : 0L;
        return new RenderEffect(RenderEffect.nativeCreateBlurEffect(radiusX, radiusY, nativeInputEffect, edgeTreatment.nativeInt));
    }

    public static RenderEffect createBlurEffect(float radiusX, float radiusY, Shader.TileMode edgeTreatment) {
        return new RenderEffect(RenderEffect.nativeCreateBlurEffect(radiusX, radiusY, 0L, edgeTreatment.nativeInt));
    }

    public static RenderEffect createBitmapEffect(Bitmap bitmap) {
        float right2 = bitmap.getWidth();
        float bottom2 = bitmap.getHeight();
        return new RenderEffect(RenderEffect.nativeCreateBitmapEffect(bitmap.getNativeInstance(), 0.0f, 0.0f, right2, bottom2, 0.0f, 0.0f, right2, bottom2));
    }

    public static RenderEffect createBitmapEffect(Bitmap bitmap, Rect src, Rect dst) {
        long bitmapHandle = bitmap.getNativeInstance();
        int left = src == null ? 0 : src.left;
        int top = src == null ? 0 : src.top;
        int right2 = src == null ? bitmap.getWidth() : src.right;
        int bottom2 = src == null ? bitmap.getHeight() : src.bottom;
        return new RenderEffect(RenderEffect.nativeCreateBitmapEffect(bitmapHandle, left, top, right2, bottom2, dst.left, dst.top, dst.right, dst.bottom));
    }

    public static RenderEffect createColorFilterEffect(ColorFilter colorFilter, RenderEffect renderEffect) {
        return new RenderEffect(RenderEffect.nativeCreateColorFilterEffect(colorFilter.getNativeInstance(), renderEffect.getNativeInstance()));
    }

    public static RenderEffect createColorFilterEffect(ColorFilter colorFilter) {
        return new RenderEffect(RenderEffect.nativeCreateColorFilterEffect(colorFilter.getNativeInstance(), 0L));
    }

    public static RenderEffect createBlendModeEffect(RenderEffect dst, RenderEffect src, BlendMode blendMode) {
        return new RenderEffect(RenderEffect.nativeCreateBlendModeEffect(dst.getNativeInstance(), src.getNativeInstance(), blendMode.getXfermode().porterDuffMode));
    }

    public static RenderEffect createChainEffect(RenderEffect outer, RenderEffect inner) {
        return new RenderEffect(RenderEffect.nativeCreateChainEffect(outer.getNativeInstance(), inner.getNativeInstance()));
    }

    public static RenderEffect createShaderEffect(Shader shader) {
        return new RenderEffect(RenderEffect.nativeCreateShaderEffect(shader.getNativeInstance()));
    }

    private RenderEffect(long nativeRenderEffect) {
        this.mNativeRenderEffect = nativeRenderEffect;
        RenderEffectHolder.RENDER_EFFECT_REGISTRY.registerNativeAllocation(this, this.mNativeRenderEffect);
    }

    long getNativeInstance() {
        return this.mNativeRenderEffect;
    }

    private static native long nativeCreateOffsetEffect(float var0, float var1, long var2);

    private static native long nativeCreateBlurEffect(float var0, float var1, long var2, int var4);

    private static native long nativeCreateBitmapEffect(long var0, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9);

    private static native long nativeCreateColorFilterEffect(long var0, long var2);

    private static native long nativeCreateBlendModeEffect(long var0, long var2, int var4);

    private static native long nativeCreateChainEffect(long var0, long var2);

    private static native long nativeCreateShaderEffect(long var0);

    private static native long nativeGetFinalizer();

    static /* synthetic */ long access$000() {
        return RenderEffect.nativeGetFinalizer();
    }

    private static class RenderEffectHolder {
        public static final NativeAllocationRegistry RENDER_EFFECT_REGISTRY = NativeAllocationRegistry.createMalloced(RenderEffect.class.getClassLoader(), RenderEffect.access$000());

        private RenderEffectHolder() {
        }
    }
}

