/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.FastMath;
import java.io.PrintWriter;

public class RectF
implements Parcelable {
    public float left;
    public float top;
    public float right;
    public float bottom;
    public static final Parcelable.Creator<RectF> CREATOR = new Parcelable.Creator<RectF>(){

        @Override
        public RectF createFromParcel(Parcel in) {
            RectF r = new RectF();
            r.readFromParcel(in);
            return r;
        }

        public RectF[] newArray(int size) {
            return new RectF[size];
        }
    };

    public RectF() {
    }

    public RectF(float left, float top, float right2, float bottom2) {
        this.left = left;
        this.top = top;
        this.right = right2;
        this.bottom = bottom2;
    }

    public RectF(RectF r) {
        if (r == null) {
            this.bottom = 0.0f;
            this.right = 0.0f;
            this.top = 0.0f;
            this.left = 0.0f;
        } else {
            this.left = r.left;
            this.top = r.top;
            this.right = r.right;
            this.bottom = r.bottom;
        }
    }

    public RectF(Rect r) {
        if (r == null) {
            this.bottom = 0.0f;
            this.right = 0.0f;
            this.top = 0.0f;
            this.left = 0.0f;
        } else {
            this.left = r.left;
            this.top = r.top;
            this.right = r.right;
            this.bottom = r.bottom;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RectF r = (RectF)o;
        return this.left == r.left && this.top == r.top && this.right == r.right && this.bottom == r.bottom;
    }

    public int hashCode() {
        int result = this.left != 0.0f ? Float.floatToIntBits(this.left) : 0;
        result = 31 * result + (this.top != 0.0f ? Float.floatToIntBits(this.top) : 0);
        result = 31 * result + (this.right != 0.0f ? Float.floatToIntBits(this.right) : 0);
        result = 31 * result + (this.bottom != 0.0f ? Float.floatToIntBits(this.bottom) : 0);
        return result;
    }

    public String toString() {
        return "RectF(" + this.left + ", " + this.top + ", " + this.right + ", " + this.bottom + ")";
    }

    public String toShortString() {
        return this.toShortString(new StringBuilder(32));
    }

    public String toShortString(StringBuilder sb) {
        sb.setLength(0);
        sb.append('[');
        sb.append(this.left);
        sb.append(',');
        sb.append(this.top);
        sb.append("][");
        sb.append(this.right);
        sb.append(',');
        sb.append(this.bottom);
        sb.append(']');
        return sb.toString();
    }

    public void printShortString(PrintWriter pw) {
        pw.print('[');
        pw.print(this.left);
        pw.print(',');
        pw.print(this.top);
        pw.print("][");
        pw.print(this.right);
        pw.print(',');
        pw.print(this.bottom);
        pw.print(']');
    }

    public boolean isEmpty() {
        return this.left >= this.right || this.top >= this.bottom;
    }

    public float width() {
        return this.right - this.left;
    }

    public float height() {
        return this.bottom - this.top;
    }

    public float centerX() {
        return (this.left + this.right) * 0.5f;
    }

    public float centerY() {
        return (this.top + this.bottom) * 0.5f;
    }

    public void setEmpty() {
        this.bottom = 0.0f;
        this.top = 0.0f;
        this.right = 0.0f;
        this.left = 0.0f;
    }

    public void set(float left, float top, float right2, float bottom2) {
        this.left = left;
        this.top = top;
        this.right = right2;
        this.bottom = bottom2;
    }

    public void set(RectF src) {
        this.left = src.left;
        this.top = src.top;
        this.right = src.right;
        this.bottom = src.bottom;
    }

    public void set(Rect src) {
        this.left = src.left;
        this.top = src.top;
        this.right = src.right;
        this.bottom = src.bottom;
    }

    public void offset(float dx, float dy) {
        this.left += dx;
        this.top += dy;
        this.right += dx;
        this.bottom += dy;
    }

    public void offsetTo(float newLeft, float newTop) {
        this.right += newLeft - this.left;
        this.bottom += newTop - this.top;
        this.left = newLeft;
        this.top = newTop;
    }

    public void inset(float dx, float dy) {
        this.left += dx;
        this.top += dy;
        this.right -= dx;
        this.bottom -= dy;
    }

    public boolean contains(float x, float y) {
        return this.left < this.right && this.top < this.bottom && x >= this.left && x < this.right && y >= this.top && y < this.bottom;
    }

    public boolean contains(float left, float top, float right2, float bottom2) {
        return this.left < this.right && this.top < this.bottom && this.left <= left && this.top <= top && this.right >= right2 && this.bottom >= bottom2;
    }

    public boolean contains(RectF r) {
        return this.left < this.right && this.top < this.bottom && this.left <= r.left && this.top <= r.top && this.right >= r.right && this.bottom >= r.bottom;
    }

    public boolean intersect(float left, float top, float right2, float bottom2) {
        if (this.left < right2 && left < this.right && this.top < bottom2 && top < this.bottom) {
            if (this.left < left) {
                this.left = left;
            }
            if (this.top < top) {
                this.top = top;
            }
            if (this.right > right2) {
                this.right = right2;
            }
            if (this.bottom > bottom2) {
                this.bottom = bottom2;
            }
            return true;
        }
        return false;
    }

    public boolean intersect(RectF r) {
        return this.intersect(r.left, r.top, r.right, r.bottom);
    }

    public boolean setIntersect(RectF a, RectF b) {
        if (a.left < b.right && b.left < a.right && a.top < b.bottom && b.top < a.bottom) {
            this.left = Math.max(a.left, b.left);
            this.top = Math.max(a.top, b.top);
            this.right = Math.min(a.right, b.right);
            this.bottom = Math.min(a.bottom, b.bottom);
            return true;
        }
        return false;
    }

    public boolean intersects(float left, float top, float right2, float bottom2) {
        return this.left < right2 && left < this.right && this.top < bottom2 && top < this.bottom;
    }

    public static boolean intersects(RectF a, RectF b) {
        return a.left < b.right && b.left < a.right && a.top < b.bottom && b.top < a.bottom;
    }

    public void round(Rect dst) {
        dst.set(FastMath.round(this.left), FastMath.round(this.top), FastMath.round(this.right), FastMath.round(this.bottom));
    }

    public void roundOut(Rect dst) {
        dst.set((int)Math.floor(this.left), (int)Math.floor(this.top), (int)Math.ceil(this.right), (int)Math.ceil(this.bottom));
    }

    public void union(float left, float top, float right2, float bottom2) {
        if (left < right2 && top < bottom2) {
            if (this.left < this.right && this.top < this.bottom) {
                if (this.left > left) {
                    this.left = left;
                }
                if (this.top > top) {
                    this.top = top;
                }
                if (this.right < right2) {
                    this.right = right2;
                }
                if (this.bottom < bottom2) {
                    this.bottom = bottom2;
                }
            } else {
                this.left = left;
                this.top = top;
                this.right = right2;
                this.bottom = bottom2;
            }
        }
    }

    public void union(RectF r) {
        this.union(r.left, r.top, r.right, r.bottom);
    }

    public void union(float x, float y) {
        if (x < this.left) {
            this.left = x;
        } else if (x > this.right) {
            this.right = x;
        }
        if (y < this.top) {
            this.top = y;
        } else if (y > this.bottom) {
            this.bottom = y;
        }
    }

    public void sort() {
        float temp;
        if (this.left > this.right) {
            temp = this.left;
            this.left = this.right;
            this.right = temp;
        }
        if (this.top > this.bottom) {
            temp = this.top;
            this.top = this.bottom;
            this.bottom = temp;
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeFloat(this.left);
        out.writeFloat(this.top);
        out.writeFloat(this.right);
        out.writeFloat(this.bottom);
    }

    public void readFromParcel(Parcel in) {
        this.left = in.readFloat();
        this.top = in.readFloat();
        this.right = in.readFloat();
        this.bottom = in.readFloat();
    }

    public void scale(float scale) {
        if (scale != 1.0f) {
            this.left *= scale;
            this.top *= scale;
            this.right *= scale;
            this.bottom *= scale;
        }
    }
}

