/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap;
import android.graphics.ImageDecoder;
import com.android.layoutlib.bridge.util.NinePatchInputStream;
import com.android.ninepatch.GraphicsUtilities;
import com.android.ninepatch.NinePatch;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ImageDecoder_Delegate {
    @LayoutlibDelegate
    static Bitmap decodeBitmapImpl(ImageDecoder.Source src, ImageDecoder.OnHeaderDecodedListener listener2) throws IOException {
        InputStream stream = src instanceof ImageDecoder.InputStreamSource ? ((ImageDecoder.InputStreamSource)src).mInputStream : null;
        Bitmap bm = ImageDecoder.decodeBitmapImpl_Original(src, listener2);
        if (stream instanceof NinePatchInputStream && bm.getNinePatchChunk() == null) {
            stream = new FileInputStream(((NinePatchInputStream)stream).getPath());
            NinePatch ninePatch = NinePatch.load((InputStream)stream, (boolean)true, (boolean)false);
            BufferedImage image = ninePatch.getImage();
            int width = image.getWidth();
            int height = image.getHeight();
            int[] imageData = GraphicsUtilities.getPixels((BufferedImage)image, (int)0, (int)0, (int)width, (int)height, null);
            bm = Bitmap.createBitmap(imageData, width, height, Bitmap.Config.ARGB_8888);
            bm.setDensity(src.getDensity());
            bm.setNinePatchChunk(ninePatch.getChunk().getSerializedChunk());
        }
        return bm;
    }
}

