/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.fonts.FontCustomizationParser;
import android.graphics.fonts.FontStyle;
import android.graphics.fonts.FontVariationAxis;
import android.os.LocaleList;
import android.text.FontConfig;
import android.util.Xml;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Pattern;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class FontListParser {
    private static final String ATTR_NAME = "name";
    private static final String ATTR_LANG = "lang";
    private static final String ATTR_VARIANT = "variant";
    private static final String TAG_FONT = "font";
    private static final String VARIANT_COMPACT = "compact";
    private static final String VARIANT_ELEGANT = "elegant";
    public static final String ATTR_INDEX = "index";
    public static final String ATTR_WEIGHT = "weight";
    public static final String ATTR_POSTSCRIPT_NAME = "postScriptName";
    public static final String ATTR_STYLE = "style";
    public static final String ATTR_FALLBACK_FOR = "fallbackFor";
    public static final String STYLE_ITALIC = "italic";
    public static final String STYLE_NORMAL = "normal";
    public static final String TAG_AXIS = "axis";
    public static final String ATTR_TAG = "tag";
    public static final String ATTR_STYLEVALUE = "stylevalue";
    private static final Pattern FILENAME_WHITESPACE_PATTERN = Pattern.compile("^[ \\n\\r\\t]+|[ \\n\\r\\t]+$");

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static FontConfig parse(InputStream in) throws XmlPullParserException, IOException {
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(in, null);
        parser.nextTag();
        return FontListParser.readFamilies(parser, "/system/fonts/", new FontCustomizationParser.Result(), null, 0L, 0, true);
    }

    public static FontConfig parse(String fontsXmlPath, String systemFontDir, String oemCustomizationXmlPath, String productFontDir, Map<String, File> updatableFontMap, long lastModifiedDate, int configVersion) throws IOException, XmlPullParserException {
        FontCustomizationParser.Result oemCustomization;
        FileInputStream is;
        if (oemCustomizationXmlPath != null) {
            try {
                is = new FileInputStream(oemCustomizationXmlPath);
                try {
                    oemCustomization = FontCustomizationParser.parse(is, productFontDir, updatableFontMap);
                }
                finally {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                oemCustomization = new FontCustomizationParser.Result();
            }
        } else {
            oemCustomization = new FontCustomizationParser.Result();
        }
        is = new FileInputStream(fontsXmlPath);
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput((InputStream)is, null);
            parser.nextTag();
            FontConfig fontConfig = FontListParser.readFamilies(parser, systemFontDir, oemCustomization, updatableFontMap, lastModifiedDate, configVersion, false);
            return fontConfig;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    private static FontConfig readFamilies(XmlPullParser parser, String fontDir, FontCustomizationParser.Result customization, Map<String, File> updatableFontMap, long lastModifiedDate, int configVersion, boolean allowNonExistingFile) throws XmlPullParserException, IOException {
        ArrayList<FontConfig.FontFamily> families = new ArrayList<FontConfig.FontFamily>();
        ArrayList<FontConfig.Alias> aliases = new ArrayList<FontConfig.Alias>(customization.getAdditionalAliases());
        Map<String, FontConfig.FontFamily> oemNamedFamilies = customization.getAdditionalNamedFamilies();
        parser.require(2, null, "familyset");
        while (FontListParser.keepReading(parser)) {
            if (parser.getEventType() != 2) continue;
            String tag = parser.getName();
            if (tag.equals("family")) {
                String name;
                FontConfig.FontFamily family = FontListParser.readFamily(parser, fontDir, updatableFontMap, allowNonExistingFile);
                if (family == null || (name = family.getName()) != null && oemNamedFamilies.containsKey(name)) continue;
                families.add(family);
                continue;
            }
            if (tag.equals("alias")) {
                aliases.add(FontListParser.readAlias(parser));
                continue;
            }
            FontListParser.skip(parser);
        }
        families.addAll(oemNamedFamilies.values());
        return new FontConfig(families, aliases, lastModifiedDate, configVersion);
    }

    private static boolean keepReading(XmlPullParser parser) throws XmlPullParserException, IOException {
        int next = parser.next();
        return next != 3 && next != 1;
    }

    public static FontConfig.FontFamily readFamily(XmlPullParser parser, String fontDir, Map<String, File> updatableFontMap, boolean allowNonExistingFile) throws XmlPullParserException, IOException {
        String name = parser.getAttributeValue(null, ATTR_NAME);
        String lang = parser.getAttributeValue("", ATTR_LANG);
        String variant = parser.getAttributeValue(null, ATTR_VARIANT);
        ArrayList<FontConfig.Font> fonts = new ArrayList<FontConfig.Font>();
        while (FontListParser.keepReading(parser)) {
            if (parser.getEventType() != 2) continue;
            String tag = parser.getName();
            if (tag.equals(TAG_FONT)) {
                FontConfig.Font font = FontListParser.readFont(parser, fontDir, updatableFontMap, allowNonExistingFile);
                if (font == null) continue;
                fonts.add(font);
                continue;
            }
            FontListParser.skip(parser);
        }
        int intVariant = 0;
        if (variant != null) {
            if (variant.equals(VARIANT_COMPACT)) {
                intVariant = 1;
            } else if (variant.equals(VARIANT_ELEGANT)) {
                intVariant = 2;
            }
        }
        if (fonts.isEmpty()) {
            return null;
        }
        return new FontConfig.FontFamily(fonts, name, LocaleList.forLanguageTags(lang), intVariant);
    }

    private static FontConfig.Font readFont(XmlPullParser parser, String fontDir, Map<String, File> updatableFontMap, boolean allowNonExistingFile) throws XmlPullParserException, IOException {
        String originalPath;
        String filePath;
        String updatedName;
        String indexStr = parser.getAttributeValue(null, ATTR_INDEX);
        int index = indexStr == null ? 0 : Integer.parseInt(indexStr);
        ArrayList<FontVariationAxis> axes = new ArrayList<FontVariationAxis>();
        String weightStr = parser.getAttributeValue(null, ATTR_WEIGHT);
        int weight = weightStr == null ? 400 : Integer.parseInt(weightStr);
        boolean isItalic = STYLE_ITALIC.equals(parser.getAttributeValue(null, ATTR_STYLE));
        String fallbackFor = parser.getAttributeValue(null, ATTR_FALLBACK_FOR);
        String postScriptName = parser.getAttributeValue(null, ATTR_POSTSCRIPT_NAME);
        StringBuilder filename = new StringBuilder();
        while (FontListParser.keepReading(parser)) {
            if (parser.getEventType() == 4) {
                filename.append(parser.getText());
            }
            if (parser.getEventType() != 2) continue;
            String tag = parser.getName();
            if (tag.equals(TAG_AXIS)) {
                axes.add(FontListParser.readAxis(parser));
                continue;
            }
            FontListParser.skip(parser);
        }
        String sanitizedName = FILENAME_WHITESPACE_PATTERN.matcher(filename).replaceAll("");
        if (postScriptName == null) {
            postScriptName = sanitizedName.substring(0, sanitizedName.length() - 4);
        }
        if ((updatedName = FontListParser.findUpdatedFontFile(postScriptName, updatableFontMap)) != null) {
            filePath = updatedName;
            originalPath = fontDir + sanitizedName;
        } else {
            filePath = fontDir + sanitizedName;
            originalPath = null;
        }
        String varSettings = axes.isEmpty() ? "" : FontVariationAxis.toFontVariationSettings(axes.toArray(new FontVariationAxis[0]));
        File file2 = new File(filePath);
        if (!allowNonExistingFile && !file2.isFile()) {
            return null;
        }
        return new FontConfig.Font(file2, originalPath == null ? null : new File(originalPath), postScriptName, new FontStyle(weight, isItalic ? 1 : 0), index, varSettings, fallbackFor);
    }

    private static String findUpdatedFontFile(String psName, Map<String, File> updatableFontMap) {
        File updatedFile;
        if (updatableFontMap != null && (updatedFile = updatableFontMap.get(psName)) != null) {
            return updatedFile.getAbsolutePath();
        }
        return null;
    }

    private static FontVariationAxis readAxis(XmlPullParser parser) throws XmlPullParserException, IOException {
        String tagStr = parser.getAttributeValue(null, ATTR_TAG);
        String styleValueStr = parser.getAttributeValue(null, ATTR_STYLEVALUE);
        FontListParser.skip(parser);
        return new FontVariationAxis(tagStr, Float.parseFloat(styleValueStr));
    }

    public static FontConfig.Alias readAlias(XmlPullParser parser) throws XmlPullParserException, IOException {
        String name = parser.getAttributeValue(null, ATTR_NAME);
        String toName2 = parser.getAttributeValue(null, "to");
        String weightStr = parser.getAttributeValue(null, ATTR_WEIGHT);
        int weight = weightStr == null ? 400 : Integer.parseInt(weightStr);
        FontListParser.skip(parser);
        return new FontConfig.Alias(name, toName2, weight);
    }

    public static void skip(XmlPullParser parser) throws XmlPullParserException, IOException {
        int depth = 1;
        while (depth > 0) {
            switch (parser.next()) {
                case 2: {
                    ++depth;
                    break;
                }
                case 3: {
                    --depth;
                    break;
                }
                case 1: {
                    return;
                }
            }
        }
    }
}

