/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.res.AssetManager;
import android.graphics.fonts.Font;
import android.graphics.fonts.FontVariationAxis;
import android.text.TextUtils;
import dalvik.annotation.optimization.CriticalNative;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import libcore.util.NativeAllocationRegistry;

@Deprecated
public class FontFamily {
    private static String TAG;
    private static NativeAllocationRegistry sBuilderRegistry;
    private Runnable mNativeBuilderCleaner;
    private static NativeAllocationRegistry sFamilyRegistry;
    @UnsupportedAppUsage(maxTargetSdk=29, publicAlternatives="Use {@link android.graphics.fonts.FontFamily} instead.")
    public long mNativePtr;
    private long mBuilderPtr;

    @UnsupportedAppUsage(maxTargetSdk=29, publicAlternatives="Use {@link android.graphics.fonts.FontFamily} instead.")
    public FontFamily() {
        this.mBuilderPtr = FontFamily.nInitBuilder(null, 0);
        this.mNativeBuilderCleaner = sBuilderRegistry.registerNativeAllocation(this, this.mBuilderPtr);
    }

    @UnsupportedAppUsage(maxTargetSdk=29, publicAlternatives="Use {@link android.graphics.fonts.FontFamily} instead.")
    public FontFamily(String[] langs, int variant) {
        String langsString = langs == null || langs.length == 0 ? null : (langs.length == 1 ? langs[0] : TextUtils.join((CharSequence)",", langs));
        this.mBuilderPtr = FontFamily.nInitBuilder(langsString, variant);
        this.mNativeBuilderCleaner = sBuilderRegistry.registerNativeAllocation(this, this.mBuilderPtr);
    }

    @UnsupportedAppUsage(maxTargetSdk=29, publicAlternatives="Use {@link android.graphics.fonts.FontFamily} instead.")
    public boolean freeze() {
        if (this.mBuilderPtr == 0L) {
            throw new IllegalStateException("This FontFamily is already frozen");
        }
        this.mNativePtr = FontFamily.nCreateFamily(this.mBuilderPtr);
        this.mNativeBuilderCleaner.run();
        this.mBuilderPtr = 0L;
        if (this.mNativePtr != 0L) {
            sFamilyRegistry.registerNativeAllocation(this, this.mNativePtr);
        }
        return this.mNativePtr != 0L;
    }

    @UnsupportedAppUsage(maxTargetSdk=29, publicAlternatives="Use {@link android.graphics.fonts.FontFamily} instead.")
    public void abortCreation() {
        if (this.mBuilderPtr == 0L) {
            throw new IllegalStateException("This FontFamily is already frozen or abandoned");
        }
        this.mNativeBuilderCleaner.run();
        this.mBuilderPtr = 0L;
    }

    @UnsupportedAppUsage(maxTargetSdk=29, publicAlternatives="Use {@link android.graphics.fonts.FontFamily} instead.")
    public boolean addFont(String path, int ttcIndex, FontVariationAxis[] axes, int weight, int italic) {
        boolean bl;
        if (this.mBuilderPtr == 0L) {
            throw new IllegalStateException("Unable to call addFont after freezing.");
        }
        FileInputStream file2 = new FileInputStream(path);
        try {
            FileChannel fileChannel = file2.getChannel();
            long fontSize = fileChannel.size();
            MappedByteBuffer fontBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fontSize);
            if (axes != null) {
                for (FontVariationAxis axis : axes) {
                    FontFamily.nAddAxisValue(this.mBuilderPtr, axis.getOpenTypeTagValue(), axis.getStyleValue());
                }
            }
            bl = FontFamily.nAddFont(this.mBuilderPtr, fontBuffer, ttcIndex, weight, italic);
        }
        catch (Throwable throwable) {
            try {
                try {
                    file2.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        file2.close();
        return bl;
    }

    @UnsupportedAppUsage(maxTargetSdk=29, publicAlternatives="Use {@link android.graphics.fonts.FontFamily} instead.")
    public boolean addFontFromBuffer(ByteBuffer font, int ttcIndex, FontVariationAxis[] axes, int weight, int italic) {
        if (this.mBuilderPtr == 0L) {
            throw new IllegalStateException("Unable to call addFontWeightStyle after freezing.");
        }
        if (axes != null) {
            for (FontVariationAxis axis : axes) {
                FontFamily.nAddAxisValue(this.mBuilderPtr, axis.getOpenTypeTagValue(), axis.getStyleValue());
            }
        }
        return FontFamily.nAddFontWeightStyle(this.mBuilderPtr, font, ttcIndex, weight, italic);
    }

    @UnsupportedAppUsage(maxTargetSdk=29, publicAlternatives="Use {@link android.graphics.fonts.FontFamily} instead.")
    public boolean addFontFromAssetManager(AssetManager mgr, String path, int cookie, boolean isAsset, int ttcIndex, int weight, int isItalic, FontVariationAxis[] axes) {
        if (this.mBuilderPtr == 0L) {
            throw new IllegalStateException("Unable to call addFontFromAsset after freezing.");
        }
        try {
            ByteBuffer buffer = Font.Builder.createBuffer(mgr, path, isAsset, cookie);
            return this.addFontFromBuffer(buffer, ttcIndex, axes, weight, isItalic);
        }
        catch (IOException e) {
            return false;
        }
    }

    private static native long nInitBuilder(String var0, int var1);

    @CriticalNative
    private static native long nCreateFamily(long var0);

    @CriticalNative
    private static native long nGetBuilderReleaseFunc();

    @CriticalNative
    private static native long nGetFamilyReleaseFunc();

    private static native boolean nAddFont(long var0, ByteBuffer var2, int var3, int var4, int var5);

    private static native boolean nAddFontWeightStyle(long var0, ByteBuffer var2, int var3, int var4, int var5);

    @CriticalNative
    private static native void nAddAxisValue(long var0, int var2, float var3);

    public static void deferredStaticInitializer() {
        TAG = "FontFamily";
        sBuilderRegistry = NativeAllocationRegistry.createMalloced(FontFamily.class.getClassLoader(), FontFamily.nGetBuilderReleaseFunc());
        sFamilyRegistry = NativeAllocationRegistry.createMalloced(FontFamily.class.getClassLoader(), FontFamily.nGetFamilyReleaseFunc());
    }
}

