/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.BaseCanvas;
import android.graphics.Bitmap;
import android.graphics.BlendMode;
import android.graphics.Canvas_Delegate;
import android.graphics.DrawFilter;
import android.graphics.Matrix;
import android.graphics.NinePatch;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Picture;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.RenderNode;
import android.graphics.fonts.Font;
import android.graphics.text.MeasuredText;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import dalvik.annotation.optimization.CriticalNative;
import dalvik.annotation.optimization.FastNative;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import libcore.util.NativeAllocationRegistry;

public class Canvas
extends BaseCanvas {
    private static int sCompatiblityVersion = 0;
    private static boolean sCompatibilityRestore = false;
    private static boolean sCompatibilitySetBitmap = false;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=117521088L)
    private Bitmap mBitmap;
    private DrawFilter mDrawFilter;
    private static final int MAXMIMUM_BITMAP_SIZE = 32766;
    private Runnable mFinalizer;
    public static final int MATRIX_SAVE_FLAG = 1;
    public static final int CLIP_SAVE_FLAG = 2;
    public static final int HAS_ALPHA_LAYER_SAVE_FLAG = 4;
    public static final int FULL_COLOR_LAYER_SAVE_FLAG = 8;
    public static final int CLIP_TO_LAYER_SAVE_FLAG = 16;
    public static final int ALL_SAVE_FLAG = 31;

    @UnsupportedAppUsage
    public long getNativeCanvasWrapper() {
        return this.mNativeCanvasWrapper;
    }

    public Canvas() {
        if (!this.isHardwareAccelerated()) {
            this.mNativeCanvasWrapper = Canvas.nInitRaster(0L);
            this.mFinalizer = NoImagePreloadHolder.sRegistry.registerNativeAllocation(this, this.mNativeCanvasWrapper);
        } else {
            this.mFinalizer = null;
        }
    }

    public Canvas(Bitmap bitmap) {
        if (!bitmap.isMutable()) {
            throw new IllegalStateException("Immutable bitmap passed to Canvas constructor");
        }
        this.throwIfCannotDraw(bitmap);
        this.mNativeCanvasWrapper = Canvas.nInitRaster(bitmap.getNativeInstance());
        this.mFinalizer = NoImagePreloadHolder.sRegistry.registerNativeAllocation(this, this.mNativeCanvasWrapper);
        this.mBitmap = bitmap;
        this.mDensity = bitmap.mDensity;
    }

    public Canvas(long nativeCanvas) {
        if (nativeCanvas == 0L) {
            throw new IllegalStateException();
        }
        this.mNativeCanvasWrapper = nativeCanvas;
        this.mFinalizer = NoImagePreloadHolder.sRegistry.registerNativeAllocation(this, this.mNativeCanvasWrapper);
        this.mDensity = Bitmap.getDefaultDensity();
    }

    @Override
    public boolean isHardwareAccelerated() {
        return false;
    }

    public void setBitmap(Bitmap bitmap) {
        if (this.isHardwareAccelerated()) {
            throw new RuntimeException("Can't set a bitmap device on a HW accelerated canvas");
        }
        Matrix preservedMatrix = null;
        if (bitmap != null && sCompatibilitySetBitmap) {
            preservedMatrix = this.getMatrix();
        }
        if (bitmap == null) {
            Canvas.nSetBitmap(this.mNativeCanvasWrapper, 0L);
            this.mDensity = 0;
        } else {
            if (!bitmap.isMutable()) {
                throw new IllegalStateException();
            }
            this.throwIfCannotDraw(bitmap);
            Canvas.nSetBitmap(this.mNativeCanvasWrapper, bitmap.getNativeInstance());
            this.mDensity = bitmap.mDensity;
        }
        if (preservedMatrix != null) {
            this.setMatrix(preservedMatrix);
        }
        this.mBitmap = bitmap;
    }

    public void enableZ() {
    }

    public void disableZ() {
    }

    public boolean isOpaque() {
        return Canvas.nIsOpaque(this.mNativeCanvasWrapper);
    }

    public int getWidth() {
        return Canvas.nGetWidth(this.mNativeCanvasWrapper);
    }

    public int getHeight() {
        return Canvas.nGetHeight(this.mNativeCanvasWrapper);
    }

    public int getDensity() {
        return this.mDensity;
    }

    public void setDensity(int density) {
        if (this.mBitmap != null) {
            this.mBitmap.setDensity(density);
        }
        this.mDensity = density;
    }

    @UnsupportedAppUsage
    public void setScreenDensity(int density) {
        this.mScreenDensity = density;
    }

    public int getMaximumBitmapWidth() {
        return 32766;
    }

    public int getMaximumBitmapHeight() {
        return 32766;
    }

    private static void checkValidSaveFlags(int saveFlags) {
        if (sCompatiblityVersion >= 28 && saveFlags != 31) {
            throw new IllegalArgumentException("Invalid Layer Save Flag - only ALL_SAVE_FLAGS is allowed");
        }
    }

    public int save() {
        return Canvas.nSave(this.mNativeCanvasWrapper, 3);
    }

    public int save(int saveFlags) {
        return Canvas.nSave(this.mNativeCanvasWrapper, saveFlags);
    }

    public int saveLayer(RectF bounds2, Paint paint, int saveFlags) {
        if (bounds2 == null) {
            bounds2 = new RectF(this.getClipBounds());
        }
        Canvas.checkValidSaveFlags(saveFlags);
        return this.saveLayer(bounds2.left, bounds2.top, bounds2.right, bounds2.bottom, paint, 31);
    }

    public int saveLayer(RectF bounds2, Paint paint) {
        return this.saveLayer(bounds2, paint, 31);
    }

    public int saveUnclippedLayer(int left, int top, int right2, int bottom2) {
        return Canvas.nSaveUnclippedLayer(this.mNativeCanvasWrapper, left, top, right2, bottom2);
    }

    public void restoreUnclippedLayer(int saveCount, Paint paint) {
        Canvas.nRestoreUnclippedLayer(this.mNativeCanvasWrapper, saveCount, paint.getNativeInstance());
    }

    public int saveLayer(float left, float top, float right2, float bottom2, Paint paint, int saveFlags) {
        Canvas.checkValidSaveFlags(saveFlags);
        return Canvas.nSaveLayer(this.mNativeCanvasWrapper, left, top, right2, bottom2, paint != null ? paint.getNativeInstance() : 0L);
    }

    public int saveLayer(float left, float top, float right2, float bottom2, Paint paint) {
        return this.saveLayer(left, top, right2, bottom2, paint, 31);
    }

    public int saveLayerAlpha(RectF bounds2, int alpha, int saveFlags) {
        if (bounds2 == null) {
            bounds2 = new RectF(this.getClipBounds());
        }
        Canvas.checkValidSaveFlags(saveFlags);
        return this.saveLayerAlpha(bounds2.left, bounds2.top, bounds2.right, bounds2.bottom, alpha, 31);
    }

    public int saveLayerAlpha(RectF bounds2, int alpha) {
        return this.saveLayerAlpha(bounds2, alpha, 31);
    }

    public int saveLayerAlpha(float left, float top, float right2, float bottom2, int alpha, int saveFlags) {
        Canvas.checkValidSaveFlags(saveFlags);
        alpha = Math.min(255, Math.max(0, alpha));
        return Canvas.nSaveLayerAlpha(this.mNativeCanvasWrapper, left, top, right2, bottom2, alpha);
    }

    public int saveLayerAlpha(float left, float top, float right2, float bottom2, int alpha) {
        return this.saveLayerAlpha(left, top, right2, bottom2, alpha, 31);
    }

    public void restore() {
        if (!(Canvas.nRestore(this.mNativeCanvasWrapper) || sCompatibilityRestore && this.isHardwareAccelerated())) {
            throw new IllegalStateException("Underflow in restore - more restores than saves");
        }
    }

    public int getSaveCount() {
        return Canvas.nGetSaveCount(this.mNativeCanvasWrapper);
    }

    public void restoreToCount(int saveCount) {
        if (saveCount < 1) {
            if (!sCompatibilityRestore || !this.isHardwareAccelerated()) {
                throw new IllegalArgumentException("Underflow in restoreToCount - more restores than saves");
            }
            saveCount = 1;
        }
        Canvas.nRestoreToCount(this.mNativeCanvasWrapper, saveCount);
    }

    public void translate(float dx, float dy) {
        if (dx == 0.0f && dy == 0.0f) {
            return;
        }
        Canvas.nTranslate(this.mNativeCanvasWrapper, dx, dy);
    }

    public void scale(float sx, float sy) {
        if (sx == 1.0f && sy == 1.0f) {
            return;
        }
        Canvas.nScale(this.mNativeCanvasWrapper, sx, sy);
    }

    public final void scale(float sx, float sy, float px, float py) {
        if (sx == 1.0f && sy == 1.0f) {
            return;
        }
        this.translate(px, py);
        this.scale(sx, sy);
        this.translate(-px, -py);
    }

    public void rotate(float degrees) {
        if (degrees == 0.0f) {
            return;
        }
        Canvas.nRotate(this.mNativeCanvasWrapper, degrees);
    }

    public final void rotate(float degrees, float px, float py) {
        if (degrees == 0.0f) {
            return;
        }
        this.translate(px, py);
        this.rotate(degrees);
        this.translate(-px, -py);
    }

    public void skew(float sx, float sy) {
        if (sx == 0.0f && sy == 0.0f) {
            return;
        }
        Canvas.nSkew(this.mNativeCanvasWrapper, sx, sy);
    }

    public void concat(Matrix matrix) {
        if (matrix != null) {
            Canvas.nConcat(this.mNativeCanvasWrapper, matrix.ni());
        }
    }

    public void setMatrix(Matrix matrix) {
        Canvas.nSetMatrix(this.mNativeCanvasWrapper, matrix == null ? 0L : matrix.ni());
    }

    @Deprecated
    public void getMatrix(Matrix ctm) {
        Canvas.nGetMatrix(this.mNativeCanvasWrapper, ctm.ni());
    }

    @Deprecated
    public final Matrix getMatrix() {
        Matrix m = new Matrix();
        this.getMatrix(m);
        return m;
    }

    private static void checkValidClipOp(Region.Op op) {
        if (sCompatiblityVersion >= 28 && op != Region.Op.INTERSECT && op != Region.Op.DIFFERENCE) {
            throw new IllegalArgumentException("Invalid Region.Op - only INTERSECT and DIFFERENCE are allowed");
        }
    }

    @Deprecated
    public boolean clipRect(RectF rect, Region.Op op) {
        Canvas.checkValidClipOp(op);
        return Canvas.nClipRect(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom, op.nativeInt);
    }

    @Deprecated
    public boolean clipRect(Rect rect, Region.Op op) {
        Canvas.checkValidClipOp(op);
        return Canvas.nClipRect(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom, op.nativeInt);
    }

    public boolean clipRectUnion(Rect rect) {
        return Canvas.nClipRect(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom, Region.Op.UNION.nativeInt);
    }

    public boolean clipRect(RectF rect) {
        return Canvas.nClipRect(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom, Region.Op.INTERSECT.nativeInt);
    }

    public boolean clipOutRect(RectF rect) {
        return Canvas.nClipRect(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom, Region.Op.DIFFERENCE.nativeInt);
    }

    public boolean clipRect(Rect rect) {
        return Canvas.nClipRect(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom, Region.Op.INTERSECT.nativeInt);
    }

    public boolean clipOutRect(Rect rect) {
        return Canvas.nClipRect(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom, Region.Op.DIFFERENCE.nativeInt);
    }

    @Deprecated
    public boolean clipRect(float left, float top, float right2, float bottom2, Region.Op op) {
        Canvas.checkValidClipOp(op);
        return Canvas.nClipRect(this.mNativeCanvasWrapper, left, top, right2, bottom2, op.nativeInt);
    }

    public boolean clipRect(float left, float top, float right2, float bottom2) {
        return Canvas.nClipRect(this.mNativeCanvasWrapper, left, top, right2, bottom2, Region.Op.INTERSECT.nativeInt);
    }

    public boolean clipOutRect(float left, float top, float right2, float bottom2) {
        return Canvas.nClipRect(this.mNativeCanvasWrapper, left, top, right2, bottom2, Region.Op.DIFFERENCE.nativeInt);
    }

    public boolean clipRect(int left, int top, int right2, int bottom2) {
        return Canvas.nClipRect(this.mNativeCanvasWrapper, left, top, right2, bottom2, Region.Op.INTERSECT.nativeInt);
    }

    public boolean clipOutRect(int left, int top, int right2, int bottom2) {
        return Canvas.nClipRect(this.mNativeCanvasWrapper, left, top, right2, bottom2, Region.Op.DIFFERENCE.nativeInt);
    }

    @Deprecated
    public boolean clipPath(Path path, Region.Op op) {
        Canvas.checkValidClipOp(op);
        return Canvas.nClipPath(this.mNativeCanvasWrapper, path.readOnlyNI(), op.nativeInt);
    }

    public boolean clipPath(Path path) {
        return this.clipPath(path, Region.Op.INTERSECT);
    }

    public boolean clipOutPath(Path path) {
        return this.clipPath(path, Region.Op.DIFFERENCE);
    }

    @Deprecated
    public boolean clipRegion(Region region, Region.Op op) {
        return false;
    }

    @Deprecated
    public boolean clipRegion(Region region) {
        return false;
    }

    public DrawFilter getDrawFilter() {
        return this.mDrawFilter;
    }

    public void setDrawFilter(DrawFilter filter2) {
        long nativeFilter = 0L;
        if (filter2 != null) {
            nativeFilter = filter2.mNativeInt;
        }
        this.mDrawFilter = filter2;
        Canvas.nSetDrawFilter(this.mNativeCanvasWrapper, nativeFilter);
    }

    @Deprecated
    public boolean quickReject(RectF rect, EdgeType type) {
        return Canvas.nQuickReject(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom);
    }

    public boolean quickReject(RectF rect) {
        return Canvas.nQuickReject(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom);
    }

    @Deprecated
    public boolean quickReject(Path path, EdgeType type) {
        return Canvas.nQuickReject(this.mNativeCanvasWrapper, path.readOnlyNI());
    }

    public boolean quickReject(Path path) {
        return Canvas.nQuickReject(this.mNativeCanvasWrapper, path.readOnlyNI());
    }

    @Deprecated
    public boolean quickReject(float left, float top, float right2, float bottom2, EdgeType type) {
        return Canvas.nQuickReject(this.mNativeCanvasWrapper, left, top, right2, bottom2);
    }

    public boolean quickReject(float left, float top, float right2, float bottom2) {
        return Canvas.nQuickReject(this.mNativeCanvasWrapper, left, top, right2, bottom2);
    }

    public boolean getClipBounds_Original(Rect bounds2) {
        return Canvas.nGetClipBounds(this.mNativeCanvasWrapper, bounds2);
    }

    @LayoutlibDelegate
    public boolean getClipBounds(Rect rect) {
        return Canvas_Delegate.getClipBounds(this, rect);
    }

    public final Rect getClipBounds_Original() {
        Rect r = new Rect();
        this.getClipBounds(r);
        return r;
    }

    @LayoutlibDelegate
    public final Rect getClipBounds() {
        return Canvas_Delegate.getClipBounds(this);
    }

    public void drawPicture(Picture picture) {
        picture.endRecording();
        int restoreCount = this.save();
        picture.draw(this);
        this.restoreToCount(restoreCount);
    }

    public void drawPicture(Picture picture, RectF dst) {
        this.save();
        this.translate(dst.left, dst.top);
        if (picture.getWidth() > 0 && picture.getHeight() > 0) {
            this.scale(dst.width() / (float)picture.getWidth(), dst.height() / (float)picture.getHeight());
        }
        this.drawPicture(picture);
        this.restore();
    }

    public void drawPicture(Picture picture, Rect dst) {
        this.save();
        this.translate(dst.left, dst.top);
        if (picture.getWidth() > 0 && picture.getHeight() > 0) {
            this.scale((float)dst.width() / (float)picture.getWidth(), (float)dst.height() / (float)picture.getHeight());
        }
        this.drawPicture(picture);
        this.restore();
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void release() {
        this.mNativeCanvasWrapper = 0L;
        if (this.mFinalizer != null) {
            this.mFinalizer.run();
            this.mFinalizer = null;
        }
    }

    @UnsupportedAppUsage
    public static void freeCaches() {
        Canvas.nFreeCaches();
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static void freeTextLayoutCaches() {
        Canvas.nFreeTextLayoutCaches();
    }

    static void setCompatibilityVersion(int apiLevel) {
        sCompatiblityVersion = apiLevel;
        sCompatibilityRestore = apiLevel < 23;
        sCompatibilitySetBitmap = apiLevel < 26;
        Canvas.nSetCompatibilityVersion(apiLevel);
    }

    private static native void nFreeCaches();

    private static native void nFreeTextLayoutCaches();

    private static native long nGetNativeFinalizer();

    private static native void nSetCompatibilityVersion(int var0);

    @FastNative
    private static native long nInitRaster(long var0);

    @FastNative
    private static native void nSetBitmap(long var0, long var2);

    @FastNative
    private static native boolean nGetClipBounds(long var0, Rect var2);

    @CriticalNative
    private static native boolean nIsOpaque(long var0);

    @CriticalNative
    private static native int nGetWidth(long var0);

    @CriticalNative
    private static native int nGetHeight(long var0);

    @CriticalNative
    private static native int nSave(long var0, int var2);

    @CriticalNative
    private static native int nSaveLayer(long var0, float var2, float var3, float var4, float var5, long var6);

    @CriticalNative
    private static native int nSaveLayerAlpha(long var0, float var2, float var3, float var4, float var5, int var6);

    @CriticalNative
    private static native int nSaveUnclippedLayer(long var0, int var2, int var3, int var4, int var5);

    @CriticalNative
    private static native void nRestoreUnclippedLayer(long var0, int var2, long var3);

    @CriticalNative
    private static native boolean nRestore(long var0);

    @CriticalNative
    private static native void nRestoreToCount(long var0, int var2);

    @CriticalNative
    private static native int nGetSaveCount(long var0);

    @CriticalNative
    private static native void nTranslate(long var0, float var2, float var3);

    @CriticalNative
    private static native void nScale(long var0, float var2, float var3);

    @CriticalNative
    private static native void nRotate(long var0, float var2);

    @CriticalNative
    private static native void nSkew(long var0, float var2, float var3);

    @CriticalNative
    private static native void nConcat(long var0, long var2);

    @CriticalNative
    private static native void nSetMatrix(long var0, long var2);

    @CriticalNative
    private static native boolean nClipRect(long var0, float var2, float var3, float var4, float var5, int var6);

    @CriticalNative
    private static native boolean nClipPath(long var0, long var2, int var4);

    @CriticalNative
    private static native void nSetDrawFilter(long var0, long var2);

    @CriticalNative
    private static native void nGetMatrix(long var0, long var2);

    @CriticalNative
    private static native boolean nQuickReject(long var0, long var2);

    @CriticalNative
    private static native boolean nQuickReject(long var0, float var2, float var3, float var4, float var5);

    @Override
    public void drawArc(RectF oval, float startAngle, float sweepAngle, boolean useCenter, Paint paint) {
        super.drawArc(oval, startAngle, sweepAngle, useCenter, paint);
    }

    @Override
    public void drawArc(float left, float top, float right2, float bottom2, float startAngle, float sweepAngle, boolean useCenter, Paint paint) {
        super.drawArc(left, top, right2, bottom2, startAngle, sweepAngle, useCenter, paint);
    }

    @Override
    public void drawARGB(int a, int r, int g, int b) {
        super.drawARGB(a, r, g, b);
    }

    @Override
    public void drawBitmap(Bitmap bitmap, float left, float top, Paint paint) {
        super.drawBitmap(bitmap, left, top, paint);
    }

    @Override
    public void drawBitmap(Bitmap bitmap, Rect src, RectF dst, Paint paint) {
        super.drawBitmap(bitmap, src, dst, paint);
    }

    @Override
    public void drawBitmap(Bitmap bitmap, Rect src, Rect dst, Paint paint) {
        super.drawBitmap(bitmap, src, dst, paint);
    }

    @Override
    @Deprecated
    public void drawBitmap(int[] colors, int offset2, int stride, float x, float y, int width, int height, boolean hasAlpha, Paint paint) {
        super.drawBitmap(colors, offset2, stride, x, y, width, height, hasAlpha, paint);
    }

    @Override
    @Deprecated
    public void drawBitmap(int[] colors, int offset2, int stride, int x, int y, int width, int height, boolean hasAlpha, Paint paint) {
        super.drawBitmap(colors, offset2, stride, x, y, width, height, hasAlpha, paint);
    }

    @Override
    public void drawBitmap(Bitmap bitmap, Matrix matrix, Paint paint) {
        super.drawBitmap(bitmap, matrix, paint);
    }

    @Override
    public void drawBitmapMesh(Bitmap bitmap, int meshWidth, int meshHeight, float[] verts, int vertOffset, int[] colors, int colorOffset, Paint paint) {
        super.drawBitmapMesh(bitmap, meshWidth, meshHeight, verts, vertOffset, colors, colorOffset, paint);
    }

    @Override
    public void drawCircle(float cx, float cy, float radius, Paint paint) {
        super.drawCircle(cx, cy, radius, paint);
    }

    @Override
    public void drawColor(int color2) {
        super.drawColor(color2);
    }

    public void drawColor(long color2) {
        super.drawColor(color2, BlendMode.SRC_OVER);
    }

    @Override
    public void drawColor(int color2, PorterDuff.Mode mode) {
        super.drawColor(color2, mode);
    }

    @Override
    public void drawColor(int color2, BlendMode mode) {
        super.drawColor(color2, mode);
    }

    @Override
    public void drawColor(long color2, BlendMode mode) {
        super.drawColor(color2, mode);
    }

    @Override
    public void drawLine(float startX, float startY, float stopX, float stopY, Paint paint) {
        super.drawLine(startX, startY, stopX, stopY, paint);
    }

    @Override
    public void drawLines(float[] pts, int offset2, int count, Paint paint) {
        super.drawLines(pts, offset2, count, paint);
    }

    @Override
    public void drawLines(float[] pts, Paint paint) {
        super.drawLines(pts, paint);
    }

    @Override
    public void drawOval(RectF oval, Paint paint) {
        super.drawOval(oval, paint);
    }

    @Override
    public void drawOval(float left, float top, float right2, float bottom2, Paint paint) {
        super.drawOval(left, top, right2, bottom2, paint);
    }

    @Override
    public void drawPaint(Paint paint) {
        super.drawPaint(paint);
    }

    @Override
    public void drawPatch(NinePatch patch, Rect dst, Paint paint) {
        super.drawPatch(patch, dst, paint);
    }

    @Override
    public void drawPatch(NinePatch patch, RectF dst, Paint paint) {
        super.drawPatch(patch, dst, paint);
    }

    @Override
    public void drawPath(Path path, Paint paint) {
        super.drawPath(path, paint);
    }

    @Override
    public void drawPoint(float x, float y, Paint paint) {
        super.drawPoint(x, y, paint);
    }

    @Override
    public void drawPoints(float[] pts, int offset2, int count, Paint paint) {
        super.drawPoints(pts, offset2, count, paint);
    }

    @Override
    public void drawPoints(float[] pts, Paint paint) {
        super.drawPoints(pts, paint);
    }

    @Override
    @Deprecated
    public void drawPosText(char[] text, int index, int count, float[] pos, Paint paint) {
        super.drawPosText(text, index, count, pos, paint);
    }

    @Override
    @Deprecated
    public void drawPosText(String text, float[] pos, Paint paint) {
        super.drawPosText(text, pos, paint);
    }

    @Override
    public void drawRect(RectF rect, Paint paint) {
        super.drawRect(rect, paint);
    }

    @Override
    public void drawRect(Rect r, Paint paint) {
        super.drawRect(r, paint);
    }

    @Override
    public void drawRect(float left, float top, float right2, float bottom2, Paint paint) {
        super.drawRect(left, top, right2, bottom2, paint);
    }

    @Override
    public void drawRGB(int r, int g, int b) {
        super.drawRGB(r, g, b);
    }

    @Override
    public void drawRoundRect(RectF rect, float rx, float ry, Paint paint) {
        super.drawRoundRect(rect, rx, ry, paint);
    }

    @Override
    public void drawRoundRect(float left, float top, float right2, float bottom2, float rx, float ry, Paint paint) {
        super.drawRoundRect(left, top, right2, bottom2, rx, ry, paint);
    }

    @Override
    public void drawDoubleRoundRect(RectF outer, float outerRx, float outerRy, RectF inner, float innerRx, float innerRy, Paint paint) {
        super.drawDoubleRoundRect(outer, outerRx, outerRy, inner, innerRx, innerRy, paint);
    }

    @Override
    public void drawDoubleRoundRect(RectF outer, float[] outerRadii, RectF inner, float[] innerRadii, Paint paint) {
        super.drawDoubleRoundRect(outer, outerRadii, inner, innerRadii, paint);
    }

    @Override
    public void drawGlyphs(int[] glyphIds, int glyphIdOffset, float[] positions, int positionOffset, int glyphCount, Font font, Paint paint) {
        super.drawGlyphs(glyphIds, glyphIdOffset, positions, positionOffset, glyphCount, font, paint);
    }

    @Override
    public void drawText(char[] text, int index, int count, float x, float y, Paint paint) {
        super.drawText(text, index, count, x, y, paint);
    }

    @Override
    public void drawText(String text, float x, float y, Paint paint) {
        super.drawText(text, x, y, paint);
    }

    @Override
    public void drawText(String text, int start, int end, float x, float y, Paint paint) {
        super.drawText(text, start, end, x, y, paint);
    }

    @Override
    public void drawText(CharSequence text, int start, int end, float x, float y, Paint paint) {
        super.drawText(text, start, end, x, y, paint);
    }

    @Override
    public void drawTextOnPath(char[] text, int index, int count, Path path, float hOffset, float vOffset, Paint paint) {
        super.drawTextOnPath(text, index, count, path, hOffset, vOffset, paint);
    }

    @Override
    public void drawTextOnPath(String text, Path path, float hOffset, float vOffset, Paint paint) {
        super.drawTextOnPath(text, path, hOffset, vOffset, paint);
    }

    @Override
    public void drawTextRun(char[] text, int index, int count, int contextIndex, int contextCount, float x, float y, boolean isRtl, Paint paint) {
        super.drawTextRun(text, index, count, contextIndex, contextCount, x, y, isRtl, paint);
    }

    @Override
    public void drawTextRun(CharSequence text, int start, int end, int contextStart, int contextEnd, float x, float y, boolean isRtl, Paint paint) {
        super.drawTextRun(text, start, end, contextStart, contextEnd, x, y, isRtl, paint);
    }

    @Override
    public void drawTextRun(MeasuredText text, int start, int end, int contextStart, int contextEnd, float x, float y, boolean isRtl, Paint paint) {
        super.drawTextRun(text, start, end, contextStart, contextEnd, x, y, isRtl, paint);
    }

    @Override
    public void drawVertices(VertexMode mode, int vertexCount, float[] verts, int vertOffset, float[] texs, int texOffset, int[] colors, int colorOffset, short[] indices, int indexOffset, int indexCount, Paint paint) {
        super.drawVertices(mode, vertexCount, verts, vertOffset, texs, texOffset, colors, colorOffset, indices, indexOffset, indexCount, paint);
    }

    public void drawRenderNode(RenderNode renderNode) {
        throw new IllegalArgumentException("Software rendering doesn't support drawRenderNode");
    }

    static /* synthetic */ long access$000() {
        return Canvas.nGetNativeFinalizer();
    }

    public static enum VertexMode {
        TRIANGLES(0),
        TRIANGLE_STRIP(1),
        TRIANGLE_FAN(2);

        final int nativeInt;

        private VertexMode(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }

    public static enum EdgeType {
        BW,
        AA;

    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Saveflags {
    }

    private static class NoImagePreloadHolder {
        public static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(Canvas.class.getClassLoader(), Canvas.access$000());

        private NoImagePreloadHolder() {
        }
    }
}

