/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.compat.annotation.UnsupportedAppUsage;
import android.database.AbstractCursor;
import android.database.CursorIndexOutOfBoundsException;
import android.database.DatabaseUtils;
import java.util.ArrayList;

public class MatrixCursor
extends AbstractCursor {
    private final String[] columnNames;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private Object[] data;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private int rowCount = 0;
    private final int columnCount;

    public MatrixCursor(String[] columnNames, int initialCapacity) {
        this.columnNames = columnNames;
        this.columnCount = columnNames.length;
        if (initialCapacity < 1) {
            initialCapacity = 1;
        }
        this.data = new Object[this.columnCount * initialCapacity];
    }

    public MatrixCursor(String[] columnNames) {
        this(columnNames, 16);
    }

    @UnsupportedAppUsage
    private Object get(int column) {
        if (column < 0 || column >= this.columnCount) {
            throw new CursorIndexOutOfBoundsException("Requested column: " + column + ", # of columns: " + this.columnCount);
        }
        if (this.mPos < 0) {
            throw new CursorIndexOutOfBoundsException("Before first row.");
        }
        if (this.mPos >= this.rowCount) {
            throw new CursorIndexOutOfBoundsException("After last row.");
        }
        return this.data[this.mPos * this.columnCount + column];
    }

    public RowBuilder newRow() {
        int row = this.rowCount++;
        int endIndex = this.rowCount * this.columnCount;
        this.ensureCapacity(endIndex);
        return new RowBuilder(row);
    }

    public void addRow(Object[] columnValues) {
        if (columnValues.length != this.columnCount) {
            throw new IllegalArgumentException("columnNames.length = " + this.columnCount + ", columnValues.length = " + columnValues.length);
        }
        int start = this.rowCount++ * this.columnCount;
        this.ensureCapacity(start + this.columnCount);
        System.arraycopy(columnValues, 0, this.data, start, this.columnCount);
    }

    public void addRow(Iterable<?> columnValues) {
        int start = this.rowCount * this.columnCount;
        int end = start + this.columnCount;
        this.ensureCapacity(end);
        if (columnValues instanceof ArrayList) {
            this.addRow((ArrayList)columnValues, start);
            return;
        }
        int current = start;
        Object[] localData = this.data;
        for (Object columnValue : columnValues) {
            if (current == end) {
                throw new IllegalArgumentException("columnValues.size() > columnNames.length");
            }
            localData[current++] = columnValue;
        }
        if (current != end) {
            throw new IllegalArgumentException("columnValues.size() < columnNames.length");
        }
        ++this.rowCount;
    }

    private void addRow(ArrayList<?> columnValues, int start) {
        int size = columnValues.size();
        if (size != this.columnCount) {
            throw new IllegalArgumentException("columnNames.length = " + this.columnCount + ", columnValues.size() = " + size);
        }
        ++this.rowCount;
        Object[] localData = this.data;
        for (int i = 0; i < size; ++i) {
            localData[start + i] = columnValues.get(i);
        }
    }

    private void ensureCapacity(int size) {
        if (size > this.data.length) {
            Object[] oldData = this.data;
            int newSize = this.data.length * 2;
            if (newSize < size) {
                newSize = size;
            }
            this.data = new Object[newSize];
            System.arraycopy(oldData, 0, this.data, 0, oldData.length);
        }
    }

    @Override
    public int getCount() {
        return this.rowCount;
    }

    @Override
    public String[] getColumnNames() {
        return this.columnNames;
    }

    @Override
    public String getString(int column) {
        Object value2 = this.get(column);
        if (value2 == null) {
            return null;
        }
        return value2.toString();
    }

    @Override
    public short getShort(int column) {
        Object value2 = this.get(column);
        if (value2 == null) {
            return 0;
        }
        if (value2 instanceof Number) {
            return ((Number)value2).shortValue();
        }
        return Short.parseShort(value2.toString());
    }

    @Override
    public int getInt(int column) {
        Object value2 = this.get(column);
        if (value2 == null) {
            return 0;
        }
        if (value2 instanceof Number) {
            return ((Number)value2).intValue();
        }
        return Integer.parseInt(value2.toString());
    }

    @Override
    public long getLong(int column) {
        Object value2 = this.get(column);
        if (value2 == null) {
            return 0L;
        }
        if (value2 instanceof Number) {
            return ((Number)value2).longValue();
        }
        return Long.parseLong(value2.toString());
    }

    @Override
    public float getFloat(int column) {
        Object value2 = this.get(column);
        if (value2 == null) {
            return 0.0f;
        }
        if (value2 instanceof Number) {
            return ((Number)value2).floatValue();
        }
        return Float.parseFloat(value2.toString());
    }

    @Override
    public double getDouble(int column) {
        Object value2 = this.get(column);
        if (value2 == null) {
            return 0.0;
        }
        if (value2 instanceof Number) {
            return ((Number)value2).doubleValue();
        }
        return Double.parseDouble(value2.toString());
    }

    @Override
    public byte[] getBlob(int column) {
        Object value2 = this.get(column);
        return (byte[])value2;
    }

    @Override
    public int getType(int column) {
        return DatabaseUtils.getTypeOfObject(this.get(column));
    }

    @Override
    public boolean isNull(int column) {
        return this.get(column) == null;
    }

    public class RowBuilder {
        private final int row;
        private final int endIndex;
        private int index;

        RowBuilder(int row) {
            this.row = row;
            this.index = row * MatrixCursor.this.columnCount;
            this.endIndex = this.index + MatrixCursor.this.columnCount;
        }

        public RowBuilder add(Object columnValue) {
            if (this.index == this.endIndex) {
                throw new CursorIndexOutOfBoundsException("No more columns left.");
            }
            ((MatrixCursor)MatrixCursor.this).data[this.index++] = columnValue;
            return this;
        }

        public RowBuilder add(String columnName, Object value2) {
            for (int i = 0; i < MatrixCursor.this.columnNames.length; ++i) {
                if (!columnName.equals(MatrixCursor.this.columnNames[i])) continue;
                ((MatrixCursor)MatrixCursor.this).data[this.row * ((MatrixCursor)MatrixCursor.this).columnCount + i] = value2;
            }
            return this;
        }

        public RowBuilder add(int columnIndex, Object value2) {
            ((MatrixCursor)MatrixCursor.this).data[this.row * ((MatrixCursor)MatrixCursor.this).columnCount + columnIndex] = value2;
            return this;
        }
    }
}

