/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.content.res.loader.ResourcesLoader;
import android.text.TextUtils;
import java.util.Arrays;
import java.util.Objects;

public class ResourcesKey {
    @UnsupportedAppUsage
    public final String mResDir;
    @UnsupportedAppUsage
    public final String[] mSplitResDirs;
    public final String[] mOverlayPaths;
    public final String[] mLibDirs;
    @UnsupportedAppUsage(maxTargetSdk=26)
    public int mDisplayId;
    public final Configuration mOverrideConfiguration;
    public final CompatibilityInfo mCompatInfo;
    public final ResourcesLoader[] mLoaders;
    private final int mHash;

    public ResourcesKey(String resDir, String[] splitResDirs, String[] overlayPaths, String[] libDirs, int overrideDisplayId, Configuration overrideConfig, CompatibilityInfo compatInfo, ResourcesLoader[] loader) {
        this.mResDir = resDir;
        this.mSplitResDirs = splitResDirs;
        this.mOverlayPaths = overlayPaths;
        this.mLibDirs = libDirs;
        this.mLoaders = loader != null && loader.length == 0 ? null : loader;
        this.mDisplayId = overrideDisplayId;
        this.mOverrideConfiguration = new Configuration(overrideConfig != null ? overrideConfig : Configuration.EMPTY);
        this.mCompatInfo = compatInfo != null ? compatInfo : CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO;
        int hash2 = 17;
        hash2 = 31 * hash2 + Objects.hashCode(this.mResDir);
        hash2 = 31 * hash2 + Arrays.hashCode(this.mSplitResDirs);
        hash2 = 31 * hash2 + Arrays.hashCode(this.mOverlayPaths);
        hash2 = 31 * hash2 + Arrays.hashCode(this.mLibDirs);
        hash2 = 31 * hash2 + Objects.hashCode(this.mDisplayId);
        hash2 = 31 * hash2 + Objects.hashCode(this.mOverrideConfiguration);
        hash2 = 31 * hash2 + Objects.hashCode(this.mCompatInfo);
        this.mHash = hash2 = 31 * hash2 + Arrays.hashCode(this.mLoaders);
    }

    @UnsupportedAppUsage
    public ResourcesKey(String resDir, String[] splitResDirs, String[] overlayPaths, String[] libDirs, int displayId, Configuration overrideConfig, CompatibilityInfo compatInfo) {
        this(resDir, splitResDirs, overlayPaths, libDirs, displayId, overrideConfig, compatInfo, null);
    }

    public boolean hasOverrideConfiguration() {
        return !Configuration.EMPTY.equals(this.mOverrideConfiguration);
    }

    public boolean isPathReferenced(String path) {
        if (this.mResDir != null && this.mResDir.startsWith(path)) {
            return true;
        }
        return ResourcesKey.anyStartsWith(this.mSplitResDirs, path) || ResourcesKey.anyStartsWith(this.mOverlayPaths, path) || ResourcesKey.anyStartsWith(this.mLibDirs, path);
    }

    private static boolean anyStartsWith(String[] list, String prefix) {
        if (list != null) {
            for (String s : list) {
                if (s == null || !s.startsWith(prefix)) continue;
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.mHash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ResourcesKey)) {
            return false;
        }
        ResourcesKey peer = (ResourcesKey)obj;
        if (this.mHash != peer.mHash) {
            return false;
        }
        if (!Objects.equals(this.mResDir, peer.mResDir)) {
            return false;
        }
        if (!Arrays.equals(this.mSplitResDirs, peer.mSplitResDirs)) {
            return false;
        }
        if (!Arrays.equals(this.mOverlayPaths, peer.mOverlayPaths)) {
            return false;
        }
        if (!Arrays.equals(this.mLibDirs, peer.mLibDirs)) {
            return false;
        }
        if (this.mDisplayId != peer.mDisplayId) {
            return false;
        }
        if (!Objects.equals(this.mOverrideConfiguration, peer.mOverrideConfiguration)) {
            return false;
        }
        if (!Objects.equals(this.mCompatInfo, peer.mCompatInfo)) {
            return false;
        }
        return Arrays.equals(this.mLoaders, peer.mLoaders);
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder().append("ResourcesKey{");
        builder2.append(" mHash=").append(Integer.toHexString(this.mHash));
        builder2.append(" mResDir=").append(this.mResDir);
        builder2.append(" mSplitDirs=[");
        if (this.mSplitResDirs != null) {
            builder2.append(TextUtils.join((CharSequence)",", this.mSplitResDirs));
        }
        builder2.append("]");
        builder2.append(" mOverlayDirs=[");
        if (this.mOverlayPaths != null) {
            builder2.append(TextUtils.join((CharSequence)",", this.mOverlayPaths));
        }
        builder2.append("]");
        builder2.append(" mLibDirs=[");
        if (this.mLibDirs != null) {
            builder2.append(TextUtils.join((CharSequence)",", this.mLibDirs));
        }
        builder2.append("]");
        builder2.append(" mDisplayId=").append(this.mDisplayId);
        builder2.append(" mOverrideConfig=").append(Configuration.resourceQualifierString(this.mOverrideConfiguration));
        builder2.append(" mCompatInfo=").append(this.mCompatInfo);
        builder2.append(" mLoaders=[");
        if (this.mLoaders != null) {
            builder2.append(TextUtils.join((CharSequence)",", this.mLoaders));
        }
        builder2.append("]}");
        return builder2.toString();
    }
}

