/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Xml;
import com.android.internal.R;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class FontResourcesParser {
    private static final String TAG = "FontResourcesParser";

    public static FamilyResourceEntry parse(XmlPullParser parser, Resources resources) throws XmlPullParserException, IOException {
        int type;
        while ((type = parser.next()) != 2 && type != 1) {
        }
        if (type != 2) {
            throw new XmlPullParserException("No start tag found");
        }
        return FontResourcesParser.readFamilies(parser, resources);
    }

    private static FamilyResourceEntry readFamilies(XmlPullParser parser, Resources resources) throws XmlPullParserException, IOException {
        parser.require(2, null, "font-family");
        String tag = parser.getName();
        Object result = null;
        if (tag.equals("font-family")) {
            return FontResourcesParser.readFamily(parser, resources);
        }
        FontResourcesParser.skip(parser);
        Log.e(TAG, "Failed to find font-family tag");
        return null;
    }

    private static FamilyResourceEntry readFamily(XmlPullParser parser, Resources resources) throws XmlPullParserException, IOException {
        AttributeSet attrs = Xml.asAttributeSet(parser);
        TypedArray array2 = resources.obtainAttributes(attrs, R.styleable.FontFamily);
        String authority = array2.getString(0);
        String providerPackage = array2.getString(2);
        String query = array2.getString(1);
        int certsId = array2.getResourceId(3, 0);
        String systemFontFamilyName = array2.getString(4);
        array2.recycle();
        if (authority != null && providerPackage != null && query != null) {
            TypedArray typedArray;
            while (parser.next() != 3) {
                FontResourcesParser.skip(parser);
            }
            ArrayList<List<String>> certs = null;
            if (certsId != 0 && (typedArray = resources.obtainTypedArray(certsId)).length() > 0) {
                boolean isArrayOfArrays;
                certs = new ArrayList<List<String>>();
                boolean bl = isArrayOfArrays = typedArray.getResourceId(0, 0) != 0;
                if (isArrayOfArrays) {
                    for (int i = 0; i < typedArray.length(); ++i) {
                        int certId = typedArray.getResourceId(i, 0);
                        String[] certsArray = resources.getStringArray(certId);
                        List<String> certsList = Arrays.asList(certsArray);
                        certs.add(certsList);
                    }
                } else {
                    String[] certsArray = resources.getStringArray(certsId);
                    List<String> certsList = Arrays.asList(certsArray);
                    certs.add(certsList);
                }
            }
            return new ProviderResourceEntry(authority, providerPackage, query, certs, systemFontFamilyName);
        }
        ArrayList<FontFileResourceEntry> fonts = new ArrayList<FontFileResourceEntry>();
        while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            String tag = parser.getName();
            if (tag.equals("font")) {
                FontFileResourceEntry entry = FontResourcesParser.readFont(parser, resources);
                if (entry == null) continue;
                fonts.add(entry);
                continue;
            }
            FontResourcesParser.skip(parser);
        }
        if (fonts.isEmpty()) {
            return null;
        }
        return new FontFamilyFilesResourceEntry(fonts.toArray(new FontFileResourceEntry[fonts.size()]));
    }

    private static FontFileResourceEntry readFont(XmlPullParser parser, Resources resources) throws XmlPullParserException, IOException {
        AttributeSet attrs = Xml.asAttributeSet(parser);
        TypedArray array2 = resources.obtainAttributes(attrs, R.styleable.FontFamilyFont);
        int weight = array2.getInt(1, -1);
        int italic = array2.getInt(2, -1);
        String variationSettings = array2.getString(4);
        int ttcIndex = array2.getInt(3, 0);
        String filename = array2.getString(0);
        array2.recycle();
        while (parser.next() != 3) {
            FontResourcesParser.skip(parser);
        }
        if (filename == null) {
            return null;
        }
        return new FontFileResourceEntry(filename, weight, italic, variationSettings, ttcIndex);
    }

    private static void skip(XmlPullParser parser) throws XmlPullParserException, IOException {
        int depth = 1;
        while (depth > 0) {
            switch (parser.next()) {
                case 2: {
                    ++depth;
                    break;
                }
                case 3: {
                    --depth;
                }
            }
        }
    }

    public static class FontFamilyFilesResourceEntry
    implements FamilyResourceEntry {
        private final FontFileResourceEntry[] mEntries;

        public FontFamilyFilesResourceEntry(FontFileResourceEntry[] entries) {
            this.mEntries = entries;
        }

        public FontFileResourceEntry[] getEntries() {
            return this.mEntries;
        }
    }

    public static class FontFileResourceEntry {
        public static final int RESOLVE_BY_FONT_TABLE = -1;
        public static final int UPRIGHT = 0;
        public static final int ITALIC = 1;
        private final String mFileName;
        private int mWeight;
        private int mItalic;
        private int mTtcIndex;
        private String mVariationSettings;
        private int mResourceId;

        public FontFileResourceEntry(String fileName, int weight, int italic, String variationSettings, int ttcIndex) {
            this.mFileName = fileName;
            this.mWeight = weight;
            this.mItalic = italic;
            this.mVariationSettings = variationSettings;
            this.mTtcIndex = ttcIndex;
        }

        public String getFileName() {
            return this.mFileName;
        }

        public int getWeight() {
            return this.mWeight;
        }

        public int getItalic() {
            return this.mItalic;
        }

        public String getVariationSettings() {
            return this.mVariationSettings;
        }

        public int getTtcIndex() {
            return this.mTtcIndex;
        }
    }

    public static class ProviderResourceEntry
    implements FamilyResourceEntry {
        private final String mProviderAuthority;
        private final String mProviderPackage;
        private final String mQuery;
        private final String mSystemFontFamilyName;
        private final List<List<String>> mCerts;

        public ProviderResourceEntry(String authority, String pkg, String query, List<List<String>> certs, String systemFontFamilyName) {
            this.mProviderAuthority = authority;
            this.mProviderPackage = pkg;
            this.mQuery = query;
            this.mCerts = certs;
            this.mSystemFontFamilyName = systemFontFamilyName;
        }

        public String getAuthority() {
            return this.mProviderAuthority;
        }

        public String getPackage() {
            return this.mProviderPackage;
        }

        public String getQuery() {
            return this.mQuery;
        }

        public String getSystemFontFamilyName() {
            return this.mSystemFontFamilyName;
        }

        public List<List<String>> getCerts() {
            return this.mCerts;
        }
    }

    public static interface FamilyResourceEntry {
    }
}

