/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.parsing.result;

import android.content.pm.ApplicationInfo;
import android.content.pm.parsing.result.ParseInput;
import android.content.pm.parsing.result.ParseResult;
import android.os.ServiceManager;
import android.util.ArrayMap;
import android.util.Slog;
import com.android.internal.compat.IPlatformCompat;
import com.android.internal.util.CollectionUtils;

public class ParseTypeImpl
implements ParseInput,
ParseResult<Object> {
    private static final String TAG = "PackageParsing";
    public static final boolean DEBUG_FILL_STACK_TRACE = false;
    public static final boolean DEBUG_LOG_ON_ERROR = false;
    public static final boolean DEBUG_THROW_ALL_ERRORS = false;
    private ParseInput.Callback mCallback;
    private Object mResult;
    private int mErrorCode = 1;
    private String mErrorMessage;
    private Exception mException;
    private ArrayMap<Long, String> mDeferredErrors = null;
    private String mPackageName;
    private Integer mTargetSdkVersion;

    public static ParseTypeImpl forParsingWithoutPlatformCompat() {
        return new ParseTypeImpl((changeId, packageName, targetSdkVersion) -> {
            int gateSdkVersion = ParseInput.DeferredError.getTargetSdkForChange(changeId);
            if (gateSdkVersion == -1) {
                return false;
            }
            return targetSdkVersion > gateSdkVersion;
        });
    }

    public static ParseTypeImpl forDefaultParsing() {
        IPlatformCompat platformCompat = IPlatformCompat.Stub.asInterface(ServiceManager.getService("platform_compat"));
        return new ParseTypeImpl((changeId, packageName, targetSdkVersion) -> {
            ApplicationInfo appInfo = new ApplicationInfo();
            appInfo.packageName = packageName;
            appInfo.targetSdkVersion = targetSdkVersion;
            try {
                return platformCompat.isChangeEnabled(changeId, appInfo);
            }
            catch (Exception e) {
                Slog.wtf(TAG, "IPlatformCompat query failed", e);
                return true;
            }
        });
    }

    public ParseTypeImpl(ParseInput.Callback callback2) {
        this.mCallback = callback2;
    }

    public ParseInput reset() {
        this.mResult = null;
        this.mErrorCode = 1;
        this.mErrorMessage = null;
        this.mException = null;
        if (this.mDeferredErrors != null) {
            this.mDeferredErrors.erase();
        }
        this.mPackageName = null;
        this.mTargetSdkVersion = null;
        return this;
    }

    @Override
    public <ResultType> ParseResult<ResultType> success(ResultType result) {
        if (this.mErrorCode != 1) {
            Slog.wtf(TAG, "Cannot set to success after set to error, was " + this.mErrorMessage, this.mException);
        }
        this.mResult = result;
        return this;
    }

    @Override
    public ParseResult<?> deferError(String parseError, long deferredError) {
        if (this.mTargetSdkVersion != null) {
            if (this.mDeferredErrors != null && this.mDeferredErrors.containsKey(deferredError)) {
                return this.success(null);
            }
            if (this.mCallback.isChangeEnabled(deferredError, this.mPackageName, this.mTargetSdkVersion)) {
                return this.error(parseError);
            }
            if (this.mDeferredErrors == null) {
                this.mDeferredErrors = new ArrayMap();
            }
            this.mDeferredErrors.put(deferredError, null);
            return this.success(null);
        }
        if (this.mDeferredErrors == null) {
            this.mDeferredErrors = new ArrayMap();
        }
        this.mDeferredErrors.putIfAbsent(deferredError, parseError);
        return this.success(null);
    }

    @Override
    public ParseResult<?> enableDeferredError(String packageName, int targetSdkVersion) {
        this.mPackageName = packageName;
        this.mTargetSdkVersion = targetSdkVersion;
        int size = CollectionUtils.size(this.mDeferredErrors);
        for (int index = size - 1; index >= 0; --index) {
            long changeId = this.mDeferredErrors.keyAt(index);
            String errorMessage = this.mDeferredErrors.valueAt(index);
            if (this.mCallback.isChangeEnabled(changeId, this.mPackageName, this.mTargetSdkVersion)) {
                return this.error(errorMessage);
            }
            this.mDeferredErrors.setValueAt(index, null);
        }
        return this.success(null);
    }

    @Override
    public <ResultType> ParseResult<ResultType> skip(String parseError) {
        return this.error(-125, parseError);
    }

    @Override
    public <ResultType> ParseResult<ResultType> error(int parseError) {
        return this.error(parseError, null);
    }

    @Override
    public <ResultType> ParseResult<ResultType> error(String parseError) {
        return this.error(-108, parseError);
    }

    @Override
    public <ResultType> ParseResult<ResultType> error(int errorCode, String errorMessage) {
        return this.error(errorCode, errorMessage, null);
    }

    @Override
    public <ResultType> ParseResult<ResultType> error(ParseResult<?> intentResult) {
        return this.error(intentResult.getErrorCode(), intentResult.getErrorMessage(), intentResult.getException());
    }

    @Override
    public <ResultType> ParseResult<ResultType> error(int errorCode, String errorMessage, Exception exception) {
        this.mErrorCode = errorCode;
        this.mErrorMessage = errorMessage;
        this.mException = exception;
        return this;
    }

    @Override
    public Object getResult() {
        return this.mResult;
    }

    @Override
    public boolean isSuccess() {
        return this.mErrorCode == 1;
    }

    @Override
    public boolean isError() {
        return !this.isSuccess();
    }

    @Override
    public int getErrorCode() {
        return this.mErrorCode;
    }

    @Override
    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    @Override
    public Exception getException() {
        return this.mException;
    }
}

