/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.parsing.component;

import android.annotation.NonNull;
import android.content.pm.ApplicationInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArraySet;
import com.android.internal.util.AnnotationValidations;
import com.android.internal.util.CollectionUtils;
import com.android.internal.util.Parcelling;
import java.util.Collections;
import java.util.Set;

public class ParsedProcess
implements Parcelable {
    protected String name;
    protected Set<String> deniedPermissions = Collections.emptySet();
    protected int gwpAsanMode = -1;
    protected int memtagMode = -1;
    protected int nativeHeapZeroInitialized = -1;
    static Parcelling<Set<String>> sParcellingForDeniedPermissions = Parcelling.Cache.get(Parcelling.BuiltIn.ForInternedStringSet.class);
    public static final Parcelable.Creator<ParsedProcess> CREATOR;

    public ParsedProcess() {
    }

    public ParsedProcess(ParsedProcess other) {
        this.name = other.name;
        this.deniedPermissions = new ArraySet<String>(other.deniedPermissions);
    }

    public void addStateFrom(ParsedProcess other) {
        this.deniedPermissions = CollectionUtils.addAll(this.deniedPermissions, other.deniedPermissions);
    }

    public ParsedProcess(String name, Set<String> deniedPermissions, int gwpAsanMode, int memtagMode, int nativeHeapZeroInitialized) {
        this.name = name;
        AnnotationValidations.validate(NonNull.class, null, (Object)name);
        this.deniedPermissions = deniedPermissions;
        AnnotationValidations.validate(NonNull.class, null, deniedPermissions);
        this.gwpAsanMode = gwpAsanMode;
        AnnotationValidations.validate(ApplicationInfo.GwpAsanMode.class, null, gwpAsanMode);
        this.memtagMode = memtagMode;
        AnnotationValidations.validate(ApplicationInfo.MemtagMode.class, null, memtagMode);
        this.nativeHeapZeroInitialized = nativeHeapZeroInitialized;
        AnnotationValidations.validate(ApplicationInfo.NativeHeapZeroInitialized.class, null, nativeHeapZeroInitialized);
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getDeniedPermissions() {
        return this.deniedPermissions;
    }

    public int getGwpAsanMode() {
        return this.gwpAsanMode;
    }

    public int getMemtagMode() {
        return this.memtagMode;
    }

    public int getNativeHeapZeroInitialized() {
        return this.nativeHeapZeroInitialized;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.name);
        sParcellingForDeniedPermissions.parcel(this.deniedPermissions, dest, flags);
        dest.writeInt(this.gwpAsanMode);
        dest.writeInt(this.memtagMode);
        dest.writeInt(this.nativeHeapZeroInitialized);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    protected ParsedProcess(Parcel in) {
        String _name = in.readString();
        Set<String> _deniedPermissions = sParcellingForDeniedPermissions.unparcel(in);
        int _gwpAsanMode = in.readInt();
        int _memtagMode = in.readInt();
        int _nativeHeapZeroInitialized = in.readInt();
        this.name = _name;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.name);
        this.deniedPermissions = _deniedPermissions;
        AnnotationValidations.validate(NonNull.class, null, this.deniedPermissions);
        this.gwpAsanMode = _gwpAsanMode;
        AnnotationValidations.validate(ApplicationInfo.GwpAsanMode.class, null, this.gwpAsanMode);
        this.memtagMode = _memtagMode;
        AnnotationValidations.validate(ApplicationInfo.MemtagMode.class, null, this.memtagMode);
        this.nativeHeapZeroInitialized = _nativeHeapZeroInitialized;
        AnnotationValidations.validate(ApplicationInfo.NativeHeapZeroInitialized.class, null, this.nativeHeapZeroInitialized);
    }

    @Deprecated
    private void __metadata() {
    }

    static {
        if (sParcellingForDeniedPermissions == null) {
            sParcellingForDeniedPermissions = Parcelling.Cache.put(new Parcelling.BuiltIn.ForInternedStringSet());
        }
        CREATOR = new Parcelable.Creator<ParsedProcess>(){

            public ParsedProcess[] newArray(int size) {
                return new ParsedProcess[size];
            }

            @Override
            public ParsedProcess createFromParcel(Parcel in) {
                return new ParsedProcess(in);
            }
        };
    }
}

