/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.parsing.component;

import android.annotation.NonNull;
import android.annotation.StringRes;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArraySet;
import com.android.internal.util.AnnotationValidations;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public class ParsedAttribution
implements Parcelable {
    public static final int MAX_ATTRIBUTION_TAG_LEN = 50;
    private static final int MAX_NUM_ATTRIBUTIONS = 10000;
    public final String tag;
    public final int label;
    public final List<String> inheritFrom;
    public static final Parcelable.Creator<ParsedAttribution> CREATOR = new Parcelable.Creator<ParsedAttribution>(){

        public ParsedAttribution[] newArray(int size) {
            return new ParsedAttribution[size];
        }

        @Override
        public ParsedAttribution createFromParcel(Parcel in) {
            return new ParsedAttribution(in);
        }
    };

    public static boolean isCombinationValid(List<ParsedAttribution> attributions) {
        int attributionNum;
        if (attributions == null) {
            return true;
        }
        ArraySet<String> attributionTags = new ArraySet<String>(attributions.size());
        ArraySet<String> inheritFromAttributionTags = new ArraySet<String>();
        int numAttributions = attributions.size();
        if (numAttributions > 10000) {
            return false;
        }
        for (attributionNum = 0; attributionNum < numAttributions; ++attributionNum) {
            boolean wasAdded = attributionTags.add(attributions.get((int)attributionNum).tag);
            if (wasAdded) continue;
            return false;
        }
        for (attributionNum = 0; attributionNum < numAttributions; ++attributionNum) {
            ParsedAttribution feature = attributions.get(attributionNum);
            int numInheritFrom = feature.inheritFrom.size();
            for (int inheritFromNum = 0; inheritFromNum < numInheritFrom; ++inheritFromNum) {
                String inheritFrom = feature.inheritFrom.get(inheritFromNum);
                if (attributionTags.contains(inheritFrom)) {
                    return false;
                }
                boolean wasAdded = inheritFromAttributionTags.add(inheritFrom);
                if (wasAdded) continue;
                return false;
            }
        }
        return true;
    }

    public static String maxToString(int value2) {
        switch (value2) {
            case 50: {
                return "MAX_ATTRIBUTION_TAG_LEN";
            }
            case 10000: {
                return "MAX_NUM_ATTRIBUTIONS";
            }
        }
        return Integer.toHexString(value2);
    }

    public ParsedAttribution(String tag, int label, List<String> inheritFrom) {
        this.tag = tag;
        AnnotationValidations.validate(NonNull.class, null, (Object)tag);
        this.label = label;
        AnnotationValidations.validate(StringRes.class, null, label);
        this.inheritFrom = inheritFrom;
        AnnotationValidations.validate(NonNull.class, null, inheritFrom);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.tag);
        dest.writeInt(this.label);
        dest.writeStringList(this.inheritFrom);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    protected ParsedAttribution(Parcel in) {
        String _tag = in.readString();
        int _label = in.readInt();
        ArrayList<String> _inheritFrom = new ArrayList<String>();
        in.readStringList(_inheritFrom);
        this.tag = _tag;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.tag);
        this.label = _label;
        AnnotationValidations.validate(StringRes.class, null, this.label);
        this.inheritFrom = _inheritFrom;
        AnnotationValidations.validate(NonNull.class, null, this.inheritFrom);
    }

    @Deprecated
    private void __metadata() {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Max {
    }
}

