/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.parsing.component;

import android.content.pm.PackageUserState;
import android.content.pm.parsing.ParsingPackage;
import android.content.pm.parsing.ParsingPackageUtils;
import android.content.pm.parsing.ParsingUtils;
import android.content.pm.parsing.component.ParsedComponent;
import android.content.pm.parsing.component.ParsedComponentUtils;
import android.content.pm.parsing.component.ParsedIntentInfo;
import android.content.pm.parsing.component.ParsedMainComponent;
import android.content.pm.parsing.result.ParseInput;
import android.content.pm.parsing.result.ParseResult;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os.Bundle;
import android.text.TextUtils;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParserException;

public class ComponentParseUtils {
    public static boolean isImplicitlyExposedIntent(ParsedIntentInfo intentInfo) {
        return intentInfo.hasCategory("android.intent.category.BROWSABLE") || intentInfo.hasAction("android.intent.action.SEND") || intentInfo.hasAction("android.intent.action.SENDTO") || intentInfo.hasAction("android.intent.action.SEND_MULTIPLE");
    }

    static <Component extends ParsedComponent> ParseResult<Component> parseAllMetaData(ParsingPackage pkg, Resources res, XmlResourceParser parser, String tag, Component component, ParseInput input) throws XmlPullParserException, IOException {
        int type;
        int depth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > depth)) {
            ParseResult<Bundle> result;
            if (type != 2 || !(result = "meta-data".equals(parser.getName()) ? ParsedComponentUtils.addMetaData(component, pkg, res, parser, input) : ParsingUtils.unknownTag(tag, pkg, parser, input)).isError()) continue;
            return input.error(result);
        }
        return input.success(component);
    }

    public static ParseResult<String> buildProcessName(String pkg, String defProc, CharSequence procSeq, int flags, String[] separateProcesses, ParseInput input) {
        if ((flags & 2) != 0 && !"system".contentEquals(procSeq)) {
            return input.success(defProc != null ? defProc : pkg);
        }
        if (separateProcesses != null) {
            for (int i = separateProcesses.length - 1; i >= 0; --i) {
                String sp = separateProcesses[i];
                if (!sp.equals(pkg) && !sp.equals(defProc) && !sp.contentEquals(procSeq)) continue;
                return input.success(pkg);
            }
        }
        if (procSeq == null || procSeq.length() <= 0) {
            return input.success(defProc);
        }
        ParseResult<String> nameResult = ComponentParseUtils.buildCompoundName(pkg, procSeq, "process", input);
        return input.success(TextUtils.safeIntern(nameResult.getResult()));
    }

    public static ParseResult<String> buildTaskAffinityName(String pkg, String defProc, CharSequence procSeq, ParseInput input) {
        if (procSeq == null) {
            return input.success(defProc);
        }
        if (procSeq.length() <= 0) {
            return input.success(null);
        }
        return ComponentParseUtils.buildCompoundName(pkg, procSeq, "taskAffinity", input);
    }

    public static ParseResult<String> buildCompoundName(String pkg, CharSequence procSeq, String type, ParseInput input) {
        ParseResult nameResult;
        String proc = procSeq.toString();
        char c = proc.charAt(0);
        if (pkg != null && c == ':') {
            if (proc.length() < 2) {
                return input.error("Bad " + type + " name " + proc + " in package " + pkg + ": must be at least two characters");
            }
            String subName = proc.substring(1);
            ParseResult nameResult2 = ParsingPackageUtils.validateName(input, subName, false, false);
            if (nameResult2.isError()) {
                return input.error("Invalid " + type + " name " + proc + " in package " + pkg + ": " + nameResult2.getErrorMessage());
            }
            return input.success(pkg + proc);
        }
        if (!"system".equals(proc) && (nameResult = ParsingPackageUtils.validateName(input, proc, true, false)).isError()) {
            return input.error("Invalid " + type + " name " + proc + " in package " + pkg + ": " + nameResult.getErrorMessage());
        }
        return input.success(proc);
    }

    public static int flag(int flag, int attribute, TypedArray typedArray) {
        return typedArray.getBoolean(attribute, false) ? flag : 0;
    }

    public static int flag(int flag, int attribute, boolean defaultValue2, TypedArray typedArray) {
        return typedArray.getBoolean(attribute, defaultValue2) ? flag : 0;
    }

    public static CharSequence getNonLocalizedLabel(ParsedComponent component) {
        return component.nonLocalizedLabel;
    }

    public static int getIcon(ParsedComponent component) {
        return component.icon;
    }

    public static boolean isMatch(PackageUserState state, boolean isSystem, boolean isPackageEnabled, ParsedMainComponent component, int flags) {
        return state.isMatch(isSystem, isPackageEnabled, component.isEnabled(), component.isDirectBootAware(), component.getName(), flags);
    }

    public static boolean isEnabled(PackageUserState state, boolean isPackageEnabled, ParsedMainComponent parsedComponent, int flags) {
        return state.isEnabled(isPackageEnabled, parsedComponent.isEnabled(), parsedComponent.getName(), flags);
    }
}

