/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.parsing;

import android.content.pm.PackageParser;
import android.content.pm.VerifierInfo;
import android.content.pm.parsing.ApkLite;
import android.content.pm.parsing.PackageLite;
import android.content.pm.parsing.ParsingPackageUtils;
import android.content.pm.parsing.result.ParseInput;
import android.content.pm.parsing.result.ParseResult;
import android.content.res.ApkAssets;
import android.content.res.XmlResourceParser;
import android.os.Trace;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.AttributeSet;
import android.util.Pair;
import android.util.Slog;
import com.android.internal.util.ArrayUtils;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParserException;

public class ApkLiteParseUtils {
    private static final String TAG = "PackageParsing";
    private static final int PARSE_DEFAULT_INSTALL_LOCATION = -1;
    private static final Comparator<String> sSplitNameComparator = new SplitNameComparator();
    public static final String APK_FILE_EXTENSION = ".apk";

    public static ParseResult<PackageLite> parsePackageLite(ParseInput input, File packageFile, int flags) {
        if (packageFile.isDirectory()) {
            return ApkLiteParseUtils.parseClusterPackageLite(input, packageFile, flags);
        }
        return ApkLiteParseUtils.parseMonolithicPackageLite(input, packageFile, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ParseResult<PackageLite> parseMonolithicPackageLite(ParseInput input, File packageFile, int flags) {
        Trace.traceBegin(262144L, "parseApkLite");
        try {
            ParseResult<ApkLite> result = ApkLiteParseUtils.parseApkLite(input, packageFile, flags);
            if (result.isError()) {
                ParseResult<PackageLite> parseResult = input.error(result);
                return parseResult;
            }
            ApkLite baseApk = result.getResult();
            String packagePath = packageFile.getAbsolutePath();
            ParseResult<PackageLite> parseResult = input.success(new PackageLite(packagePath, baseApk.getPath(), baseApk, null, null, null, null, null, null, baseApk.getTargetSdkVersion()));
            return parseResult;
        }
        finally {
            Trace.traceEnd(262144L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ParseResult<PackageLite> parseClusterPackageLite(ParseInput input, File packageDir, int flags) {
        File[] files = packageDir.listFiles();
        if (ArrayUtils.isEmpty(files)) {
            return input.error(-100, "No packages found in split");
        }
        if (files.length == 1 && files[0].isDirectory()) {
            return ApkLiteParseUtils.parseClusterPackageLite(input, files[0], flags);
        }
        String packageName = null;
        int versionCode = 0;
        ArrayMap<String, ApkLite> apks = new ArrayMap<String, ApkLite>();
        Trace.traceBegin(262144L, "parseApkLite");
        try {
            for (File file2 : files) {
                if (!ApkLiteParseUtils.isApkFile(file2)) continue;
                ParseResult<ApkLite> result = ApkLiteParseUtils.parseApkLite(input, file2, flags);
                if (result.isError()) {
                    ParseResult<PackageLite> parseResult = input.error(result);
                    return parseResult;
                }
                ApkLite lite = result.getResult();
                if (packageName == null) {
                    packageName = lite.getPackageName();
                    versionCode = lite.getVersionCode();
                } else {
                    if (!packageName.equals(lite.getPackageName())) {
                        ParseResult<PackageLite> parseResult = input.error(-101, "Inconsistent package " + lite.getPackageName() + " in " + file2 + "; expected " + packageName);
                        return parseResult;
                    }
                    if (versionCode != lite.getVersionCode()) {
                        ParseResult<PackageLite> parseResult = input.error(-101, "Inconsistent version " + lite.getVersionCode() + " in " + file2 + "; expected " + versionCode);
                        return parseResult;
                    }
                }
                if (apks.put(lite.getSplitName(), lite) == null) continue;
                ParseResult<PackageLite> parseResult = input.error(-101, "Split name " + lite.getSplitName() + " defined more than once; most recent was " + file2);
                return parseResult;
            }
        }
        finally {
            Trace.traceEnd(262144L);
        }
        ApkLite baseApk = (ApkLite)apks.remove(null);
        return ApkLiteParseUtils.composePackageLiteFromApks(input, packageDir, baseApk, apks);
    }

    public static ParseResult<PackageLite> composePackageLiteFromApks(ParseInput input, File packageDir, ApkLite baseApk, ArrayMap<String, ApkLite> splitApks) {
        return ApkLiteParseUtils.composePackageLiteFromApks(input, packageDir, baseApk, splitApks, false);
    }

    public static ParseResult<PackageLite> composePackageLiteFromApks(ParseInput input, File packageDir, ApkLite baseApk, ArrayMap<String, ApkLite> splitApks, boolean apkRenamed) {
        if (baseApk == null) {
            return input.error(-101, "Missing base APK in " + packageDir);
        }
        int size = ArrayUtils.size(splitApks);
        String[] splitNames = null;
        boolean[] isFeatureSplits = null;
        String[] usesSplitNames = null;
        String[] configForSplits = null;
        String[] splitCodePaths = null;
        int[] splitRevisionCodes = null;
        if (size > 0) {
            splitNames = new String[size];
            isFeatureSplits = new boolean[size];
            usesSplitNames = new String[size];
            configForSplits = new String[size];
            splitCodePaths = new String[size];
            splitRevisionCodes = new int[size];
            splitNames = splitApks.keySet().toArray(splitNames);
            Arrays.sort(splitNames, sSplitNameComparator);
            for (int i = 0; i < size; ++i) {
                ApkLite apk = splitApks.get(splitNames[i]);
                usesSplitNames[i] = apk.getUsesSplitName();
                isFeatureSplits[i] = apk.isFeatureSplit();
                configForSplits[i] = apk.getConfigForSplit();
                splitCodePaths[i] = apkRenamed ? new File(packageDir, ApkLiteParseUtils.splitNameToFileName(apk)).getAbsolutePath() : apk.getPath();
                splitRevisionCodes[i] = apk.getRevisionCode();
            }
        }
        String codePath = packageDir.getAbsolutePath();
        String baseCodePath = apkRenamed ? new File(packageDir, ApkLiteParseUtils.splitNameToFileName(baseApk)).getAbsolutePath() : baseApk.getPath();
        return input.success(new PackageLite(codePath, baseCodePath, baseApk, splitNames, isFeatureSplits, usesSplitNames, configForSplits, splitCodePaths, splitRevisionCodes, baseApk.getTargetSdkVersion()));
    }

    public static String splitNameToFileName(ApkLite apk) {
        Objects.requireNonNull(apk);
        String fileName = apk.getSplitName() == null ? "base" : "split_" + apk.getSplitName();
        return fileName + APK_FILE_EXTENSION;
    }

    public static ParseResult<ApkLite> parseApkLite(ParseInput input, File apkFile, int flags) {
        return ApkLiteParseUtils.parseApkLiteInner(input, apkFile, null, null, flags);
    }

    public static ParseResult<ApkLite> parseApkLite(ParseInput input, FileDescriptor fd, String debugPathName, int flags) {
        return ApkLiteParseUtils.parseApkLiteInner(input, null, fd, debugPathName, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static ParseResult<ApkLite> parseApkLiteInner(ParseInput input, File apkFile, FileDescriptor fd, String debugPathName, int flags) {
        block27: {
            apkPath = fd != null ? debugPathName : apkFile.getAbsolutePath();
            parser = null;
            apkAssets = null;
            try {
                apkAssets = fd != null ? ApkAssets.loadFromFd(fd, debugPathName, 0, null) : ApkAssets.loadFromPath(apkPath);
            }
            catch (IOException e) {
                var9_11 = input.error(-100, "Failed to parse " + apkPath, e);
                IoUtils.closeQuietly(parser);
                if (apkAssets != null) {
                    try {
                        apkAssets.close();
                    }
                    catch (Throwable var10_15) {
                        // empty catch block
                    }
                }
                return var9_11;
            }
            parser = apkAssets.openXml("AndroidManifest.xml");
            if ((flags & 32) == 0) ** GOTO lbl46
            skipVerify = (flags & 16) != 0;
            Trace.traceBegin(262144L, "collectCertificates");
            result = ParsingPackageUtils.getSigningDetails(input, apkFile.getAbsolutePath(), skipVerify, false, PackageParser.SigningDetails.UNKNOWN, 0);
            if (!result.isError()) break block27;
            var11_19 = input.error(result);
            Trace.traceEnd(262144L);
            IoUtils.closeQuietly(parser);
            if (apkAssets != null) {
                try {
                    apkAssets.close();
                }
                catch (Throwable var12_20) {
                    // empty catch block
                }
            }
            return var11_19;
        }
        try {
            signingDetails = result.getResult();
            {
                catch (Throwable var13_21) {
                    throw var13_21;
                }
            }
            finally {
                Trace.traceEnd(262144L);
            }
lbl46:
            // 1 sources

            signingDetails = PackageParser.SigningDetails.UNKNOWN;
            var9_13 = ApkLiteParseUtils.parseApkLite(input, apkPath, parser, signingDetails);
        }
        catch (IOException | RuntimeException | XmlPullParserException e) {
            try {
                Slog.w("PackageParsing", "Failed to parse " + apkPath, e);
                var9_14 = input.error(-102, "Failed to parse " + apkPath, (Exception)e);
            }
            catch (Throwable var14_22) {
                IoUtils.closeQuietly(parser);
                if (apkAssets != null) {
                    try {
                        apkAssets.close();
                    }
                    catch (Throwable var15_23) {
                        // empty catch block
                    }
                }
                throw var14_22;
            }
            IoUtils.closeQuietly(parser);
            if (apkAssets != null) {
                try {
                    apkAssets.close();
                }
                catch (Throwable var10_18) {
                    // empty catch block
                }
            }
            return var9_14;
        }
        IoUtils.closeQuietly(parser);
        if (apkAssets != null) {
            try {
                apkAssets.close();
            }
            catch (Throwable var10_17) {
                // empty catch block
            }
        }
        return var9_13;
    }

    private static ParseResult<ApkLite> parseApkLite(ParseInput input, String codePath, XmlResourceParser parser, PackageParser.SigningDetails signingDetails) throws IOException, XmlPullParserException {
        int type;
        ParseResult<Pair<String, String>> result = ApkLiteParseUtils.parsePackageSplitNames(input, parser);
        if (result.isError()) {
            return input.error(result);
        }
        Pair<String, String> packageSplit = result.getResult();
        int installLocation = parser.getAttributeIntValue("http://schemas.android.com/apk/res/android", "installLocation", -1);
        int versionCode = parser.getAttributeIntValue("http://schemas.android.com/apk/res/android", "versionCode", 0);
        int versionCodeMajor = parser.getAttributeIntValue("http://schemas.android.com/apk/res/android", "versionCodeMajor", 0);
        int revisionCode = parser.getAttributeIntValue("http://schemas.android.com/apk/res/android", "revisionCode", 0);
        boolean coreApp = parser.getAttributeBooleanValue(null, "coreApp", false);
        boolean isolatedSplits = parser.getAttributeBooleanValue("http://schemas.android.com/apk/res/android", "isolatedSplits", false);
        boolean isFeatureSplit = parser.getAttributeBooleanValue("http://schemas.android.com/apk/res/android", "isFeatureSplit", false);
        boolean isSplitRequired = parser.getAttributeBooleanValue("http://schemas.android.com/apk/res/android", "isSplitRequired", false);
        String configForSplit = parser.getAttributeValue(null, "configForSplit");
        int targetSdkVersion = 0;
        int minSdkVersion = 1;
        boolean debuggable = false;
        boolean profilableByShell = false;
        boolean multiArch = false;
        boolean use32bitAbi = false;
        boolean extractNativeLibs = true;
        boolean useEmbeddedDex = false;
        String usesSplitName = null;
        String targetPackage = null;
        boolean overlayIsStatic = false;
        int overlayPriority = 0;
        int rollbackDataPolicy = 0;
        String requiredSystemPropertyName = null;
        String requiredSystemPropertyValue = null;
        int searchDepth = parser.getDepth() + 1;
        ArrayList<VerifierInfo> verifiers = new ArrayList<VerifierInfo>();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() >= searchDepth)) {
            ParseResult<Integer> targetResult;
            if (type == 3 || type == 4 || parser.getDepth() != searchDepth) continue;
            if ("package-verifier".equals(parser.getName())) {
                VerifierInfo verifier = ApkLiteParseUtils.parseVerifier(parser);
                if (verifier == null) continue;
                verifiers.add(verifier);
                continue;
            }
            if ("application".equals(parser.getName())) {
                int innerType;
                debuggable = parser.getAttributeBooleanValue("http://schemas.android.com/apk/res/android", "debuggable", false);
                multiArch = parser.getAttributeBooleanValue("http://schemas.android.com/apk/res/android", "multiArch", false);
                use32bitAbi = parser.getAttributeBooleanValue("http://schemas.android.com/apk/res/android", "use32bitAbi", false);
                extractNativeLibs = parser.getAttributeBooleanValue("http://schemas.android.com/apk/res/android", "extractNativeLibs", true);
                useEmbeddedDex = parser.getAttributeBooleanValue("http://schemas.android.com/apk/res/android", "useEmbeddedDex", false);
                rollbackDataPolicy = parser.getAttributeIntValue("http://schemas.android.com/apk/res/android", "rollbackDataPolicy", 0);
                int innerDepth = parser.getDepth();
                while ((innerType = parser.next()) != 1 && (innerType != 3 || parser.getDepth() > innerDepth)) {
                    if (innerType == 3 || innerType == 4 || parser.getDepth() != innerDepth + 1 || !"profileable".equals(parser.getName())) continue;
                    profilableByShell = parser.getAttributeBooleanValue("http://schemas.android.com/apk/res/android", "shell", profilableByShell);
                }
                continue;
            }
            if ("overlay".equals(parser.getName())) {
                requiredSystemPropertyName = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "requiredSystemPropertyName");
                requiredSystemPropertyValue = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "requiredSystemPropertyValue");
                targetPackage = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "targetPackage");
                overlayIsStatic = parser.getAttributeBooleanValue("http://schemas.android.com/apk/res/android", "isStatic", false);
                overlayPriority = parser.getAttributeIntValue("http://schemas.android.com/apk/res/android", "priority", 0);
                continue;
            }
            if ("uses-split".equals(parser.getName())) {
                if (usesSplitName != null) {
                    Slog.w(TAG, "Only one <uses-split> permitted. Ignoring others.");
                    continue;
                }
                usesSplitName = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "name");
                if (usesSplitName != null) continue;
                return input.error(-108, "<uses-split> tag requires 'android:name' attribute");
            }
            if (!"uses-sdk".equals(parser.getName())) continue;
            String minSdkVersionString = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "minSdkVersion");
            String targetSdkVersionString = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "targetSdkVersion");
            int minVer = 1;
            String minCode = null;
            int targetVer = 0;
            String targetCode = null;
            if (!TextUtils.isEmpty(minSdkVersionString)) {
                try {
                    minVer = Integer.parseInt(minSdkVersionString);
                }
                catch (NumberFormatException ignored) {
                    minCode = minSdkVersionString;
                }
            }
            if (!TextUtils.isEmpty(targetSdkVersionString)) {
                try {
                    targetVer = Integer.parseInt(targetSdkVersionString);
                }
                catch (NumberFormatException ignored) {
                    targetCode = targetSdkVersionString;
                    if (minCode == null) {
                        minCode = targetCode;
                    }
                }
            } else {
                targetVer = minVer;
                targetCode = minCode;
            }
            if ((targetResult = ParsingPackageUtils.computeTargetSdkVersion(targetVer, targetCode, ParsingPackageUtils.SDK_CODENAMES, input)).isError()) {
                return input.error(targetResult);
            }
            targetSdkVersion = targetResult.getResult();
            ParseResult<Integer> minResult = ParsingPackageUtils.computeMinSdkVersion(minVer, minCode, ParsingPackageUtils.SDK_VERSION, ParsingPackageUtils.SDK_CODENAMES, input);
            if (minResult.isError()) {
                return input.error(minResult);
            }
            minSdkVersion = minResult.getResult();
        }
        if (!PackageParser.checkRequiredSystemProperties(requiredSystemPropertyName, requiredSystemPropertyValue)) {
            Slog.i(TAG, "Skipping target and overlay pair " + targetPackage + " and " + codePath + ": overlay ignored due to required system property: " + requiredSystemPropertyName + " with value: " + requiredSystemPropertyValue);
            targetPackage = null;
            overlayIsStatic = false;
            overlayPriority = 0;
        }
        return input.success(new ApkLite(codePath, (String)packageSplit.first, (String)packageSplit.second, isFeatureSplit, configForSplit, usesSplitName, isSplitRequired, versionCode, versionCodeMajor, revisionCode, installLocation, verifiers, signingDetails, coreApp, debuggable, profilableByShell, multiArch, use32bitAbi, useEmbeddedDex, extractNativeLibs, isolatedSplits, targetPackage, overlayIsStatic, overlayPriority, minSdkVersion, targetSdkVersion, rollbackDataPolicy));
    }

    public static ParseResult<Pair<String, String>> parsePackageSplitNames(ParseInput input, XmlResourceParser parser) throws IOException, XmlPullParserException {
        ParseResult nameResult;
        int type;
        while ((type = parser.next()) != 2 && type != 1) {
        }
        if (type != 2) {
            return input.error(-108, "No start tag found");
        }
        if (!parser.getName().equals("manifest")) {
            return input.error(-108, "No <manifest> tag");
        }
        String packageName = parser.getAttributeValue(null, "package");
        if (!"android".equals(packageName) && (nameResult = ParsingPackageUtils.validateName(input, packageName, true, true)).isError()) {
            return input.error(-106, "Invalid manifest package: " + nameResult.getErrorMessage());
        }
        String splitName = parser.getAttributeValue(null, "split");
        if (splitName != null) {
            if (splitName.length() == 0) {
                splitName = null;
            } else {
                ParseResult nameResult2 = ParsingPackageUtils.validateName(input, splitName, false, false);
                if (nameResult2.isError()) {
                    return input.error(-106, "Invalid manifest split: " + nameResult2.getErrorMessage());
                }
            }
        }
        return input.success(Pair.create(packageName.intern(), splitName != null ? splitName.intern() : splitName));
    }

    public static VerifierInfo parseVerifier(AttributeSet attrs) {
        String packageName = attrs.getAttributeValue("http://schemas.android.com/apk/res/android", "name");
        String encodedPublicKey = attrs.getAttributeValue("http://schemas.android.com/apk/res/android", "publicKey");
        if (packageName == null || packageName.length() == 0) {
            Slog.i(TAG, "verifier package name was null; skipping");
            return null;
        }
        PublicKey publicKey = PackageParser.parsePublicKey(encodedPublicKey);
        if (publicKey == null) {
            Slog.i(TAG, "Unable to parse verifier public key for " + packageName);
            return null;
        }
        return new VerifierInfo(packageName, publicKey);
    }

    public static boolean isApkFile(File file2) {
        return ApkLiteParseUtils.isApkPath(file2.getName());
    }

    public static boolean isApkPath(String path) {
        return path.endsWith(APK_FILE_EXTENSION);
    }

    private static class SplitNameComparator
    implements Comparator<String> {
        private SplitNameComparator() {
        }

        @Override
        public int compare(String lhs, String rhs) {
            if (lhs == null) {
                return -1;
            }
            if (rhs == null) {
                return 1;
            }
            return lhs.compareTo(rhs);
        }
    }
}

