/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.ComponentInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.RegisteredServicesCacheListener;
import android.content.pm.ResolveInfo;
import android.content.pm.UserInfo;
import android.content.pm.XmlSerializerAndParser;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.os.Environment;
import android.os.Handler;
import android.os.UserHandle;
import android.os.UserManager;
import android.util.AtomicFile;
import android.util.AttributeSet;
import android.util.IntArray;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.util.TypedXmlPullParser;
import android.util.TypedXmlSerializer;
import android.util.Xml;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.BackgroundThread;
import com.android.internal.util.ArrayUtils;
import com.google.android.collect.Lists;
import com.google.android.collect.Maps;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParserException;

public abstract class RegisteredServicesCache<V> {
    private static final String TAG = "PackageManager";
    private static final boolean DEBUG = false;
    protected static final String REGISTERED_SERVICES_DIR = "registered_services";
    public final Context mContext;
    private final String mInterfaceName;
    private final String mMetaDataName;
    private final String mAttributesName;
    private final XmlSerializerAndParser<V> mSerializerAndParser;
    protected final Object mServicesLock = new Object();
    @GuardedBy(value={"mServicesLock"})
    private final SparseArray<UserServices<V>> mUserServices = new SparseArray(2);
    private RegisteredServicesCacheListener<V> mListener;
    private Handler mHandler;
    private final BroadcastReceiver mPackageReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            int uid = intent.getIntExtra("android.intent.extra.UID", -1);
            if (uid != -1) {
                RegisteredServicesCache.this.handlePackageEvent(intent, UserHandle.getUserId(uid));
            }
        }
    };
    private final BroadcastReceiver mExternalReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            RegisteredServicesCache.this.handlePackageEvent(intent, 0);
        }
    };
    private final BroadcastReceiver mUserRemovedReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            int userId = intent.getIntExtra("android.intent.extra.user_handle", -1);
            RegisteredServicesCache.this.onUserRemoved(userId);
        }
    };

    @GuardedBy(value={"mServicesLock"})
    private UserServices<V> findOrCreateUserLocked(int userId) {
        return this.findOrCreateUserLocked(userId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"mServicesLock"})
    private UserServices<V> findOrCreateUserLocked(int userId, boolean loadFromFileIfNew) {
        UserServices<V> services = this.mUserServices.get(userId);
        if (services == null) {
            AtomicFile file2;
            UserInfo user;
            services = new UserServices();
            this.mUserServices.put(userId, services);
            if (loadFromFileIfNew && this.mSerializerAndParser != null && (user = this.getUser(userId)) != null && (file2 = this.createFileForUser(user.id)).getBaseFile().exists()) {
                FileInputStream is = null;
                try {
                    is = file2.openRead();
                    this.readPersistentServicesLocked(is);
                }
                catch (Exception e) {
                    Log.w(TAG, "Error reading persistent services for user " + user.id, e);
                }
                finally {
                    IoUtils.closeQuietly(is);
                }
            }
        }
        return services;
    }

    @UnsupportedAppUsage
    public RegisteredServicesCache(Context context, String interfaceName, String metaDataName, String attributeName, XmlSerializerAndParser<V> serializerAndParser) {
        this.mContext = context;
        this.mInterfaceName = interfaceName;
        this.mMetaDataName = metaDataName;
        this.mAttributesName = attributeName;
        this.mSerializerAndParser = serializerAndParser;
        this.migrateIfNecessaryLocked();
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.PACKAGE_ADDED");
        intentFilter.addAction("android.intent.action.PACKAGE_CHANGED");
        intentFilter.addAction("android.intent.action.PACKAGE_REMOVED");
        intentFilter.addDataScheme("package");
        Handler handler = BackgroundThread.getHandler();
        this.mContext.registerReceiverAsUser(this.mPackageReceiver, UserHandle.ALL, intentFilter, null, handler);
        IntentFilter sdFilter = new IntentFilter();
        sdFilter.addAction("android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE");
        sdFilter.addAction("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE");
        this.mContext.registerReceiver(this.mExternalReceiver, sdFilter, null, handler);
        IntentFilter userFilter = new IntentFilter();
        sdFilter.addAction("android.intent.action.USER_REMOVED");
        this.mContext.registerReceiver(this.mUserRemovedReceiver, userFilter, null, handler);
    }

    private void handlePackageEvent(Intent intent, int userId) {
        String action2 = intent.getAction();
        boolean isRemoval = "android.intent.action.PACKAGE_REMOVED".equals(action2) || "android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE".equals(action2);
        boolean replacing = intent.getBooleanExtra("android.intent.extra.REPLACING", false);
        if (!isRemoval || !replacing) {
            int[] uids = null;
            if ("android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE".equals(action2) || "android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE".equals(action2)) {
                uids = intent.getIntArrayExtra("android.intent.extra.changed_uid_list");
            } else {
                int uid = intent.getIntExtra("android.intent.extra.UID", -1);
                if (uid > 0) {
                    uids = new int[]{uid};
                }
            }
            this.generateServicesMap(uids, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateCache(int userId) {
        Object object = this.mServicesLock;
        synchronized (object) {
            UserServices<V> user = this.findOrCreateUserLocked(userId);
            user.services = null;
            this.onServicesChangedLocked(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(FileDescriptor fd, PrintWriter fout, String[] args, int userId) {
        Object object = this.mServicesLock;
        synchronized (object) {
            UserServices<V> user = this.findOrCreateUserLocked(userId);
            if (user.services != null) {
                fout.println("RegisteredServicesCache: " + user.services.size() + " services");
                for (ServiceInfo info : user.services.values()) {
                    fout.println("  " + info);
                }
            } else {
                fout.println("RegisteredServicesCache: services not loaded");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisteredServicesCacheListener<V> getListener() {
        RegisteredServicesCache registeredServicesCache = this;
        synchronized (registeredServicesCache) {
            return this.mListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListener(RegisteredServicesCacheListener<V> listener2, Handler handler) {
        if (handler == null) {
            handler = BackgroundThread.getHandler();
        }
        RegisteredServicesCache registeredServicesCache = this;
        synchronized (registeredServicesCache) {
            this.mHandler = handler;
            this.mListener = listener2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListener(V type, int userId, boolean removed) {
        Handler handler;
        RegisteredServicesCacheListener listener2;
        RegisteredServicesCache registeredServicesCache = this;
        synchronized (registeredServicesCache) {
            listener2 = this.mListener;
            handler = this.mHandler;
        }
        if (listener2 == null) {
            return;
        }
        RegisteredServicesCacheListener listener22 = listener2;
        handler.post(() -> {
            try {
                listener22.onServiceChanged(type, userId, removed);
            }
            catch (Throwable th) {
                Slog.wtf(TAG, "Exception from onServiceChanged", th);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceInfo<V> getServiceInfo(V type, int userId) {
        Object object = this.mServicesLock;
        synchronized (object) {
            UserServices<V> user = this.findOrCreateUserLocked(userId);
            if (user.services == null) {
                this.generateServicesMap(null, userId);
            }
            return user.services.get(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ServiceInfo<V>> getAllServices(int userId) {
        Object object = this.mServicesLock;
        synchronized (object) {
            UserServices<V> user = this.findOrCreateUserLocked(userId);
            if (user.services == null) {
                this.generateServicesMap(null, userId);
            }
            return Collections.unmodifiableCollection(new ArrayList(user.services.values()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateServices(int userId) {
        ArrayList allServices;
        Object object = this.mServicesLock;
        synchronized (object) {
            UserServices<V> user = this.findOrCreateUserLocked(userId);
            if (user.services == null) {
                return;
            }
            allServices = new ArrayList(user.services.values());
        }
        IntArray updatedUids = null;
        for (ServiceInfo serviceInfo : allServices) {
            long versionCode = serviceInfo.componentInfo.applicationInfo.versionCode;
            String pkg = serviceInfo.componentInfo.packageName;
            ApplicationInfo newAppInfo = null;
            try {
                newAppInfo = this.mContext.getPackageManager().getApplicationInfoAsUser(pkg, 0, userId);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
            if (newAppInfo != null && (long)newAppInfo.versionCode == versionCode) continue;
            if (updatedUids == null) {
                updatedUids = new IntArray();
            }
            updatedUids.add(serviceInfo.uid);
        }
        if (updatedUids != null && updatedUids.size() > 0) {
            int[] updatedUidsArray = updatedUids.toArray();
            this.generateServicesMap(updatedUidsArray, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBindInstantServiceAllowed(int userId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_BIND_INSTANT_SERVICE", "getBindInstantServiceAllowed");
        Object object = this.mServicesLock;
        synchronized (object) {
            UserServices<V> user = this.findOrCreateUserLocked(userId);
            return user.mBindInstantServiceAllowed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBindInstantServiceAllowed(int userId, boolean allowed) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_BIND_INSTANT_SERVICE", "setBindInstantServiceAllowed");
        Object object = this.mServicesLock;
        synchronized (object) {
            UserServices<V> user = this.findOrCreateUserLocked(userId);
            user.mBindInstantServiceAllowed = allowed;
        }
    }

    @VisibleForTesting
    protected boolean inSystemImage(int callerUid) {
        String[] packages = this.mContext.getPackageManager().getPackagesForUid(callerUid);
        if (packages != null) {
            for (String name : packages) {
                try {
                    PackageInfo packageInfo = this.mContext.getPackageManager().getPackageInfo(name, 0);
                    if ((packageInfo.applicationInfo.flags & 1) == 0) continue;
                    return true;
                }
                catch (PackageManager.NameNotFoundException e) {
                    return false;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected List<ResolveInfo> queryIntentServices(int userId) {
        PackageManager pm = this.mContext.getPackageManager();
        int flags = 786560;
        Object object = this.mServicesLock;
        synchronized (object) {
            UserServices<V> user = this.findOrCreateUserLocked(userId);
            if (user.mBindInstantServiceAllowed) {
                flags |= 0x800000;
            }
        }
        return pm.queryIntentServicesAsUser(new Intent(this.mInterfaceName), flags, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateServicesMap(int[] changedUids, int userId) {
        ArrayList<ServiceInfo<V>> serviceInfos = new ArrayList<ServiceInfo<V>>();
        List<ResolveInfo> resolveInfos = this.queryIntentServices(userId);
        for (ResolveInfo resolveInfo : resolveInfos) {
            try {
                ServiceInfo<V> info = this.parseServiceInfo(resolveInfo);
                if (info == null) {
                    Log.w(TAG, "Unable to load service info " + resolveInfo.toString());
                    continue;
                }
                serviceInfos.add(info);
            }
            catch (IOException | XmlPullParserException e) {
                Log.w(TAG, "Unable to load service info " + resolveInfo.toString(), e);
            }
        }
        Object object = this.mServicesLock;
        synchronized (object) {
            boolean firstScan;
            UserServices<V> user = this.findOrCreateUserLocked(userId);
            boolean bl = firstScan = user.services == null;
            if (firstScan) {
                user.services = Maps.newHashMap();
            }
            StringBuilder changes = new StringBuilder();
            boolean changed = false;
            for (ServiceInfo serviceInfo : serviceInfos) {
                Integer previousUid = user.persistentServices.get(serviceInfo.type);
                if (previousUid == null) {
                    changed = true;
                    user.services.put((ServiceInfo)serviceInfo.type, serviceInfo);
                    user.persistentServices.put((Integer)serviceInfo.type, serviceInfo.uid);
                    if (user.mPersistentServicesFileDidNotExist && firstScan) continue;
                    this.notifyListener(serviceInfo.type, userId, false);
                    continue;
                }
                if (previousUid == serviceInfo.uid) {
                    user.services.put((ServiceInfo)serviceInfo.type, serviceInfo);
                    continue;
                }
                if (!this.inSystemImage(serviceInfo.uid) && this.containsTypeAndUid(serviceInfos, serviceInfo.type, previousUid)) continue;
                changed = true;
                user.services.put((ServiceInfo)serviceInfo.type, serviceInfo);
                user.persistentServices.put((Integer)serviceInfo.type, serviceInfo.uid);
                this.notifyListener(serviceInfo.type, userId, false);
            }
            ArrayList toBeRemoved = Lists.newArrayList();
            for (Object v1 : user.persistentServices.keySet()) {
                if (this.containsType(serviceInfos, v1) || !this.containsUid(changedUids, user.persistentServices.get(v1))) continue;
                toBeRemoved.add(v1);
            }
            for (Object v1 : toBeRemoved) {
                changed = true;
                user.persistentServices.remove(v1);
                user.services.remove(v1);
                this.notifyListener(v1, userId, true);
            }
            if (changed) {
                this.onServicesChangedLocked(userId);
                this.writePersistentServicesLocked(user, userId);
            }
        }
    }

    protected void onServicesChangedLocked(int userId) {
    }

    private boolean containsUid(int[] changedUids, int uid) {
        return changedUids == null || ArrayUtils.contains(changedUids, uid);
    }

    private boolean containsType(ArrayList<ServiceInfo<V>> serviceInfos, V type) {
        int N = serviceInfos.size();
        for (int i = 0; i < N; ++i) {
            if (!serviceInfos.get((int)i).type.equals(type)) continue;
            return true;
        }
        return false;
    }

    private boolean containsTypeAndUid(ArrayList<ServiceInfo<V>> serviceInfos, V type, int uid) {
        int N = serviceInfos.size();
        for (int i = 0; i < N; ++i) {
            ServiceInfo<V> serviceInfo = serviceInfos.get(i);
            if (!serviceInfo.type.equals(type) || serviceInfo.uid != uid) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    protected ServiceInfo<V> parseServiceInfo(ResolveInfo service) throws XmlPullParserException, IOException {
        android.content.pm.ServiceInfo si = service.serviceInfo;
        ComponentName componentName = new ComponentName(si.packageName, si.name);
        PackageManager pm = this.mContext.getPackageManager();
        try (XmlResourceParser parser = null;){
            int type;
            parser = si.loadXmlMetaData(pm, this.mMetaDataName);
            if (parser == null) {
                throw new XmlPullParserException("No " + this.mMetaDataName + " meta-data");
            }
            AttributeSet attrs = Xml.asAttributeSet(parser);
            while ((type = parser.next()) != 1 && type != 2) {
            }
            String nodeName = parser.getName();
            if (!this.mAttributesName.equals(nodeName)) {
                throw new XmlPullParserException("Meta-data does not start with " + this.mAttributesName + " tag");
            }
            V v = this.parseServiceAttributes(pm.getResourcesForApplication(si.applicationInfo), si.packageName, attrs);
            if (v == null) {
                ServiceInfo<V> serviceInfo = null;
                return serviceInfo;
            }
            android.content.pm.ServiceInfo serviceInfo = service.serviceInfo;
            ServiceInfo<V> serviceInfo2 = new ServiceInfo<V>(v, serviceInfo, componentName);
            return serviceInfo2;
        }
    }

    private void readPersistentServicesLocked(InputStream is) throws XmlPullParserException, IOException {
        TypedXmlPullParser parser = Xml.resolvePullParser(is);
        int eventType = parser.getEventType();
        while (eventType != 2 && eventType != 1) {
            eventType = parser.next();
        }
        String tagName = parser.getName();
        if ("services".equals(tagName)) {
            eventType = parser.next();
            do {
                if (eventType != 2 || parser.getDepth() != 2 || !"service".equals(tagName = parser.getName())) continue;
                V service = this.mSerializerAndParser.createFromXml(parser);
                if (service == null) break;
                int uid = parser.getAttributeInt(null, "uid");
                int userId = UserHandle.getUserId(uid);
                UserServices<V> user = this.findOrCreateUserLocked(userId, false);
                user.persistentServices.put((Integer)service, uid);
            } while ((eventType = parser.next()) != 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateIfNecessaryLocked() {
        File marker;
        if (this.mSerializerAndParser == null) {
            return;
        }
        File systemDir = new File(this.getDataDirectory(), "system");
        File syncDir = new File(systemDir, REGISTERED_SERVICES_DIR);
        AtomicFile oldFile = new AtomicFile(new File(syncDir, this.mInterfaceName + ".xml"));
        boolean oldFileExists = oldFile.getBaseFile().exists();
        if (oldFileExists && !(marker = new File(syncDir, this.mInterfaceName + ".xml.migrated")).exists()) {
            FileInputStream is = null;
            try {
                is = oldFile.openRead();
                this.mUserServices.clear();
                this.readPersistentServicesLocked(is);
            }
            catch (Exception e) {
                Log.w(TAG, "Error reading persistent services, starting from scratch", e);
            }
            finally {
                IoUtils.closeQuietly(is);
            }
            try {
                for (UserInfo user : this.getUsers()) {
                    UserServices<V> userServices = this.mUserServices.get(user.id);
                    if (userServices == null) continue;
                    this.writePersistentServicesLocked(userServices, user.id);
                }
                marker.createNewFile();
            }
            catch (Exception e) {
                Log.w(TAG, "Migration failed", e);
            }
            this.mUserServices.clear();
        }
    }

    private void writePersistentServicesLocked(UserServices<V> user, int userId) {
        block4: {
            if (this.mSerializerAndParser == null) {
                return;
            }
            AtomicFile atomicFile = this.createFileForUser(userId);
            FileOutputStream fos = null;
            try {
                fos = atomicFile.startWrite();
                TypedXmlSerializer out = Xml.resolveSerializer(fos);
                out.startDocument(null, true);
                out.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
                out.startTag(null, "services");
                for (Map.Entry service : user.persistentServices.entrySet()) {
                    out.startTag(null, "service");
                    out.attributeInt(null, "uid", service.getValue());
                    this.mSerializerAndParser.writeAsXml(service.getKey(), out);
                    out.endTag(null, "service");
                }
                out.endTag(null, "services");
                out.endDocument();
                atomicFile.finishWrite(fos);
            }
            catch (IOException e1) {
                Log.w(TAG, "Error writing accounts", e1);
                if (fos == null) break block4;
                atomicFile.failWrite(fos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected void onUserRemoved(int userId) {
        Object object = this.mServicesLock;
        synchronized (object) {
            this.mUserServices.remove(userId);
        }
    }

    @VisibleForTesting
    protected List<UserInfo> getUsers() {
        return UserManager.get(this.mContext).getAliveUsers();
    }

    @VisibleForTesting
    protected UserInfo getUser(int userId) {
        return UserManager.get(this.mContext).getUserInfo(userId);
    }

    private AtomicFile createFileForUser(int userId) {
        File userDir = this.getUserSystemDirectory(userId);
        File userFile = new File(userDir, "registered_services/" + this.mInterfaceName + ".xml");
        return new AtomicFile(userFile);
    }

    @VisibleForTesting
    protected File getUserSystemDirectory(int userId) {
        return Environment.getUserSystemDirectory(userId);
    }

    @VisibleForTesting
    protected File getDataDirectory() {
        return Environment.getDataDirectory();
    }

    @VisibleForTesting
    protected Map<V, Integer> getPersistentServices(int userId) {
        return this.findOrCreateUserLocked((int)userId).persistentServices;
    }

    public abstract V parseServiceAttributes(Resources var1, String var2, AttributeSet var3);

    public static class ServiceInfo<V> {
        @UnsupportedAppUsage
        public final V type;
        public final ComponentInfo componentInfo;
        @UnsupportedAppUsage
        public final ComponentName componentName;
        @UnsupportedAppUsage
        public final int uid;

        public ServiceInfo(V type, ComponentInfo componentInfo, ComponentName componentName) {
            this.type = type;
            this.componentInfo = componentInfo;
            this.componentName = componentName;
            this.uid = componentInfo != null ? componentInfo.applicationInfo.uid : -1;
        }

        public String toString() {
            return "ServiceInfo: " + this.type + ", " + this.componentName + ", uid " + this.uid;
        }
    }

    private static class UserServices<V> {
        @GuardedBy(value={"mServicesLock"})
        final Map<V, Integer> persistentServices = Maps.newHashMap();
        @GuardedBy(value={"mServicesLock"})
        Map<V, ServiceInfo<V>> services = null;
        @GuardedBy(value={"mServicesLock"})
        boolean mPersistentServicesFileDidNotExist = true;
        @GuardedBy(value={"mServicesLock"})
        boolean mBindInstantServiceAllowed = false;

        private UserServices() {
        }
    }
}

