/*
 * Decompiled with CFR 0.152.
 */
package android.content.integrity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AppInstallMetadata {
    private final String mPackageName;
    private final List<String> mAppCertificates;
    private final String mInstallerName;
    private final List<String> mInstallerCertificates;
    private final long mVersionCode;
    private final boolean mIsPreInstalled;
    private final boolean mIsStampPresent;
    private final boolean mIsStampVerified;
    private final boolean mIsStampTrusted;
    private final String mStampCertificateHash;
    private final Map<String, String> mAllowedInstallersAndCertificates;

    private AppInstallMetadata(Builder builder2) {
        this.mPackageName = builder2.mPackageName;
        this.mAppCertificates = builder2.mAppCertificates;
        this.mInstallerName = builder2.mInstallerName;
        this.mInstallerCertificates = builder2.mInstallerCertificates;
        this.mVersionCode = builder2.mVersionCode;
        this.mIsPreInstalled = builder2.mIsPreInstalled;
        this.mIsStampPresent = builder2.mIsStampPresent;
        this.mIsStampVerified = builder2.mIsStampVerified;
        this.mIsStampTrusted = builder2.mIsStampTrusted;
        this.mStampCertificateHash = builder2.mStampCertificateHash;
        this.mAllowedInstallersAndCertificates = builder2.mAllowedInstallersAndCertificates;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public List<String> getAppCertificates() {
        return this.mAppCertificates;
    }

    public String getInstallerName() {
        return this.mInstallerName;
    }

    public List<String> getInstallerCertificates() {
        return this.mInstallerCertificates;
    }

    public long getVersionCode() {
        return this.mVersionCode;
    }

    public boolean isPreInstalled() {
        return this.mIsPreInstalled;
    }

    public boolean isStampPresent() {
        return this.mIsStampPresent;
    }

    public boolean isStampVerified() {
        return this.mIsStampVerified;
    }

    public boolean isStampTrusted() {
        return this.mIsStampTrusted;
    }

    public String getStampCertificateHash() {
        return this.mStampCertificateHash;
    }

    public Map<String, String> getAllowedInstallersAndCertificates() {
        return this.mAllowedInstallersAndCertificates;
    }

    public String toString() {
        return String.format("AppInstallMetadata { PackageName = %s, AppCerts = %s, InstallerName = %s, InstallerCerts = %s, VersionCode = %d, PreInstalled = %b, StampPresent = %b, StampVerified = %b, StampTrusted = %b, StampCert = %s }", this.mPackageName, this.mAppCertificates, this.mInstallerName == null ? "null" : this.mInstallerName, this.mInstallerCertificates == null ? "null" : this.mInstallerCertificates, this.mVersionCode, this.mIsPreInstalled, this.mIsStampPresent, this.mIsStampVerified, this.mIsStampTrusted, this.mStampCertificateHash == null ? "null" : this.mStampCertificateHash);
    }

    public static class Builder {
        private String mPackageName;
        private List<String> mAppCertificates;
        private String mInstallerName;
        private List<String> mInstallerCertificates;
        private long mVersionCode;
        private boolean mIsPreInstalled;
        private boolean mIsStampPresent;
        private boolean mIsStampVerified;
        private boolean mIsStampTrusted;
        private String mStampCertificateHash;
        private Map<String, String> mAllowedInstallersAndCertificates = new HashMap<String, String>();

        public Builder setAllowedInstallersAndCert(Map<String, String> allowedInstallersAndCertificates) {
            this.mAllowedInstallersAndCertificates = allowedInstallersAndCertificates;
            return this;
        }

        public Builder setPackageName(String packageName) {
            this.mPackageName = Objects.requireNonNull(packageName);
            return this;
        }

        public Builder setAppCertificates(List<String> appCertificates) {
            this.mAppCertificates = Objects.requireNonNull(appCertificates);
            return this;
        }

        public Builder setInstallerName(String installerName) {
            this.mInstallerName = Objects.requireNonNull(installerName);
            return this;
        }

        public Builder setInstallerCertificates(List<String> installerCertificates) {
            this.mInstallerCertificates = Objects.requireNonNull(installerCertificates);
            return this;
        }

        public Builder setVersionCode(long versionCode) {
            this.mVersionCode = versionCode;
            return this;
        }

        public Builder setIsPreInstalled(boolean isPreInstalled) {
            this.mIsPreInstalled = isPreInstalled;
            return this;
        }

        public Builder setIsStampPresent(boolean isStampPresent) {
            this.mIsStampPresent = isStampPresent;
            return this;
        }

        public Builder setIsStampVerified(boolean isStampVerified) {
            this.mIsStampVerified = isStampVerified;
            return this;
        }

        public Builder setIsStampTrusted(boolean isStampTrusted) {
            this.mIsStampTrusted = isStampTrusted;
            return this;
        }

        public Builder setStampCertificateHash(String stampCertificateHash) {
            this.mStampCertificateHash = Objects.requireNonNull(stampCertificateHash);
            return this;
        }

        public AppInstallMetadata build() {
            Objects.requireNonNull(this.mPackageName);
            Objects.requireNonNull(this.mAppCertificates);
            return new AppInstallMetadata(this);
        }
    }
}

