/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import java.util.ArrayList;

public class MimeTypeFilter {
    private MimeTypeFilter() {
    }

    private static boolean mimeTypeAgainstFilter(String[] mimeTypeParts, String[] filterParts) {
        if (filterParts.length != 2) {
            throw new IllegalArgumentException("Ill-formatted MIME type filter. Must be type/subtype.");
        }
        if (filterParts[0].isEmpty() || filterParts[1].isEmpty()) {
            throw new IllegalArgumentException("Ill-formatted MIME type filter. Type or subtype empty.");
        }
        if (mimeTypeParts.length != 2) {
            return false;
        }
        if (!"*".equals(filterParts[0]) && !filterParts[0].equals(mimeTypeParts[0])) {
            return false;
        }
        return "*".equals(filterParts[1]) || filterParts[1].equals(mimeTypeParts[1]);
    }

    public static boolean matches(String mimeType, String filter2) {
        if (mimeType == null) {
            return false;
        }
        String[] mimeTypeParts = mimeType.split("/");
        String[] filterParts = filter2.split("/");
        return MimeTypeFilter.mimeTypeAgainstFilter(mimeTypeParts, filterParts);
    }

    public static String matches(String mimeType, String[] filters) {
        if (mimeType == null) {
            return null;
        }
        String[] mimeTypeParts = mimeType.split("/");
        for (String filter2 : filters) {
            String[] filterParts = filter2.split("/");
            if (!MimeTypeFilter.mimeTypeAgainstFilter(mimeTypeParts, filterParts)) continue;
            return filter2;
        }
        return null;
    }

    public static String matches(String[] mimeTypes, String filter2) {
        if (mimeTypes == null) {
            return null;
        }
        String[] filterParts = filter2.split("/");
        for (String mimeType : mimeTypes) {
            String[] mimeTypeParts = mimeType.split("/");
            if (!MimeTypeFilter.mimeTypeAgainstFilter(mimeTypeParts, filterParts)) continue;
            return mimeType;
        }
        return null;
    }

    public static String[] matchesMany(String[] mimeTypes, String filter2) {
        if (mimeTypes == null) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        String[] filterParts = filter2.split("/");
        for (String mimeType : mimeTypes) {
            String[] mimeTypeParts = mimeType.split("/");
            if (!MimeTypeFilter.mimeTypeAgainstFilter(mimeTypeParts, filterParts)) continue;
            list.add(mimeType);
        }
        return list.toArray(new String[list.size()]);
    }
}

