/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ContentInterface;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentValues;
import android.content.OperationApplicationException;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Log;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;

public class LoggingContentInterface
implements ContentInterface {
    private final String tag;
    private final ContentInterface delegate;

    public LoggingContentInterface(String tag, ContentInterface delegate) {
        this.tag = tag;
        this.delegate = delegate;
    }

    @Override
    public Cursor query(Uri uri, String[] projection, Bundle queryArgs, CancellationSignal cancellationSignal) throws RemoteException {
        Logger l = new Logger("query", uri, projection, queryArgs, cancellationSignal);
        try {
            Cursor cursor = l.setResult(this.delegate.query(uri, projection, queryArgs, cancellationSignal));
            return cursor;
        }
        catch (Exception res) {
            l.setResult(res);
            throw res;
        }
        finally {
            try {
                l.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    @Override
    public String getType(Uri uri) throws RemoteException {
        Logger l = new Logger("getType", uri);
        try {
            String string2 = l.setResult(this.delegate.getType(uri));
            return string2;
        }
        catch (Exception res) {
            l.setResult(res);
            throw res;
        }
        finally {
            try {
                l.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    @Override
    public String[] getStreamTypes(Uri uri, String mimeTypeFilter) throws RemoteException {
        Logger l = new Logger("getStreamTypes", uri, mimeTypeFilter);
        try {
            String[] stringArray = l.setResult(this.delegate.getStreamTypes(uri, mimeTypeFilter));
            return stringArray;
        }
        catch (Exception res) {
            l.setResult(res);
            throw res;
        }
        finally {
            try {
                l.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    @Override
    public Uri canonicalize(Uri uri) throws RemoteException {
        Logger l = new Logger("canonicalize", uri);
        try {
            Uri uri2 = l.setResult(this.delegate.canonicalize(uri));
            return uri2;
        }
        catch (Exception res) {
            l.setResult(res);
            throw res;
        }
        finally {
            try {
                l.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    @Override
    public Uri uncanonicalize(Uri uri) throws RemoteException {
        Logger l = new Logger("uncanonicalize", uri);
        try {
            Uri uri2 = l.setResult(this.delegate.uncanonicalize(uri));
            return uri2;
        }
        catch (Exception res) {
            l.setResult(res);
            throw res;
        }
        finally {
            try {
                l.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    @Override
    public boolean refresh(Uri uri, Bundle args, CancellationSignal cancellationSignal) throws RemoteException {
        Logger l = new Logger("refresh", uri, args, cancellationSignal);
        try {
            boolean bl = l.setResult(this.delegate.refresh(uri, args, cancellationSignal));
            return bl;
        }
        catch (Exception res) {
            l.setResult(res);
            throw res;
        }
        finally {
            try {
                l.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    @Override
    public int checkUriPermission(Uri uri, int uid, int modeFlags) throws RemoteException {
        Logger l = new Logger("checkUriPermission", uri, uid, modeFlags);
        try {
            int n = l.setResult(this.delegate.checkUriPermission(uri, uid, modeFlags));
            return n;
        }
        catch (Exception res) {
            l.setResult(res);
            throw res;
        }
        finally {
            try {
                l.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    @Override
    public Uri insert(Uri uri, ContentValues initialValues, Bundle extras) throws RemoteException {
        Logger l = new Logger("insert", uri, initialValues, extras);
        try {
            Uri uri2 = l.setResult(this.delegate.insert(uri, initialValues, extras));
            return uri2;
        }
        catch (Exception res) {
            l.setResult(res);
            throw res;
        }
        finally {
            try {
                l.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    @Override
    public int bulkInsert(Uri uri, ContentValues[] initialValues) throws RemoteException {
        Logger l = new Logger("bulkInsert", uri, initialValues);
        try {
            int n = l.setResult(this.delegate.bulkInsert(uri, initialValues));
            return n;
        }
        catch (Exception res) {
            l.setResult(res);
            throw res;
        }
        finally {
            try {
                l.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    @Override
    public int delete(Uri uri, Bundle extras) throws RemoteException {
        Logger l = new Logger("delete", uri, extras);
        try {
            int n = l.setResult(this.delegate.delete(uri, extras));
            return n;
        }
        catch (Exception res) {
            l.setResult(res);
            throw res;
        }
        finally {
            try {
                l.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    @Override
    public int update(Uri uri, ContentValues values2, Bundle extras) throws RemoteException {
        Logger l = new Logger("update", uri, values2, extras);
        try {
            int n = l.setResult(this.delegate.update(uri, values2, extras));
            return n;
        }
        catch (Exception res) {
            l.setResult(res);
            throw res;
        }
        finally {
            try {
                l.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    @Override
    public ParcelFileDescriptor openFile(Uri uri, String mode, CancellationSignal signal) throws RemoteException, FileNotFoundException {
        Logger l = new Logger("openFile", uri, mode, signal);
        try {
            ParcelFileDescriptor parcelFileDescriptor = l.setResult(this.delegate.openFile(uri, mode, signal));
            return parcelFileDescriptor;
        }
        catch (Exception res) {
            l.setResult(res);
            throw res;
        }
        finally {
            try {
                l.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    @Override
    public AssetFileDescriptor openAssetFile(Uri uri, String mode, CancellationSignal signal) throws RemoteException, FileNotFoundException {
        Logger l = new Logger("openAssetFile", uri, mode, signal);
        try {
            AssetFileDescriptor assetFileDescriptor = l.setResult(this.delegate.openAssetFile(uri, mode, signal));
            return assetFileDescriptor;
        }
        catch (Exception res) {
            l.setResult(res);
            throw res;
        }
        finally {
            try {
                l.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    @Override
    public AssetFileDescriptor openTypedAssetFile(Uri uri, String mimeTypeFilter, Bundle opts, CancellationSignal signal) throws RemoteException, FileNotFoundException {
        Logger l = new Logger("openTypedAssetFile", uri, mimeTypeFilter, opts, signal);
        try {
            AssetFileDescriptor assetFileDescriptor = l.setResult(this.delegate.openTypedAssetFile(uri, mimeTypeFilter, opts, signal));
            return assetFileDescriptor;
        }
        catch (Exception res) {
            l.setResult(res);
            throw res;
        }
        finally {
            try {
                l.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    @Override
    public ContentProviderResult[] applyBatch(String authority, ArrayList<ContentProviderOperation> operations) throws RemoteException, OperationApplicationException {
        Logger l = new Logger("applyBatch", authority, operations);
        try {
            ContentProviderResult[] contentProviderResultArray = l.setResult(this.delegate.applyBatch(authority, operations));
            return contentProviderResultArray;
        }
        catch (Exception res) {
            l.setResult(res);
            throw res;
        }
        finally {
            try {
                l.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    @Override
    public Bundle call(String authority, String method, String arg, Bundle extras) throws RemoteException {
        Logger l = new Logger("call", authority, method, arg, extras);
        try {
            Bundle bundle = l.setResult(this.delegate.call(authority, method, arg, extras));
            return bundle;
        }
        catch (Exception res) {
            l.setResult(res);
            throw res;
        }
        finally {
            try {
                l.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    private class Logger
    implements AutoCloseable {
        private final StringBuilder sb = new StringBuilder();

        public Logger(String method, Object ... args) {
            for (Object arg : args) {
                if (!(arg instanceof Bundle)) continue;
                ((Bundle)arg).size();
            }
            this.sb.append("callingUid=").append(Binder.getCallingUid()).append(' ');
            this.sb.append(method);
            this.sb.append('(').append(this.deepToString(args)).append(')');
        }

        private String deepToString(Object value2) {
            if (value2 != null && value2.getClass().isArray()) {
                return Arrays.deepToString((Object[])value2);
            }
            return String.valueOf(value2);
        }

        public <T> T setResult(T res) {
            if (res instanceof Cursor) {
                this.sb.append('\n');
                DatabaseUtils.dumpCursor((Cursor)res, this.sb);
            } else {
                this.sb.append(" = ").append(this.deepToString(res));
            }
            return res;
        }

        @Override
        public void close() {
            Log.v(LoggingContentInterface.this.tag, this.sb.toString());
        }
    }
}

