/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.TimeUtils;
import android.util.proto.ProtoOutputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class ClipDescription
implements Parcelable {
    public static final String MIMETYPE_TEXT_PLAIN = "text/plain";
    public static final String MIMETYPE_TEXT_HTML = "text/html";
    public static final String MIMETYPE_TEXT_URILIST = "text/uri-list";
    public static final String MIMETYPE_TEXT_INTENT = "text/vnd.android.intent";
    public static final String MIMETYPE_APPLICATION_ACTIVITY = "application/vnd.android.activity";
    public static final String MIMETYPE_APPLICATION_SHORTCUT = "application/vnd.android.shortcut";
    public static final String MIMETYPE_APPLICATION_TASK = "application/vnd.android.task";
    public static final String MIMETYPE_UNKNOWN = "application/octet-stream";
    public static final String EXTRA_PENDING_INTENT = "android.intent.extra.PENDING_INTENT";
    public static final String EXTRA_ACTIVITY_OPTIONS = "android.intent.extra.ACTIVITY_OPTIONS";
    public static final int CLASSIFICATION_NOT_COMPLETE = 1;
    public static final int CLASSIFICATION_NOT_PERFORMED = 2;
    public static final int CLASSIFICATION_COMPLETE = 3;
    final CharSequence mLabel;
    private final ArrayList<String> mMimeTypes;
    private PersistableBundle mExtras;
    private long mTimeStamp;
    private boolean mIsStyledText;
    private final ArrayMap<String, Float> mEntityConfidence = new ArrayMap();
    private int mClassificationStatus = 1;
    public static final Parcelable.Creator<ClipDescription> CREATOR = new Parcelable.Creator<ClipDescription>(){

        @Override
        public ClipDescription createFromParcel(Parcel source) {
            return new ClipDescription(source);
        }

        public ClipDescription[] newArray(int size) {
            return new ClipDescription[size];
        }
    };

    public ClipDescription(CharSequence label, String[] mimeTypes) {
        if (mimeTypes == null) {
            throw new NullPointerException("mimeTypes is null");
        }
        this.mLabel = label;
        this.mMimeTypes = new ArrayList<String>(Arrays.asList(mimeTypes));
    }

    public ClipDescription(ClipDescription o) {
        this.mLabel = o.mLabel;
        this.mMimeTypes = new ArrayList<String>(o.mMimeTypes);
        this.mTimeStamp = o.mTimeStamp;
    }

    public static boolean compareMimeTypes(String concreteType, String desiredType) {
        int typeLength = desiredType.length();
        if (typeLength == 3 && desiredType.equals("*/*")) {
            return true;
        }
        int slashpos = desiredType.indexOf(47);
        return slashpos > 0 && (typeLength == slashpos + 2 && desiredType.charAt(slashpos + 1) == '*' ? desiredType.regionMatches(0, concreteType, 0, slashpos + 1) : desiredType.equals(concreteType));
    }

    public void setTimestamp(long timeStamp) {
        this.mTimeStamp = timeStamp;
    }

    public long getTimestamp() {
        return this.mTimeStamp;
    }

    public CharSequence getLabel() {
        return this.mLabel;
    }

    public boolean hasMimeType(String mimeType) {
        int size = this.mMimeTypes.size();
        for (int i = 0; i < size; ++i) {
            if (!ClipDescription.compareMimeTypes(this.mMimeTypes.get(i), mimeType)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMimeType(String[] targetMimeTypes) {
        for (String targetMimeType : targetMimeTypes) {
            if (!this.hasMimeType(targetMimeType)) continue;
            return true;
        }
        return false;
    }

    public String[] filterMimeTypes(String mimeType) {
        ArrayList<String> array2 = null;
        int size = this.mMimeTypes.size();
        for (int i = 0; i < size; ++i) {
            if (!ClipDescription.compareMimeTypes(this.mMimeTypes.get(i), mimeType)) continue;
            if (array2 == null) {
                array2 = new ArrayList<String>();
            }
            array2.add(this.mMimeTypes.get(i));
        }
        if (array2 == null) {
            return null;
        }
        String[] rawArray = new String[array2.size()];
        array2.toArray(rawArray);
        return rawArray;
    }

    public int getMimeTypeCount() {
        return this.mMimeTypes.size();
    }

    public String getMimeType(int index) {
        return this.mMimeTypes.get(index);
    }

    void addMimeTypes(String[] mimeTypes) {
        for (int i = 0; i != mimeTypes.length; ++i) {
            String mimeType = mimeTypes[i];
            if (this.mMimeTypes.contains(mimeType)) continue;
            this.mMimeTypes.add(mimeType);
        }
    }

    public PersistableBundle getExtras() {
        return this.mExtras;
    }

    public void setExtras(PersistableBundle extras) {
        this.mExtras = new PersistableBundle(extras);
    }

    public void validate() {
        if (this.mMimeTypes == null) {
            throw new NullPointerException("null mime types");
        }
        int size = this.mMimeTypes.size();
        if (size <= 0) {
            throw new IllegalArgumentException("must have at least 1 mime type");
        }
        for (int i = 0; i < size; ++i) {
            if (this.mMimeTypes.get(i) != null) continue;
            throw new NullPointerException("mime type at " + i + " is null");
        }
    }

    public boolean isStyledText() {
        return this.mIsStyledText;
    }

    void setIsStyledText(boolean isStyledText) {
        this.mIsStyledText = isStyledText;
    }

    public void setClassificationStatus(int status) {
        this.mClassificationStatus = status;
    }

    public float getConfidenceScore(String entity) {
        if (this.mClassificationStatus != 3) {
            throw new IllegalStateException("Classification not complete");
        }
        return this.mEntityConfidence.getOrDefault(entity, Float.valueOf(0.0f)).floatValue();
    }

    public int getClassificationStatus() {
        return this.mClassificationStatus;
    }

    public void setConfidenceScores(Map<String, Float> confidences) {
        this.mEntityConfidence.clear();
        this.mEntityConfidence.putAll(confidences);
        this.mClassificationStatus = 3;
    }

    public String toString() {
        StringBuilder b = new StringBuilder(128);
        b.append("ClipDescription { ");
        this.toShortString(b, true);
        b.append(" }");
        return b.toString();
    }

    public boolean toShortString(StringBuilder b, boolean redactContent) {
        boolean first;
        boolean bl = first = !this.toShortStringTypesOnly(b);
        if (this.mLabel != null) {
            if (!first) {
                b.append(' ');
            }
            first = false;
            if (redactContent) {
                b.append("hasLabel(").append(this.mLabel.length()).append(')');
            } else {
                b.append('\"').append(this.mLabel).append('\"');
            }
        }
        if (this.mExtras != null) {
            if (!first) {
                b.append(' ');
            }
            first = false;
            if (redactContent) {
                if (this.mExtras.isParcelled()) {
                    b.append("hasExtras");
                } else {
                    b.append("hasExtras(").append(this.mExtras.size()).append(')');
                }
            } else {
                b.append(this.mExtras.toString());
            }
        }
        if (this.mTimeStamp > 0L) {
            if (!first) {
                b.append(' ');
            }
            first = false;
            b.append('<');
            b.append(TimeUtils.logTimeOfDay(this.mTimeStamp));
            b.append('>');
        }
        return !first;
    }

    public boolean toShortStringTypesOnly(StringBuilder b) {
        boolean first = true;
        int size = this.mMimeTypes.size();
        for (int i = 0; i < size; ++i) {
            if (!first) {
                b.append(' ');
            }
            first = false;
            b.append(this.mMimeTypes.get(i));
        }
        return !first;
    }

    public void dumpDebug(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        int size = this.mMimeTypes.size();
        for (int i = 0; i < size; ++i) {
            proto.write(2237677961217L, this.mMimeTypes.get(i));
        }
        if (this.mLabel != null) {
            proto.write(1138166333442L, this.mLabel.toString());
        }
        if (this.mExtras != null) {
            this.mExtras.dumpDebug(proto, 1146756268035L);
        }
        if (this.mTimeStamp > 0L) {
            proto.write(1112396529668L, this.mTimeStamp);
        }
        proto.end(token);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        TextUtils.writeToParcel(this.mLabel, dest, flags);
        dest.writeStringList(this.mMimeTypes);
        dest.writePersistableBundle(this.mExtras);
        dest.writeLong(this.mTimeStamp);
        dest.writeBoolean(this.mIsStyledText);
        dest.writeInt(this.mClassificationStatus);
        dest.writeBundle(this.confidencesToBundle());
    }

    private Bundle confidencesToBundle() {
        Bundle bundle = new Bundle();
        int size = this.mEntityConfidence.size();
        for (int i = 0; i < size; ++i) {
            bundle.putFloat(this.mEntityConfidence.keyAt(i), this.mEntityConfidence.valueAt(i).floatValue());
        }
        return bundle;
    }

    private void readBundleToConfidences(Bundle bundle) {
        for (String key : bundle.keySet()) {
            this.mEntityConfidence.put(key, Float.valueOf(bundle.getFloat(key)));
        }
    }

    ClipDescription(Parcel in) {
        this.mLabel = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
        this.mMimeTypes = in.createStringArrayList();
        this.mExtras = in.readPersistableBundle();
        this.mTimeStamp = in.readLong();
        this.mIsStyledText = in.readBoolean();
        this.mClassificationStatus = in.readInt();
        this.readBundleToConfidences(in.readBundle());
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface ClassificationStatus {
    }
}

