/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.AttributionSource;
import android.content.ClipDescription;
import android.content.ContentProvider;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.StrictMode;
import android.text.Html;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.URLSpan;
import android.util.proto.ProtoOutputStream;
import android.view.textclassifier.TextLinks;
import com.android.internal.util.ArrayUtils;
import java.util.ArrayList;
import java.util.List;

public class ClipData
implements Parcelable {
    static final String[] MIMETYPES_TEXT_PLAIN = new String[]{"text/plain"};
    static final String[] MIMETYPES_TEXT_HTML = new String[]{"text/html"};
    static final String[] MIMETYPES_TEXT_URILIST = new String[]{"text/uri-list"};
    static final String[] MIMETYPES_TEXT_INTENT = new String[]{"text/vnd.android.intent"};
    final ClipDescription mClipDescription;
    final Bitmap mIcon;
    final ArrayList<Item> mItems;
    private boolean mParcelItemActivityInfos;
    public static final Parcelable.Creator<ClipData> CREATOR = new Parcelable.Creator<ClipData>(){

        @Override
        public ClipData createFromParcel(Parcel source) {
            return new ClipData(source);
        }

        public ClipData[] newArray(int size) {
            return new ClipData[size];
        }
    };

    public ClipData(CharSequence label, String[] mimeTypes, Item item) {
        this.mClipDescription = new ClipDescription(label, mimeTypes);
        if (item == null) {
            throw new NullPointerException("item is null");
        }
        this.mIcon = null;
        this.mItems = new ArrayList();
        this.mItems.add(item);
        this.mClipDescription.setIsStyledText(this.isStyledText());
    }

    public ClipData(ClipDescription description, Item item) {
        this.mClipDescription = description;
        if (item == null) {
            throw new NullPointerException("item is null");
        }
        this.mIcon = null;
        this.mItems = new ArrayList();
        this.mItems.add(item);
        this.mClipDescription.setIsStyledText(this.isStyledText());
    }

    public ClipData(ClipDescription description, ArrayList<Item> items) {
        this.mClipDescription = description;
        if (items == null) {
            throw new NullPointerException("item is null");
        }
        this.mIcon = null;
        this.mItems = items;
    }

    public ClipData(ClipData other) {
        this.mClipDescription = other.mClipDescription;
        this.mIcon = other.mIcon;
        this.mItems = new ArrayList<Item>(other.mItems);
    }

    public ClipData copyForTransferWithActivityInfo() {
        ClipData copy = new ClipData(this);
        copy.mParcelItemActivityInfos = true;
        return copy;
    }

    public boolean willParcelWithActivityInfo() {
        return this.mParcelItemActivityInfos;
    }

    public static ClipData newPlainText(CharSequence label, CharSequence text) {
        Item item = new Item(text);
        return new ClipData(label, MIMETYPES_TEXT_PLAIN, item);
    }

    public static ClipData newHtmlText(CharSequence label, CharSequence text, String htmlText) {
        Item item = new Item(text, htmlText);
        return new ClipData(label, MIMETYPES_TEXT_HTML, item);
    }

    public static ClipData newIntent(CharSequence label, Intent intent) {
        Item item = new Item(intent);
        return new ClipData(label, MIMETYPES_TEXT_INTENT, item);
    }

    public static ClipData newUri(ContentResolver resolver, CharSequence label, Uri uri) {
        Item item = new Item(uri);
        String[] mimeTypes = ClipData.getMimeTypes(resolver, uri);
        return new ClipData(label, mimeTypes, item);
    }

    private static String[] getMimeTypes(ContentResolver resolver, Uri uri) {
        String[] mimeTypes = null;
        if ("content".equals(uri.getScheme())) {
            String realType = resolver.getType(uri);
            mimeTypes = resolver.getStreamTypes(uri, "*/*");
            if (realType != null) {
                if (mimeTypes == null) {
                    mimeTypes = new String[]{realType};
                } else if (!ArrayUtils.contains(mimeTypes, realType)) {
                    String[] tmp = new String[mimeTypes.length + 1];
                    tmp[0] = realType;
                    System.arraycopy(mimeTypes, 0, tmp, 1, mimeTypes.length);
                    mimeTypes = tmp;
                }
            }
        }
        if (mimeTypes == null) {
            mimeTypes = MIMETYPES_TEXT_URILIST;
        }
        return mimeTypes;
    }

    public static ClipData newRawUri(CharSequence label, Uri uri) {
        Item item = new Item(uri);
        return new ClipData(label, MIMETYPES_TEXT_URILIST, item);
    }

    public ClipDescription getDescription() {
        return this.mClipDescription;
    }

    public void addItem(Item item) {
        if (item == null) {
            throw new NullPointerException("item is null");
        }
        this.mItems.add(item);
        if (this.mItems.size() == 1) {
            this.mClipDescription.setIsStyledText(this.isStyledText());
        }
    }

    public void addItem(ContentResolver resolver, Item item) {
        this.addItem(item);
        if (item.getHtmlText() != null) {
            this.mClipDescription.addMimeTypes(MIMETYPES_TEXT_HTML);
        } else if (item.getText() != null) {
            this.mClipDescription.addMimeTypes(MIMETYPES_TEXT_PLAIN);
        }
        if (item.getIntent() != null) {
            this.mClipDescription.addMimeTypes(MIMETYPES_TEXT_INTENT);
        }
        if (item.getUri() != null) {
            this.mClipDescription.addMimeTypes(ClipData.getMimeTypes(resolver, item.getUri()));
        }
    }

    @UnsupportedAppUsage
    public Bitmap getIcon() {
        return this.mIcon;
    }

    public int getItemCount() {
        return this.mItems.size();
    }

    public Item getItemAt(int index) {
        return this.mItems.get(index);
    }

    public void setItemAt(int index, Item item) {
        this.mItems.set(index, item);
    }

    public void prepareToLeaveProcess(boolean leavingPackage) {
        this.prepareToLeaveProcess(leavingPackage, 1);
    }

    public void prepareToLeaveProcess(boolean leavingPackage, int intentFlags) {
        int size = this.mItems.size();
        for (int i = 0; i < size; ++i) {
            Item item = this.mItems.get(i);
            if (item.mIntent != null) {
                item.mIntent.prepareToLeaveProcess(leavingPackage);
            }
            if (item.mUri == null || !leavingPackage) continue;
            if (StrictMode.vmFileUriExposureEnabled()) {
                item.mUri.checkFileUriExposed("ClipData.Item.getUri()");
            }
            if (!StrictMode.vmContentUriWithoutPermissionEnabled()) continue;
            item.mUri.checkContentUriWithoutPermission("ClipData.Item.getUri()", intentFlags);
        }
    }

    public void prepareToEnterProcess(AttributionSource source) {
        int size = this.mItems.size();
        for (int i = 0; i < size; ++i) {
            Item item = this.mItems.get(i);
            if (item.mIntent == null) continue;
            item.mIntent.prepareToEnterProcess(false, source);
        }
    }

    public void fixUris(int contentUserHint) {
        int size = this.mItems.size();
        for (int i = 0; i < size; ++i) {
            Item item = this.mItems.get(i);
            if (item.mIntent != null) {
                item.mIntent.fixUris(contentUserHint);
            }
            if (item.mUri == null) continue;
            item.mUri = ContentProvider.maybeAddUserId(item.mUri, contentUserHint);
        }
    }

    public void fixUrisLight(int contentUserHint) {
        int size = this.mItems.size();
        for (int i = 0; i < size; ++i) {
            Uri data;
            Item item = this.mItems.get(i);
            if (item.mIntent != null && (data = item.mIntent.getData()) != null) {
                item.mIntent.setData(ContentProvider.maybeAddUserId(data, contentUserHint));
            }
            if (item.mUri == null) continue;
            item.mUri = ContentProvider.maybeAddUserId(item.mUri, contentUserHint);
        }
    }

    private boolean isStyledText() {
        Spanned spanned;
        if (this.mItems.isEmpty()) {
            return false;
        }
        CharSequence text = this.mItems.get(0).getText();
        return text instanceof Spanned && TextUtils.hasStyleSpan(spanned = (Spanned)text);
    }

    public String toString() {
        StringBuilder b = new StringBuilder(128);
        b.append("ClipData { ");
        this.toShortString(b, true);
        b.append(" }");
        return b.toString();
    }

    public void toShortString(StringBuilder b, boolean redactContent) {
        boolean first = this.mClipDescription != null ? !this.mClipDescription.toShortString(b, redactContent) : true;
        if (this.mIcon != null) {
            if (!first) {
                b.append(' ');
            }
            first = false;
            b.append("I:");
            b.append(this.mIcon.getWidth());
            b.append('x');
            b.append(this.mIcon.getHeight());
        }
        if (this.mItems.size() != 1) {
            if (!first) {
                b.append(' ');
            }
            first = false;
            b.append(this.mItems.size()).append(" items:");
        }
        for (int i = 0; i < this.mItems.size(); ++i) {
            if (!first) {
                b.append(' ');
            }
            first = false;
            b.append('{');
            this.mItems.get(i).toShortString(b, redactContent);
            b.append('}');
        }
    }

    public void dumpDebug(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        if (this.mClipDescription != null) {
            this.mClipDescription.dumpDebug(proto, 0x10B00000001L);
        }
        if (this.mIcon != null) {
            long iToken = proto.start(1146756268034L);
            proto.write(0x10500000001L, this.mIcon.getWidth());
            proto.write(1120986464258L, this.mIcon.getHeight());
            proto.end(iToken);
        }
        for (int i = 0; i < this.mItems.size(); ++i) {
            this.mItems.get(i).dumpDebug(proto, 2246267895811L);
        }
        proto.end(token);
    }

    public void collectUris(List<Uri> out) {
        for (int i = 0; i < this.mItems.size(); ++i) {
            Intent intent;
            Item item = this.getItemAt(i);
            if (item.getUri() != null) {
                out.add(item.getUri());
            }
            if ((intent = item.getIntent()) == null) continue;
            if (intent.getData() != null) {
                out.add(intent.getData());
            }
            if (intent.getClipData() == null) continue;
            intent.getClipData().collectUris(out);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        this.mClipDescription.writeToParcel(dest, flags);
        if (this.mIcon != null) {
            dest.writeInt(1);
            this.mIcon.writeToParcel(dest, flags);
        } else {
            dest.writeInt(0);
        }
        int N = this.mItems.size();
        dest.writeInt(N);
        for (int i = 0; i < N; ++i) {
            Item item = this.mItems.get(i);
            TextUtils.writeToParcel(item.mText, dest, flags);
            dest.writeString8(item.mHtmlText);
            dest.writeTypedObject(item.mIntent, flags);
            dest.writeTypedObject(item.mUri, flags);
            dest.writeTypedObject(this.mParcelItemActivityInfos ? item.mActivityInfo : null, flags);
            dest.writeTypedObject(item.mTextLinks, flags);
        }
    }

    ClipData(Parcel in) {
        this.mClipDescription = new ClipDescription(in);
        this.mIcon = in.readInt() != 0 ? Bitmap.CREATOR.createFromParcel(in) : null;
        this.mItems = new ArrayList();
        int N = in.readInt();
        for (int i = 0; i < N; ++i) {
            CharSequence text = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            String htmlText = in.readString8();
            Intent intent = in.readTypedObject(Intent.CREATOR);
            Uri uri = in.readTypedObject(Uri.CREATOR);
            ActivityInfo info = in.readTypedObject(ActivityInfo.CREATOR);
            TextLinks textLinks = in.readTypedObject(TextLinks.CREATOR);
            Item item = new Item(text, htmlText, intent, uri);
            item.setActivityInfo(info);
            item.setTextLinks(textLinks);
            this.mItems.add(item);
        }
    }

    public static class Item {
        final CharSequence mText;
        final String mHtmlText;
        final Intent mIntent;
        @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
        Uri mUri;
        private TextLinks mTextLinks;
        private ActivityInfo mActivityInfo;

        public Item(Item other) {
            this.mText = other.mText;
            this.mHtmlText = other.mHtmlText;
            this.mIntent = other.mIntent;
            this.mUri = other.mUri;
            this.mActivityInfo = other.mActivityInfo;
            this.mTextLinks = other.mTextLinks;
        }

        public Item(CharSequence text) {
            this.mText = text;
            this.mHtmlText = null;
            this.mIntent = null;
            this.mUri = null;
        }

        public Item(CharSequence text, String htmlText) {
            this.mText = text;
            this.mHtmlText = htmlText;
            this.mIntent = null;
            this.mUri = null;
        }

        public Item(Intent intent) {
            this.mText = null;
            this.mHtmlText = null;
            this.mIntent = intent;
            this.mUri = null;
        }

        public Item(Uri uri) {
            this.mText = null;
            this.mHtmlText = null;
            this.mIntent = null;
            this.mUri = uri;
        }

        public Item(CharSequence text, Intent intent, Uri uri) {
            this.mText = text;
            this.mHtmlText = null;
            this.mIntent = intent;
            this.mUri = uri;
        }

        public Item(CharSequence text, String htmlText, Intent intent, Uri uri) {
            if (htmlText != null && text == null) {
                throw new IllegalArgumentException("Plain text must be supplied if HTML text is supplied");
            }
            this.mText = text;
            this.mHtmlText = htmlText;
            this.mIntent = intent;
            this.mUri = uri;
        }

        public CharSequence getText() {
            return this.mText;
        }

        public String getHtmlText() {
            return this.mHtmlText;
        }

        public Intent getIntent() {
            return this.mIntent;
        }

        public Uri getUri() {
            return this.mUri;
        }

        public ActivityInfo getActivityInfo() {
            return this.mActivityInfo;
        }

        public void setActivityInfo(ActivityInfo info) {
            this.mActivityInfo = info;
        }

        public TextLinks getTextLinks() {
            return this.mTextLinks;
        }

        public void setTextLinks(TextLinks textLinks) {
            this.mTextLinks = textLinks;
        }

        /*
         * Exception decompiling
         */
        public CharSequence coerceToText(Context context) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 12[SIMPLE_IF_TAKEN]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public CharSequence coerceToStyledText(Context context) {
            CharSequence text = this.getText();
            if (text instanceof Spanned) {
                return text;
            }
            String htmlText = this.getHtmlText();
            if (htmlText != null) {
                try {
                    Spanned newText = Html.fromHtml(htmlText);
                    if (newText != null) {
                        return newText;
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            if (text != null) {
                return text;
            }
            return this.coerceToHtmlOrStyledText(context, true);
        }

        public String coerceToHtmlText(Context context) {
            String htmlText = this.getHtmlText();
            if (htmlText != null) {
                return htmlText;
            }
            CharSequence text = this.getText();
            if (text != null) {
                if (text instanceof Spanned) {
                    return Html.toHtml((Spanned)text);
                }
                return Html.escapeHtml(text);
            }
            text = this.coerceToHtmlOrStyledText(context, false);
            return text != null ? text.toString() : null;
        }

        /*
         * Exception decompiling
         */
        private CharSequence coerceToHtmlOrStyledText(Context context, boolean styled) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 46[SIMPLE_IF_TAKEN]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private String uriToHtml(String uri) {
            StringBuilder builder2 = new StringBuilder(256);
            builder2.append("<a href=\"");
            builder2.append(Html.escapeHtml(uri));
            builder2.append("\">");
            builder2.append(Html.escapeHtml(uri));
            builder2.append("</a>");
            return builder2.toString();
        }

        private CharSequence uriToStyledText(String uri) {
            SpannableStringBuilder builder2 = new SpannableStringBuilder();
            builder2.append(uri);
            builder2.setSpan(new URLSpan(uri), 0, builder2.length(), 33);
            return builder2;
        }

        public String toString() {
            StringBuilder b = new StringBuilder(128);
            b.append("ClipData.Item { ");
            this.toShortString(b, true);
            b.append(" }");
            return b.toString();
        }

        public void toShortString(StringBuilder b, boolean redactContent) {
            boolean first = true;
            if (this.mHtmlText != null) {
                first = false;
                if (redactContent) {
                    b.append("H(").append(this.mHtmlText.length()).append(')');
                } else {
                    b.append("H:").append(this.mHtmlText);
                }
            }
            if (this.mText != null) {
                if (!first) {
                    b.append(' ');
                }
                first = false;
                if (redactContent) {
                    b.append("T(").append(this.mText.length()).append(')');
                } else {
                    b.append("T:").append(this.mText);
                }
            }
            if (this.mUri != null) {
                if (!first) {
                    b.append(' ');
                }
                first = false;
                if (redactContent) {
                    b.append("U(").append(this.mUri.getScheme()).append(')');
                } else {
                    b.append("U:").append(this.mUri);
                }
            }
            if (this.mIntent != null) {
                if (!first) {
                    b.append(' ');
                }
                first = false;
                b.append("I:");
                this.mIntent.toShortString(b, redactContent, true, true, true);
            }
        }

        public void dumpDebug(ProtoOutputStream proto, long fieldId) {
            long token = proto.start(fieldId);
            if (this.mHtmlText != null) {
                proto.write(0x10900000001L, this.mHtmlText);
            } else if (this.mText != null) {
                proto.write(1138166333442L, this.mText.toString());
            } else if (this.mUri != null) {
                proto.write(1138166333443L, this.mUri.toString());
            } else if (this.mIntent != null) {
                this.mIntent.dumpDebug(proto, 1146756268036L, true, true, true, true);
            } else {
                proto.write(1133871366149L, true);
            }
            proto.end(token);
        }
    }
}

