/*
 * Decompiled with CFR 0.152.
 */
package android.companion;

import android.annotation.NonNull;
import android.companion.DeviceFilter;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.OneTimeUseBuilder;
import com.android.internal.lang.System_Delegate;
import com.android.internal.util.AnnotationValidations;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AssociationRequest
implements Parcelable {
    private static final String LOG_TAG = AssociationRequest.class.getSimpleName();
    public static final String DEVICE_PROFILE_WATCH = "android.app.role.COMPANION_DEVICE_WATCH";
    private boolean mSingleDevice = false;
    private List<DeviceFilter<?>> mDeviceFilters = new ArrayList();
    @DeviceProfile
    private String mDeviceProfile = null;
    private String mCallingPackage = null;
    private String mDeviceProfilePrivilegesDescription = null;
    private long mCreationTime;
    private boolean mSkipPrompt = false;
    public static final Parcelable.Creator<AssociationRequest> CREATOR = new Parcelable.Creator<AssociationRequest>(){

        public AssociationRequest[] newArray(int size) {
            return new AssociationRequest[size];
        }

        @Override
        public AssociationRequest createFromParcel(Parcel in) {
            return new AssociationRequest(in);
        }
    };

    private void onConstructed() {
        this.mCreationTime = System_Delegate.currentTimeMillis();
    }

    public void setCallingPackage(String pkg) {
        this.mCallingPackage = pkg;
    }

    public void setDeviceProfilePrivilegesDescription(String desc) {
        this.mDeviceProfilePrivilegesDescription = desc;
    }

    public void setSkipPrompt(boolean value2) {
        this.mSkipPrompt = true;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean isSingleDevice() {
        return this.mSingleDevice;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public List<DeviceFilter<?>> getDeviceFilters() {
        return this.mDeviceFilters;
    }

    public AssociationRequest(boolean singleDevice, List<DeviceFilter<?>> deviceFilters, @DeviceProfile String deviceProfile, String callingPackage, String deviceProfilePrivilegesDescription, long creationTime, boolean skipPrompt) {
        this.mSingleDevice = singleDevice;
        this.mDeviceFilters = deviceFilters;
        AnnotationValidations.validate(NonNull.class, null, this.mDeviceFilters);
        this.mDeviceProfile = deviceProfile;
        AnnotationValidations.validate(DeviceProfile.class, null, (Object)this.mDeviceProfile);
        this.mCallingPackage = callingPackage;
        this.mDeviceProfilePrivilegesDescription = deviceProfilePrivilegesDescription;
        this.mCreationTime = creationTime;
        this.mSkipPrompt = skipPrompt;
        this.onConstructed();
    }

    @DeviceProfile
    public String getDeviceProfile() {
        return this.mDeviceProfile;
    }

    public String getCallingPackage() {
        return this.mCallingPackage;
    }

    public String getDeviceProfilePrivilegesDescription() {
        return this.mDeviceProfilePrivilegesDescription;
    }

    public long getCreationTime() {
        return this.mCreationTime;
    }

    public boolean isSkipPrompt() {
        return this.mSkipPrompt;
    }

    public String toString() {
        return "AssociationRequest { singleDevice = " + this.mSingleDevice + ", deviceFilters = " + this.mDeviceFilters + ", deviceProfile = " + this.mDeviceProfile + ", callingPackage = " + this.mCallingPackage + ", deviceProfilePrivilegesDescription = " + this.mDeviceProfilePrivilegesDescription + ", creationTime = " + this.mCreationTime + ", skipPrompt = " + this.mSkipPrompt + " }";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssociationRequest that = (AssociationRequest)o;
        return this.mSingleDevice == that.mSingleDevice && Objects.equals(this.mDeviceFilters, that.mDeviceFilters) && Objects.equals(this.mDeviceProfile, that.mDeviceProfile) && Objects.equals(this.mCallingPackage, that.mCallingPackage) && Objects.equals(this.mDeviceProfilePrivilegesDescription, that.mDeviceProfilePrivilegesDescription) && this.mCreationTime == that.mCreationTime && this.mSkipPrompt == that.mSkipPrompt;
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + Boolean.hashCode(this.mSingleDevice);
        _hash = 31 * _hash + Objects.hashCode(this.mDeviceFilters);
        _hash = 31 * _hash + Objects.hashCode(this.mDeviceProfile);
        _hash = 31 * _hash + Objects.hashCode(this.mCallingPackage);
        _hash = 31 * _hash + Objects.hashCode(this.mDeviceProfilePrivilegesDescription);
        _hash = 31 * _hash + Long.hashCode(this.mCreationTime);
        _hash = 31 * _hash + Boolean.hashCode(this.mSkipPrompt);
        return _hash;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        byte flg = 0;
        if (this.mSingleDevice) {
            flg = (byte)(flg | 1);
        }
        if (this.mSkipPrompt) {
            flg = (byte)(flg | 0x40);
        }
        if (this.mDeviceProfile != null) {
            flg = (byte)(flg | 4);
        }
        if (this.mCallingPackage != null) {
            flg = (byte)(flg | 8);
        }
        if (this.mDeviceProfilePrivilegesDescription != null) {
            flg = (byte)(flg | 0x10);
        }
        dest.writeByte(flg);
        dest.writeParcelableList(this.mDeviceFilters, flags);
        if (this.mDeviceProfile != null) {
            dest.writeString(this.mDeviceProfile);
        }
        if (this.mCallingPackage != null) {
            dest.writeString(this.mCallingPackage);
        }
        if (this.mDeviceProfilePrivilegesDescription != null) {
            dest.writeString(this.mDeviceProfilePrivilegesDescription);
        }
        dest.writeLong(this.mCreationTime);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    AssociationRequest(Parcel in) {
        byte flg = in.readByte();
        boolean singleDevice = (flg & 1) != 0;
        boolean skipPrompt = (flg & 0x40) != 0;
        ArrayList deviceFilters = new ArrayList();
        in.readParcelableList(deviceFilters, DeviceFilter.class.getClassLoader());
        String deviceProfile = (flg & 4) == 0 ? null : in.readString();
        String callingPackage = (flg & 8) == 0 ? null : in.readString();
        String deviceProfilePrivilegesDescription = (flg & 0x10) == 0 ? null : in.readString();
        long creationTime = in.readLong();
        this.mSingleDevice = singleDevice;
        this.mDeviceFilters = deviceFilters;
        AnnotationValidations.validate(NonNull.class, null, this.mDeviceFilters);
        this.mDeviceProfile = deviceProfile;
        AnnotationValidations.validate(DeviceProfile.class, null, (Object)this.mDeviceProfile);
        this.mCallingPackage = callingPackage;
        this.mDeviceProfilePrivilegesDescription = deviceProfilePrivilegesDescription;
        this.mCreationTime = creationTime;
        this.mSkipPrompt = skipPrompt;
        this.onConstructed();
    }

    @Deprecated
    private void __metadata() {
    }

    public static class Builder
    extends OneTimeUseBuilder<AssociationRequest> {
        private boolean mSingleDevice = false;
        private ArrayList<DeviceFilter<?>> mDeviceFilters = null;
        private String mDeviceProfile = null;

        public Builder setSingleDevice(boolean singleDevice) {
            this.checkNotUsed();
            this.mSingleDevice = singleDevice;
            return this;
        }

        public Builder addDeviceFilter(DeviceFilter<?> deviceFilter) {
            this.checkNotUsed();
            if (deviceFilter != null) {
                this.mDeviceFilters = ArrayUtils.add(this.mDeviceFilters, deviceFilter);
            }
            return this;
        }

        public Builder setDeviceProfile(@DeviceProfile String deviceProfile) {
            this.checkNotUsed();
            this.mDeviceProfile = deviceProfile;
            return this;
        }

        @Override
        public AssociationRequest build() {
            this.markUsed();
            return new AssociationRequest(this.mSingleDevice, CollectionUtils.emptyIfNull(this.mDeviceFilters), this.mDeviceProfile, null, null, -1L, false);
        }
    }

    public static @interface DeviceProfile {
    }
}

