/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@SystemApi
public class OobData
implements Parcelable {
    private static final String TAG = "OobData";
    @SystemApi
    public static final int OOB_LENGTH_OCTETS = 2;
    @SystemApi
    public static final int DEVICE_ADDRESS_OCTETS = 7;
    @SystemApi
    public static final int CLASS_OF_DEVICE_OCTETS = 3;
    @SystemApi
    public static final int CONFIRMATION_OCTETS = 16;
    @SystemApi
    public static final int RANDOMIZER_OCTETS = 16;
    @SystemApi
    public static final int LE_DEVICE_ROLE_OCTETS = 1;
    @SystemApi
    public static final int LE_TK_OCTETS = 16;
    @SystemApi
    public static final int LE_APPEARANCE_OCTETS = 2;
    @SystemApi
    public static final int LE_DEVICE_FLAG_OCTETS = 1;
    @SystemApi
    public static final int LE_DEVICE_ROLE_PERIPHERAL_ONLY = 0;
    @SystemApi
    public static final int LE_DEVICE_ROLE_CENTRAL_ONLY = 1;
    @SystemApi
    public static final int LE_DEVICE_ROLE_BOTH_PREFER_PERIPHERAL = 2;
    @SystemApi
    public static final int LE_DEVICE_ROLE_BOTH_PREFER_CENTRAL = 3;
    @SystemApi
    public static final int LE_FLAG_LIMITED_DISCOVERY_MODE = 0;
    @SystemApi
    public static final int LE_FLAG_GENERAL_DISCOVERY_MODE = 1;
    @SystemApi
    public static final int LE_FLAG_BREDR_NOT_SUPPORTED = 2;
    @SystemApi
    public static final int LE_FLAG_SIMULTANEOUS_CONTROLLER = 3;
    @SystemApi
    public static final int LE_FLAG_SIMULTANEOUS_HOST = 4;
    private final byte[] mDeviceAddressWithType;
    private final byte[] mConfirmationHash;
    private byte[] mRandomizerHash = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private byte[] mDeviceName = new byte[]{66, 108, 117, 101, 116, 111, 111, 116, 104, 32, 68, 101, 118, 105, 99, 101};
    private final byte[] mClassicLength;
    private byte[] mClassOfDevice = new byte[3];
    private final int mLeDeviceRole;
    private byte[] mLeTemporaryKey = new byte[16];
    private byte[] mLeAppearance = new byte[2];
    private int mLeFlags = 0;
    public static final Parcelable.Creator<OobData> CREATOR = new Parcelable.Creator<OobData>(){

        @Override
        public OobData createFromParcel(Parcel in) {
            return new OobData(in);
        }

        public OobData[] newArray(int size) {
            return new OobData[size];
        }
    };

    @SystemApi
    public byte[] getDeviceAddressWithType() {
        return this.mDeviceAddressWithType;
    }

    @SystemApi
    public byte[] getConfirmationHash() {
        return this.mConfirmationHash;
    }

    @SystemApi
    public byte[] getRandomizerHash() {
        return this.mRandomizerHash;
    }

    @SystemApi
    public byte[] getDeviceName() {
        return this.mDeviceName;
    }

    @SystemApi
    public byte[] getClassicLength() {
        return this.mClassicLength;
    }

    @SystemApi
    public byte[] getClassOfDevice() {
        return this.mClassOfDevice;
    }

    @SystemApi
    public byte[] getLeTemporaryKey() {
        return this.mLeTemporaryKey;
    }

    @SystemApi
    public byte[] getLeAppearance() {
        return this.mLeAppearance;
    }

    @SystemApi
    public int getLeFlags() {
        return this.mLeFlags;
    }

    @SystemApi
    public int getLeDeviceRole() {
        return this.mLeDeviceRole;
    }

    private OobData(byte[] classicLength, byte[] deviceAddressWithType, byte[] confirmationHash) {
        this.mClassicLength = classicLength;
        this.mDeviceAddressWithType = deviceAddressWithType;
        this.mConfirmationHash = confirmationHash;
        this.mLeDeviceRole = -1;
    }

    private OobData(byte[] deviceAddressWithType, int leDeviceRole, byte[] confirmationHash) {
        this.mDeviceAddressWithType = deviceAddressWithType;
        this.mLeDeviceRole = leDeviceRole;
        this.mConfirmationHash = confirmationHash;
        this.mClassicLength = new byte[2];
    }

    private OobData(Parcel in) {
        this.mDeviceAddressWithType = in.createByteArray();
        this.mConfirmationHash = in.createByteArray();
        this.mRandomizerHash = in.createByteArray();
        this.mDeviceName = in.createByteArray();
        this.mClassicLength = in.createByteArray();
        this.mClassOfDevice = in.createByteArray();
        this.mLeDeviceRole = in.readInt();
        this.mLeTemporaryKey = in.createByteArray();
        this.mLeAppearance = in.createByteArray();
        this.mLeFlags = in.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeByteArray(this.mDeviceAddressWithType);
        out.writeByteArray(this.mConfirmationHash);
        out.writeByteArray(this.mRandomizerHash);
        out.writeByteArray(this.mDeviceName);
        out.writeByteArray(this.mClassicLength);
        out.writeByteArray(this.mClassOfDevice);
        out.writeInt(this.mLeDeviceRole);
        out.writeByteArray(this.mLeTemporaryKey);
        out.writeByteArray(this.mLeAppearance);
        out.writeInt(this.mLeFlags);
    }

    public String toString() {
        return "OobData: \n\tDevice Address With Type: " + this.toHexString(this.mDeviceAddressWithType) + "\n\tConfirmation: " + this.toHexString(this.mConfirmationHash) + "\n\tRandomizer: " + this.toHexString(this.mRandomizerHash) + "\n\tDevice Name: " + this.toHexString(this.mDeviceName) + "\n\tOobData Length: " + this.toHexString(this.mClassicLength) + "\n\tClass of Device: " + this.toHexString(this.mClassOfDevice) + "\n\tLE Device Role: " + this.toHexString(this.mLeDeviceRole) + "\n\tLE Temporary Key: " + this.toHexString(this.mLeTemporaryKey) + "\n\tLE Appearance: " + this.toHexString(this.mLeAppearance) + "\n\tLE Flags: " + this.toHexString(this.mLeFlags) + "\n\t";
    }

    private String toHexString(int b) {
        return this.toHexString(new byte[]{(byte)b});
    }

    private String toHexString(byte b) {
        return this.toHexString(new byte[]{b});
    }

    private String toHexString(byte[] array2) {
        StringBuilder builder2 = new StringBuilder(array2.length * 2);
        for (byte b : array2) {
            builder2.append(String.format("%02x", b));
        }
        return builder2.toString();
    }

    static /* synthetic */ byte[] access$102(OobData x0, byte[] x1) {
        x0.mLeTemporaryKey = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$202(OobData x0, byte[] x1) {
        x0.mLeAppearance = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$402(OobData x0, byte[] x1) {
        x0.mDeviceName = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$502(OobData x0, byte[] x1) {
        x0.mRandomizerHash = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$702(OobData x0, byte[] x1) {
        x0.mClassOfDevice = x1;
        return x1;
    }

    @SystemApi
    public static class ClassicBuilder {
        private byte[] mConfirmationHash = null;
        private byte[] mRandomizerHash = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        private byte[] mDeviceName = null;
        private final byte[] mClassicLength;
        private final byte[] mDeviceAddressWithType;
        private byte[] mClassOfDevice = null;

        @SystemApi
        public ClassicBuilder(byte[] confirmationHash, byte[] classicLength, byte[] deviceAddressWithType) {
            Objects.requireNonNull(confirmationHash);
            Objects.requireNonNull(classicLength);
            Objects.requireNonNull(deviceAddressWithType);
            if (confirmationHash.length != 16) {
                throw new IllegalArgumentException("confirmationHash must be 16 octets in length.");
            }
            this.mConfirmationHash = confirmationHash;
            if (classicLength.length != 2) {
                throw new IllegalArgumentException("classicLength must be 2 octets in length.");
            }
            this.mClassicLength = classicLength;
            if (deviceAddressWithType.length != 7) {
                throw new IllegalArgumentException("deviceAddressWithType must be 7 octets in length.");
            }
            this.mDeviceAddressWithType = deviceAddressWithType;
        }

        @SystemApi
        public ClassicBuilder setRandomizerHash(byte[] randomizerHash) {
            Objects.requireNonNull(randomizerHash);
            if (randomizerHash.length != 16) {
                throw new IllegalArgumentException("randomizerHash must be 16 octets in length.");
            }
            this.mRandomizerHash = randomizerHash;
            return this;
        }

        @SystemApi
        public ClassicBuilder setDeviceName(byte[] deviceName) {
            Objects.requireNonNull(deviceName);
            this.mDeviceName = deviceName;
            return this;
        }

        @SystemApi
        public ClassicBuilder setClassOfDevice(byte[] classOfDevice) {
            Objects.requireNonNull(classOfDevice);
            if (classOfDevice.length != 3) {
                throw new IllegalArgumentException("classOfDevice must be 3 octets in length.");
            }
            this.mClassOfDevice = classOfDevice;
            return this;
        }

        @SystemApi
        public OobData build() {
            OobData oob = new OobData(this.mClassicLength, this.mDeviceAddressWithType, this.mConfirmationHash);
            OobData.access$402(oob, this.mDeviceName != null ? this.mDeviceName : oob.mDeviceName);
            OobData.access$702(oob, this.mClassOfDevice != null ? this.mClassOfDevice : oob.mClassOfDevice);
            OobData.access$502(oob, this.mRandomizerHash);
            return oob;
        }
    }

    @SystemApi
    public static class LeBuilder {
        private byte[] mConfirmationHash = null;
        private byte[] mRandomizerHash = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        private byte[] mDeviceName = null;
        private final byte[] mDeviceAddressWithType;
        private final int mLeDeviceRole;
        private byte[] mLeTemporaryKey = null;
        private byte[] mLeAppearance = null;
        private int mLeFlags = 1;

        @SystemApi
        public LeBuilder setDeviceName(byte[] deviceName) {
            Objects.requireNonNull(deviceName);
            this.mDeviceName = deviceName;
            return this;
        }

        @SystemApi
        public LeBuilder(byte[] confirmationHash, byte[] deviceAddressWithType, int leDeviceRole) {
            Objects.requireNonNull(confirmationHash);
            Objects.requireNonNull(deviceAddressWithType);
            if (confirmationHash.length != 16) {
                throw new IllegalArgumentException("confirmationHash must be 16 octets in length.");
            }
            this.mConfirmationHash = confirmationHash;
            if (deviceAddressWithType.length != 7) {
                throw new IllegalArgumentException("confirmationHash must be 7 octets in length.");
            }
            this.mDeviceAddressWithType = deviceAddressWithType;
            if (leDeviceRole < 0 || leDeviceRole > 3) {
                throw new IllegalArgumentException("leDeviceRole must be a valid value.");
            }
            this.mLeDeviceRole = leDeviceRole;
        }

        @SystemApi
        public LeBuilder setLeTemporaryKey(byte[] leTemporaryKey) {
            Objects.requireNonNull(leTemporaryKey);
            if (leTemporaryKey.length != 16) {
                throw new IllegalArgumentException("leTemporaryKey must be 16 octets in length.");
            }
            this.mLeTemporaryKey = leTemporaryKey;
            return this;
        }

        @SystemApi
        public LeBuilder setRandomizerHash(byte[] randomizerHash) {
            Objects.requireNonNull(randomizerHash);
            if (randomizerHash.length != 16) {
                throw new IllegalArgumentException("randomizerHash must be 16 octets in length.");
            }
            this.mRandomizerHash = randomizerHash;
            return this;
        }

        @SystemApi
        public LeBuilder setLeFlags(int leFlags) {
            if (leFlags < 0 || leFlags > 4) {
                throw new IllegalArgumentException("leFlags must be a valid value.");
            }
            this.mLeFlags = leFlags;
            return this;
        }

        @SystemApi
        public OobData build() {
            OobData oob = new OobData(this.mDeviceAddressWithType, this.mLeDeviceRole, this.mConfirmationHash);
            OobData.access$102(oob, this.mLeTemporaryKey != null ? this.mLeTemporaryKey : oob.mLeTemporaryKey);
            OobData.access$202(oob, this.mLeAppearance != null ? this.mLeAppearance : oob.mLeAppearance);
            oob.mLeFlags = this.mLeFlags != 15 ? this.mLeFlags : oob.mLeFlags;
            OobData.access$402(oob, this.mDeviceName != null ? this.mDeviceName : oob.mDeviceName);
            OobData.access$502(oob, this.mRandomizerHash);
            return oob;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LeFlag {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LeRole {
    }
}

