/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresPermission;
import android.app.PendingIntent;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.IBluetoothGattCallback;
import android.bluetooth.IBluetoothGattServerCallback;
import android.bluetooth.le.AdvertiseData;
import android.bluetooth.le.AdvertisingSetParameters;
import android.bluetooth.le.IAdvertisingSetCallback;
import android.bluetooth.le.IPeriodicAdvertisingCallback;
import android.bluetooth.le.IScannerCallback;
import android.bluetooth.le.PeriodicAdvertisingParameters;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.AttributionSource;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.os.WorkSource;
import java.util.ArrayList;
import java.util.List;

public interface IBluetoothGatt
extends IInterface {
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public void registerScanner(IScannerCallback var1, WorkSource var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public void unregisterScanner(int var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public void startScan(int var1, ScanSettings var2, List<ScanFilter> var3, List var4, AttributionSource var5) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public void startScanForIntent(PendingIntent var1, ScanSettings var2, List<ScanFilter> var3, AttributionSource var4) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public void stopScanForIntent(PendingIntent var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public void stopScan(int var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public void flushPendingBatchResults(int var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void startAdvertisingSet(AdvertisingSetParameters var1, AdvertiseData var2, AdvertiseData var3, PeriodicAdvertisingParameters var4, AdvertiseData var5, int var6, int var7, IAdvertisingSetCallback var8, AttributionSource var9) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void stopAdvertisingSet(IAdvertisingSetCallback var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADVERTISE", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void getOwnAddress(int var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void enableAdvertisingSet(int var1, boolean var2, int var3, int var4, AttributionSource var5) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void setAdvertisingData(int var1, AdvertiseData var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void setScanResponseData(int var1, AdvertiseData var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void setAdvertisingParameters(int var1, AdvertisingSetParameters var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void setPeriodicAdvertisingParameters(int var1, PeriodicAdvertisingParameters var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void setPeriodicAdvertisingData(int var1, AdvertiseData var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void setPeriodicAdvertisingEnable(int var1, boolean var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public void registerSync(ScanResult var1, int var2, int var3, IPeriodicAdvertisingCallback var4, AttributionSource var5) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public void unregisterSync(IPeriodicAdvertisingCallback var1, AttributionSource var2) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="system/bt/binder/android/bluetooth/IBluetoothGatt.aidl:95:1:95:25")
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void registerClient(ParcelUuid var1, IBluetoothGattCallback var2, boolean var3, AttributionSource var4) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="system/bt/binder/android/bluetooth/IBluetoothGatt.aidl:99:1:99:25")
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void unregisterClient(int var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void clientConnect(int var1, String var2, boolean var3, int var4, boolean var5, int var6, AttributionSource var7) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void clientDisconnect(int var1, String var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void clientSetPreferredPhy(int var1, String var2, int var3, int var4, int var5, AttributionSource var6) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void clientReadPhy(int var1, String var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void refreshDevice(int var1, String var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void discoverServices(int var1, String var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void discoverServiceByUuid(int var1, String var2, ParcelUuid var3, AttributionSource var4) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void readCharacteristic(int var1, String var2, int var3, int var4, AttributionSource var5) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void readUsingCharacteristicUuid(int var1, String var2, ParcelUuid var3, int var4, int var5, int var6, AttributionSource var7) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void writeCharacteristic(int var1, String var2, int var3, int var4, int var5, byte[] var6, AttributionSource var7) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void readDescriptor(int var1, String var2, int var3, int var4, AttributionSource var5) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void writeDescriptor(int var1, String var2, int var3, int var4, byte[] var5, AttributionSource var6) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void registerForNotification(int var1, String var2, int var3, boolean var4, AttributionSource var5) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void beginReliableWrite(int var1, String var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void endReliableWrite(int var1, String var2, boolean var3, AttributionSource var4) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void readRemoteRssi(int var1, String var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void configureMTU(int var1, String var2, int var3, AttributionSource var4) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void connectionParameterUpdate(int var1, String var2, int var3, AttributionSource var4) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void leConnectionUpdate(int var1, String var2, int var3, int var4, int var5, int var6, int var7, int var8, AttributionSource var9) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void registerServer(ParcelUuid var1, IBluetoothGattServerCallback var2, boolean var3, AttributionSource var4) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void unregisterServer(int var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void serverConnect(int var1, String var2, boolean var3, int var4, AttributionSource var5) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void serverDisconnect(int var1, String var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void serverSetPreferredPhy(int var1, String var2, int var3, int var4, int var5, AttributionSource var6) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void serverReadPhy(int var1, String var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void addService(int var1, BluetoothGattService var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void removeService(int var1, int var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void clearServices(int var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void sendResponse(int var1, String var2, int var3, int var4, int var5, byte[] var6, AttributionSource var7) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void sendNotification(int var1, String var2, int var3, boolean var4, byte[] var5, AttributionSource var6) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void disconnectAll(AttributionSource var1) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void unregAll(AttributionSource var1) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int numHwTrackFiltersAvailable(AttributionSource var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBluetoothGatt {
        public static final String DESCRIPTOR = "android.bluetooth.IBluetoothGatt";
        static final int TRANSACTION_getDevicesMatchingConnectionStates = 1;
        static final int TRANSACTION_registerScanner = 2;
        static final int TRANSACTION_unregisterScanner = 3;
        static final int TRANSACTION_startScan = 4;
        static final int TRANSACTION_startScanForIntent = 5;
        static final int TRANSACTION_stopScanForIntent = 6;
        static final int TRANSACTION_stopScan = 7;
        static final int TRANSACTION_flushPendingBatchResults = 8;
        static final int TRANSACTION_startAdvertisingSet = 9;
        static final int TRANSACTION_stopAdvertisingSet = 10;
        static final int TRANSACTION_getOwnAddress = 11;
        static final int TRANSACTION_enableAdvertisingSet = 12;
        static final int TRANSACTION_setAdvertisingData = 13;
        static final int TRANSACTION_setScanResponseData = 14;
        static final int TRANSACTION_setAdvertisingParameters = 15;
        static final int TRANSACTION_setPeriodicAdvertisingParameters = 16;
        static final int TRANSACTION_setPeriodicAdvertisingData = 17;
        static final int TRANSACTION_setPeriodicAdvertisingEnable = 18;
        static final int TRANSACTION_registerSync = 19;
        static final int TRANSACTION_unregisterSync = 20;
        static final int TRANSACTION_registerClient = 21;
        static final int TRANSACTION_unregisterClient = 22;
        static final int TRANSACTION_clientConnect = 23;
        static final int TRANSACTION_clientDisconnect = 24;
        static final int TRANSACTION_clientSetPreferredPhy = 25;
        static final int TRANSACTION_clientReadPhy = 26;
        static final int TRANSACTION_refreshDevice = 27;
        static final int TRANSACTION_discoverServices = 28;
        static final int TRANSACTION_discoverServiceByUuid = 29;
        static final int TRANSACTION_readCharacteristic = 30;
        static final int TRANSACTION_readUsingCharacteristicUuid = 31;
        static final int TRANSACTION_writeCharacteristic = 32;
        static final int TRANSACTION_readDescriptor = 33;
        static final int TRANSACTION_writeDescriptor = 34;
        static final int TRANSACTION_registerForNotification = 35;
        static final int TRANSACTION_beginReliableWrite = 36;
        static final int TRANSACTION_endReliableWrite = 37;
        static final int TRANSACTION_readRemoteRssi = 38;
        static final int TRANSACTION_configureMTU = 39;
        static final int TRANSACTION_connectionParameterUpdate = 40;
        static final int TRANSACTION_leConnectionUpdate = 41;
        static final int TRANSACTION_registerServer = 42;
        static final int TRANSACTION_unregisterServer = 43;
        static final int TRANSACTION_serverConnect = 44;
        static final int TRANSACTION_serverDisconnect = 45;
        static final int TRANSACTION_serverSetPreferredPhy = 46;
        static final int TRANSACTION_serverReadPhy = 47;
        static final int TRANSACTION_addService = 48;
        static final int TRANSACTION_removeService = 49;
        static final int TRANSACTION_clearServices = 50;
        static final int TRANSACTION_sendResponse = 51;
        static final int TRANSACTION_sendNotification = 52;
        static final int TRANSACTION_disconnectAll = 53;
        static final int TRANSACTION_unregAll = 54;
        static final int TRANSACTION_numHwTrackFiltersAvailable = 55;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IBluetoothGatt asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IBluetoothGatt) {
                return (IBluetoothGatt)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getDevicesMatchingConnectionStates";
                }
                case 2: {
                    return "registerScanner";
                }
                case 3: {
                    return "unregisterScanner";
                }
                case 4: {
                    return "startScan";
                }
                case 5: {
                    return "startScanForIntent";
                }
                case 6: {
                    return "stopScanForIntent";
                }
                case 7: {
                    return "stopScan";
                }
                case 8: {
                    return "flushPendingBatchResults";
                }
                case 9: {
                    return "startAdvertisingSet";
                }
                case 10: {
                    return "stopAdvertisingSet";
                }
                case 11: {
                    return "getOwnAddress";
                }
                case 12: {
                    return "enableAdvertisingSet";
                }
                case 13: {
                    return "setAdvertisingData";
                }
                case 14: {
                    return "setScanResponseData";
                }
                case 15: {
                    return "setAdvertisingParameters";
                }
                case 16: {
                    return "setPeriodicAdvertisingParameters";
                }
                case 17: {
                    return "setPeriodicAdvertisingData";
                }
                case 18: {
                    return "setPeriodicAdvertisingEnable";
                }
                case 19: {
                    return "registerSync";
                }
                case 20: {
                    return "unregisterSync";
                }
                case 21: {
                    return "registerClient";
                }
                case 22: {
                    return "unregisterClient";
                }
                case 23: {
                    return "clientConnect";
                }
                case 24: {
                    return "clientDisconnect";
                }
                case 25: {
                    return "clientSetPreferredPhy";
                }
                case 26: {
                    return "clientReadPhy";
                }
                case 27: {
                    return "refreshDevice";
                }
                case 28: {
                    return "discoverServices";
                }
                case 29: {
                    return "discoverServiceByUuid";
                }
                case 30: {
                    return "readCharacteristic";
                }
                case 31: {
                    return "readUsingCharacteristicUuid";
                }
                case 32: {
                    return "writeCharacteristic";
                }
                case 33: {
                    return "readDescriptor";
                }
                case 34: {
                    return "writeDescriptor";
                }
                case 35: {
                    return "registerForNotification";
                }
                case 36: {
                    return "beginReliableWrite";
                }
                case 37: {
                    return "endReliableWrite";
                }
                case 38: {
                    return "readRemoteRssi";
                }
                case 39: {
                    return "configureMTU";
                }
                case 40: {
                    return "connectionParameterUpdate";
                }
                case 41: {
                    return "leConnectionUpdate";
                }
                case 42: {
                    return "registerServer";
                }
                case 43: {
                    return "unregisterServer";
                }
                case 44: {
                    return "serverConnect";
                }
                case 45: {
                    return "serverDisconnect";
                }
                case 46: {
                    return "serverSetPreferredPhy";
                }
                case 47: {
                    return "serverReadPhy";
                }
                case 48: {
                    return "addService";
                }
                case 49: {
                    return "removeService";
                }
                case 50: {
                    return "clearServices";
                }
                case 51: {
                    return "sendResponse";
                }
                case 52: {
                    return "sendNotification";
                }
                case 53: {
                    return "disconnectAll";
                }
                case 54: {
                    return "unregAll";
                }
                case 55: {
                    return "numHwTrackFiltersAvailable";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    int[] _arg0 = data.createIntArray();
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    List<BluetoothDevice> _result = this.getDevicesMatchingConnectionStates(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    IScannerCallback _arg0 = IScannerCallback.Stub.asInterface(data.readStrongBinder());
                    WorkSource _arg1 = 0 != data.readInt() ? WorkSource.CREATOR.createFromParcel(data) : null;
                    AttributionSource _arg2 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.registerScanner(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.unregisterScanner(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    ScanSettings _arg1 = 0 != data.readInt() ? ScanSettings.CREATOR.createFromParcel(data) : null;
                    ArrayList<ScanFilter> _arg2 = data.createTypedArrayList(ScanFilter.CREATOR);
                    ClassLoader cl = this.getClass().getClassLoader();
                    ArrayList _arg3 = data.readArrayList(cl);
                    AttributionSource _arg4 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.startScan(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    PendingIntent _arg0 = 0 != data.readInt() ? PendingIntent.CREATOR.createFromParcel(data) : null;
                    ScanSettings _arg1 = 0 != data.readInt() ? ScanSettings.CREATOR.createFromParcel(data) : null;
                    ArrayList<ScanFilter> _arg2 = data.createTypedArrayList(ScanFilter.CREATOR);
                    AttributionSource _arg3 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.startScanForIntent(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    PendingIntent _arg0 = 0 != data.readInt() ? PendingIntent.CREATOR.createFromParcel(data) : null;
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.stopScanForIntent(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.stopScan(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.flushPendingBatchResults(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    AdvertisingSetParameters _arg0 = 0 != data.readInt() ? AdvertisingSetParameters.CREATOR.createFromParcel(data) : null;
                    AdvertiseData _arg1 = 0 != data.readInt() ? AdvertiseData.CREATOR.createFromParcel(data) : null;
                    AdvertiseData _arg2 = 0 != data.readInt() ? AdvertiseData.CREATOR.createFromParcel(data) : null;
                    PeriodicAdvertisingParameters _arg3 = 0 != data.readInt() ? PeriodicAdvertisingParameters.CREATOR.createFromParcel(data) : null;
                    AdvertiseData _arg4 = 0 != data.readInt() ? AdvertiseData.CREATOR.createFromParcel(data) : null;
                    int _arg5 = data.readInt();
                    int _arg6 = data.readInt();
                    IAdvertisingSetCallback _arg7 = IAdvertisingSetCallback.Stub.asInterface(data.readStrongBinder());
                    AttributionSource _arg8 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.startAdvertisingSet(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8);
                    reply.writeNoException();
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    IAdvertisingSetCallback _arg0 = IAdvertisingSetCallback.Stub.asInterface(data.readStrongBinder());
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.stopAdvertisingSet(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.getOwnAddress(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    AttributionSource _arg4 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.enableAdvertisingSet(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    AdvertiseData _arg1 = 0 != data.readInt() ? AdvertiseData.CREATOR.createFromParcel(data) : null;
                    AttributionSource _arg2 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.setAdvertisingData(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 14: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    AdvertiseData _arg1 = 0 != data.readInt() ? AdvertiseData.CREATOR.createFromParcel(data) : null;
                    AttributionSource _arg2 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.setScanResponseData(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 15: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    AdvertisingSetParameters _arg1 = 0 != data.readInt() ? AdvertisingSetParameters.CREATOR.createFromParcel(data) : null;
                    AttributionSource _arg2 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.setAdvertisingParameters(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 16: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    PeriodicAdvertisingParameters _arg1 = 0 != data.readInt() ? PeriodicAdvertisingParameters.CREATOR.createFromParcel(data) : null;
                    AttributionSource _arg2 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.setPeriodicAdvertisingParameters(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 17: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    AdvertiseData _arg1 = 0 != data.readInt() ? AdvertiseData.CREATOR.createFromParcel(data) : null;
                    AttributionSource _arg2 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.setPeriodicAdvertisingData(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 18: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    AttributionSource _arg2 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.setPeriodicAdvertisingEnable(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 19: {
                    data.enforceInterface(descriptor);
                    ScanResult _arg0 = 0 != data.readInt() ? ScanResult.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    IPeriodicAdvertisingCallback _arg3 = IPeriodicAdvertisingCallback.Stub.asInterface(data.readStrongBinder());
                    AttributionSource _arg4 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.registerSync(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    return true;
                }
                case 20: {
                    data.enforceInterface(descriptor);
                    IPeriodicAdvertisingCallback _arg0 = IPeriodicAdvertisingCallback.Stub.asInterface(data.readStrongBinder());
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.unregisterSync(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 21: {
                    data.enforceInterface(descriptor);
                    ParcelUuid _arg0 = 0 != data.readInt() ? ParcelUuid.CREATOR.createFromParcel(data) : null;
                    IBluetoothGattCallback _arg1 = IBluetoothGattCallback.Stub.asInterface(data.readStrongBinder());
                    boolean _arg2 = 0 != data.readInt();
                    AttributionSource _arg3 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.registerClient(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 22: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.unregisterClient(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 23: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    boolean _arg2 = 0 != data.readInt();
                    int _arg3 = data.readInt();
                    boolean _arg4 = 0 != data.readInt();
                    int _arg5 = data.readInt();
                    AttributionSource _arg6 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.clientConnect(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    return true;
                }
                case 24: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    AttributionSource _arg2 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.clientDisconnect(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 25: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    AttributionSource _arg5 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.clientSetPreferredPhy(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    return true;
                }
                case 26: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    AttributionSource _arg2 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.clientReadPhy(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 27: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    AttributionSource _arg2 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.refreshDevice(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 28: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    AttributionSource _arg2 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.discoverServices(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 29: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    ParcelUuid _arg2 = 0 != data.readInt() ? ParcelUuid.CREATOR.createFromParcel(data) : null;
                    AttributionSource _arg3 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.discoverServiceByUuid(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 30: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    AttributionSource _arg4 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.readCharacteristic(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    return true;
                }
                case 31: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    ParcelUuid _arg2 = 0 != data.readInt() ? ParcelUuid.CREATOR.createFromParcel(data) : null;
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    AttributionSource _arg6 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.readUsingCharacteristicUuid(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    return true;
                }
                case 32: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    byte[] _arg5 = data.createByteArray();
                    AttributionSource _arg6 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.writeCharacteristic(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    return true;
                }
                case 33: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    AttributionSource _arg4 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.readDescriptor(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    return true;
                }
                case 34: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    byte[] _arg4 = data.createByteArray();
                    AttributionSource _arg5 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.writeDescriptor(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    return true;
                }
                case 35: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    boolean _arg3 = 0 != data.readInt();
                    AttributionSource _arg4 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.registerForNotification(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    return true;
                }
                case 36: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    AttributionSource _arg2 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.beginReliableWrite(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 37: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    boolean _arg2 = 0 != data.readInt();
                    AttributionSource _arg3 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.endReliableWrite(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 38: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    AttributionSource _arg2 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.readRemoteRssi(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 39: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    AttributionSource _arg3 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.configureMTU(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 40: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    AttributionSource _arg3 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.connectionParameterUpdate(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 41: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    int _arg6 = data.readInt();
                    int _arg7 = data.readInt();
                    AttributionSource _arg8 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.leConnectionUpdate(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8);
                    reply.writeNoException();
                    return true;
                }
                case 42: {
                    data.enforceInterface(descriptor);
                    ParcelUuid _arg0 = 0 != data.readInt() ? ParcelUuid.CREATOR.createFromParcel(data) : null;
                    IBluetoothGattServerCallback _arg1 = IBluetoothGattServerCallback.Stub.asInterface(data.readStrongBinder());
                    boolean _arg2 = 0 != data.readInt();
                    AttributionSource _arg3 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.registerServer(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 43: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.unregisterServer(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 44: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    boolean _arg2 = 0 != data.readInt();
                    int _arg3 = data.readInt();
                    AttributionSource _arg4 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.serverConnect(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    return true;
                }
                case 45: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    AttributionSource _arg2 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.serverDisconnect(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 46: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    AttributionSource _arg5 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.serverSetPreferredPhy(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    return true;
                }
                case 47: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    AttributionSource _arg2 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.serverReadPhy(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 48: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    BluetoothGattService _arg1 = 0 != data.readInt() ? BluetoothGattService.CREATOR.createFromParcel(data) : null;
                    AttributionSource _arg2 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.addService(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 49: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    AttributionSource _arg2 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.removeService(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 50: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    AttributionSource _arg1 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.clearServices(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 51: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    byte[] _arg5 = data.createByteArray();
                    AttributionSource _arg6 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.sendResponse(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    return true;
                }
                case 52: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    boolean _arg3 = 0 != data.readInt();
                    byte[] _arg4 = data.createByteArray();
                    AttributionSource _arg5 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.sendNotification(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    return true;
                }
                case 53: {
                    data.enforceInterface(descriptor);
                    AttributionSource _arg0 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.disconnectAll(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 54: {
                    data.enforceInterface(descriptor);
                    AttributionSource _arg0 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    this.unregAll(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 55: {
                    data.enforceInterface(descriptor);
                    AttributionSource _arg0 = 0 != data.readInt() ? AttributionSource.CREATOR.createFromParcel(data) : null;
                    int _result = this.numHwTrackFiltersAvailable(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IBluetoothGatt impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IBluetoothGatt getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IBluetoothGatt {
            private IBinder mRemote;
            public static IBluetoothGatt sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] states, AttributionSource attributionSource) throws RemoteException {
                ArrayList<BluetoothDevice> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(states);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<BluetoothDevice> list = Stub.getDefaultImpl().getDevicesMatchingConnectionStates(states, attributionSource);
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArrayList(BluetoothDevice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerScanner(IScannerCallback callback2, WorkSource workSource, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback2 != null ? callback2.asBinder() : null);
                    if (workSource != null) {
                        _data.writeInt(1);
                        workSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerScanner(callback2, workSource, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterScanner(int scannerId, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(scannerId);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterScanner(scannerId, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startScan(int scannerId, ScanSettings settings, List<ScanFilter> filters, List scanStorages, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(scannerId);
                    if (settings != null) {
                        _data.writeInt(1);
                        settings.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeTypedList(filters);
                    _data.writeList(scanStorages);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().startScan(scannerId, settings, filters, scanStorages, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startScanForIntent(PendingIntent intent, ScanSettings settings, List<ScanFilter> filters, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intent != null) {
                        _data.writeInt(1);
                        intent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (settings != null) {
                        _data.writeInt(1);
                        settings.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeTypedList(filters);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().startScanForIntent(intent, settings, filters, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopScanForIntent(PendingIntent intent, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intent != null) {
                        _data.writeInt(1);
                        intent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().stopScanForIntent(intent, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopScan(int scannerId, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(scannerId);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().stopScan(scannerId, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void flushPendingBatchResults(int scannerId, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(scannerId);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().flushPendingBatchResults(scannerId, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startAdvertisingSet(AdvertisingSetParameters parameters, AdvertiseData advertiseData, AdvertiseData scanResponse, PeriodicAdvertisingParameters periodicParameters, AdvertiseData periodicData, int duration, int maxExtAdvEvents, IAdvertisingSetCallback callback2, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (parameters != null) {
                        _data.writeInt(1);
                        parameters.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (advertiseData != null) {
                        _data.writeInt(1);
                        advertiseData.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (scanResponse != null) {
                        _data.writeInt(1);
                        scanResponse.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (periodicParameters != null) {
                        _data.writeInt(1);
                        periodicParameters.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (periodicData != null) {
                        _data.writeInt(1);
                        periodicData.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(duration);
                    _data.writeInt(maxExtAdvEvents);
                    _data.writeStrongBinder(callback2 != null ? callback2.asBinder() : null);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().startAdvertisingSet(parameters, advertiseData, scanResponse, periodicParameters, periodicData, duration, maxExtAdvEvents, callback2, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopAdvertisingSet(IAdvertisingSetCallback callback2, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback2 != null ? callback2.asBinder() : null);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().stopAdvertisingSet(callback2, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getOwnAddress(int advertiserId, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(advertiserId);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().getOwnAddress(advertiserId, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableAdvertisingSet(int advertiserId, boolean enable, int duration, int maxExtAdvEvents, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(advertiserId);
                    _data.writeInt(enable ? 1 : 0);
                    _data.writeInt(duration);
                    _data.writeInt(maxExtAdvEvents);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().enableAdvertisingSet(advertiserId, enable, duration, maxExtAdvEvents, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAdvertisingData(int advertiserId, AdvertiseData data, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(advertiserId);
                    if (data != null) {
                        _data.writeInt(1);
                        data.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setAdvertisingData(advertiserId, data, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setScanResponseData(int advertiserId, AdvertiseData data, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(advertiserId);
                    if (data != null) {
                        _data.writeInt(1);
                        data.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setScanResponseData(advertiserId, data, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAdvertisingParameters(int advertiserId, AdvertisingSetParameters parameters, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(advertiserId);
                    if (parameters != null) {
                        _data.writeInt(1);
                        parameters.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setAdvertisingParameters(advertiserId, parameters, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPeriodicAdvertisingParameters(int advertiserId, PeriodicAdvertisingParameters parameters, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(advertiserId);
                    if (parameters != null) {
                        _data.writeInt(1);
                        parameters.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setPeriodicAdvertisingParameters(advertiserId, parameters, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPeriodicAdvertisingData(int advertiserId, AdvertiseData data, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(advertiserId);
                    if (data != null) {
                        _data.writeInt(1);
                        data.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setPeriodicAdvertisingData(advertiserId, data, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPeriodicAdvertisingEnable(int advertiserId, boolean enable, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(advertiserId);
                    _data.writeInt(enable ? 1 : 0);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setPeriodicAdvertisingEnable(advertiserId, enable, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerSync(ScanResult scanResult, int skip, int timeout, IPeriodicAdvertisingCallback callback2, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (scanResult != null) {
                        _data.writeInt(1);
                        scanResult.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(skip);
                    _data.writeInt(timeout);
                    _data.writeStrongBinder(callback2 != null ? callback2.asBinder() : null);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerSync(scanResult, skip, timeout, callback2, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterSync(IPeriodicAdvertisingCallback callback2, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback2 != null ? callback2.asBinder() : null);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterSync(callback2, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerClient(ParcelUuid appId, IBluetoothGattCallback callback2, boolean eatt_support, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (appId != null) {
                        _data.writeInt(1);
                        appId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(callback2 != null ? callback2.asBinder() : null);
                    _data.writeInt(eatt_support ? 1 : 0);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerClient(appId, callback2, eatt_support, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterClient(int clientIf, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(clientIf);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterClient(clientIf, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clientConnect(int clientIf, String address, boolean isDirect, int transport, boolean opportunistic, int phy, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    _data.writeInt(isDirect ? 1 : 0);
                    _data.writeInt(transport);
                    _data.writeInt(opportunistic ? 1 : 0);
                    _data.writeInt(phy);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().clientConnect(clientIf, address, isDirect, transport, opportunistic, phy, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clientDisconnect(int clientIf, String address, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().clientDisconnect(clientIf, address, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clientSetPreferredPhy(int clientIf, String address, int txPhy, int rxPhy, int phyOptions, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    _data.writeInt(txPhy);
                    _data.writeInt(rxPhy);
                    _data.writeInt(phyOptions);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().clientSetPreferredPhy(clientIf, address, txPhy, rxPhy, phyOptions, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clientReadPhy(int clientIf, String addres, AttributionSource attributionSources) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(clientIf);
                    _data.writeString(addres);
                    if (attributionSources != null) {
                        _data.writeInt(1);
                        attributionSources.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().clientReadPhy(clientIf, addres, attributionSources);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void refreshDevice(int clientIf, String address, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().refreshDevice(clientIf, address, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void discoverServices(int clientIf, String address, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().discoverServices(clientIf, address, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void discoverServiceByUuid(int clientIf, String address, ParcelUuid uuid, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    if (uuid != null) {
                        _data.writeInt(1);
                        uuid.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().discoverServiceByUuid(clientIf, address, uuid, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void readCharacteristic(int clientIf, String address, int handle, int authReq, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    _data.writeInt(handle);
                    _data.writeInt(authReq);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().readCharacteristic(clientIf, address, handle, authReq, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void readUsingCharacteristicUuid(int clientIf, String address, ParcelUuid uuid, int startHandle, int endHandle, int authReq, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    if (uuid != null) {
                        _data.writeInt(1);
                        uuid.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(startHandle);
                    _data.writeInt(endHandle);
                    _data.writeInt(authReq);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().readUsingCharacteristicUuid(clientIf, address, uuid, startHandle, endHandle, authReq, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void writeCharacteristic(int clientIf, String address, int handle, int writeType, int authReq, byte[] value2, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    _data.writeInt(handle);
                    _data.writeInt(writeType);
                    _data.writeInt(authReq);
                    _data.writeByteArray(value2);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().writeCharacteristic(clientIf, address, handle, writeType, authReq, value2, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void readDescriptor(int clientIf, String address, int handle, int authReq, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    _data.writeInt(handle);
                    _data.writeInt(authReq);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().readDescriptor(clientIf, address, handle, authReq, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void writeDescriptor(int clientIf, String address, int handle, int authReq, byte[] value2, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    _data.writeInt(handle);
                    _data.writeInt(authReq);
                    _data.writeByteArray(value2);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().writeDescriptor(clientIf, address, handle, authReq, value2, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerForNotification(int clientIf, String address, int handle, boolean enable, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    _data.writeInt(handle);
                    _data.writeInt(enable ? 1 : 0);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerForNotification(clientIf, address, handle, enable, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void beginReliableWrite(int clientIf, String address, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().beginReliableWrite(clientIf, address, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void endReliableWrite(int clientIf, String address, boolean execute, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    _data.writeInt(execute ? 1 : 0);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().endReliableWrite(clientIf, address, execute, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void readRemoteRssi(int clientIf, String address, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().readRemoteRssi(clientIf, address, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void configureMTU(int clientIf, String address, int mtu, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    _data.writeInt(mtu);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().configureMTU(clientIf, address, mtu, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void connectionParameterUpdate(int clientIf, String address, int connectionPriority, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    _data.writeInt(connectionPriority);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().connectionParameterUpdate(clientIf, address, connectionPriority, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void leConnectionUpdate(int clientIf, String address, int minInterval, int maxInterval, int peripheralLatency, int supervisionTimeout, int minConnectionEventLen, int maxConnectionEventLen, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    _data.writeInt(minInterval);
                    _data.writeInt(maxInterval);
                    _data.writeInt(peripheralLatency);
                    _data.writeInt(supervisionTimeout);
                    _data.writeInt(minConnectionEventLen);
                    _data.writeInt(maxConnectionEventLen);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().leConnectionUpdate(clientIf, address, minInterval, maxInterval, peripheralLatency, supervisionTimeout, minConnectionEventLen, maxConnectionEventLen, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerServer(ParcelUuid appId, IBluetoothGattServerCallback callback2, boolean eatt_support, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (appId != null) {
                        _data.writeInt(1);
                        appId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(callback2 != null ? callback2.asBinder() : null);
                    _data.writeInt(eatt_support ? 1 : 0);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerServer(appId, callback2, eatt_support, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterServer(int serverIf, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(serverIf);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterServer(serverIf, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void serverConnect(int serverIf, String address, boolean isDirect, int transport, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(serverIf);
                    _data.writeString(address);
                    _data.writeInt(isDirect ? 1 : 0);
                    _data.writeInt(transport);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(44, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().serverConnect(serverIf, address, isDirect, transport, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void serverDisconnect(int serverIf, String address, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(serverIf);
                    _data.writeString(address);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(45, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().serverDisconnect(serverIf, address, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void serverSetPreferredPhy(int clientIf, String address, int txPhy, int rxPhy, int phyOptions, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    _data.writeInt(txPhy);
                    _data.writeInt(rxPhy);
                    _data.writeInt(phyOptions);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().serverSetPreferredPhy(clientIf, address, txPhy, rxPhy, phyOptions, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void serverReadPhy(int clientIf, String address, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(clientIf);
                    _data.writeString(address);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(47, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().serverReadPhy(clientIf, address, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addService(int serverIf, BluetoothGattService service, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(serverIf);
                    if (service != null) {
                        _data.writeInt(1);
                        service.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(48, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().addService(serverIf, service, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeService(int serverIf, int handle, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(serverIf);
                    _data.writeInt(handle);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(49, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removeService(serverIf, handle, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearServices(int serverIf, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(serverIf);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(50, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().clearServices(serverIf, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendResponse(int serverIf, String address, int requestId, int status, int offset2, byte[] value2, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(serverIf);
                    _data.writeString(address);
                    _data.writeInt(requestId);
                    _data.writeInt(status);
                    _data.writeInt(offset2);
                    _data.writeByteArray(value2);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(51, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().sendResponse(serverIf, address, requestId, status, offset2, value2, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendNotification(int serverIf, String address, int handle, boolean confirm, byte[] value2, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(serverIf);
                    _data.writeString(address);
                    _data.writeInt(handle);
                    _data.writeInt(confirm ? 1 : 0);
                    _data.writeByteArray(value2);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(52, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().sendNotification(serverIf, address, handle, confirm, value2, attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disconnectAll(AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(53, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().disconnectAll(attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregAll(AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(54, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregAll(attributionSource);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int numHwTrackFiltersAvailable(AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (attributionSource != null) {
                        _data.writeInt(1);
                        attributionSource.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(55, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().numHwTrackFiltersAvailable(attributionSource);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IBluetoothGatt {
        @Override
        public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] states, AttributionSource attributionSource) throws RemoteException {
            return null;
        }

        @Override
        public void registerScanner(IScannerCallback callback2, WorkSource workSource, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void unregisterScanner(int scannerId, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void startScan(int scannerId, ScanSettings settings, List<ScanFilter> filters, List scanStorages, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void startScanForIntent(PendingIntent intent, ScanSettings settings, List<ScanFilter> filters, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void stopScanForIntent(PendingIntent intent, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void stopScan(int scannerId, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void flushPendingBatchResults(int scannerId, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void startAdvertisingSet(AdvertisingSetParameters parameters, AdvertiseData advertiseData, AdvertiseData scanResponse, PeriodicAdvertisingParameters periodicParameters, AdvertiseData periodicData, int duration, int maxExtAdvEvents, IAdvertisingSetCallback callback2, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void stopAdvertisingSet(IAdvertisingSetCallback callback2, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void getOwnAddress(int advertiserId, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void enableAdvertisingSet(int advertiserId, boolean enable, int duration, int maxExtAdvEvents, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void setAdvertisingData(int advertiserId, AdvertiseData data, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void setScanResponseData(int advertiserId, AdvertiseData data, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void setAdvertisingParameters(int advertiserId, AdvertisingSetParameters parameters, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void setPeriodicAdvertisingParameters(int advertiserId, PeriodicAdvertisingParameters parameters, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void setPeriodicAdvertisingData(int advertiserId, AdvertiseData data, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void setPeriodicAdvertisingEnable(int advertiserId, boolean enable, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void registerSync(ScanResult scanResult, int skip, int timeout, IPeriodicAdvertisingCallback callback2, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void unregisterSync(IPeriodicAdvertisingCallback callback2, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void registerClient(ParcelUuid appId, IBluetoothGattCallback callback2, boolean eatt_support, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void unregisterClient(int clientIf, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void clientConnect(int clientIf, String address, boolean isDirect, int transport, boolean opportunistic, int phy, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void clientDisconnect(int clientIf, String address, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void clientSetPreferredPhy(int clientIf, String address, int txPhy, int rxPhy, int phyOptions, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void clientReadPhy(int clientIf, String addres, AttributionSource attributionSources) throws RemoteException {
        }

        @Override
        public void refreshDevice(int clientIf, String address, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void discoverServices(int clientIf, String address, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void discoverServiceByUuid(int clientIf, String address, ParcelUuid uuid, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void readCharacteristic(int clientIf, String address, int handle, int authReq, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void readUsingCharacteristicUuid(int clientIf, String address, ParcelUuid uuid, int startHandle, int endHandle, int authReq, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void writeCharacteristic(int clientIf, String address, int handle, int writeType, int authReq, byte[] value2, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void readDescriptor(int clientIf, String address, int handle, int authReq, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void writeDescriptor(int clientIf, String address, int handle, int authReq, byte[] value2, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void registerForNotification(int clientIf, String address, int handle, boolean enable, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void beginReliableWrite(int clientIf, String address, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void endReliableWrite(int clientIf, String address, boolean execute, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void readRemoteRssi(int clientIf, String address, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void configureMTU(int clientIf, String address, int mtu, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void connectionParameterUpdate(int clientIf, String address, int connectionPriority, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void leConnectionUpdate(int clientIf, String address, int minInterval, int maxInterval, int peripheralLatency, int supervisionTimeout, int minConnectionEventLen, int maxConnectionEventLen, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void registerServer(ParcelUuid appId, IBluetoothGattServerCallback callback2, boolean eatt_support, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void unregisterServer(int serverIf, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void serverConnect(int serverIf, String address, boolean isDirect, int transport, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void serverDisconnect(int serverIf, String address, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void serverSetPreferredPhy(int clientIf, String address, int txPhy, int rxPhy, int phyOptions, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void serverReadPhy(int clientIf, String address, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void addService(int serverIf, BluetoothGattService service, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void removeService(int serverIf, int handle, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void clearServices(int serverIf, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void sendResponse(int serverIf, String address, int requestId, int status, int offset2, byte[] value2, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void sendNotification(int serverIf, String address, int handle, boolean confirm, byte[] value2, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void disconnectAll(AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void unregAll(AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public int numHwTrackFiltersAvailable(AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

