/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothSocket;
import java.io.IOException;
import java.io.OutputStream;

@SuppressLint(value={"AndroidFrameworkBluetoothPermission"})
class BluetoothOutputStream
extends OutputStream {
    private BluetoothSocket mSocket;

    BluetoothOutputStream(BluetoothSocket s) {
        this.mSocket = s;
    }

    @Override
    public void close() throws IOException {
        this.mSocket.close();
    }

    @Override
    public void write(int oneByte) throws IOException {
        byte[] b = new byte[]{(byte)oneByte};
        this.mSocket.write(b, 0, 1);
    }

    @Override
    public void write(byte[] b, int offset2, int count) throws IOException {
        if (b == null) {
            throw new NullPointerException("buffer is null");
        }
        if ((offset2 | count) < 0 || count > b.length - offset2) {
            throw new IndexOutOfBoundsException("invalid offset or length");
        }
        this.mSocket.write(b, offset2, count);
    }
}

