/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.BluetoothProfileConnector;
import android.bluetooth.IBluetoothHearingAid;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Attributable;
import android.content.AttributionSource;
import android.content.Context;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;

public class BluetoothHearingAid
implements BluetoothProfile {
    private static final String TAG = "BluetoothHearingAid";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.hearingaid.profile.action.CONNECTION_STATE_CHANGED";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final String ACTION_ACTIVE_DEVICE_CHANGED = "android.bluetooth.hearingaid.profile.action.ACTIVE_DEVICE_CHANGED";
    public static final int SIDE_LEFT = 0;
    public static final int SIDE_RIGHT = 1;
    public static final int MODE_MONAURAL = 0;
    public static final int MODE_BINAURAL = 1;
    public static final long HI_SYNC_ID_INVALID = 0L;
    private final BluetoothAdapter mAdapter;
    private final AttributionSource mAttributionSource;
    private final BluetoothProfileConnector<IBluetoothHearingAid> mProfileConnector = new BluetoothProfileConnector(this, 21, "BluetoothHearingAid", IBluetoothHearingAid.class.getName()){

        public IBluetoothHearingAid getServiceInterface(IBinder service) {
            return IBluetoothHearingAid.Stub.asInterface(Binder.allowBlocking(service));
        }
    };

    BluetoothHearingAid(Context context, BluetoothProfile.ServiceListener listener2, BluetoothAdapter adapter) {
        this.mAdapter = adapter;
        this.mAttributionSource = adapter.getAttributionSource();
        this.mProfileConnector.connect(context, listener2);
    }

    void close() {
        this.mProfileConnector.disconnect();
    }

    private IBluetoothHearingAid getService() {
        return this.mProfileConnector.getService();
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean connect(BluetoothDevice device) {
        BluetoothHearingAid.log("connect(" + device + ")");
        IBluetoothHearingAid service = this.getService();
        try {
            if (service != null && this.isEnabled() && this.isValidDevice(device)) {
                return service.connect(device, this.mAttributionSource);
            }
            if (service == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            return false;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            return false;
        }
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean disconnect(BluetoothDevice device) {
        BluetoothHearingAid.log("disconnect(" + device + ")");
        IBluetoothHearingAid service = this.getService();
        try {
            if (service != null && this.isEnabled() && this.isValidDevice(device)) {
                return service.disconnect(device, this.mAttributionSource);
            }
            if (service == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            return false;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            return false;
        }
    }

    @Override
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public List<BluetoothDevice> getConnectedDevices() {
        IBluetoothHearingAid service = this.getService();
        try {
            if (service != null && this.isEnabled()) {
                return Attributable.setAttributionSource(service.getConnectedDevices(this.mAttributionSource), this.mAttributionSource);
            }
            if (service == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            return new ArrayList<BluetoothDevice>();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            return new ArrayList<BluetoothDevice>();
        }
    }

    @Override
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] states) {
        IBluetoothHearingAid service = this.getService();
        try {
            if (service != null && this.isEnabled()) {
                return Attributable.setAttributionSource(service.getDevicesMatchingConnectionStates(states, this.mAttributionSource), this.mAttributionSource);
            }
            if (service == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            return new ArrayList<BluetoothDevice>();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            return new ArrayList<BluetoothDevice>();
        }
    }

    @Override
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getConnectionState(BluetoothDevice device) {
        IBluetoothHearingAid service = this.getService();
        try {
            if (service != null && this.isEnabled() && this.isValidDevice(device)) {
                return service.getConnectionState(device, this.mAttributionSource);
            }
            if (service == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            return 0;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            return 0;
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean setActiveDevice(BluetoothDevice device) {
        BluetoothHearingAid.log("setActiveDevice(" + device + ")");
        IBluetoothHearingAid service = this.getService();
        try {
            if (service != null && this.isEnabled() && (device == null || this.isValidDevice(device))) {
                service.setActiveDevice(device, this.mAttributionSource);
                return true;
            }
            if (service == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            return false;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            return false;
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public List<BluetoothDevice> getActiveDevices() {
        IBluetoothHearingAid service = this.getService();
        try {
            if (service != null && this.isEnabled()) {
                return Attributable.setAttributionSource(service.getActiveDevices(this.mAttributionSource), this.mAttributionSource);
            }
            if (service == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            return new ArrayList<BluetoothDevice>();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            return new ArrayList<BluetoothDevice>();
        }
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setPriority(BluetoothDevice device, int priority) {
        BluetoothHearingAid.log("setPriority(" + device + ", " + priority + ")");
        return this.setConnectionPolicy(device, BluetoothAdapter.priorityToConnectionPolicy(priority));
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setConnectionPolicy(BluetoothDevice device, int connectionPolicy) {
        BluetoothHearingAid.log("setConnectionPolicy(" + device + ", " + connectionPolicy + ")");
        this.verifyDeviceNotNull(device, "setConnectionPolicy");
        IBluetoothHearingAid service = this.getService();
        try {
            if (service != null && this.isEnabled() && this.isValidDevice(device)) {
                if (connectionPolicy != 0 && connectionPolicy != 100) {
                    return false;
                }
                return service.setConnectionPolicy(device, connectionPolicy, this.mAttributionSource);
            }
            if (service == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            return false;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            return false;
        }
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int getPriority(BluetoothDevice device) {
        return BluetoothAdapter.connectionPolicyToPriority(this.getConnectionPolicy(device));
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int getConnectionPolicy(BluetoothDevice device) {
        this.verifyDeviceNotNull(device, "getConnectionPolicy");
        IBluetoothHearingAid service = this.getService();
        try {
            if (service != null && this.isEnabled() && this.isValidDevice(device)) {
                return service.getConnectionPolicy(device, this.mAttributionSource);
            }
            if (service == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            return 0;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            return 0;
        }
    }

    public static String stateToString(int state) {
        switch (state) {
            case 0: {
                return "disconnected";
            }
            case 1: {
                return "connecting";
            }
            case 2: {
                return "connected";
            }
            case 3: {
                return "disconnecting";
            }
        }
        return "<unknown state " + state + ">";
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void setVolume(int volume) {
        Log.d(TAG, "setVolume(" + volume + ")");
        IBluetoothHearingAid service = this.getService();
        try {
            if (service == null) {
                Log.w(TAG, "Proxy not attached to service");
                return;
            }
            if (!this.isEnabled()) {
                return;
            }
            service.setVolume(volume, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public long getHiSyncId(BluetoothDevice device) {
        this.verifyDeviceNotNull(device, "getConnectionPolicy");
        IBluetoothHearingAid service = this.getService();
        try {
            if (service == null) {
                Log.w(TAG, "Proxy not attached to service");
                return 0L;
            }
            if (!this.isEnabled() || !this.isValidDevice(device)) {
                return 0L;
            }
            return service.getHiSyncId(device, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            return 0L;
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getDeviceSide(BluetoothDevice device) {
        IBluetoothHearingAid service = this.getService();
        try {
            if (service != null && this.isEnabled() && this.isValidDevice(device)) {
                return service.getDeviceSide(device, this.mAttributionSource);
            }
            if (service == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            return 0;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            return 0;
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getDeviceMode(BluetoothDevice device) {
        IBluetoothHearingAid service = this.getService();
        try {
            if (service != null && this.isEnabled() && this.isValidDevice(device)) {
                return service.getDeviceMode(device, this.mAttributionSource);
            }
            if (service == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            return 0;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            return 0;
        }
    }

    private boolean isEnabled() {
        return this.mAdapter.getState() == 12;
    }

    private void verifyDeviceNotNull(BluetoothDevice device, String methodName) {
        if (device == null) {
            Log.e(TAG, methodName + ": device param is null");
            throw new IllegalArgumentException("Device cannot be null");
        }
    }

    private boolean isValidDevice(BluetoothDevice device) {
        if (device == null) {
            return false;
        }
        return BluetoothAdapter.checkBluetoothAddress(device.getAddress());
    }

    private static void log(String msg) {
        Log.d(TAG, msg);
    }
}

