/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothDevice;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Attributable;
import android.content.AttributionSource;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import java.util.UUID;

public class BluetoothHeadsetClientCall
implements Parcelable,
Attributable {
    public static final int CALL_STATE_ACTIVE = 0;
    public static final int CALL_STATE_HELD = 1;
    public static final int CALL_STATE_DIALING = 2;
    public static final int CALL_STATE_ALERTING = 3;
    public static final int CALL_STATE_INCOMING = 4;
    public static final int CALL_STATE_WAITING = 5;
    public static final int CALL_STATE_HELD_BY_RESPONSE_AND_HOLD = 6;
    public static final int CALL_STATE_TERMINATED = 7;
    private final BluetoothDevice mDevice;
    private final int mId;
    private int mState;
    private String mNumber;
    private boolean mMultiParty;
    private final boolean mOutgoing;
    private final UUID mUUID;
    private final long mCreationElapsedMilli;
    private final boolean mInBandRing;
    public static final Parcelable.Creator<BluetoothHeadsetClientCall> CREATOR = new Parcelable.Creator<BluetoothHeadsetClientCall>(){

        @Override
        public BluetoothHeadsetClientCall createFromParcel(Parcel in) {
            return new BluetoothHeadsetClientCall((BluetoothDevice)in.readParcelable(null), in.readInt(), UUID.fromString(in.readString()), in.readInt(), in.readString(), in.readInt() == 1, in.readInt() == 1, in.readInt() == 1);
        }

        public BluetoothHeadsetClientCall[] newArray(int size) {
            return new BluetoothHeadsetClientCall[size];
        }
    };

    public BluetoothHeadsetClientCall(BluetoothDevice device, int id2, int state, String number, boolean multiParty, boolean outgoing, boolean inBandRing) {
        this(device, id2, UUID.randomUUID(), state, number, multiParty, outgoing, inBandRing);
    }

    public BluetoothHeadsetClientCall(BluetoothDevice device, int id2, UUID uuid, int state, String number, boolean multiParty, boolean outgoing, boolean inBandRing) {
        this.mDevice = device;
        this.mId = id2;
        this.mUUID = uuid;
        this.mState = state;
        this.mNumber = number != null ? number : "";
        this.mMultiParty = multiParty;
        this.mOutgoing = outgoing;
        this.mInBandRing = inBandRing;
        this.mCreationElapsedMilli = SystemClock.elapsedRealtime();
    }

    @Override
    public void setAttributionSource(AttributionSource attributionSource) {
        Attributable.setAttributionSource(this.mDevice, attributionSource);
    }

    public void setState(int state) {
        this.mState = state;
    }

    public void setNumber(String number) {
        this.mNumber = number;
    }

    public void setMultiParty(boolean multiParty) {
        this.mMultiParty = multiParty;
    }

    public BluetoothDevice getDevice() {
        return this.mDevice;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public int getId() {
        return this.mId;
    }

    public UUID getUUID() {
        return this.mUUID;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public int getState() {
        return this.mState;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public String getNumber() {
        return this.mNumber;
    }

    public long getCreationElapsedMilli() {
        return this.mCreationElapsedMilli;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean isMultiParty() {
        return this.mMultiParty;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean isOutgoing() {
        return this.mOutgoing;
    }

    public boolean isInBandRing() {
        return this.mInBandRing;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean loggable) {
        StringBuilder builder2 = new StringBuilder("BluetoothHeadsetClientCall{mDevice: ");
        builder2.append(loggable ? this.mDevice : Integer.valueOf(this.mDevice.hashCode()));
        builder2.append(", mId: ");
        builder2.append(this.mId);
        builder2.append(", mUUID: ");
        builder2.append(this.mUUID);
        builder2.append(", mState: ");
        switch (this.mState) {
            case 0: {
                builder2.append("ACTIVE");
                break;
            }
            case 1: {
                builder2.append("HELD");
                break;
            }
            case 2: {
                builder2.append("DIALING");
                break;
            }
            case 3: {
                builder2.append("ALERTING");
                break;
            }
            case 4: {
                builder2.append("INCOMING");
                break;
            }
            case 5: {
                builder2.append("WAITING");
                break;
            }
            case 6: {
                builder2.append("HELD_BY_RESPONSE_AND_HOLD");
                break;
            }
            case 7: {
                builder2.append("TERMINATED");
                break;
            }
            default: {
                builder2.append(this.mState);
            }
        }
        builder2.append(", mNumber: ");
        builder2.append(loggable ? this.mNumber : Integer.valueOf(this.mNumber.hashCode()));
        builder2.append(", mMultiParty: ");
        builder2.append(this.mMultiParty);
        builder2.append(", mOutgoing: ");
        builder2.append(this.mOutgoing);
        builder2.append(", mInBandRing: ");
        builder2.append(this.mInBandRing);
        builder2.append("}");
        return builder2.toString();
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeParcelable(this.mDevice, 0);
        out.writeInt(this.mId);
        out.writeString(this.mUUID.toString());
        out.writeInt(this.mState);
        out.writeString(this.mNumber);
        out.writeInt(this.mMultiParty ? 1 : 0);
        out.writeInt(this.mOutgoing ? 1 : 0);
        out.writeInt(this.mInBandRing ? 1 : 0);
    }

    @Override
    public int describeContents() {
        return 0;
    }
}

