/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresNoPermission;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattServerCallback;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.IBluetoothGattServerCallback;
import android.content.AttributionSource;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class BluetoothGattServer
implements BluetoothProfile {
    private static final String TAG = "BluetoothGattServer";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private final IBluetoothGatt mService;
    private final BluetoothAdapter mAdapter;
    private final AttributionSource mAttributionSource;
    private BluetoothGattServerCallback mCallback;
    private Object mServerIfLock = new Object();
    private int mServerIf;
    private int mTransport;
    private BluetoothGattService mPendingService;
    private List<BluetoothGattService> mServices;
    private static final int CALLBACK_REG_TIMEOUT = 10000;
    @SuppressLint(value={"AndroidFrameworkBluetoothPermission"})
    private final IBluetoothGattServerCallback mBluetoothGattServerCallback = new IBluetoothGattServerCallback.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServerRegistered(int status, int serverIf) {
            Log.d(BluetoothGattServer.TAG, "onServerRegistered() - status=" + status + " serverIf=" + serverIf);
            Object object = BluetoothGattServer.this.mServerIfLock;
            synchronized (object) {
                if (BluetoothGattServer.this.mCallback != null) {
                    BluetoothGattServer.this.mServerIf = serverIf;
                    BluetoothGattServer.this.mServerIfLock.notify();
                } else {
                    Log.e(BluetoothGattServer.TAG, "onServerRegistered: mCallback is null");
                }
            }
        }

        @Override
        public void onServerConnectionState(int status, int serverIf, boolean connected, String address) {
            Log.d(BluetoothGattServer.TAG, "onServerConnectionState() - status=" + status + " serverIf=" + serverIf + " device=" + address);
            try {
                BluetoothGattServer.this.mCallback.onConnectionStateChange(BluetoothGattServer.this.mAdapter.getRemoteDevice(address), status, connected ? 2 : 0);
            }
            catch (Exception ex) {
                Log.w(BluetoothGattServer.TAG, "Unhandled exception in callback", ex);
            }
        }

        @Override
        public void onServiceAdded(int status, BluetoothGattService service) {
            Log.d(BluetoothGattServer.TAG, "onServiceAdded() - handle=" + service.getInstanceId() + " uuid=" + service.getUuid() + " status=" + status);
            if (BluetoothGattServer.this.mPendingService == null) {
                return;
            }
            BluetoothGattService tmp = BluetoothGattServer.this.mPendingService;
            BluetoothGattServer.this.mPendingService = null;
            tmp.setInstanceId(service.getInstanceId());
            List<BluetoothGattCharacteristic> temp_chars = tmp.getCharacteristics();
            List<BluetoothGattCharacteristic> svc_chars = service.getCharacteristics();
            for (int i = 0; i < svc_chars.size(); ++i) {
                BluetoothGattCharacteristic temp_char = temp_chars.get(i);
                BluetoothGattCharacteristic svc_char = svc_chars.get(i);
                temp_char.setInstanceId(svc_char.getInstanceId());
                List<BluetoothGattDescriptor> temp_descs = temp_char.getDescriptors();
                List<BluetoothGattDescriptor> svc_descs = svc_char.getDescriptors();
                for (int j = 0; j < svc_descs.size(); ++j) {
                    temp_descs.get(j).setInstanceId(svc_descs.get(j).getInstanceId());
                }
            }
            BluetoothGattServer.this.mServices.add(tmp);
            try {
                BluetoothGattServer.this.mCallback.onServiceAdded(status, tmp);
            }
            catch (Exception ex) {
                Log.w(BluetoothGattServer.TAG, "Unhandled exception in callback", ex);
            }
        }

        @Override
        public void onCharacteristicReadRequest(String address, int transId, int offset2, boolean isLong, int handle) {
            BluetoothDevice device = BluetoothGattServer.this.mAdapter.getRemoteDevice(address);
            BluetoothGattCharacteristic characteristic = BluetoothGattServer.this.getCharacteristicByHandle(handle);
            if (characteristic == null) {
                Log.w(BluetoothGattServer.TAG, "onCharacteristicReadRequest() no char for handle " + handle);
                return;
            }
            try {
                BluetoothGattServer.this.mCallback.onCharacteristicReadRequest(device, transId, offset2, characteristic);
            }
            catch (Exception ex) {
                Log.w(BluetoothGattServer.TAG, "Unhandled exception in callback", ex);
            }
        }

        @Override
        public void onDescriptorReadRequest(String address, int transId, int offset2, boolean isLong, int handle) {
            BluetoothDevice device = BluetoothGattServer.this.mAdapter.getRemoteDevice(address);
            BluetoothGattDescriptor descriptor = BluetoothGattServer.this.getDescriptorByHandle(handle);
            if (descriptor == null) {
                Log.w(BluetoothGattServer.TAG, "onDescriptorReadRequest() no desc for handle " + handle);
                return;
            }
            try {
                BluetoothGattServer.this.mCallback.onDescriptorReadRequest(device, transId, offset2, descriptor);
            }
            catch (Exception ex) {
                Log.w(BluetoothGattServer.TAG, "Unhandled exception in callback", ex);
            }
        }

        @Override
        public void onCharacteristicWriteRequest(String address, int transId, int offset2, int length, boolean isPrep, boolean needRsp, int handle, byte[] value2) {
            BluetoothDevice device = BluetoothGattServer.this.mAdapter.getRemoteDevice(address);
            BluetoothGattCharacteristic characteristic = BluetoothGattServer.this.getCharacteristicByHandle(handle);
            if (characteristic == null) {
                Log.w(BluetoothGattServer.TAG, "onCharacteristicWriteRequest() no char for handle " + handle);
                return;
            }
            try {
                BluetoothGattServer.this.mCallback.onCharacteristicWriteRequest(device, transId, characteristic, isPrep, needRsp, offset2, value2);
            }
            catch (Exception ex) {
                Log.w(BluetoothGattServer.TAG, "Unhandled exception in callback", ex);
            }
        }

        @Override
        public void onDescriptorWriteRequest(String address, int transId, int offset2, int length, boolean isPrep, boolean needRsp, int handle, byte[] value2) {
            BluetoothDevice device = BluetoothGattServer.this.mAdapter.getRemoteDevice(address);
            BluetoothGattDescriptor descriptor = BluetoothGattServer.this.getDescriptorByHandle(handle);
            if (descriptor == null) {
                Log.w(BluetoothGattServer.TAG, "onDescriptorWriteRequest() no desc for handle " + handle);
                return;
            }
            try {
                BluetoothGattServer.this.mCallback.onDescriptorWriteRequest(device, transId, descriptor, isPrep, needRsp, offset2, value2);
            }
            catch (Exception ex) {
                Log.w(BluetoothGattServer.TAG, "Unhandled exception in callback", ex);
            }
        }

        @Override
        public void onExecuteWrite(String address, int transId, boolean execWrite) {
            Log.d(BluetoothGattServer.TAG, "onExecuteWrite() - device=" + address + ", transId=" + transId + "execWrite=" + execWrite);
            BluetoothDevice device = BluetoothGattServer.this.mAdapter.getRemoteDevice(address);
            if (device == null) {
                return;
            }
            try {
                BluetoothGattServer.this.mCallback.onExecuteWrite(device, transId, execWrite);
            }
            catch (Exception ex) {
                Log.w(BluetoothGattServer.TAG, "Unhandled exception in callback", ex);
            }
        }

        @Override
        public void onNotificationSent(String address, int status) {
            BluetoothDevice device = BluetoothGattServer.this.mAdapter.getRemoteDevice(address);
            if (device == null) {
                return;
            }
            try {
                BluetoothGattServer.this.mCallback.onNotificationSent(device, status);
            }
            catch (Exception ex) {
                Log.w(BluetoothGattServer.TAG, "Unhandled exception: " + ex);
            }
        }

        @Override
        public void onMtuChanged(String address, int mtu) {
            Log.d(BluetoothGattServer.TAG, "onMtuChanged() - device=" + address + ", mtu=" + mtu);
            BluetoothDevice device = BluetoothGattServer.this.mAdapter.getRemoteDevice(address);
            if (device == null) {
                return;
            }
            try {
                BluetoothGattServer.this.mCallback.onMtuChanged(device, mtu);
            }
            catch (Exception ex) {
                Log.w(BluetoothGattServer.TAG, "Unhandled exception: " + ex);
            }
        }

        @Override
        public void onPhyUpdate(String address, int txPhy, int rxPhy, int status) {
            Log.d(BluetoothGattServer.TAG, "onPhyUpdate() - device=" + address + ", txPHy=" + txPhy + ", rxPHy=" + rxPhy);
            BluetoothDevice device = BluetoothGattServer.this.mAdapter.getRemoteDevice(address);
            if (device == null) {
                return;
            }
            try {
                BluetoothGattServer.this.mCallback.onPhyUpdate(device, txPhy, rxPhy, status);
            }
            catch (Exception ex) {
                Log.w(BluetoothGattServer.TAG, "Unhandled exception: " + ex);
            }
        }

        @Override
        public void onPhyRead(String address, int txPhy, int rxPhy, int status) {
            Log.d(BluetoothGattServer.TAG, "onPhyUpdate() - device=" + address + ", txPHy=" + txPhy + ", rxPHy=" + rxPhy);
            BluetoothDevice device = BluetoothGattServer.this.mAdapter.getRemoteDevice(address);
            if (device == null) {
                return;
            }
            try {
                BluetoothGattServer.this.mCallback.onPhyRead(device, txPhy, rxPhy, status);
            }
            catch (Exception ex) {
                Log.w(BluetoothGattServer.TAG, "Unhandled exception: " + ex);
            }
        }

        @Override
        public void onConnectionUpdated(String address, int interval, int latency, int timeout, int status) {
            Log.d(BluetoothGattServer.TAG, "onConnectionUpdated() - Device=" + address + " interval=" + interval + " latency=" + latency + " timeout=" + timeout + " status=" + status);
            BluetoothDevice device = BluetoothGattServer.this.mAdapter.getRemoteDevice(address);
            if (device == null) {
                return;
            }
            try {
                BluetoothGattServer.this.mCallback.onConnectionUpdated(device, interval, latency, timeout, status);
            }
            catch (Exception ex) {
                Log.w(BluetoothGattServer.TAG, "Unhandled exception: " + ex);
            }
        }
    };

    BluetoothGattServer(IBluetoothGatt iGatt, int transport, BluetoothAdapter adapter) {
        this.mService = iGatt;
        this.mAdapter = adapter;
        this.mAttributionSource = adapter.getAttributionSource();
        this.mCallback = null;
        this.mServerIf = 0;
        this.mTransport = transport;
        this.mServices = new ArrayList<BluetoothGattService>();
    }

    BluetoothGattCharacteristic getCharacteristicByHandle(int handle) {
        for (BluetoothGattService svc : this.mServices) {
            for (BluetoothGattCharacteristic charac : svc.getCharacteristics()) {
                if (charac.getInstanceId() != handle) continue;
                return charac;
            }
        }
        return null;
    }

    BluetoothGattDescriptor getDescriptorByHandle(int handle) {
        for (BluetoothGattService svc : this.mServices) {
            for (BluetoothGattCharacteristic charac : svc.getCharacteristics()) {
                for (BluetoothGattDescriptor desc : charac.getDescriptors()) {
                    if (desc.getInstanceId() != handle) continue;
                    return desc;
                }
            }
        }
        return null;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void close() {
        Log.d(TAG, "close()");
        this.unregisterCallback();
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    boolean registerCallback(BluetoothGattServerCallback callback2) {
        return this.registerCallback(callback2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    boolean registerCallback(BluetoothGattServerCallback callback2, boolean eatt_support) {
        Log.d(TAG, "registerCallback()");
        if (this.mService == null) {
            Log.e(TAG, "GATT service not available");
            return false;
        }
        UUID uuid = UUID.randomUUID();
        Log.d(TAG, "registerCallback() - UUID=" + uuid);
        Object object = this.mServerIfLock;
        synchronized (object) {
            if (this.mCallback != null) {
                Log.e(TAG, "App can register callback only once");
                return false;
            }
            this.mCallback = callback2;
            try {
                this.mService.registerServer(new ParcelUuid(uuid), this.mBluetoothGattServerCallback, eatt_support, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, "", e);
                this.mCallback = null;
                return false;
            }
            try {
                this.mServerIfLock.wait(10000L);
            }
            catch (InterruptedException e) {
                Log.e(TAG, "" + e);
                this.mCallback = null;
            }
            if (this.mServerIf == 0) {
                this.mCallback = null;
                return false;
            }
            return true;
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    private void unregisterCallback() {
        Log.d(TAG, "unregisterCallback() - mServerIf=" + this.mServerIf);
        if (this.mService == null || this.mServerIf == 0) {
            return;
        }
        try {
            this.mCallback = null;
            this.mService.unregisterServer(this.mServerIf, this.mAttributionSource);
            this.mServerIf = 0;
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
    }

    BluetoothGattService getService(UUID uuid, int instanceId, int type) {
        for (BluetoothGattService svc : this.mServices) {
            if (svc.getType() != type || svc.getInstanceId() != instanceId || !svc.getUuid().equals(uuid)) continue;
            return svc;
        }
        return null;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean connect(BluetoothDevice device, boolean autoConnect) {
        Log.d(TAG, "connect() - device: " + device.getAddress() + ", auto: " + autoConnect);
        if (this.mService == null || this.mServerIf == 0) {
            return false;
        }
        try {
            this.mService.serverConnect(this.mServerIf, device.getAddress(), !autoConnect, this.mTransport, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
        return true;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void cancelConnection(BluetoothDevice device) {
        Log.d(TAG, "cancelConnection() - device: " + device.getAddress());
        if (this.mService == null || this.mServerIf == 0) {
            return;
        }
        try {
            this.mService.serverDisconnect(this.mServerIf, device.getAddress(), this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void setPreferredPhy(BluetoothDevice device, int txPhy, int rxPhy, int phyOptions) {
        try {
            this.mService.serverSetPreferredPhy(this.mServerIf, device.getAddress(), txPhy, rxPhy, phyOptions, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void readPhy(BluetoothDevice device) {
        try {
            this.mService.serverReadPhy(this.mServerIf, device.getAddress(), this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean sendResponse(BluetoothDevice device, int requestId, int status, int offset2, byte[] value2) {
        if (this.mService == null || this.mServerIf == 0) {
            return false;
        }
        try {
            this.mService.sendResponse(this.mServerIf, device.getAddress(), requestId, status, offset2, value2, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
        return true;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean notifyCharacteristicChanged(BluetoothDevice device, BluetoothGattCharacteristic characteristic, boolean confirm) {
        if (this.mService == null || this.mServerIf == 0) {
            return false;
        }
        BluetoothGattService service = characteristic.getService();
        if (service == null) {
            return false;
        }
        if (characteristic.getValue() == null) {
            throw new IllegalArgumentException("Chracteristic value is empty. Use BluetoothGattCharacteristic#setvalue to update");
        }
        try {
            this.mService.sendNotification(this.mServerIf, device.getAddress(), characteristic.getInstanceId(), confirm, characteristic.getValue(), this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
        return true;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean addService(BluetoothGattService service) {
        Log.d(TAG, "addService() - service: " + service.getUuid());
        if (this.mService == null || this.mServerIf == 0) {
            return false;
        }
        this.mPendingService = service;
        try {
            this.mService.addService(this.mServerIf, service, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
        return true;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean removeService(BluetoothGattService service) {
        Log.d(TAG, "removeService() - service: " + service.getUuid());
        if (this.mService == null || this.mServerIf == 0) {
            return false;
        }
        BluetoothGattService intService = this.getService(service.getUuid(), service.getInstanceId(), service.getType());
        if (intService == null) {
            return false;
        }
        try {
            this.mService.removeService(this.mServerIf, service.getInstanceId(), this.mAttributionSource);
            this.mServices.remove(intService);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
        return true;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void clearServices() {
        Log.d(TAG, "clearServices()");
        if (this.mService == null || this.mServerIf == 0) {
            return;
        }
        try {
            this.mService.clearServices(this.mServerIf, this.mAttributionSource);
            this.mServices.clear();
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
    }

    @RequiresNoPermission
    public List<BluetoothGattService> getServices() {
        return this.mServices;
    }

    @RequiresNoPermission
    public BluetoothGattService getService(UUID uuid) {
        for (BluetoothGattService service : this.mServices) {
            if (!service.getUuid().equals(uuid)) continue;
            return service;
        }
        return null;
    }

    @Override
    @RequiresNoPermission
    public int getConnectionState(BluetoothDevice device) {
        throw new UnsupportedOperationException("Use BluetoothManager#getConnectionState instead.");
    }

    @Override
    @RequiresNoPermission
    public List<BluetoothDevice> getConnectedDevices() {
        throw new UnsupportedOperationException("Use BluetoothManager#getConnectedDevices instead.");
    }

    @Override
    @RequiresNoPermission
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] states) {
        throw new UnsupportedOperationException("Use BluetoothManager#getDevicesMatchingConnectionStates instead.");
    }
}

