/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresPermission;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothAvrcpPlayerSettings;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.BluetoothProfileConnector;
import android.bluetooth.IBluetoothAvrcpController;
import android.content.Attributable;
import android.content.AttributionSource;
import android.content.Context;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;

public class BluetoothAvrcpController
implements BluetoothProfile {
    private static final String TAG = "BluetoothAvrcpController";
    private static final boolean DBG = false;
    private static final boolean VDBG = false;
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.avrcp-controller.profile.action.CONNECTION_STATE_CHANGED";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_PLAYER_SETTING = "android.bluetooth.avrcp-controller.profile.action.PLAYER_SETTING";
    public static final String EXTRA_PLAYER_SETTING = "android.bluetooth.avrcp-controller.profile.extra.PLAYER_SETTING";
    private final BluetoothAdapter mAdapter;
    private final AttributionSource mAttributionSource;
    private final BluetoothProfileConnector<IBluetoothAvrcpController> mProfileConnector = new BluetoothProfileConnector(this, 12, "BluetoothAvrcpController", IBluetoothAvrcpController.class.getName()){

        public IBluetoothAvrcpController getServiceInterface(IBinder service) {
            return IBluetoothAvrcpController.Stub.asInterface(Binder.allowBlocking(service));
        }
    };

    BluetoothAvrcpController(Context context, BluetoothProfile.ServiceListener listener2, BluetoothAdapter adapter) {
        this.mAdapter = adapter;
        this.mAttributionSource = adapter.getAttributionSource();
        this.mProfileConnector.connect(context, listener2);
    }

    void close() {
        this.mProfileConnector.disconnect();
    }

    private IBluetoothAvrcpController getService() {
        return this.mProfileConnector.getService();
    }

    public void finalize() {
        this.close();
    }

    @Override
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public List<BluetoothDevice> getConnectedDevices() {
        IBluetoothAvrcpController service = this.getService();
        if (service != null && this.isEnabled()) {
            try {
                return Attributable.setAttributionSource(service.getConnectedDevices(this.mAttributionSource), this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    @Override
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] states) {
        IBluetoothAvrcpController service = this.getService();
        if (service != null && this.isEnabled()) {
            try {
                return Attributable.setAttributionSource(service.getDevicesMatchingConnectionStates(states, this.mAttributionSource), this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    @Override
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getConnectionState(BluetoothDevice device) {
        IBluetoothAvrcpController service = this.getService();
        if (service != null && this.isEnabled() && BluetoothAvrcpController.isValidDevice(device)) {
            try {
                return service.getConnectionState(device, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
                return 0;
            }
        }
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return 0;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothAvrcpPlayerSettings getPlayerSettings(BluetoothDevice device) {
        BluetoothAvrcpPlayerSettings settings = null;
        IBluetoothAvrcpController service = this.getService();
        if (service != null && this.isEnabled()) {
            try {
                settings = service.getPlayerSettings(device, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error talking to BT service in getMetadata() " + e);
                return null;
            }
        }
        return settings;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean setPlayerApplicationSetting(BluetoothAvrcpPlayerSettings plAppSetting) {
        IBluetoothAvrcpController service = this.getService();
        if (service != null && this.isEnabled()) {
            try {
                return service.setPlayerApplicationSetting(plAppSetting, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error talking to BT service in setPlayerApplicationSetting() " + e);
                return false;
            }
        }
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return false;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void sendGroupNavigationCmd(BluetoothDevice device, int keyCode, int keyState) {
        Log.d(TAG, "sendGroupNavigationCmd dev = " + device + " key " + keyCode + " State = " + keyState);
        IBluetoothAvrcpController service = this.getService();
        if (service != null && this.isEnabled()) {
            try {
                service.sendGroupNavigationCmd(device, keyCode, keyState, this.mAttributionSource);
                return;
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error talking to BT service in sendGroupNavigationCmd()", e);
                return;
            }
        }
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
    }

    private boolean isEnabled() {
        return this.mAdapter.getState() == 12;
    }

    private static boolean isValidDevice(BluetoothDevice device) {
        return device != null && BluetoothAdapter.checkBluetoothAddress(device.getAddress());
    }

    private static void log(String msg) {
        Log.d(TAG, msg);
    }
}

