/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresNoPermission;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.ActivityThread;
import android.app.PropertyInvalidatedCache;
import android.bluetooth.BluetoothA2dp;
import android.bluetooth.BluetoothA2dpSink;
import android.bluetooth.BluetoothActivityEnergyInfo;
import android.bluetooth.BluetoothAvrcpController;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattServer;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothHeadsetClient;
import android.bluetooth.BluetoothHearingAid;
import android.bluetooth.BluetoothHidDevice;
import android.bluetooth.BluetoothHidHost;
import android.bluetooth.BluetoothLeAudio;
import android.bluetooth.BluetoothManager;
import android.bluetooth.BluetoothMap;
import android.bluetooth.BluetoothMapClient;
import android.bluetooth.BluetoothPan;
import android.bluetooth.BluetoothPbap;
import android.bluetooth.BluetoothPbapClient;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.BluetoothSap;
import android.bluetooth.BluetoothServerSocket;
import android.bluetooth.IBluetooth;
import android.bluetooth.IBluetoothConnectionCallback;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothManagerCallback;
import android.bluetooth.IBluetoothMetadataListener;
import android.bluetooth.IBluetoothOobDataCallback;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.bluetooth.OobData;
import android.bluetooth.le.BluetoothLeAdvertiser;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.PeriodicAdvertisingManager;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanRecord;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Attributable;
import android.content.AttributionSource;
import android.content.Context;
import android.os.Binder;
import android.os.IBinder;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.SynchronousResultReceiver;
import android.os.SystemProperties;
import android.util.Log;
import android.util.Pair;
import com.android.internal.annotations.GuardedBy;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class BluetoothAdapter {
    private static final String TAG = "BluetoothAdapter";
    private static final String DESCRIPTOR = "android.bluetooth.BluetoothAdapter";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    public static final String DEFAULT_MAC_ADDRESS = "02:00:00:00:00:00";
    public static final int ERROR = Integer.MIN_VALUE;
    public static final String ACTION_STATE_CHANGED = "android.bluetooth.adapter.action.STATE_CHANGED";
    public static final String EXTRA_STATE = "android.bluetooth.adapter.extra.STATE";
    public static final String EXTRA_PREVIOUS_STATE = "android.bluetooth.adapter.extra.PREVIOUS_STATE";
    public static final int STATE_OFF = 10;
    public static final int STATE_TURNING_ON = 11;
    public static final int STATE_ON = 12;
    public static final int STATE_TURNING_OFF = 13;
    public static final int STATE_BLE_TURNING_ON = 14;
    public static final int STATE_BLE_ON = 15;
    public static final int STATE_BLE_TURNING_OFF = 16;
    public static final UUID LE_PSM_CHARACTERISTIC_UUID = UUID.fromString("2d410339-82b6-42aa-b34e-e2e01df8cc1a");
    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public static final String ACTION_REQUEST_DISCOVERABLE = "android.bluetooth.adapter.action.REQUEST_DISCOVERABLE";
    public static final String EXTRA_DISCOVERABLE_DURATION = "android.bluetooth.adapter.extra.DISCOVERABLE_DURATION";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_REQUEST_ENABLE = "android.bluetooth.adapter.action.REQUEST_ENABLE";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_REQUEST_DISABLE = "android.bluetooth.adapter.action.REQUEST_DISABLE";
    @SystemApi
    public static final String ACTION_REQUEST_BLE_SCAN_ALWAYS_AVAILABLE = "android.bluetooth.adapter.action.REQUEST_BLE_SCAN_ALWAYS_AVAILABLE";
    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public static final String ACTION_SCAN_MODE_CHANGED = "android.bluetooth.adapter.action.SCAN_MODE_CHANGED";
    public static final String EXTRA_SCAN_MODE = "android.bluetooth.adapter.extra.SCAN_MODE";
    public static final String EXTRA_PREVIOUS_SCAN_MODE = "android.bluetooth.adapter.extra.PREVIOUS_SCAN_MODE";
    public static final int SCAN_MODE_NONE = 20;
    public static final int SCAN_MODE_CONNECTABLE = 21;
    public static final int SCAN_MODE_CONNECTABLE_DISCOVERABLE = 23;
    public static final int IO_CAPABILITY_OUT = 0;
    public static final int IO_CAPABILITY_IO = 1;
    public static final int IO_CAPABILITY_IN = 2;
    public static final int IO_CAPABILITY_NONE = 3;
    public static final int IO_CAPABILITY_KBDISP = 4;
    public static final int IO_CAPABILITY_MAX = 5;
    public static final int IO_CAPABILITY_UNKNOWN = 255;
    @SystemApi
    public static final int ACTIVE_DEVICE_AUDIO = 0;
    @SystemApi
    public static final int ACTIVE_DEVICE_PHONE_CALL = 1;
    @SystemApi
    public static final int ACTIVE_DEVICE_ALL = 2;
    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public static final String ACTION_DISCOVERY_STARTED = "android.bluetooth.adapter.action.DISCOVERY_STARTED";
    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public static final String ACTION_DISCOVERY_FINISHED = "android.bluetooth.adapter.action.DISCOVERY_FINISHED";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_LOCAL_NAME_CHANGED = "android.bluetooth.adapter.action.LOCAL_NAME_CHANGED";
    public static final String EXTRA_LOCAL_NAME = "android.bluetooth.adapter.extra.LOCAL_NAME";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.adapter.action.CONNECTION_STATE_CHANGED";
    public static final String EXTRA_CONNECTION_STATE = "android.bluetooth.adapter.extra.CONNECTION_STATE";
    public static final String EXTRA_PREVIOUS_CONNECTION_STATE = "android.bluetooth.adapter.extra.PREVIOUS_CONNECTION_STATE";
    @SystemApi
    public static final String ACTION_BLE_STATE_CHANGED = "android.bluetooth.adapter.action.BLE_STATE_CHANGED";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_BLUETOOTH_ADDRESS_CHANGED = "android.bluetooth.adapter.action.BLUETOOTH_ADDRESS_CHANGED";
    public static final String EXTRA_BLUETOOTH_ADDRESS = "android.bluetooth.adapter.extra.BLUETOOTH_ADDRESS";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_BLE_ACL_CONNECTED = "android.bluetooth.adapter.action.BLE_ACL_CONNECTED";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_BLE_ACL_DISCONNECTED = "android.bluetooth.adapter.action.BLE_ACL_DISCONNECTED";
    public static final int STATE_DISCONNECTED = 0;
    public static final int STATE_CONNECTING = 1;
    public static final int STATE_CONNECTED = 2;
    public static final int STATE_DISCONNECTING = 3;
    public static final String BLUETOOTH_MANAGER_SERVICE = "bluetooth_manager";
    private final IBinder mToken;
    public static final int SOCKET_CHANNEL_AUTO_STATIC_NO_SDP = -2;
    private static final int ADDRESS_LENGTH = 17;
    private static BluetoothAdapter sAdapter;
    private BluetoothLeScanner mBluetoothLeScanner;
    private BluetoothLeAdvertiser mBluetoothLeAdvertiser;
    private PeriodicAdvertisingManager mPeriodicAdvertisingManager;
    private final IBluetoothManager mManagerService;
    private final AttributionSource mAttributionSource;
    @UnsupportedAppUsage
    @GuardedBy(value={"mServiceLock"})
    private IBluetooth mService;
    private final ReentrantReadWriteLock mServiceLock = new ReentrantReadWriteLock();
    @GuardedBy(value={"sServiceLock"})
    private static boolean sServiceRegistered;
    @GuardedBy(value={"sServiceLock"})
    private static IBluetooth sService;
    private static final Object sServiceLock;
    private final Object mLock = new Object();
    private final Map<LeScanCallback, ScanCallback> mLeScanClients;
    private final Map<BluetoothDevice, List<Pair<OnMetadataChangedListener, Executor>>> mMetadataListeners = new HashMap<BluetoothDevice, List<Pair<OnMetadataChangedListener, Executor>>>();
    private final Map<BluetoothConnectionCallback, Executor> mBluetoothConnectionCallbackExecutorMap = new HashMap<BluetoothConnectionCallback, Executor>();
    @SuppressLint(value={"AndroidFrameworkBluetoothPermission"})
    private final IBluetoothMetadataListener mBluetoothMetadataListener = new IBluetoothMetadataListener.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMetadataChanged(BluetoothDevice device, int key, byte[] value2) {
            Attributable.setAttributionSource(device, BluetoothAdapter.this.mAttributionSource);
            Map map2 = BluetoothAdapter.this.mMetadataListeners;
            synchronized (map2) {
                if (BluetoothAdapter.this.mMetadataListeners.containsKey(device)) {
                    List list = (List)BluetoothAdapter.this.mMetadataListeners.get(device);
                    for (Pair pair : list) {
                        OnMetadataChangedListener listener2 = (OnMetadataChangedListener)pair.first;
                        Executor executor = (Executor)pair.second;
                        executor.execute(() -> listener2.onMetadataChanged(device, key, value2));
                    }
                }
            }
        }
    };
    private static final String BLUETOOTH_GET_STATE_CACHE_PROPERTY = "cache_key.bluetooth.get_state";
    private final PropertyInvalidatedCache<Void, Integer> mBluetoothGetStateCache = new PropertyInvalidatedCache<Void, Integer>(8, "cache_key.bluetooth.get_state"){

        @Override
        @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
        protected Integer recompute(Void query) {
            try {
                return BluetoothAdapter.this.mService.getState();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    };
    private static final String BLUETOOTH_FILTERING_CACHE_PROPERTY = "cache_key.bluetooth.is_offloaded_filtering_supported";
    private final PropertyInvalidatedCache<Void, Boolean> mBluetoothFilteringCache = new PropertyInvalidatedCache<Void, Boolean>(8, "cache_key.bluetooth.is_offloaded_filtering_supported"){

        @Override
        @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
        protected Boolean recompute(Void query) {
            try {
                BluetoothAdapter.this.mServiceLock.readLock().lock();
                if (BluetoothAdapter.this.mService != null) {
                    Boolean bl = BluetoothAdapter.this.mService.isOffloadedFilteringSupported();
                    return bl;
                }
            }
            catch (RemoteException e) {
                Log.e(BluetoothAdapter.TAG, "failed to get isOffloadedFilteringSupported, error: ", e);
            }
            finally {
                BluetoothAdapter.this.mServiceLock.readLock().unlock();
            }
            return false;
        }
    };
    private static final String BLUETOOTH_GET_ADAPTER_CONNECTION_STATE_CACHE_PROPERTY = "cache_key.bluetooth.get_adapter_connection_state";
    private final PropertyInvalidatedCache<Void, Integer> mBluetoothGetAdapterConnectionStateCache = new PropertyInvalidatedCache<Void, Integer>(8, "cache_key.bluetooth.get_adapter_connection_state"){

        @Override
        @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
        protected Integer recompute(Void query) {
            try {
                return BluetoothAdapter.this.mService.getAdapterConnectionState();
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
        }
    };
    private static final String BLUETOOTH_PROFILE_CACHE_PROPERTY = "cache_key.bluetooth.get_profile_connection_state";
    private final PropertyInvalidatedCache<Integer, Integer> mGetProfileConnectionStateCache = new PropertyInvalidatedCache<Integer, Integer>(8, "cache_key.bluetooth.get_profile_connection_state"){

        @Override
        @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
        protected Integer recompute(Integer query) {
            try {
                BluetoothAdapter.this.mServiceLock.readLock().lock();
                if (BluetoothAdapter.this.mService != null) {
                    Integer n = BluetoothAdapter.this.mService.getProfileConnectionState(query);
                    return n;
                }
            }
            catch (RemoteException e) {
                Log.e(BluetoothAdapter.TAG, "getProfileConnectionState:", e);
            }
            finally {
                BluetoothAdapter.this.mServiceLock.readLock().unlock();
            }
            return 0;
        }

        @Override
        public String queryToString(Integer query) {
            return String.format("getProfileConnectionState(profile=\"%d\")", query);
        }
    };
    private static final IBluetoothManagerCallback sManagerCallback;
    private final IBluetoothManagerCallback mManagerCallback = new IBluetoothManagerCallback.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onBluetoothServiceUp(IBluetooth bluetoothService) {
            Object object = BluetoothAdapter.this.mServiceLock.writeLock();
            synchronized (object) {
                BluetoothAdapter.this.mService = bluetoothService;
            }
            object = BluetoothAdapter.this.mMetadataListeners;
            synchronized (object) {
                BluetoothAdapter.this.mMetadataListeners.forEach((device, pair) -> {
                    try {
                        BluetoothAdapter.this.mService.registerMetadataListener(BluetoothAdapter.this.mBluetoothMetadataListener, (BluetoothDevice)device, BluetoothAdapter.this.mAttributionSource);
                    }
                    catch (RemoteException e) {
                        Log.e(BluetoothAdapter.TAG, "Failed to register metadata listener", e);
                    }
                });
            }
            object = BluetoothAdapter.this.mBluetoothConnectionCallbackExecutorMap;
            synchronized (object) {
                if (!BluetoothAdapter.this.mBluetoothConnectionCallbackExecutorMap.isEmpty()) {
                    try {
                        BluetoothAdapter.this.mService.registerBluetoothConnectionCallback(BluetoothAdapter.this.mConnectionCallback, BluetoothAdapter.this.mAttributionSource);
                    }
                    catch (RemoteException e) {
                        Log.e(BluetoothAdapter.TAG, "onBluetoothServiceUp: Failed to register bluetoothconnection callback", e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onBluetoothServiceDown() {
            ReentrantReadWriteLock.WriteLock writeLock = BluetoothAdapter.this.mServiceLock.writeLock();
            synchronized (writeLock) {
                BluetoothAdapter.this.mService = null;
                if (BluetoothAdapter.this.mLeScanClients != null) {
                    BluetoothAdapter.this.mLeScanClients.clear();
                }
                if (BluetoothAdapter.this.mBluetoothLeAdvertiser != null) {
                    BluetoothAdapter.this.mBluetoothLeAdvertiser.cleanup();
                }
                if (BluetoothAdapter.this.mBluetoothLeScanner != null) {
                    BluetoothAdapter.this.mBluetoothLeScanner.cleanup();
                }
            }
        }

        @Override
        public void onBrEdrDown() {
        }
    };
    @GuardedBy(value={"sServiceLock"})
    private static final WeakHashMap<IBluetoothManagerCallback, Void> sProxyServiceStateCallbacks;
    @SuppressLint(value={"AndroidFrameworkBluetoothPermission"})
    private final IBluetoothConnectionCallback mConnectionCallback = new IBluetoothConnectionCallback.Stub(){

        @Override
        public void onDeviceConnected(BluetoothDevice device) {
            Attributable.setAttributionSource(device, BluetoothAdapter.this.mAttributionSource);
            for (Map.Entry callbackExecutorEntry : BluetoothAdapter.this.mBluetoothConnectionCallbackExecutorMap.entrySet()) {
                BluetoothConnectionCallback callback2 = (BluetoothConnectionCallback)callbackExecutorEntry.getKey();
                Executor executor = (Executor)callbackExecutorEntry.getValue();
                executor.execute(() -> callback2.onDeviceConnected(device));
            }
        }

        @Override
        public void onDeviceDisconnected(BluetoothDevice device, int hciReason) {
            Attributable.setAttributionSource(device, BluetoothAdapter.this.mAttributionSource);
            for (Map.Entry callbackExecutorEntry : BluetoothAdapter.this.mBluetoothConnectionCallbackExecutorMap.entrySet()) {
                BluetoothConnectionCallback callback2 = (BluetoothConnectionCallback)callbackExecutorEntry.getKey();
                Executor executor = (Executor)callbackExecutorEntry.getValue();
                executor.execute(() -> callback2.onDeviceDisconnected(device, hciReason));
            }
        }
    };

    public static String nameForState(int state) {
        switch (state) {
            case 10: {
                return "OFF";
            }
            case 11: {
                return "TURNING_ON";
            }
            case 12: {
                return "ON";
            }
            case 13: {
                return "TURNING_OFF";
            }
            case 14: {
                return "BLE_TURNING_ON";
            }
            case 15: {
                return "BLE_ON";
            }
            case 16: {
                return "BLE_TURNING_OFF";
            }
        }
        return "?!?!? (" + state + ")";
    }

    @Deprecated
    @RequiresNoPermission
    public static synchronized BluetoothAdapter getDefaultAdapter() {
        if (sAdapter == null) {
            sAdapter = BluetoothAdapter.createAdapter(BluetoothManager.resolveAttributionSource(null));
        }
        return sAdapter;
    }

    public static BluetoothAdapter createAdapter(AttributionSource attributionSource) {
        IBinder binder = ServiceManager.getService(BLUETOOTH_MANAGER_SERVICE);
        if (binder != null) {
            return new BluetoothAdapter(IBluetoothManager.Stub.asInterface(binder), attributionSource);
        }
        Log.e(TAG, "Bluetooth binder is null");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BluetoothAdapter(IBluetoothManager managerService, AttributionSource attributionSource) {
        this.mManagerService = Objects.requireNonNull(managerService);
        this.mAttributionSource = Objects.requireNonNull(attributionSource);
        ReentrantReadWriteLock.WriteLock writeLock = this.mServiceLock.writeLock();
        synchronized (writeLock) {
            this.mService = this.getBluetoothService(this.mManagerCallback);
        }
        this.mLeScanClients = new HashMap<LeScanCallback, ScanCallback>();
        this.mToken = new Binder(DESCRIPTOR);
    }

    @RequiresNoPermission
    public BluetoothDevice getRemoteDevice(String address) {
        BluetoothDevice res = new BluetoothDevice(address);
        res.setAttributionSource(this.mAttributionSource);
        return res;
    }

    @RequiresNoPermission
    public BluetoothDevice getRemoteDevice(byte[] address) {
        if (address == null || address.length != 6) {
            throw new IllegalArgumentException("Bluetooth address must have 6 bytes");
        }
        BluetoothDevice res = new BluetoothDevice(String.format(Locale.US, "%02X:%02X:%02X:%02X:%02X:%02X", address[0], address[1], address[2], address[3], address[4], address[5]));
        res.setAttributionSource(this.mAttributionSource);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresNoPermission
    public BluetoothLeAdvertiser getBluetoothLeAdvertiser() {
        if (!this.getLeAccess()) {
            return null;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mBluetoothLeAdvertiser == null) {
                this.mBluetoothLeAdvertiser = new BluetoothLeAdvertiser(this);
            }
            return this.mBluetoothLeAdvertiser;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresNoPermission
    public PeriodicAdvertisingManager getPeriodicAdvertisingManager() {
        if (!this.getLeAccess()) {
            return null;
        }
        if (!this.isLePeriodicAdvertisingSupported()) {
            return null;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPeriodicAdvertisingManager == null) {
                this.mPeriodicAdvertisingManager = new PeriodicAdvertisingManager(this);
            }
            return this.mPeriodicAdvertisingManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresNoPermission
    public BluetoothLeScanner getBluetoothLeScanner() {
        if (!this.getLeAccess()) {
            return null;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mBluetoothLeScanner == null) {
                this.mBluetoothLeScanner = new BluetoothLeScanner(this);
            }
            return this.mBluetoothLeScanner;
        }
    }

    @RequiresNoPermission
    public boolean isEnabled() {
        return this.getState() == 12;
    }

    @SystemApi
    @RequiresNoPermission
    public boolean isLeEnabled() {
        int state = this.getLeState();
        Log.d(TAG, "isLeEnabled(): " + BluetoothAdapter.nameForState(state));
        return state == 12 || state == 15 || state == 11 || state == 13;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean disableBLE() {
        if (!this.isBleScanAlwaysAvailable()) {
            return false;
        }
        String packageName = ActivityThread.currentPackageName();
        try {
            return this.mManagerService.disableBle(this.mAttributionSource, this.mToken);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean enableBLE() {
        if (!this.isBleScanAlwaysAvailable()) {
            return false;
        }
        String packageName = ActivityThread.currentPackageName();
        try {
            return this.mManagerService.enableBle(this.mAttributionSource, this.mToken);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    @RequiresNoPermission
    public void disableBluetoothGetStateCache() {
        this.mBluetoothGetStateCache.disableLocal();
    }

    public static void invalidateBluetoothGetStateCache() {
        PropertyInvalidatedCache.invalidateCache(BLUETOOTH_GET_STATE_CACHE_PROPERTY);
    }

    private int getStateInternal() {
        int state;
        block7: {
            state = 10;
            try {
                this.mServiceLock.readLock().lock();
                if (this.mService != null) {
                    state = this.mBluetoothGetStateCache.query(null);
                }
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof RemoteException) {
                    Log.e(TAG, "", e.getCause());
                    break block7;
                }
                throw e;
            }
            finally {
                this.mServiceLock.readLock().unlock();
            }
        }
        return state;
    }

    @RequiresNoPermission
    public int getState() {
        int state = this.getStateInternal();
        if (state == 15 || state == 14 || state == 16) {
            state = 10;
        }
        return state;
    }

    @RequiresNoPermission
    @UnsupportedAppUsage(publicAlternatives="Use {@link #getState()} instead to determine whether you can use BLE & BT classic.")
    public int getLeState() {
        int state = this.getStateInternal();
        return state;
    }

    boolean getLeAccess() {
        if (this.getLeState() == 12) {
            return true;
        }
        return this.getLeState() == 15;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean enable() {
        if (this.isEnabled()) {
            Log.d(TAG, "enable(): BT already enabled!");
            return true;
        }
        try {
            return this.mManagerService.enable(this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean disable() {
        try {
            return this.mManagerService.disable(this.mAttributionSource, true);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    @UnsupportedAppUsage(trackingBug=171933273L)
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean disable(boolean persist) {
        try {
            return this.mManagerService.disable(this.mAttributionSource, persist);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.LOCAL_MAC_ADDRESS"})
    public String getAddress() {
        try {
            return this.mManagerService.getAddress(this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return null;
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public String getName() {
        try {
            return this.mManagerService.getName(this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return null;
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public int getNameLengthForAdvertise() {
        try {
            return this.mService.getNameLengthForAdvertise(this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return -1;
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean factoryReset() {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.mService.factoryReset(this.mAttributionSource) && this.mManagerService != null && this.mManagerService.onFactoryReset(this.mAttributionSource)) {
                boolean bl = true;
                return bl;
            }
            Log.e(TAG, "factoryReset(): Setting persist.bluetooth.factoryreset to retry later");
            SystemProperties.set("persist.bluetooth.factoryreset", "true");
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @UnsupportedAppUsage
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public ParcelUuid[] getUuids() {
        if (this.getState() != 12) {
            return null;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                ParcelUuid[] parcelUuidArray = this.mService.getUuids(this.mAttributionSource);
                return parcelUuidArray;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return null;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean setName(String name) {
        if (this.getState() != 12) {
            return false;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.setName(name, this.mAttributionSource);
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothClass getBluetoothClass() {
        if (this.getState() != 12) {
            return null;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                BluetoothClass bluetoothClass = this.mService.getBluetoothClass(this.mAttributionSource);
                return bluetoothClass;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return null;
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setBluetoothClass(BluetoothClass bluetoothClass) {
        if (this.getState() != 12) {
            return false;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.setBluetoothClass(bluetoothClass, this.mAttributionSource);
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getIoCapability() {
        if (this.getState() != 12) {
            return 255;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                int n = this.mService.getIoCapability(this.mAttributionSource);
                return n;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, e.getMessage(), e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return 255;
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setIoCapability(int capability) {
        if (this.getState() != 12) {
            return false;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.setIoCapability(capability, this.mAttributionSource);
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, e.getMessage(), e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getLeIoCapability() {
        if (this.getState() != 12) {
            return 255;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                int n = this.mService.getLeIoCapability(this.mAttributionSource);
                return n;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, e.getMessage(), e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return 255;
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setLeIoCapability(int capability) {
        if (this.getState() != 12) {
            return false;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.setLeIoCapability(capability, this.mAttributionSource);
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, e.getMessage(), e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public int getScanMode() {
        if (this.getState() != 12) {
            return 20;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                int n = this.mService.getScanMode(this.mAttributionSource);
                return n;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return 20;
    }

    @UnsupportedAppUsage(publicAlternatives="Use {@link #ACTION_REQUEST_DISCOVERABLE}, which shows UI that confirms the user wants to go into discoverable mode.")
    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public boolean setScanMode(int mode, long durationMillis) {
        if (this.getState() != 12) {
            return false;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                int durationSeconds = Math.toIntExact(durationMillis / 1000L);
                boolean bl = this.mService.setScanMode(mode, durationSeconds, this.mAttributionSource);
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        catch (ArithmeticException ex) {
            Log.e(TAG, "setScanMode: Duration in seconds outside of the bounds of an int");
            throw new IllegalArgumentException("Duration not in bounds. In seconds, the durationMillis must be in the range of an int");
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @UnsupportedAppUsage
    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public boolean setScanMode(int mode) {
        if (this.getState() != 12) {
            return false;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.setScanMode(mode, this.getDiscoverableTimeout(), this.mAttributionSource);
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @UnsupportedAppUsage
    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public int getDiscoverableTimeout() {
        if (this.getState() != 12) {
            return -1;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                int n = this.mService.getDiscoverableTimeout(this.mAttributionSource);
                return n;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return -1;
    }

    @UnsupportedAppUsage
    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public void setDiscoverableTimeout(int timeout) {
        if (this.getState() != 12) {
            return;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                this.mService.setDiscoverableTimeout(timeout, this.mAttributionSource);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public long getDiscoveryEndMillis() {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                long l = this.mService.getDiscoveryEndMillis(this.mAttributionSource);
                return l;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return -1L;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public boolean startDiscovery() {
        if (this.getState() != 12) {
            return false;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.startDiscovery(this.mAttributionSource);
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public boolean cancelDiscovery() {
        if (this.getState() != 12) {
            return false;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.cancelDiscovery(this.mAttributionSource);
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public boolean isDiscovering() {
        if (this.getState() != 12) {
            return false;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.isDiscovering(this.mAttributionSource);
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED", "android.permission.MODIFY_PHONE_STATE"})
    public boolean removeActiveDevice(int profiles) {
        if (profiles != 0 && profiles != 1 && profiles != 2) {
            Log.e(TAG, "Invalid profiles param value in removeActiveDevice");
            throw new IllegalArgumentException("Profiles must be one of BluetoothAdapter.ACTIVE_DEVICE_AUDIO, BluetoothAdapter.ACTIVE_DEVICE_PHONE_CALL, or BluetoothAdapter.ACTIVE_DEVICE_ALL");
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                Log.d(TAG, "removeActiveDevice, profiles: " + profiles);
                boolean bl = this.mService.removeActiveDevice(profiles, this.mAttributionSource);
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED", "android.permission.MODIFY_PHONE_STATE"})
    public boolean setActiveDevice(BluetoothDevice device, int profiles) {
        if (device == null) {
            Log.e(TAG, "setActiveDevice: Null device passed as parameter");
            throw new IllegalArgumentException("device cannot be null");
        }
        if (profiles != 0 && profiles != 1 && profiles != 2) {
            Log.e(TAG, "Invalid profiles param value in setActiveDevice");
            throw new IllegalArgumentException("Profiles must be one of BluetoothAdapter.ACTIVE_DEVICE_AUDIO, BluetoothAdapter.ACTIVE_DEVICE_PHONE_CALL, or BluetoothAdapter.ACTIVE_DEVICE_ALL");
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                Log.d(TAG, "setActiveDevice, device: " + device + ", profiles: " + profiles);
                boolean bl = this.mService.setActiveDevice(device, profiles, this.mAttributionSource);
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED", "android.permission.MODIFY_PHONE_STATE"})
    public boolean connectAllEnabledProfiles(BluetoothDevice device) {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.connectAllEnabledProfiles(device, this.mAttributionSource);
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean disconnectAllEnabledProfiles(BluetoothDevice device) {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.disconnectAllEnabledProfiles(device, this.mAttributionSource);
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @RequiresNoPermission
    public boolean isMultipleAdvertisementSupported() {
        if (this.getState() != 12) {
            return false;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.isMultiAdvertisementSupported();
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "failed to get isMultipleAdvertisementSupported, error: ", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @SystemApi
    @RequiresNoPermission
    public boolean isBleScanAlwaysAvailable() {
        try {
            return this.mManagerService.isBleScanAlwaysAvailable();
        }
        catch (RemoteException e) {
            Log.e(TAG, "remote expection when calling isBleScanAlwaysAvailable", e);
            return false;
        }
    }

    @RequiresNoPermission
    public void disableIsOffloadedFilteringSupportedCache() {
        this.mBluetoothFilteringCache.disableLocal();
    }

    public static void invalidateIsOffloadedFilteringSupportedCache() {
        PropertyInvalidatedCache.invalidateCache(BLUETOOTH_FILTERING_CACHE_PROPERTY);
    }

    @RequiresNoPermission
    public boolean isOffloadedFilteringSupported() {
        if (!this.getLeAccess()) {
            return false;
        }
        return this.mBluetoothFilteringCache.query(null);
    }

    @RequiresNoPermission
    public boolean isOffloadedScanBatchingSupported() {
        if (!this.getLeAccess()) {
            return false;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.isOffloadedScanBatchingSupported();
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "failed to get isOffloadedScanBatchingSupported, error: ", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @RequiresNoPermission
    public boolean isLe2MPhySupported() {
        if (!this.getLeAccess()) {
            return false;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.isLe2MPhySupported();
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "failed to get isExtendedAdvertisingSupported, error: ", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @RequiresNoPermission
    public boolean isLeCodedPhySupported() {
        if (!this.getLeAccess()) {
            return false;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.isLeCodedPhySupported();
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "failed to get isLeCodedPhySupported, error: ", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @RequiresNoPermission
    public boolean isLeExtendedAdvertisingSupported() {
        if (!this.getLeAccess()) {
            return false;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.isLeExtendedAdvertisingSupported();
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "failed to get isLeExtendedAdvertisingSupported, error: ", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @RequiresNoPermission
    public boolean isLePeriodicAdvertisingSupported() {
        if (!this.getLeAccess()) {
            return false;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.isLePeriodicAdvertisingSupported();
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "failed to get isLePeriodicAdvertisingSupported, error: ", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @RequiresNoPermission
    public int getLeMaximumAdvertisingDataLength() {
        if (!this.getLeAccess()) {
            return 0;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                int n = this.mService.getLeMaximumAdvertisingDataLength();
                return n;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "failed to get getLeMaximumAdvertisingDataLength, error: ", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return 0;
    }

    @RequiresNoPermission
    private boolean isHearingAidProfileSupported() {
        try {
            return this.mManagerService.isHearingAidProfileSupported();
        }
        catch (RemoteException e) {
            Log.e(TAG, "remote expection when calling isHearingAidProfileSupported", e);
            return false;
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getMaxConnectedAudioDevices() {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                int n = this.mService.getMaxConnectedAudioDevices(this.mAttributionSource);
                return n;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "failed to get getMaxConnectedAudioDevices, error: ", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return 1;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean isHardwareTrackingFiltersAvailable() {
        if (!this.getLeAccess()) {
            return false;
        }
        try {
            IBluetoothGatt iGatt = this.mManagerService.getBluetoothGatt();
            if (iGatt == null) {
                return false;
            }
            return iGatt.numHwTrackFiltersAvailable(this.mAttributionSource) != 0;
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    @Deprecated
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public BluetoothActivityEnergyInfo getControllerActivityEnergyInfo(int updateType) {
        SynchronousResultReceiver receiver = new SynchronousResultReceiver();
        this.requestControllerActivityEnergyInfo(receiver);
        try {
            SynchronousResultReceiver.Result result = receiver.awaitResult(1000L);
            if (result.bundle != null) {
                return (BluetoothActivityEnergyInfo)result.bundle.getParcelable("controller_activity");
            }
        }
        catch (TimeoutException e) {
            Log.e(TAG, "getControllerActivityEnergyInfo timed out");
        }
        return null;
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void requestControllerActivityEnergyInfo(ResultReceiver result) {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                this.mService.requestActivityInfo(result, this.mAttributionSource);
                result = null;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "getControllerActivityEnergyInfoCallback: " + e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
            if (result != null) {
                result.send(0, null);
            }
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public List<BluetoothDevice> getMostRecentlyConnectedDevices() {
        if (this.getState() != 12) {
            return new ArrayList<BluetoothDevice>();
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                List<BluetoothDevice> list = Attributable.setAttributionSource(this.mService.getMostRecentlyConnectedDevices(this.mAttributionSource), this.mAttributionSource);
                return list;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return new ArrayList<BluetoothDevice>();
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public Set<BluetoothDevice> getBondedDevices() {
        if (this.getState() != 12) {
            return this.toDeviceSet(Arrays.asList(new BluetoothDevice[0]));
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                Set<BluetoothDevice> set = this.toDeviceSet(Attributable.setAttributionSource(Arrays.asList(this.mService.getBondedDevices(this.mAttributionSource)), this.mAttributionSource));
                return set;
            }
            Set<BluetoothDevice> set = this.toDeviceSet(Arrays.asList(new BluetoothDevice[0]));
            return set;
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresNoPermission
    public List<Integer> getSupportedProfiles() {
        ArrayList<Integer> supportedProfiles = new ArrayList<Integer>();
        try {
            IBluetoothManagerCallback iBluetoothManagerCallback = this.mManagerCallback;
            synchronized (iBluetoothManagerCallback) {
                if (this.mService != null) {
                    long supportedProfilesBitMask = this.mService.getSupportedProfiles();
                    for (int i = 0; i <= 22; ++i) {
                        if ((supportedProfilesBitMask & (long)(1 << i)) == 0L) continue;
                        supportedProfiles.add(i);
                    }
                } else if (this.isHearingAidProfileSupported()) {
                    supportedProfiles.add(21);
                }
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "getSupportedProfiles:", e);
        }
        return supportedProfiles;
    }

    @RequiresNoPermission
    public void disableGetAdapterConnectionStateCache() {
        this.mBluetoothGetAdapterConnectionStateCache.disableLocal();
    }

    public static void invalidateGetAdapterConnectionStateCache() {
        PropertyInvalidatedCache.invalidateCache(BLUETOOTH_GET_ADAPTER_CONNECTION_STATE_CACHE_PROPERTY);
    }

    @UnsupportedAppUsage
    @RequiresNoPermission
    public int getConnectionState() {
        block8: {
            if (this.getState() != 12) {
                return 0;
            }
            try {
                this.mServiceLock.readLock().lock();
                if (this.mService != null) {
                    int n = this.mBluetoothGetAdapterConnectionStateCache.query(null);
                    return n;
                }
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof RemoteException) {
                    Log.e(TAG, "getConnectionState:", e.getCause());
                    break block8;
                }
                throw e;
            }
            finally {
                this.mServiceLock.readLock().unlock();
            }
        }
        return 0;
    }

    @RequiresNoPermission
    public void disableGetProfileConnectionStateCache() {
        this.mGetProfileConnectionStateCache.disableLocal();
    }

    public static void invalidateGetProfileConnectionStateCache() {
        PropertyInvalidatedCache.invalidateCache(BLUETOOTH_PROFILE_CACHE_PROPERTY);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
    public int getProfileConnectionState(int profile) {
        if (this.getState() != 12) {
            return 0;
        }
        return this.mGetProfileConnectionStateCache.query(new Integer(profile));
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothServerSocket listenUsingRfcommOn(int channel) throws IOException {
        return this.listenUsingRfcommOn(channel, false, false);
    }

    @UnsupportedAppUsage
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothServerSocket listenUsingRfcommOn(int channel, boolean mitm, boolean min16DigitPin) throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(1, true, true, channel, mitm, min16DigitPin);
        int errno = socket.mSocket.bindListen();
        if (channel == -2) {
            socket.setChannel(socket.mSocket.getPort());
        }
        if (errno != 0) {
            throw new IOException("Error: " + errno);
        }
        return socket;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothServerSocket listenUsingRfcommWithServiceRecord(String name, UUID uuid) throws IOException {
        return this.createNewRfcommSocketAndRecord(name, uuid, true, true);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothServerSocket listenUsingInsecureRfcommWithServiceRecord(String name, UUID uuid) throws IOException {
        return this.createNewRfcommSocketAndRecord(name, uuid, false, false);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothServerSocket listenUsingEncryptedRfcommWithServiceRecord(String name, UUID uuid) throws IOException {
        return this.createNewRfcommSocketAndRecord(name, uuid, false, true);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    private BluetoothServerSocket createNewRfcommSocketAndRecord(String name, UUID uuid, boolean auth, boolean encrypt) throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(1, auth, encrypt, new ParcelUuid(uuid));
        socket.setServiceName(name);
        int errno = socket.mSocket.bindListen();
        if (errno != 0) {
            throw new IOException("Error: " + errno);
        }
        return socket;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothServerSocket listenUsingInsecureRfcommOn(int port) throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(1, false, false, port);
        int errno = socket.mSocket.bindListen();
        if (port == -2) {
            socket.setChannel(socket.mSocket.getPort());
        }
        if (errno != 0) {
            throw new IOException("Error: " + errno);
        }
        return socket;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothServerSocket listenUsingL2capOn(int port, boolean mitm, boolean min16DigitPin) throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(3, true, true, port, mitm, min16DigitPin);
        int errno = socket.mSocket.bindListen();
        if (port == -2) {
            int assignedChannel = socket.mSocket.getPort();
            Log.d(TAG, "listenUsingL2capOn: set assigned channel to " + assignedChannel);
            socket.setChannel(assignedChannel);
        }
        if (errno != 0) {
            throw new IOException("Error: " + errno);
        }
        return socket;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothServerSocket listenUsingL2capOn(int port) throws IOException {
        return this.listenUsingL2capOn(port, false, false);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothServerSocket listenUsingInsecureL2capOn(int port) throws IOException {
        Log.d(TAG, "listenUsingInsecureL2capOn: port=" + port);
        BluetoothServerSocket socket = new BluetoothServerSocket(3, false, false, port, false, false);
        int errno = socket.mSocket.bindListen();
        if (port == -2) {
            int assignedChannel = socket.mSocket.getPort();
            Log.d(TAG, "listenUsingInsecureL2capOn: set assigned channel to " + assignedChannel);
            socket.setChannel(assignedChannel);
        }
        if (errno != 0) {
            throw new IOException("Error: " + errno);
        }
        return socket;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
    public Pair<byte[], byte[]> readOutOfBandData() {
        return null;
    }

    @SuppressLint(value={"AndroidFrameworkRequiresPermission", "AndroidFrameworkBluetoothPermission"})
    public boolean getProfileProxy(Context context, BluetoothProfile.ServiceListener listener2, int profile) {
        if (context == null || listener2 == null) {
            return false;
        }
        if (profile == 1) {
            BluetoothHeadset headset = new BluetoothHeadset(context, listener2, this);
            return true;
        }
        if (profile == 2) {
            BluetoothA2dp a2dp = new BluetoothA2dp(context, listener2, this);
            return true;
        }
        if (profile == 11) {
            BluetoothA2dpSink a2dpSink = new BluetoothA2dpSink(context, listener2, this);
            return true;
        }
        if (profile == 12) {
            BluetoothAvrcpController avrcp = new BluetoothAvrcpController(context, listener2, this);
            return true;
        }
        if (profile == 4) {
            BluetoothHidHost iDev = new BluetoothHidHost(context, listener2, this);
            return true;
        }
        if (profile == 5) {
            BluetoothPan pan = new BluetoothPan(context, listener2, this);
            return true;
        }
        if (profile == 6) {
            BluetoothPbap pbap = new BluetoothPbap(context, listener2, this);
            return true;
        }
        if (profile == 3) {
            Log.e(TAG, "getProfileProxy(): BluetoothHealth is deprecated");
            return false;
        }
        if (profile == 9) {
            BluetoothMap map2 = new BluetoothMap(context, listener2, this);
            return true;
        }
        if (profile == 16) {
            BluetoothHeadsetClient headsetClient = new BluetoothHeadsetClient(context, listener2, this);
            return true;
        }
        if (profile == 10) {
            BluetoothSap sap = new BluetoothSap(context, listener2, this);
            return true;
        }
        if (profile == 17) {
            BluetoothPbapClient pbapClient = new BluetoothPbapClient(context, listener2, this);
            return true;
        }
        if (profile == 18) {
            BluetoothMapClient mapClient = new BluetoothMapClient(context, listener2, this);
            return true;
        }
        if (profile == 19) {
            BluetoothHidDevice hidDevice = new BluetoothHidDevice(context, listener2, this);
            return true;
        }
        if (profile == 21) {
            if (this.isHearingAidProfileSupported()) {
                BluetoothHearingAid hearingAid = new BluetoothHearingAid(context, listener2, this);
                return true;
            }
            return false;
        }
        if (profile == 22) {
            BluetoothLeAudio leAudio = new BluetoothLeAudio(context, listener2, this);
            return true;
        }
        return false;
    }

    @SuppressLint(value={"AndroidFrameworkRequiresPermission", "AndroidFrameworkBluetoothPermission"})
    public void closeProfileProxy(int profile, BluetoothProfile proxy) {
        if (proxy == null) {
            return;
        }
        switch (profile) {
            case 1: {
                BluetoothHeadset headset = (BluetoothHeadset)proxy;
                headset.close();
                break;
            }
            case 2: {
                BluetoothA2dp a2dp = (BluetoothA2dp)proxy;
                a2dp.close();
                break;
            }
            case 11: {
                BluetoothA2dpSink a2dpSink = (BluetoothA2dpSink)proxy;
                a2dpSink.close();
                break;
            }
            case 12: {
                BluetoothAvrcpController avrcp = (BluetoothAvrcpController)proxy;
                avrcp.close();
                break;
            }
            case 4: {
                BluetoothHidHost iDev = (BluetoothHidHost)proxy;
                iDev.close();
                break;
            }
            case 5: {
                BluetoothPan pan = (BluetoothPan)proxy;
                pan.close();
                break;
            }
            case 6: {
                BluetoothPbap pbap = (BluetoothPbap)proxy;
                pbap.close();
                break;
            }
            case 7: {
                BluetoothGatt gatt = (BluetoothGatt)proxy;
                gatt.close();
                break;
            }
            case 8: {
                BluetoothGattServer gattServer = (BluetoothGattServer)proxy;
                gattServer.close();
                break;
            }
            case 9: {
                BluetoothMap map2 = (BluetoothMap)proxy;
                map2.close();
                break;
            }
            case 16: {
                BluetoothHeadsetClient headsetClient = (BluetoothHeadsetClient)proxy;
                headsetClient.close();
                break;
            }
            case 10: {
                BluetoothSap sap = (BluetoothSap)proxy;
                sap.close();
                break;
            }
            case 17: {
                BluetoothPbapClient pbapClient = (BluetoothPbapClient)proxy;
                pbapClient.close();
                break;
            }
            case 18: {
                BluetoothMapClient mapClient = (BluetoothMapClient)proxy;
                mapClient.close();
                break;
            }
            case 19: {
                BluetoothHidDevice hidDevice = (BluetoothHidDevice)proxy;
                hidDevice.close();
                break;
            }
            case 21: {
                BluetoothHearingAid hearingAid = (BluetoothHearingAid)proxy;
                hearingAid.close();
                break;
            }
            case 22: {
                BluetoothLeAudio leAudio = (BluetoothLeAudio)proxy;
                leAudio.close();
            }
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean enableNoAutoConnect() {
        if (this.isEnabled()) {
            Log.d(TAG, "enableNoAutoConnect(): BT already enabled!");
            return true;
        }
        try {
            return this.mManagerService.enableNoAutoConnect(this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void generateLocalOobData(int transport, Executor executor, OobDataCallback callback2) {
        if (transport != 1 && transport != 2) {
            throw new IllegalArgumentException("Invalid transport '" + transport + "'!");
        }
        Objects.requireNonNull(callback2);
        if (!this.isEnabled()) {
            Log.w(TAG, "generateLocalOobData(): Adapter isn't enabled!");
            callback2.onError(1);
        } else {
            try {
                this.mService.generateLocalOobData(transport, new WrappedOobDataCallback(callback2, executor), this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, "", e);
            }
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
    public boolean changeApplicationBluetoothState(boolean on, BluetoothStateChangeCallback callback2) {
        return false;
    }

    private Set<BluetoothDevice> toDeviceSet(List<BluetoothDevice> devices2) {
        HashSet<BluetoothDevice> deviceSet = new HashSet<BluetoothDevice>(devices2);
        return Collections.unmodifiableSet(deviceSet);
    }

    protected void finalize() throws Throwable {
        try {
            this.removeServiceStateCallback(this.mManagerCallback);
        }
        finally {
            super.finalize();
        }
    }

    public static boolean checkBluetoothAddress(String address) {
        if (address == null || address.length() != 17) {
            return false;
        }
        block4: for (int i = 0; i < 17; ++i) {
            char c = address.charAt(i);
            switch (i % 3) {
                case 0: 
                case 1: {
                    if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F') continue block4;
                    return false;
                }
                case 2: {
                    if (c == ':') continue block4;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isAddressRandomStatic(String address) {
        Objects.requireNonNull(address);
        return BluetoothAdapter.checkBluetoothAddress(address) && (Integer.parseInt(address.split(":")[0], 16) & 0xC0) == 192;
    }

    @UnsupportedAppUsage
    @RequiresNoPermission
    public IBluetoothManager getBluetoothManager() {
        return this.mManagerService;
    }

    @RequiresNoPermission
    public AttributionSource getAttributionSource() {
        return this.mAttributionSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IBluetooth getBluetoothService() {
        Object object = sServiceLock;
        synchronized (object) {
            if (sProxyServiceStateCallbacks.isEmpty()) {
                throw new IllegalStateException("Anonymous service access requires at least one lifecycle in process");
            }
            return sService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    IBluetooth getBluetoothService(IBluetoothManagerCallback cb) {
        Objects.requireNonNull(cb);
        Object object = sServiceLock;
        synchronized (object) {
            sProxyServiceStateCallbacks.put(cb, null);
            this.registerOrUnregisterAdapterLocked();
            return sService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeServiceStateCallback(IBluetoothManagerCallback cb) {
        Objects.requireNonNull(cb);
        Object object = sServiceLock;
        synchronized (object) {
            sProxyServiceStateCallbacks.remove(cb);
            this.registerOrUnregisterAdapterLocked();
        }
    }

    @GuardedBy(value={"sServiceLock"})
    private void registerOrUnregisterAdapterLocked() {
        boolean wantRegistered;
        boolean isRegistered = sServiceRegistered;
        boolean bl = wantRegistered = !sProxyServiceStateCallbacks.isEmpty();
        if (isRegistered != wantRegistered) {
            if (wantRegistered) {
                try {
                    sService = this.mManagerService.registerAdapter(sManagerCallback);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            try {
                this.mManagerService.unregisterAdapter(sManagerCallback);
                sService = null;
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            sServiceRegistered = wantRegistered;
        }
    }

    public boolean registerServiceLifecycleCallback(ServiceLifecycleCallback callback2) {
        return this.getBluetoothService(callback2.mRemote) != null;
    }

    public void unregisterServiceLifecycleCallback(ServiceLifecycleCallback callback2) {
        this.removeServiceStateCallback(callback2.mRemote);
    }

    @Deprecated
    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public boolean startLeScan(LeScanCallback callback2) {
        return this.startLeScan(null, callback2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public boolean startLeScan(final UUID[] serviceUuids, final LeScanCallback callback2) {
        Log.d(TAG, "startLeScan(): " + Arrays.toString(serviceUuids));
        if (callback2 == null) {
            Log.e(TAG, "startLeScan: null callback");
            return false;
        }
        BluetoothLeScanner scanner = this.getBluetoothLeScanner();
        if (scanner == null) {
            Log.e(TAG, "startLeScan: cannot get BluetoothLeScanner");
            return false;
        }
        Map<LeScanCallback, ScanCallback> map2 = this.mLeScanClients;
        synchronized (map2) {
            if (this.mLeScanClients.containsKey(callback2)) {
                Log.e(TAG, "LE Scan has already started");
                return false;
            }
            try {
                IBluetoothGatt iGatt = this.mManagerService.getBluetoothGatt();
                if (iGatt == null) {
                    return false;
                }
                ScanCallback scanCallback = new ScanCallback(){

                    @Override
                    public void onScanResult(int callbackType, ScanResult result) {
                        if (callbackType != 1) {
                            Log.e(BluetoothAdapter.TAG, "LE Scan has already started");
                            return;
                        }
                        ScanRecord scanRecord = result.getScanRecord();
                        if (scanRecord == null) {
                            return;
                        }
                        if (serviceUuids != null) {
                            ArrayList<ParcelUuid> uuids = new ArrayList<ParcelUuid>();
                            for (UUID uuid : serviceUuids) {
                                uuids.add(new ParcelUuid(uuid));
                            }
                            List<ParcelUuid> scanServiceUuids = scanRecord.getServiceUuids();
                            if (scanServiceUuids == null || !scanServiceUuids.containsAll(uuids)) {
                                Log.d(BluetoothAdapter.TAG, "uuids does not match");
                                return;
                            }
                        }
                        callback2.onLeScan(result.getDevice(), result.getRssi(), scanRecord.getBytes());
                    }
                };
                ScanSettings settings = new ScanSettings.Builder().setCallbackType(1).setScanMode(2).build();
                ArrayList<ScanFilter> filters = new ArrayList<ScanFilter>();
                if (serviceUuids != null && serviceUuids.length > 0) {
                    ScanFilter filter2 = new ScanFilter.Builder().setServiceUuid(new ParcelUuid(serviceUuids[0])).build();
                    filters.add(filter2);
                }
                scanner.startScan(filters, settings, scanCallback);
                this.mLeScanClients.put(callback2, scanCallback);
                return true;
            }
            catch (RemoteException e) {
                Log.e(TAG, "", e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public void stopLeScan(LeScanCallback callback2) {
        Log.d(TAG, "stopLeScan()");
        BluetoothLeScanner scanner = this.getBluetoothLeScanner();
        if (scanner == null) {
            return;
        }
        Map<LeScanCallback, ScanCallback> map2 = this.mLeScanClients;
        synchronized (map2) {
            ScanCallback scanCallback = this.mLeScanClients.remove(callback2);
            if (scanCallback == null) {
                Log.d(TAG, "scan not started yet");
                return;
            }
            scanner.stopScan(scanCallback);
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothServerSocket listenUsingL2capChannel() throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(4, true, true, -2, false, false);
        int errno = socket.mSocket.bindListen();
        if (errno != 0) {
            throw new IOException("Error: " + errno);
        }
        int assignedPsm = socket.mSocket.getPort();
        if (assignedPsm == 0) {
            throw new IOException("Error: Unable to assign PSM value");
        }
        Log.d(TAG, "listenUsingL2capChannel: set assigned PSM to " + assignedPsm);
        socket.setChannel(assignedPsm);
        return socket;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothServerSocket listenUsingInsecureL2capChannel() throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(4, false, false, -2, false, false);
        int errno = socket.mSocket.bindListen();
        if (errno != 0) {
            throw new IOException("Error: " + errno);
        }
        int assignedPsm = socket.mSocket.getPort();
        if (assignedPsm == 0) {
            throw new IOException("Error: Unable to assign PSM value");
        }
        Log.d(TAG, "listenUsingInsecureL2capChannel: set assigned PSM to " + assignedPsm);
        socket.setChannel(assignedPsm);
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean addOnMetadataChangedListener(BluetoothDevice device, Executor executor, OnMetadataChangedListener listener2) {
        Log.d(TAG, "addOnMetadataChangedListener()");
        IBluetooth service = this.mService;
        if (service == null) {
            Log.e(TAG, "Bluetooth is not enabled. Cannot register metadata listener");
            return false;
        }
        if (listener2 == null) {
            throw new NullPointerException("listener is null");
        }
        if (device == null) {
            throw new NullPointerException("device is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is null");
        }
        Map<BluetoothDevice, List<Pair<OnMetadataChangedListener, Executor>>> map2 = this.mMetadataListeners;
        synchronized (map2) {
            List<Pair<OnMetadataChangedListener, Executor>> listenerList = this.mMetadataListeners.get(device);
            if (listenerList == null) {
                listenerList = new ArrayList<Pair<OnMetadataChangedListener, Executor>>();
                this.mMetadataListeners.put(device, listenerList);
            } else if (listenerList.stream().anyMatch(pair -> ((OnMetadataChangedListener)pair.first).equals(listener2))) {
                throw new IllegalArgumentException("listener was already regestered for the device");
            }
            Pair<OnMetadataChangedListener, Executor> listenerPair = new Pair<OnMetadataChangedListener, Executor>(listener2, executor);
            listenerList.add(listenerPair);
            boolean ret = false;
            try {
                ret = service.registerMetadataListener(this.mBluetoothMetadataListener, device, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, "registerMetadataListener fail", e);
            }
            finally {
                if (!ret) {
                    listenerList.remove(listenerPair);
                    if (listenerList.isEmpty()) {
                        this.mMetadataListeners.remove(device);
                    }
                }
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean removeOnMetadataChangedListener(BluetoothDevice device, OnMetadataChangedListener listener2) {
        Log.d(TAG, "removeOnMetadataChangedListener()");
        if (device == null) {
            throw new NullPointerException("device is null");
        }
        if (listener2 == null) {
            throw new NullPointerException("listener is null");
        }
        Map<BluetoothDevice, List<Pair<OnMetadataChangedListener, Executor>>> map2 = this.mMetadataListeners;
        synchronized (map2) {
            if (!this.mMetadataListeners.containsKey(device)) {
                throw new IllegalArgumentException("device was not registered");
            }
            this.mMetadataListeners.get(device).removeIf(pair -> ((OnMetadataChangedListener)pair.first).equals(listener2));
            if (this.mMetadataListeners.get(device).isEmpty()) {
                this.mMetadataListeners.remove(device);
                IBluetooth service = this.mService;
                if (service == null) {
                    return true;
                }
                try {
                    return service.unregisterMetadataListener(device, this.mAttributionSource);
                }
                catch (RemoteException e) {
                    Log.e(TAG, "unregisterMetadataListener fail", e);
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean registerBluetoothConnectionCallback(Executor executor, BluetoothConnectionCallback callback2) {
        Log.d(TAG, "registerBluetoothConnectionCallback()");
        if (callback2 == null) {
            return false;
        }
        Map<BluetoothConnectionCallback, Executor> map2 = this.mBluetoothConnectionCallbackExecutorMap;
        synchronized (map2) {
            if (this.mBluetoothConnectionCallbackExecutorMap.isEmpty()) {
                try {
                    this.mServiceLock.readLock().lock();
                    if (this.mService != null && !this.mService.registerBluetoothConnectionCallback(this.mConnectionCallback, this.mAttributionSource)) {
                        boolean bl = false;
                        return bl;
                    }
                }
                catch (RemoteException e) {
                    Log.e(TAG, "", e);
                    this.mBluetoothConnectionCallbackExecutorMap.remove(callback2);
                }
                finally {
                    this.mServiceLock.readLock().unlock();
                }
            }
            if (this.mBluetoothConnectionCallbackExecutorMap.containsKey(callback2)) {
                throw new IllegalArgumentException("This callback has already been registered");
            }
            this.mBluetoothConnectionCallbackExecutorMap.put(callback2, executor);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean unregisterBluetoothConnectionCallback(BluetoothConnectionCallback callback2) {
        Log.d(TAG, "unregisterBluetoothConnectionCallback()");
        if (callback2 == null) {
            return false;
        }
        Map<BluetoothConnectionCallback, Executor> map2 = this.mBluetoothConnectionCallbackExecutorMap;
        synchronized (map2) {
            if (this.mBluetoothConnectionCallbackExecutorMap.remove(callback2) != null) {
                return false;
            }
        }
        if (!this.mBluetoothConnectionCallbackExecutorMap.isEmpty()) {
            return true;
        }
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null) {
                boolean bl = this.mService.unregisterBluetoothConnectionCallback(this.mConnectionCallback, this.mAttributionSource);
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    public static int priorityToConnectionPolicy(int priority) {
        switch (priority) {
            case 1000: {
                return 100;
            }
            case 100: {
                return 100;
            }
            case 0: {
                return 0;
            }
            case -1: {
                return -1;
            }
        }
        Log.e(TAG, "setPriority: Invalid priority: " + priority);
        return -1;
    }

    public static int connectionPolicyToPriority(int connectionPolicy) {
        switch (connectionPolicy) {
            case 100: {
                return 100;
            }
            case 0: {
                return 0;
            }
            case -1: {
                return -1;
            }
        }
        return -1;
    }

    static {
        sServiceLock = new Object();
        sManagerCallback = new IBluetoothManagerCallback.Stub(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBluetoothServiceUp(IBluetooth bluetoothService) {
                Log.d(BluetoothAdapter.TAG, "onBluetoothServiceUp: " + bluetoothService);
                Object object = sServiceLock;
                synchronized (object) {
                    sService = bluetoothService;
                    for (IBluetoothManagerCallback cb : sProxyServiceStateCallbacks.keySet()) {
                        try {
                            if (cb != null) {
                                cb.onBluetoothServiceUp(bluetoothService);
                                continue;
                            }
                            Log.d(BluetoothAdapter.TAG, "onBluetoothServiceUp: cb is null!");
                        }
                        catch (Exception e) {
                            Log.e(BluetoothAdapter.TAG, "", e);
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBluetoothServiceDown() {
                Log.d(BluetoothAdapter.TAG, "onBluetoothServiceDown");
                Object object = sServiceLock;
                synchronized (object) {
                    sService = null;
                    for (IBluetoothManagerCallback cb : sProxyServiceStateCallbacks.keySet()) {
                        try {
                            if (cb != null) {
                                cb.onBluetoothServiceDown();
                                continue;
                            }
                            Log.d(BluetoothAdapter.TAG, "onBluetoothServiceDown: cb is null!");
                        }
                        catch (Exception e) {
                            Log.e(BluetoothAdapter.TAG, "", e);
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBrEdrDown() {
                Object object = sServiceLock;
                synchronized (object) {
                    for (IBluetoothManagerCallback cb : sProxyServiceStateCallbacks.keySet()) {
                        try {
                            if (cb != null) {
                                cb.onBrEdrDown();
                                continue;
                            }
                            Log.d(BluetoothAdapter.TAG, "onBrEdrDown: cb is null!");
                        }
                        catch (Exception e) {
                            Log.e(BluetoothAdapter.TAG, "", e);
                        }
                    }
                }
            }
        };
        sProxyServiceStateCallbacks = new WeakHashMap();
    }

    public static abstract class BluetoothConnectionCallback {
        public void onDeviceConnected(BluetoothDevice device) {
        }

        public void onDeviceDisconnected(BluetoothDevice device, int reason) {
        }

        public static String disconnectReasonText(int reason) {
            switch (reason) {
                case 0x7FFFFFFF: {
                    return "Reason unknown";
                }
                case 1100: {
                    return "Local request";
                }
                case 1101: {
                    return "Remote request";
                }
                case 1102: {
                    return "Local error";
                }
                case 1103: {
                    return "Remote error";
                }
                case 1104: {
                    return "Timeout";
                }
                case 1105: {
                    return "Security";
                }
                case 1106: {
                    return "System policy";
                }
                case 1107: {
                    return "Resource constrained";
                }
                case 1108: {
                    return "Connection already exists";
                }
                case 1109: {
                    return "Bad parameters";
                }
            }
            return "Unrecognized disconnect reason: " + reason;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface DisconnectReason {
        }
    }

    @SystemApi
    public static interface OnMetadataChangedListener {
        public void onMetadataChanged(BluetoothDevice var1, int var2, byte[] var3);
    }

    public static abstract class ServiceLifecycleCallback {
        IBluetoothManagerCallback mRemote = new IBluetoothManagerCallback.Stub(){

            @Override
            public void onBluetoothServiceUp(IBluetooth bluetoothService) {
                this.onBluetoothServiceUp();
            }

            @Override
            public void onBluetoothServiceDown() {
                this.onBluetoothServiceDown();
            }

            @Override
            public void onBrEdrDown() {
            }
        };

        public abstract void onBluetoothServiceUp();

        public abstract void onBluetoothServiceDown();
    }

    public static interface LeScanCallback {
        public void onLeScan(BluetoothDevice var1, int var2, byte[] var3);
    }

    public class StateChangeCallbackWrapper
    extends IBluetoothStateChangeCallback.Stub {
        private BluetoothStateChangeCallback mCallback;

        StateChangeCallbackWrapper(BluetoothStateChangeCallback callback2) {
            this.mCallback = callback2;
        }

        @Override
        public void onBluetoothStateChange(boolean on) {
            this.mCallback.onBluetoothStateChange(on);
        }
    }

    public static interface BluetoothStateChangeCallback {
        public void onBluetoothStateChange(boolean var1);
    }

    public class WrappedOobDataCallback
    extends IBluetoothOobDataCallback.Stub {
        private final OobDataCallback mCallback;
        private final Executor mExecutor;

        WrappedOobDataCallback(OobDataCallback callback2, Executor executor) {
            Objects.requireNonNull(callback2);
            Objects.requireNonNull(executor);
            this.mCallback = callback2;
            this.mExecutor = executor;
        }

        @Override
        public void onOobData(final int transport, final OobData oobData) {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    WrappedOobDataCallback.this.mCallback.onOobData(transport, oobData);
                }
            });
        }

        @Override
        public void onError(final int errorCode) {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    WrappedOobDataCallback.this.mCallback.onError(errorCode);
                }
            });
        }
    }

    @SystemApi
    public static interface OobDataCallback {
        public void onOobData(int var1, OobData var2);

        public void onError(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface OobError {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ActiveDeviceUse {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IoCapability {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ScanMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AdapterState {
    }
}

