/*
 * Decompiled with CFR 0.152.
 */
package android.appwidget;

import android.app.Activity;
import android.app.ActivityOptions;
import android.appwidget.AppWidgetManager;
import android.appwidget.AppWidgetProviderInfo;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.pm.LauncherActivityInfo;
import android.content.pm.LauncherApps;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Pair;
import android.util.SizeF;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import android.widget.RemoteViews;
import android.widget.RemoteViewsAdapter;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;

public class AppWidgetHostView
extends FrameLayout {
    static final String TAG = "AppWidgetHostView";
    private static final String KEY_JAILED_ARRAY = "jail";
    private static final String KEY_INFLATION_ID = "inflation_id";
    static final boolean LOGD = false;
    static final int VIEW_MODE_NOINIT = 0;
    static final int VIEW_MODE_CONTENT = 1;
    static final int VIEW_MODE_ERROR = 2;
    static final int VIEW_MODE_DEFAULT = 3;
    private static final int FIRST_RESOURCE_COLOR_ID = 17170461;
    private static final int LAST_RESOURCE_COLOR_ID = 17170525;
    private static final LayoutInflater.Filter INFLATER_FILTER = clazz -> clazz.isAnnotationPresent(RemoteViews.RemoteView.class);
    Context mContext;
    Context mRemoteContext;
    @UnsupportedAppUsage
    int mAppWidgetId;
    @UnsupportedAppUsage
    AppWidgetProviderInfo mInfo;
    View mView;
    int mViewMode = 0;
    int mLayoutId = -1;
    private RemoteViews.InteractionHandler mInteractionHandler;
    private boolean mOnLightBackground;
    private SizeF mCurrentSize = null;
    private RemoteViews.ColorResources mColorResources = null;
    private SparseIntArray mColorMapping = null;
    private RemoteViews mLastInflatedRemoteViews = null;
    private long mLastInflatedRemoteViewsId = -1L;
    private Executor mAsyncExecutor;
    private CancellationSignal mLastExecutionSignal;
    private SparseArray<Parcelable> mDelayedRestoredState;
    private long mDelayedRestoredInflationId;

    public AppWidgetHostView(Context context) {
        this(context, 0x10A0000, 0x10A0001);
    }

    public AppWidgetHostView(Context context, RemoteViews.InteractionHandler handler) {
        this(context, 0x10A0000, 0x10A0001);
        this.mInteractionHandler = this.getHandler(handler);
    }

    public AppWidgetHostView(Context context, int animationIn, int animationOut) {
        super(context);
        this.mContext = context;
        this.setIsRootNamespace(true);
    }

    public void setInteractionHandler(RemoteViews.InteractionHandler handler) {
        this.mInteractionHandler = this.getHandler(handler);
    }

    public void setAppWidget(int appWidgetId, AppWidgetProviderInfo info) {
        this.mAppWidgetId = appWidgetId;
        this.mInfo = info;
        Rect padding = this.getDefaultPadding();
        this.setPadding(padding.left, padding.top, padding.right, padding.bottom);
        if (info != null) {
            String description = info.loadLabel(this.getContext().getPackageManager());
            if ((info.providerInfo.applicationInfo.flags & 0x40000000) != 0) {
                description = Resources.getSystem().getString(17041492, description);
            }
            this.setContentDescription(description);
        }
    }

    public static Rect getDefaultPaddingForWidget(Context context, ComponentName component, Rect padding) {
        return AppWidgetHostView.getDefaultPaddingForWidget(context, padding);
    }

    private static Rect getDefaultPaddingForWidget(Context context, Rect padding) {
        if (padding == null) {
            padding = new Rect(0, 0, 0, 0);
        } else {
            padding.set(0, 0, 0, 0);
        }
        Resources r = context.getResources();
        padding.left = r.getDimensionPixelSize(17105166);
        padding.right = r.getDimensionPixelSize(17105167);
        padding.top = r.getDimensionPixelSize(0x1050110);
        padding.bottom = r.getDimensionPixelSize(17105165);
        return padding;
    }

    private Rect getDefaultPadding() {
        return AppWidgetHostView.getDefaultPaddingForWidget(this.mContext, null);
    }

    public int getAppWidgetId() {
        return this.mAppWidgetId;
    }

    public AppWidgetProviderInfo getAppWidgetInfo() {
        return this.mInfo;
    }

    @Override
    protected void dispatchSaveInstanceState(SparseArray<Parcelable> container) {
        SparseArray<Parcelable> jail = new SparseArray<Parcelable>();
        super.dispatchSaveInstanceState(jail);
        Bundle bundle = new Bundle();
        bundle.putSparseParcelableArray(KEY_JAILED_ARRAY, jail);
        bundle.putLong(KEY_INFLATION_ID, this.mLastInflatedRemoteViewsId);
        container.put(this.generateId(), bundle);
        container.put(this.generateId(), bundle);
    }

    private int generateId() {
        int id2 = this.getId();
        return id2 == -1 ? this.mAppWidgetId : id2;
    }

    @Override
    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> container) {
        Parcelable parcelable = container.get(this.generateId());
        SparseArray<Object> jail = null;
        long inflationId = -1L;
        if (parcelable instanceof Bundle) {
            Bundle bundle = (Bundle)parcelable;
            jail = bundle.getSparseParcelableArray(KEY_JAILED_ARRAY);
            inflationId = bundle.getLong(KEY_INFLATION_ID, -1L);
        }
        if (jail == null) {
            jail = new SparseArray();
        }
        this.mDelayedRestoredState = jail;
        this.mDelayedRestoredInflationId = inflationId;
        this.restoreInstanceState();
    }

    void restoreInstanceState() {
        long inflationId = this.mDelayedRestoredInflationId;
        SparseArray<Parcelable> state = this.mDelayedRestoredState;
        if (inflationId == -1L || inflationId != this.mLastInflatedRemoteViewsId) {
            return;
        }
        this.mDelayedRestoredInflationId = -1L;
        this.mDelayedRestoredState = null;
        try {
            super.dispatchRestoreInstanceState(state);
        }
        catch (Exception e) {
            Log.e(TAG, "failed to restoreInstanceState for widget id: " + this.mAppWidgetId + ", " + (this.mInfo == null ? "null" : this.mInfo.provider), e);
        }
    }

    private SizeF computeSizeFromLayout(int left, int top, int right2, int bottom2) {
        float density = this.getResources().getDisplayMetrics().density;
        return new SizeF((float)(right2 - left - this.getPaddingLeft() - this.getPaddingRight()) / density, (float)(bottom2 - top - this.getPaddingTop() - this.getPaddingBottom()) / density);
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right2, int bottom2) {
        try {
            RemoteViews toApply;
            SizeF newSize;
            SizeF oldSize = this.mCurrentSize;
            this.mCurrentSize = newSize = this.computeSizeFromLayout(left, top, right2, bottom2);
            if (this.mLastInflatedRemoteViews != null && (toApply = this.mLastInflatedRemoteViews.getRemoteViewsToApplyIfDifferent(oldSize, newSize)) != null) {
                this.applyRemoteViews(toApply, false);
                this.measureChildWithMargins(this.mView, View.MeasureSpec.makeMeasureSpec(this.getMeasuredWidth(), 0x40000000), 0, View.MeasureSpec.makeMeasureSpec(this.getMeasuredHeight(), 0x40000000), 0);
            }
            super.onLayout(changed, left, top, right2, bottom2);
        }
        catch (RuntimeException e) {
            Log.e(TAG, "Remote provider threw runtime exception, using error view instead.", e);
            this.removeViewInLayout(this.mView);
            View child = this.getErrorView();
            this.prepareView(child);
            this.addViewInLayout(child, 0, child.getLayoutParams());
            this.measureChild(child, View.MeasureSpec.makeMeasureSpec(this.getMeasuredWidth(), 0x40000000), View.MeasureSpec.makeMeasureSpec(this.getMeasuredHeight(), 0x40000000));
            child.layout(0, 0, child.getMeasuredWidth() + this.mPaddingLeft + this.mPaddingRight, child.getMeasuredHeight() + this.mPaddingTop + this.mPaddingBottom);
            this.mView = child;
            this.mViewMode = 2;
        }
    }

    @Deprecated
    public void updateAppWidgetSize(Bundle newOptions, int minWidth, int minHeight, int maxWidth, int maxHeight) {
        this.updateAppWidgetSize(newOptions, minWidth, minHeight, maxWidth, maxHeight, false);
    }

    public void updateAppWidgetSize(Bundle newOptions, List<SizeF> sizes) {
        AppWidgetManager widgetManager = AppWidgetManager.getInstance(this.mContext);
        Rect padding = this.getDefaultPadding();
        float density = this.getResources().getDisplayMetrics().density;
        float xPaddingDips = (float)(padding.left + padding.right) / density;
        float yPaddingDips = (float)(padding.top + padding.bottom) / density;
        ArrayList<SizeF> paddedSizes = new ArrayList<SizeF>(sizes.size());
        float minWidth = Float.MAX_VALUE;
        float maxWidth = 0.0f;
        float minHeight = Float.MAX_VALUE;
        float maxHeight = 0.0f;
        for (int i = 0; i < sizes.size(); ++i) {
            SizeF size = sizes.get(i);
            SizeF paddedSize = new SizeF(Math.max(0.0f, size.getWidth() - xPaddingDips), Math.max(0.0f, size.getHeight() - yPaddingDips));
            paddedSizes.add(paddedSize);
            minWidth = Math.min(minWidth, paddedSize.getWidth());
            maxWidth = Math.max(maxWidth, paddedSize.getWidth());
            minHeight = Math.min(minHeight, paddedSize.getHeight());
            maxHeight = Math.max(maxHeight, paddedSize.getHeight());
        }
        if (paddedSizes.equals(widgetManager.getAppWidgetOptions(this.mAppWidgetId).getParcelableArrayList("appWidgetSizes"))) {
            return;
        }
        Bundle options = newOptions.deepCopy();
        options.putInt("appWidgetMinWidth", (int)minWidth);
        options.putInt("appWidgetMinHeight", (int)minHeight);
        options.putInt("appWidgetMaxWidth", (int)maxWidth);
        options.putInt("appWidgetMaxHeight", (int)maxHeight);
        options.putParcelableArrayList("appWidgetSizes", paddedSizes);
        this.updateAppWidgetOptions(options);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void updateAppWidgetSize(Bundle newOptions, int minWidth, int minHeight, int maxWidth, int maxHeight, boolean ignorePadding) {
        if (newOptions == null) {
            newOptions = new Bundle();
        }
        Rect padding = this.getDefaultPadding();
        float density = this.getResources().getDisplayMetrics().density;
        int xPaddingDips = (int)((float)(padding.left + padding.right) / density);
        int yPaddingDips = (int)((float)(padding.top + padding.bottom) / density);
        int newMinWidth = minWidth - (ignorePadding ? 0 : xPaddingDips);
        int newMinHeight = minHeight - (ignorePadding ? 0 : yPaddingDips);
        int newMaxWidth = maxWidth - (ignorePadding ? 0 : xPaddingDips);
        int newMaxHeight = maxHeight - (ignorePadding ? 0 : yPaddingDips);
        AppWidgetManager widgetManager = AppWidgetManager.getInstance(this.mContext);
        Bundle oldOptions = widgetManager.getAppWidgetOptions(this.mAppWidgetId);
        boolean needsUpdate = false;
        if (newMinWidth != oldOptions.getInt("appWidgetMinWidth") || newMinHeight != oldOptions.getInt("appWidgetMinHeight") || newMaxWidth != oldOptions.getInt("appWidgetMaxWidth") || newMaxHeight != oldOptions.getInt("appWidgetMaxHeight")) {
            needsUpdate = true;
        }
        if (needsUpdate) {
            newOptions.putInt("appWidgetMinWidth", newMinWidth);
            newOptions.putInt("appWidgetMinHeight", newMinHeight);
            newOptions.putInt("appWidgetMaxWidth", newMaxWidth);
            newOptions.putInt("appWidgetMaxHeight", newMaxHeight);
            newOptions.putParcelableArrayList("appWidgetSizes", new ArrayList());
            this.updateAppWidgetOptions(newOptions);
        }
    }

    public void updateAppWidgetOptions(Bundle options) {
        AppWidgetManager.getInstance(this.mContext).updateAppWidgetOptions(this.mAppWidgetId, options);
    }

    @Override
    public FrameLayout.LayoutParams generateLayoutParams(AttributeSet attrs) {
        Context context = this.mRemoteContext != null ? this.mRemoteContext : this.mContext;
        return new FrameLayout.LayoutParams(context, attrs);
    }

    public void setExecutor(Executor executor) {
        if (this.mLastExecutionSignal != null) {
            this.mLastExecutionSignal.cancel();
            this.mLastExecutionSignal = null;
        }
        this.mAsyncExecutor = executor;
    }

    public void setOnLightBackground(boolean onLightBackground) {
        this.mOnLightBackground = onLightBackground;
    }

    void resetAppWidget(AppWidgetProviderInfo info) {
        this.setAppWidget(this.mAppWidgetId, info);
        this.mViewMode = 0;
        this.updateAppWidget(null);
    }

    public void updateAppWidget(RemoteViews remoteViews) {
        this.mLastInflatedRemoteViews = remoteViews;
        this.applyRemoteViews(remoteViews, true);
    }

    private void reapplyLastRemoteViews() {
        SparseArray<Parcelable> savedState = new SparseArray<Parcelable>();
        this.saveHierarchyState(savedState);
        this.applyRemoteViews(this.mLastInflatedRemoteViews, true);
        this.restoreHierarchyState(savedState);
    }

    protected void applyRemoteViews(RemoteViews remoteViews, boolean useAsyncIfPossible) {
        boolean recycled = false;
        View content2 = null;
        RuntimeException exception = null;
        this.mLastInflatedRemoteViewsId = -1L;
        if (this.mLastExecutionSignal != null) {
            this.mLastExecutionSignal.cancel();
            this.mLastExecutionSignal = null;
        }
        if (remoteViews == null) {
            if (this.mViewMode == 3) {
                return;
            }
            content2 = this.getDefaultView();
            this.mLayoutId = -1;
            this.mViewMode = 3;
        } else {
            RemoteViews rvToApply = remoteViews.getRemoteViewsToApply(this.mContext, this.mCurrentSize);
            if (this.mOnLightBackground) {
                rvToApply = rvToApply.getDarkTextViews();
            }
            if (this.mAsyncExecutor != null && useAsyncIfPossible) {
                this.inflateAsync(rvToApply);
                return;
            }
            int layoutId = rvToApply.getLayoutId();
            if (rvToApply.canRecycleView(this.mView)) {
                try {
                    rvToApply.reapply(this.mContext, this.mView, this.mInteractionHandler, this.mCurrentSize, this.mColorResources);
                    content2 = this.mView;
                    this.mLastInflatedRemoteViewsId = rvToApply.computeUniqueId(remoteViews);
                    recycled = true;
                }
                catch (RuntimeException e) {
                    exception = e;
                }
            }
            if (content2 == null) {
                try {
                    content2 = rvToApply.apply(this.mContext, this, this.mInteractionHandler, this.mCurrentSize, this.mColorResources);
                    this.mLastInflatedRemoteViewsId = rvToApply.computeUniqueId(remoteViews);
                }
                catch (RuntimeException e) {
                    exception = e;
                }
            }
            this.mLayoutId = layoutId;
            this.mViewMode = 1;
        }
        this.applyContent(content2, recycled, exception);
    }

    private void applyContent(View content2, boolean recycled, Exception exception) {
        if (content2 == null) {
            if (this.mViewMode == 2) {
                return;
            }
            if (exception != null) {
                Log.w(TAG, "Error inflating RemoteViews", exception);
            }
            content2 = this.getErrorView();
            this.mViewMode = 2;
        }
        if (!recycled) {
            this.prepareView(content2);
            this.addView(content2);
        }
        if (this.mView != content2) {
            this.removeView(this.mView);
            this.mView = content2;
        }
    }

    private void inflateAsync(RemoteViews remoteViews) {
        this.mRemoteContext = this.getRemoteContext();
        int layoutId = remoteViews.getLayoutId();
        if (this.mLastExecutionSignal != null) {
            this.mLastExecutionSignal.cancel();
        }
        if (layoutId == this.mLayoutId && this.mView != null) {
            try {
                this.mLastExecutionSignal = remoteViews.reapplyAsync(this.mContext, this.mView, this.mAsyncExecutor, new ViewApplyListener(remoteViews, layoutId, true), this.mInteractionHandler, this.mCurrentSize, this.mColorResources);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.mLastExecutionSignal == null) {
            this.mLastExecutionSignal = remoteViews.applyAsync(this.mContext, this, this.mAsyncExecutor, new ViewApplyListener(remoteViews, layoutId, false), this.mInteractionHandler, this.mCurrentSize, this.mColorResources);
        }
    }

    void viewDataChanged(int viewId) {
        Object v = this.findViewById(viewId);
        if (v != null && v instanceof AdapterView) {
            AdapterView adapterView = (AdapterView)v;
            Object adapter = adapterView.getAdapter();
            if (adapter instanceof BaseAdapter) {
                BaseAdapter baseAdapter = (BaseAdapter)adapter;
                baseAdapter.notifyDataSetChanged();
            } else if (adapter == null && adapterView instanceof RemoteViewsAdapter.RemoteAdapterConnectionCallback) {
                ((RemoteViewsAdapter.RemoteAdapterConnectionCallback)((Object)adapterView)).deferNotifyDataSetChanged();
            }
        }
    }

    protected Context getRemoteContext() {
        try {
            Context newContext = this.mContext.createApplicationContext(this.mInfo.providerInfo.applicationInfo, 4);
            if (this.mColorResources != null) {
                this.mColorResources.apply(newContext);
            }
            return newContext;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e(TAG, "Package name " + this.mInfo.providerInfo.packageName + " not found");
            return this.mContext;
        }
    }

    protected void prepareView(View view) {
        FrameLayout.LayoutParams requested = (FrameLayout.LayoutParams)view.getLayoutParams();
        if (requested == null) {
            requested = new FrameLayout.LayoutParams(-1, -1);
        }
        requested.gravity = 17;
        view.setLayoutParams(requested);
    }

    protected View getDefaultView() {
        View defaultView = null;
        RuntimeException exception = null;
        try {
            if (this.mInfo != null) {
                int category;
                Context theirContext;
                this.mRemoteContext = theirContext = this.getRemoteContext();
                LayoutInflater inflater = (LayoutInflater)theirContext.getSystemService("layout_inflater");
                inflater = inflater.cloneInContext(theirContext);
                inflater.setFilter(INFLATER_FILTER);
                AppWidgetManager manager = AppWidgetManager.getInstance(this.mContext);
                Bundle options = manager.getAppWidgetOptions(this.mAppWidgetId);
                int layoutId = this.mInfo.initialLayout;
                if (options.containsKey("appWidgetCategory") && (category = options.getInt("appWidgetCategory")) == 2) {
                    int kgLayoutId = this.mInfo.initialKeyguardLayout;
                    int n = layoutId = kgLayoutId == 0 ? layoutId : kgLayoutId;
                }
                if (!((defaultView = inflater.inflate(layoutId, (ViewGroup)this, false)) instanceof AdapterView)) {
                    defaultView.setOnClickListener(this::onDefaultViewClicked);
                }
            } else {
                Log.w(TAG, "can't inflate defaultView because mInfo is missing");
            }
        }
        catch (RuntimeException e) {
            exception = e;
        }
        if (exception != null) {
            Log.w(TAG, "Error inflating AppWidget " + this.mInfo, exception);
        }
        if (defaultView == null) {
            defaultView = this.getErrorView();
        }
        return defaultView;
    }

    private void onDefaultViewClicked(View view) {
        LauncherApps launcherApps;
        List<LauncherActivityInfo> activities;
        if (this.mInfo != null && !(activities = (launcherApps = this.getContext().getSystemService(LauncherApps.class)).getActivityList(this.mInfo.provider.getPackageName(), this.mInfo.getProfile())).isEmpty()) {
            LauncherActivityInfo ai = activities.get(0);
            launcherApps.startMainActivity(ai.getComponentName(), ai.getUser(), RemoteViews.getSourceBounds(view), null);
        }
    }

    protected View getErrorView() {
        TextView tv = new TextView(this.mContext);
        tv.setText(17040315);
        tv.setBackgroundColor(Color.argb(127, 0, 0, 0));
        return tv;
    }

    @Override
    public void onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfoInternal(info);
        info.setClassName(AppWidgetHostView.class.getName());
    }

    public ActivityOptions createSharedElementActivityOptions(int[] sharedViewIds, String[] sharedViewNames, Intent fillInIntent) {
        Context parentContext = this.getContext();
        while (parentContext instanceof ContextWrapper && !(parentContext instanceof Activity)) {
            parentContext = ((ContextWrapper)parentContext).getBaseContext();
        }
        if (!(parentContext instanceof Activity)) {
            return null;
        }
        ArrayList sharedElements = new ArrayList();
        Bundle extras = new Bundle();
        for (int i = 0; i < sharedViewIds.length; ++i) {
            Object view = this.findViewById(sharedViewIds[i]);
            if (view == null) continue;
            sharedElements.add(Pair.create(view, sharedViewNames[i]));
            extras.putParcelable(sharedViewNames[i], RemoteViews.getSourceBounds(view));
        }
        if (!sharedElements.isEmpty()) {
            fillInIntent.putExtra("android.widget.extra.SHARED_ELEMENT_BOUNDS", extras);
            ActivityOptions opts = ActivityOptions.makeSceneTransitionAnimation((Activity)parentContext, sharedElements.toArray(new Pair[sharedElements.size()]));
            opts.setPendingIntentLaunchFlags(0x10000000);
            return opts;
        }
        return null;
    }

    private RemoteViews.InteractionHandler getHandler(RemoteViews.InteractionHandler handler) {
        return (view, pendingIntent, response) -> {
            AppWidgetManager.getInstance(this.mContext).noteAppWidgetTapped(this.mAppWidgetId);
            if (handler != null) {
                return handler.onInteraction(view, pendingIntent, response);
            }
            return RemoteViews.startPendingIntent(view, pendingIntent, response.getLaunchOptions(view));
        };
    }

    public void setColorResources(SparseIntArray colorMapping) {
        if (this.mColorMapping != null && this.isSameColorMapping(this.mColorMapping, colorMapping)) {
            return;
        }
        this.mColorMapping = colorMapping.clone();
        this.mColorResources = RemoteViews.ColorResources.create(this.mContext, this.mColorMapping);
        this.mLayoutId = -1;
        this.mViewMode = 0;
        this.reapplyLastRemoteViews();
    }

    private boolean isSameColorMapping(SparseIntArray oldColors, SparseIntArray newColors) {
        if (oldColors.size() != newColors.size()) {
            return false;
        }
        for (int i = 0; i < oldColors.size(); ++i) {
            if (oldColors.keyAt(i) == newColors.keyAt(i) && oldColors.valueAt(i) == newColors.valueAt(i)) continue;
            return false;
        }
        return true;
    }

    public void resetColorResources() {
        if (this.mColorResources != null) {
            this.mColorResources = null;
            this.mColorMapping = null;
            this.mLayoutId = -1;
            this.mViewMode = 0;
            this.reapplyLastRemoteViews();
        }
    }

    private class ViewApplyListener
    implements RemoteViews.OnViewAppliedListener {
        private final RemoteViews mViews;
        private final boolean mIsReapply;
        private final int mLayoutId;

        ViewApplyListener(RemoteViews views, int layoutId, boolean isReapply) {
            this.mViews = views;
            this.mLayoutId = layoutId;
            this.mIsReapply = isReapply;
        }

        @Override
        public void onViewApplied(View v) {
            AppWidgetHostView.this.mLayoutId = this.mLayoutId;
            AppWidgetHostView.this.mViewMode = 1;
            AppWidgetHostView.this.applyContent(v, this.mIsReapply, null);
            AppWidgetHostView.this.mLastInflatedRemoteViewsId = this.mViews.computeUniqueId(AppWidgetHostView.this.mLastInflatedRemoteViews);
            AppWidgetHostView.this.restoreInstanceState();
            AppWidgetHostView.this.mLastExecutionSignal = null;
        }

        @Override
        public void onError(Exception e) {
            if (this.mIsReapply) {
                AppWidgetHostView.this.mLastExecutionSignal = this.mViews.applyAsync(AppWidgetHostView.this.mContext, AppWidgetHostView.this, AppWidgetHostView.this.mAsyncExecutor, new ViewApplyListener(this.mViews, this.mLayoutId, false), AppWidgetHostView.this.mInteractionHandler, AppWidgetHostView.this.mCurrentSize);
            } else {
                AppWidgetHostView.this.applyContent(null, false, e);
            }
            AppWidgetHostView.this.mLastExecutionSignal = null;
        }
    }
}

