/*
 * Decompiled with CFR 0.152.
 */
package android.app.usage;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.usage.NetworkStats;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.net.DataUsageRequest;
import android.net.INetworkStatsService;
import android.net.Network;
import android.net.NetworkStateSnapshot;
import android.net.NetworkTemplate;
import android.net.UnderlyingNetworkInfo;
import android.net.netstats.provider.INetworkStatsProviderCallback;
import android.net.netstats.provider.NetworkStatsProvider;
import android.os.Binder;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.text.TextUtils;
import android.util.DataUnit;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.net.module.util.NetworkIdentityUtils;
import java.util.List;
import java.util.Objects;

public class NetworkStatsManager {
    private static final String TAG = "NetworkStatsManager";
    private static final boolean DBG = false;
    public static final int CALLBACK_LIMIT_REACHED = 0;
    public static final int CALLBACK_RELEASED = 1;
    public static final long MIN_THRESHOLD_BYTES = DataUnit.MEBIBYTES.toBytes(2L);
    private final Context mContext;
    private final INetworkStatsService mService;
    public static final int FLAG_POLL_ON_OPEN = 1;
    public static final int FLAG_POLL_FORCE = 2;
    public static final int FLAG_AUGMENT_WITH_SUBSCRIPTION_PLAN = 4;
    private int mFlags;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public NetworkStatsManager(Context context) throws ServiceManager.ServiceNotFoundException {
        this(context, INetworkStatsService.Stub.asInterface(ServiceManager.getServiceOrThrow("netstats")));
    }

    @VisibleForTesting
    public NetworkStatsManager(Context context, INetworkStatsService service) {
        this.mContext = context;
        this.mService = service;
        this.setPollOnOpen(true);
    }

    public void setPollOnOpen(boolean pollOnOpen) {
        this.mFlags = pollOnOpen ? (this.mFlags |= 1) : (this.mFlags &= 0xFFFFFFFE);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void setPollForce(boolean pollForce) {
        this.mFlags = pollForce ? (this.mFlags |= 2) : (this.mFlags &= 0xFFFFFFFD);
    }

    public void setAugmentWithSubscriptionPlan(boolean augmentWithSubscriptionPlan) {
        this.mFlags = augmentWithSubscriptionPlan ? (this.mFlags |= 4) : (this.mFlags &= 0xFFFFFFFB);
    }

    public NetworkStats.Bucket querySummaryForDevice(NetworkTemplate template, long startTime, long endTime) throws SecurityException, RemoteException {
        NetworkStats.Bucket bucket = null;
        NetworkStats stats = new NetworkStats(this.mContext, template, this.mFlags, startTime, endTime, this.mService);
        bucket = stats.getDeviceSummaryForNetwork();
        stats.close();
        return bucket;
    }

    public NetworkStats.Bucket querySummaryForDevice(int networkType, String subscriberId, long startTime, long endTime) throws SecurityException, RemoteException {
        NetworkTemplate template;
        try {
            template = NetworkStatsManager.createTemplate(networkType, subscriberId);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return this.querySummaryForDevice(template, startTime, endTime);
    }

    public NetworkStats.Bucket querySummaryForUser(int networkType, String subscriberId, long startTime, long endTime) throws SecurityException, RemoteException {
        NetworkTemplate template;
        try {
            template = NetworkStatsManager.createTemplate(networkType, subscriberId);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        NetworkStats stats = new NetworkStats(this.mContext, template, this.mFlags, startTime, endTime, this.mService);
        stats.startSummaryEnumeration();
        stats.close();
        return stats.getSummaryAggregate();
    }

    public NetworkStats querySummary(int networkType, String subscriberId, long startTime, long endTime) throws SecurityException, RemoteException {
        NetworkTemplate template;
        try {
            template = NetworkStatsManager.createTemplate(networkType, subscriberId);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return this.querySummary(template, startTime, endTime);
    }

    public NetworkStats querySummary(NetworkTemplate template, long startTime, long endTime) throws SecurityException, RemoteException {
        NetworkStats result = new NetworkStats(this.mContext, template, this.mFlags, startTime, endTime, this.mService);
        result.startSummaryEnumeration();
        return result;
    }

    public NetworkStats queryDetailsForUid(int networkType, String subscriberId, long startTime, long endTime, int uid) throws SecurityException {
        return this.queryDetailsForUidTagState(networkType, subscriberId, startTime, endTime, uid, 0, -1);
    }

    public NetworkStats queryDetailsForUid(NetworkTemplate template, long startTime, long endTime, int uid) throws SecurityException {
        return this.queryDetailsForUidTagState(template, startTime, endTime, uid, 0, -1);
    }

    public NetworkStats queryDetailsForUidTag(int networkType, String subscriberId, long startTime, long endTime, int uid, int tag) throws SecurityException {
        return this.queryDetailsForUidTagState(networkType, subscriberId, startTime, endTime, uid, tag, -1);
    }

    public NetworkStats queryDetailsForUidTagState(int networkType, String subscriberId, long startTime, long endTime, int uid, int tag, int state) throws SecurityException {
        NetworkTemplate template = NetworkStatsManager.createTemplate(networkType, subscriberId);
        return this.queryDetailsForUidTagState(template, startTime, endTime, uid, tag, state);
    }

    public NetworkStats queryDetailsForUidTagState(NetworkTemplate template, long startTime, long endTime, int uid, int tag, int state) throws SecurityException {
        NetworkStats result;
        try {
            result = new NetworkStats(this.mContext, template, this.mFlags, startTime, endTime, this.mService);
            result.startHistoryEnumeration(uid, tag, state);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error while querying stats for uid=" + uid + " tag=" + tag + " state=" + state, e);
            return null;
        }
        return result;
    }

    public NetworkStats queryDetails(int networkType, String subscriberId, long startTime, long endTime) throws SecurityException, RemoteException {
        NetworkTemplate template;
        try {
            template = NetworkStatsManager.createTemplate(networkType, subscriberId);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        NetworkStats result = new NetworkStats(this.mContext, template, this.mFlags, startTime, endTime, this.mService);
        result.startUserUidEnumeration();
        return result;
    }

    public void registerUsageCallback(NetworkTemplate template, int networkType, long thresholdBytes, UsageCallback callback2, Handler handler) {
        Objects.requireNonNull(callback2, "UsageCallback cannot be null");
        Looper looper = handler == null ? Looper.myLooper() : handler.getLooper();
        DataUsageRequest request = new DataUsageRequest(0, template, thresholdBytes);
        try {
            CallbackHandler callbackHandler = new CallbackHandler(looper, networkType, template.getSubscriberId(), callback2);
            callback2.request = this.mService.registerUsageCallback(this.mContext.getOpPackageName(), request, new Messenger(callbackHandler), new Binder());
            if (callback2.request == null) {
                Log.e(TAG, "Request from callback is null; should not happen");
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void registerUsageCallback(int networkType, String subscriberId, long thresholdBytes, UsageCallback callback2) {
        this.registerUsageCallback(networkType, subscriberId, thresholdBytes, callback2, null);
    }

    public void registerUsageCallback(int networkType, String subscriberId, long thresholdBytes, UsageCallback callback2, Handler handler) {
        NetworkTemplate template = NetworkStatsManager.createTemplate(networkType, subscriberId);
        this.registerUsageCallback(template, networkType, thresholdBytes, callback2, handler);
    }

    public void unregisterUsageCallback(UsageCallback callback2) {
        if (callback2 == null || callback2.request == null || ((UsageCallback)callback2).request.requestId == 0) {
            throw new IllegalArgumentException("Invalid UsageCallback");
        }
        try {
            this.mService.unregisterUsageRequest(callback2.request);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_STATS_PROVIDER", "android.permission.MAINLINE_NETWORK_STACK"})
    public void registerNetworkStatsProvider(String tag, NetworkStatsProvider provider2) {
        try {
            if (provider2.getProviderCallbackBinder() != null) {
                throw new IllegalArgumentException("provider is already registered");
            }
            INetworkStatsProviderCallback cbBinder = this.mService.registerNetworkStatsProvider(tag, provider2.getProviderBinder());
            provider2.setProviderCallbackBinder(cbBinder);
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_STATS_PROVIDER", "android.permission.MAINLINE_NETWORK_STACK"})
    public void unregisterNetworkStatsProvider(NetworkStatsProvider provider2) {
        try {
            provider2.getProviderCallbackBinderOrThrow().unregister();
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
        }
    }

    private static NetworkTemplate createTemplate(int networkType, String subscriberId) {
        NetworkTemplate template;
        switch (networkType) {
            case 0: {
                template = subscriberId == null ? NetworkTemplate.buildTemplateMobileWildcard() : NetworkTemplate.buildTemplateMobileAll(subscriberId);
                break;
            }
            case 1: {
                template = TextUtils.isEmpty(subscriberId) ? NetworkTemplate.buildTemplateWifiWildcard() : NetworkTemplate.buildTemplateWifi(NetworkTemplate.WIFI_NETWORKID_ALL, subscriberId);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot create template for network type " + networkType + ", subscriberId '" + NetworkIdentityUtils.scrubSubscriberId(subscriberId) + "'.");
            }
        }
        return template;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresPermission(anyOf={"android.permission.MAINLINE_NETWORK_STACK", "android.permission.NETWORK_STACK"})
    public void notifyNetworkStatus(List<Network> defaultNetworks, List<NetworkStateSnapshot> networkStateSnapshots, String activeIface, List<UnderlyingNetworkInfo> underlyingNetworkInfos) {
        try {
            Objects.requireNonNull(defaultNetworks);
            Objects.requireNonNull(networkStateSnapshots);
            Objects.requireNonNull(underlyingNetworkInfos);
            this.mService.notifyNetworkStatus(defaultNetworks.toArray(new Network[0]), networkStateSnapshots.toArray(new NetworkStateSnapshot[0]), activeIface, underlyingNetworkInfos.toArray(new UnderlyingNetworkInfo[0]));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static class CallbackHandler
    extends Handler {
        private final int mNetworkType;
        private final String mSubscriberId;
        private UsageCallback mCallback;

        CallbackHandler(Looper looper, int networkType, String subscriberId, UsageCallback callback2) {
            super(looper);
            this.mNetworkType = networkType;
            this.mSubscriberId = subscriberId;
            this.mCallback = callback2;
        }

        @Override
        public void handleMessage(Message message) {
            DataUsageRequest request = (DataUsageRequest)CallbackHandler.getObject(message, "DataUsageRequest");
            switch (message.what) {
                case 0: {
                    if (this.mCallback != null) {
                        this.mCallback.onThresholdReached(this.mNetworkType, this.mSubscriberId);
                        break;
                    }
                    Log.e(NetworkStatsManager.TAG, "limit reached with released callback for " + request);
                    break;
                }
                case 1: {
                    this.mCallback = null;
                }
            }
        }

        private static Object getObject(Message msg, String key) {
            return msg.getData().getParcelable(key);
        }
    }

    public static abstract class UsageCallback {
        private DataUsageRequest request;

        public abstract void onThresholdReached(int var1, String var2);
    }
}

