/*
 * Decompiled with CFR 0.152.
 */
package android.app.timezonedetector;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.ShellCommand;
import android.text.TextUtils;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class TelephonyTimeZoneSuggestion
implements Parcelable {
    public static final Parcelable.Creator<TelephonyTimeZoneSuggestion> CREATOR = new Parcelable.Creator<TelephonyTimeZoneSuggestion>(){

        @Override
        public TelephonyTimeZoneSuggestion createFromParcel(Parcel in) {
            return TelephonyTimeZoneSuggestion.createFromParcel(in);
        }

        public TelephonyTimeZoneSuggestion[] newArray(int size) {
            return new TelephonyTimeZoneSuggestion[size];
        }
    };
    public static final int MATCH_TYPE_NA = 0;
    public static final int MATCH_TYPE_NETWORK_COUNTRY_ONLY = 2;
    public static final int MATCH_TYPE_NETWORK_COUNTRY_AND_OFFSET = 3;
    public static final int MATCH_TYPE_EMULATOR_ZONE_ID = 4;
    public static final int MATCH_TYPE_TEST_NETWORK_OFFSET_ONLY = 5;
    public static final int QUALITY_NA = 0;
    public static final int QUALITY_SINGLE_ZONE = 1;
    public static final int QUALITY_MULTIPLE_ZONES_WITH_SAME_OFFSET = 2;
    public static final int QUALITY_MULTIPLE_ZONES_WITH_DIFFERENT_OFFSETS = 3;
    private final int mSlotIndex;
    private final String mZoneId;
    private final int mMatchType;
    private final int mQuality;
    private List<String> mDebugInfo;

    public static TelephonyTimeZoneSuggestion createEmptySuggestion(int slotIndex, String debugInfo) {
        return new Builder(slotIndex).addDebugInfo(debugInfo).build();
    }

    private TelephonyTimeZoneSuggestion(Builder builder2) {
        this.mSlotIndex = builder2.mSlotIndex;
        this.mZoneId = builder2.mZoneId;
        this.mMatchType = builder2.mMatchType;
        this.mQuality = builder2.mQuality;
        this.mDebugInfo = builder2.mDebugInfo != null ? new ArrayList(builder2.mDebugInfo) : null;
    }

    private static TelephonyTimeZoneSuggestion createFromParcel(Parcel in) {
        int slotIndex = in.readInt();
        TelephonyTimeZoneSuggestion suggestion = new Builder(slotIndex).setZoneId(in.readString()).setMatchType(in.readInt()).setQuality(in.readInt()).build();
        ArrayList debugInfo = in.readArrayList(TelephonyTimeZoneSuggestion.class.getClassLoader());
        if (debugInfo != null) {
            suggestion.addDebugInfo(debugInfo);
        }
        return suggestion;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mSlotIndex);
        dest.writeString(this.mZoneId);
        dest.writeInt(this.mMatchType);
        dest.writeInt(this.mQuality);
        dest.writeList(this.mDebugInfo);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getSlotIndex() {
        return this.mSlotIndex;
    }

    public String getZoneId() {
        return this.mZoneId;
    }

    public int getMatchType() {
        return this.mMatchType;
    }

    public int getQuality() {
        return this.mQuality;
    }

    public List<String> getDebugInfo() {
        return this.mDebugInfo == null ? Collections.emptyList() : Collections.unmodifiableList(this.mDebugInfo);
    }

    public void addDebugInfo(String debugInfo) {
        if (this.mDebugInfo == null) {
            this.mDebugInfo = new ArrayList<String>();
        }
        this.mDebugInfo.add(debugInfo);
    }

    public void addDebugInfo(List<String> debugInfo) {
        if (this.mDebugInfo == null) {
            this.mDebugInfo = new ArrayList<String>(debugInfo.size());
        }
        this.mDebugInfo.addAll(debugInfo);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TelephonyTimeZoneSuggestion that = (TelephonyTimeZoneSuggestion)o;
        return this.mSlotIndex == that.mSlotIndex && this.mMatchType == that.mMatchType && this.mQuality == that.mQuality && Objects.equals(this.mZoneId, that.mZoneId);
    }

    public int hashCode() {
        return Objects.hash(this.mSlotIndex, this.mZoneId, this.mMatchType, this.mQuality);
    }

    public String toString() {
        return "TelephonyTimeZoneSuggestion{mSlotIndex=" + this.mSlotIndex + ", mZoneId='" + this.mZoneId + '\'' + ", mMatchType=" + this.mMatchType + ", mQuality=" + this.mQuality + ", mDebugInfo=" + this.mDebugInfo + '}';
    }

    public static TelephonyTimeZoneSuggestion parseCommandLineArg(ShellCommand cmd) throws IllegalArgumentException {
        String opt;
        Integer slotIndex = null;
        String zoneId = null;
        Integer quality = null;
        Integer matchType = null;
        block12: while ((opt = cmd.getNextArg()) != null) {
            switch (opt) {
                case "--slot_index": {
                    slotIndex = Integer.parseInt(cmd.getNextArgRequired());
                    continue block12;
                }
                case "--zone_id": {
                    zoneId = cmd.getNextArgRequired();
                    continue block12;
                }
                case "--quality": {
                    quality = TelephonyTimeZoneSuggestion.parseQualityCommandLineArg(cmd.getNextArgRequired());
                    continue block12;
                }
                case "--match_type": {
                    matchType = TelephonyTimeZoneSuggestion.parseMatchTypeCommandLineArg(cmd.getNextArgRequired());
                    continue block12;
                }
            }
            throw new IllegalArgumentException("Unknown option: " + opt);
        }
        if (slotIndex == null) {
            throw new IllegalArgumentException("No slotIndex specified.");
        }
        Builder builder2 = new Builder(slotIndex);
        if (!TextUtils.isEmpty(zoneId) && !"_".equals(zoneId)) {
            builder2.setZoneId(zoneId);
        }
        if (quality != null) {
            builder2.setQuality(quality);
        }
        if (matchType != null) {
            builder2.setMatchType(matchType);
        }
        builder2.addDebugInfo("Command line injection");
        return builder2.build();
    }

    private static int parseQualityCommandLineArg(String arg) {
        switch (arg) {
            case "single": {
                return 1;
            }
            case "multiple_same": {
                return 2;
            }
            case "multiple_different": {
                return 3;
            }
        }
        throw new IllegalArgumentException("Unrecognized quality: " + arg);
    }

    private static int parseMatchTypeCommandLineArg(String arg) {
        switch (arg) {
            case "emulator": {
                return 4;
            }
            case "country_with_offset": {
                return 3;
            }
            case "country": {
                return 2;
            }
            case "test_network": {
                return 5;
            }
        }
        throw new IllegalArgumentException("Unrecognized match_type: " + arg);
    }

    public static void printCommandLineOpts(PrintWriter pw) {
        pw.println("Telephony suggestion options:");
        pw.println("  --slot_index <number>");
        pw.println("  To withdraw a previous suggestion:");
        pw.println("    [--zone_id \"_\"]");
        pw.println("  To make a new suggestion:");
        pw.println("    --zone_id <Olson ID>");
        pw.println("    --quality <single|multiple_same|multiple_different>");
        pw.println("    --match_type <emulator|country_with_offset|country|test_network>");
        pw.println();
        pw.println("See " + TelephonyTimeZoneSuggestion.class.getName() + " for more information");
    }

    public static class Builder {
        private final int mSlotIndex;
        private String mZoneId;
        private int mMatchType;
        private int mQuality;
        private List<String> mDebugInfo;

        public Builder(int slotIndex) {
            this.mSlotIndex = slotIndex;
        }

        public Builder setZoneId(String zoneId) {
            this.mZoneId = zoneId;
            return this;
        }

        public Builder setMatchType(int matchType) {
            this.mMatchType = matchType;
            return this;
        }

        public Builder setQuality(int quality) {
            this.mQuality = quality;
            return this;
        }

        public Builder addDebugInfo(String debugInfo) {
            if (this.mDebugInfo == null) {
                this.mDebugInfo = new ArrayList<String>();
            }
            this.mDebugInfo.add(debugInfo);
            return this;
        }

        void validate() {
            int quality = this.mQuality;
            int matchType = this.mMatchType;
            if (this.mZoneId == null) {
                if (quality != 0 || matchType != 0) {
                    throw new RuntimeException("Invalid quality or match type for null zone ID. quality=" + quality + ", matchType=" + matchType);
                }
            } else {
                boolean matchTypeValid;
                boolean qualityValid = quality == 1 || quality == 2 || quality == 3;
                boolean bl = matchTypeValid = matchType == 2 || matchType == 3 || matchType == 4 || matchType == 5;
                if (!qualityValid || !matchTypeValid) {
                    throw new RuntimeException("Invalid quality or match type with zone ID. quality=" + quality + ", matchType=" + matchType);
                }
            }
        }

        public TelephonyTimeZoneSuggestion build() {
            this.validate();
            return new TelephonyTimeZoneSuggestion(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Quality {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MatchType {
    }
}

