/*
 * Decompiled with CFR 0.152.
 */
package android.app.time;

import android.annotation.SystemApi;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@SystemApi
public class TimeZoneConfiguration
implements Parcelable {
    public static final Parcelable.Creator<TimeZoneConfiguration> CREATOR = new Parcelable.Creator<TimeZoneConfiguration>(){

        @Override
        public TimeZoneConfiguration createFromParcel(Parcel in) {
            return TimeZoneConfiguration.createFromParcel(in);
        }

        public TimeZoneConfiguration[] newArray(int size) {
            return new TimeZoneConfiguration[size];
        }
    };
    private static final String SETTING_AUTO_DETECTION_ENABLED = "autoDetectionEnabled";
    private static final String SETTING_GEO_DETECTION_ENABLED = "geoDetectionEnabled";
    private final Bundle mBundle;

    private TimeZoneConfiguration(Builder builder2) {
        this.mBundle = Objects.requireNonNull(builder2.mBundle);
    }

    private static TimeZoneConfiguration createFromParcel(Parcel in) {
        return new Builder().setPropertyBundleInternal(in.readBundle()).build();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeBundle(this.mBundle);
    }

    public boolean isComplete() {
        return this.hasIsAutoDetectionEnabled() && this.hasIsGeoDetectionEnabled();
    }

    public boolean isAutoDetectionEnabled() {
        this.enforceSettingPresent(SETTING_AUTO_DETECTION_ENABLED);
        return this.mBundle.getBoolean(SETTING_AUTO_DETECTION_ENABLED);
    }

    public boolean hasIsAutoDetectionEnabled() {
        return this.mBundle.containsKey(SETTING_AUTO_DETECTION_ENABLED);
    }

    public boolean isGeoDetectionEnabled() {
        this.enforceSettingPresent(SETTING_GEO_DETECTION_ENABLED);
        return this.mBundle.getBoolean(SETTING_GEO_DETECTION_ENABLED);
    }

    public boolean hasIsGeoDetectionEnabled() {
        return this.mBundle.containsKey(SETTING_GEO_DETECTION_ENABLED);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeZoneConfiguration that = (TimeZoneConfiguration)o;
        return this.mBundle.kindofEquals(that.mBundle);
    }

    public int hashCode() {
        return Objects.hash(this.mBundle);
    }

    public String toString() {
        return "TimeZoneConfiguration{mBundle=" + this.mBundle + '}';
    }

    private void enforceSettingPresent(String setting) {
        if (!this.mBundle.containsKey(setting)) {
            throw new IllegalStateException(setting + " is not set");
        }
    }

    @SystemApi
    public static class Builder {
        private final Bundle mBundle = new Bundle();

        public Builder() {
        }

        public Builder(TimeZoneConfiguration toCopy) {
            this.mergeProperties(toCopy);
        }

        public Builder mergeProperties(TimeZoneConfiguration other) {
            this.mBundle.putAll(other.mBundle);
            return this;
        }

        Builder setPropertyBundleInternal(Bundle bundle) {
            this.mBundle.putAll(bundle);
            return this;
        }

        public Builder setAutoDetectionEnabled(boolean enabled) {
            this.mBundle.putBoolean(TimeZoneConfiguration.SETTING_AUTO_DETECTION_ENABLED, enabled);
            return this;
        }

        public Builder setGeoDetectionEnabled(boolean enabled) {
            this.mBundle.putBoolean(TimeZoneConfiguration.SETTING_GEO_DETECTION_ENABLED, enabled);
            return this;
        }

        public TimeZoneConfiguration build() {
            return new TimeZoneConfiguration(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface Setting {
    }
}

