/*
 * Decompiled with CFR 0.152.
 */
package android.app.time;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.time.ExternalTimeSuggestion;
import android.app.time.ITimeZoneDetectorListener;
import android.app.time.TimeCapabilitiesAndConfig;
import android.app.time.TimeConfiguration;
import android.app.time.TimeZoneCapabilitiesAndConfig;
import android.app.time.TimeZoneConfiguration;
import android.app.timedetector.ITimeDetectorService;
import android.app.timezonedetector.ITimeZoneDetectorService;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.ArrayMap;
import com.android.internal.annotations.GuardedBy;
import java.util.concurrent.Executor;

@SystemApi
public class TimeManager {
    private static final String TAG = "time.TimeManager";
    private static final boolean DEBUG = false;
    private final Object mLock = new Object();
    private final ITimeZoneDetectorService mITimeZoneDetectorService = ITimeZoneDetectorService.Stub.asInterface(ServiceManager.getServiceOrThrow("time_zone_detector"));
    private final ITimeDetectorService mITimeDetectorService = ITimeDetectorService.Stub.asInterface(ServiceManager.getServiceOrThrow("time_detector"));
    @GuardedBy(value={"mLock"})
    private ITimeZoneDetectorListener mTimeZoneDetectorReceiver;
    @GuardedBy(value={"mLock"})
    private ArrayMap<TimeZoneDetectorListener, TimeZoneDetectorListener> mTimeZoneDetectorListeners;

    @RequiresPermission(value="android.permission.MANAGE_TIME_AND_ZONE_DETECTION")
    public TimeZoneCapabilitiesAndConfig getTimeZoneCapabilitiesAndConfig() {
        try {
            return this.mITimeZoneDetectorService.getCapabilitiesAndConfig();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_TIME_AND_ZONE_DETECTION")
    public TimeCapabilitiesAndConfig getTimeCapabilitiesAndConfig() {
        try {
            return this.mITimeDetectorService.getCapabilitiesAndConfig();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_TIME_AND_ZONE_DETECTION")
    public boolean updateTimeConfiguration(TimeConfiguration configuration) {
        try {
            return this.mITimeDetectorService.updateConfiguration(configuration);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_TIME_AND_ZONE_DETECTION")
    public boolean updateTimeZoneConfiguration(TimeZoneConfiguration configuration) {
        try {
            return this.mITimeZoneDetectorService.updateConfiguration(configuration);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.MANAGE_TIME_AND_ZONE_DETECTION")
    public void addTimeZoneDetectorListener(Executor executor, TimeZoneDetectorListener listener2) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mTimeZoneDetectorListeners == null) {
                this.mTimeZoneDetectorListeners = new ArrayMap();
            } else if (this.mTimeZoneDetectorListeners.containsKey(listener2)) {
                return;
            }
            if (this.mTimeZoneDetectorReceiver == null) {
                ITimeZoneDetectorListener.Stub iListener = new ITimeZoneDetectorListener.Stub(){

                    @Override
                    public void onChange() {
                        TimeManager.this.notifyTimeZoneDetectorListeners();
                    }
                };
                this.mTimeZoneDetectorReceiver = iListener;
                try {
                    this.mITimeZoneDetectorService.addListener(this.mTimeZoneDetectorReceiver);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            this.mTimeZoneDetectorListeners.put(listener2, () -> executor.execute(listener2::onChange));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTimeZoneDetectorListeners() {
        ArrayMap<TimeZoneDetectorListener, TimeZoneDetectorListener> timeZoneDetectorListeners;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mTimeZoneDetectorListeners == null || this.mTimeZoneDetectorListeners.isEmpty()) {
                return;
            }
            timeZoneDetectorListeners = new ArrayMap<TimeZoneDetectorListener, TimeZoneDetectorListener>(this.mTimeZoneDetectorListeners);
        }
        int size = timeZoneDetectorListeners.size();
        for (int i = 0; i < size; ++i) {
            timeZoneDetectorListeners.valueAt(i).onChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.MANAGE_TIME_AND_ZONE_DETECTION")
    public void removeTimeZoneDetectorListener(TimeZoneDetectorListener listener2) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mTimeZoneDetectorListeners == null || this.mTimeZoneDetectorListeners.isEmpty()) {
                return;
            }
            this.mTimeZoneDetectorListeners.remove(listener2);
            if (this.mTimeZoneDetectorListeners.isEmpty()) {
                try {
                    this.mITimeZoneDetectorService.removeListener(this.mTimeZoneDetectorReceiver);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
                finally {
                    this.mTimeZoneDetectorReceiver = null;
                }
            }
        }
    }

    @RequiresPermission(value="android.permission.SUGGEST_EXTERNAL_TIME")
    public void suggestExternalTime(ExternalTimeSuggestion timeSuggestion) {
        try {
            this.mITimeDetectorService.suggestExternalTime(timeSuggestion);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FunctionalInterface
    public static interface TimeZoneDetectorListener {
        public void onChange();
    }
}

