/*
 * Decompiled with CFR 0.152.
 */
package android.app.time;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import java.util.Objects;

public class TimeCapabilities
implements Parcelable {
    public static final Parcelable.Creator<TimeCapabilities> CREATOR = new Parcelable.Creator<TimeCapabilities>(){

        @Override
        public TimeCapabilities createFromParcel(Parcel in) {
            return TimeCapabilities.createFromParcel(in);
        }

        public TimeCapabilities[] newArray(int size) {
            return new TimeCapabilities[size];
        }
    };
    private final UserHandle mUserHandle;
    private final int mConfigureAutoTimeDetectionEnabledCapability;
    private final int mSuggestTimeManuallyCapability;

    private TimeCapabilities(Builder builder2) {
        this.mUserHandle = Objects.requireNonNull(builder2.mUserHandle);
        this.mConfigureAutoTimeDetectionEnabledCapability = builder2.mConfigureAutoDetectionEnabledCapability;
        this.mSuggestTimeManuallyCapability = builder2.mSuggestTimeManuallyCapability;
    }

    private static TimeCapabilities createFromParcel(Parcel in) {
        UserHandle userHandle = UserHandle.readFromParcel(in);
        return new Builder(userHandle).setConfigureAutoTimeDetectionEnabledCapability(in.readInt()).setSuggestTimeManuallyCapability(in.readInt()).build();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        UserHandle.writeToParcel(this.mUserHandle, dest);
        dest.writeInt(this.mConfigureAutoTimeDetectionEnabledCapability);
        dest.writeInt(this.mSuggestTimeManuallyCapability);
    }

    public int getConfigureAutoTimeDetectionEnabledCapability() {
        return this.mConfigureAutoTimeDetectionEnabledCapability;
    }

    public int getSuggestTimeManuallyCapability() {
        return this.mSuggestTimeManuallyCapability;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeCapabilities that = (TimeCapabilities)o;
        return this.mConfigureAutoTimeDetectionEnabledCapability == that.mConfigureAutoTimeDetectionEnabledCapability && this.mSuggestTimeManuallyCapability == that.mSuggestTimeManuallyCapability && this.mUserHandle.equals(that.mUserHandle);
    }

    public int hashCode() {
        return Objects.hash(this.mUserHandle, this.mConfigureAutoTimeDetectionEnabledCapability, this.mSuggestTimeManuallyCapability);
    }

    public String toString() {
        return "TimeCapabilities{mUserHandle=" + this.mUserHandle + ", mConfigureAutoTimeDetectionEnabledCapability=" + this.mConfigureAutoTimeDetectionEnabledCapability + ", mSuggestTimeManuallyCapability=" + this.mSuggestTimeManuallyCapability + '}';
    }

    public static class Builder {
        private final UserHandle mUserHandle;
        private int mConfigureAutoDetectionEnabledCapability;
        private int mSuggestTimeManuallyCapability;

        public Builder(TimeCapabilities timeCapabilities) {
            Objects.requireNonNull(timeCapabilities);
            this.mUserHandle = timeCapabilities.mUserHandle;
            this.mConfigureAutoDetectionEnabledCapability = timeCapabilities.mConfigureAutoTimeDetectionEnabledCapability;
            this.mSuggestTimeManuallyCapability = timeCapabilities.mSuggestTimeManuallyCapability;
        }

        public Builder(UserHandle userHandle) {
            this.mUserHandle = Objects.requireNonNull(userHandle);
        }

        public Builder setConfigureAutoTimeDetectionEnabledCapability(int setConfigureAutoTimeDetectionEnabledCapability) {
            this.mConfigureAutoDetectionEnabledCapability = setConfigureAutoTimeDetectionEnabledCapability;
            return this;
        }

        public Builder setSuggestTimeManuallyCapability(int suggestTimeManuallyCapability) {
            this.mSuggestTimeManuallyCapability = suggestTimeManuallyCapability;
            return this;
        }

        public TimeCapabilities build() {
            this.verifyCapabilitySet(this.mConfigureAutoDetectionEnabledCapability, "configureAutoDetectionEnabledCapability");
            this.verifyCapabilitySet(this.mSuggestTimeManuallyCapability, "suggestTimeManuallyCapability");
            return new TimeCapabilities(this);
        }

        private void verifyCapabilitySet(int value2, String name) {
            if (value2 == 0) {
                throw new IllegalStateException(name + " was not set");
            }
        }
    }
}

