/*
 * Decompiled with CFR 0.152.
 */
package android.app.smartspace;

import android.annotation.SystemApi;
import android.app.smartspace.ISmartspaceCallback;
import android.app.smartspace.ISmartspaceManager;
import android.app.smartspace.SmartspaceConfig;
import android.app.smartspace.SmartspaceSessionId;
import android.app.smartspace.SmartspaceTarget;
import android.app.smartspace.SmartspaceTargetEvent;
import android.content.Context;
import android.content.pm.ParceledListSlice;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.ArrayMap;
import android.util.Log;
import dalvik.system.CloseGuard;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

@SystemApi
public class SmartspaceSession
implements AutoCloseable {
    private static final String TAG = SmartspaceSession.class.getSimpleName();
    private static final boolean DEBUG = false;
    private final ISmartspaceManager mInterface;
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private final AtomicBoolean mIsClosed = new AtomicBoolean(false);
    private final SmartspaceSessionId mSessionId;
    private final ArrayMap<OnTargetsAvailableListener, CallbackWrapper> mRegisteredCallbacks = new ArrayMap();
    private final IBinder mToken = new Binder();

    SmartspaceSession(Context context, SmartspaceConfig smartspaceConfig) {
        IBinder b = ServiceManager.getService("smartspace");
        this.mInterface = ISmartspaceManager.Stub.asInterface(b);
        this.mSessionId = new SmartspaceSessionId(context.getPackageName() + ":" + UUID.randomUUID().toString(), context.getUser());
        try {
            this.mInterface.createSmartspaceSession(smartspaceConfig, this.mSessionId, this.mToken);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to create Smartspace session", e);
            e.rethrowFromSystemServer();
        }
        this.mCloseGuard.open("close");
    }

    public void notifySmartspaceEvent(SmartspaceTargetEvent event) {
        if (this.mIsClosed.get()) {
            throw new IllegalStateException("This client has already been destroyed.");
        }
        try {
            this.mInterface.notifySmartspaceEvent(this.mSessionId, event);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to notify event", e);
            e.rethrowFromSystemServer();
        }
    }

    public void requestSmartspaceUpdate() {
        if (this.mIsClosed.get()) {
            throw new IllegalStateException("This client has already been destroyed.");
        }
        try {
            this.mInterface.requestSmartspaceUpdate(this.mSessionId);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to request update.", e);
            e.rethrowFromSystemServer();
        }
    }

    public void addOnTargetsAvailableListener(Executor listenerExecutor, OnTargetsAvailableListener listener2) {
        if (this.mIsClosed.get()) {
            throw new IllegalStateException("This client has already been destroyed.");
        }
        if (this.mRegisteredCallbacks.containsKey(listener2)) {
            return;
        }
        try {
            CallbackWrapper callbackWrapper = new CallbackWrapper(listenerExecutor, listener2::onTargetsAvailable);
            this.mRegisteredCallbacks.put(listener2, callbackWrapper);
            this.mInterface.registerSmartspaceUpdates(this.mSessionId, callbackWrapper);
            this.mInterface.requestSmartspaceUpdate(this.mSessionId);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to register for smartspace updates", e);
            e.rethrowAsRuntimeException();
        }
    }

    public void removeOnTargetsAvailableListener(OnTargetsAvailableListener listener2) {
        if (this.mIsClosed.get()) {
            throw new IllegalStateException("This client has already been destroyed.");
        }
        if (!this.mRegisteredCallbacks.containsKey(listener2)) {
            return;
        }
        try {
            CallbackWrapper callbackWrapper = this.mRegisteredCallbacks.remove(listener2);
            this.mInterface.unregisterSmartspaceUpdates(this.mSessionId, callbackWrapper);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to unregister for smartspace updates", e);
            e.rethrowAsRuntimeException();
        }
    }

    private void destroy() {
        if (!this.mIsClosed.getAndSet(true)) {
            this.mCloseGuard.close();
            try {
                this.mInterface.destroySmartspaceSession(this.mSessionId);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to notify Smartspace target event", e);
                e.rethrowFromSystemServer();
            }
        } else {
            throw new IllegalStateException("This client has already been destroyed.");
        }
    }

    protected void finalize() {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            if (!this.mIsClosed.get()) {
                this.destroy();
            }
        }
        finally {
            try {
                super.finalize();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    @Override
    public void close() {
        try {
            this.destroy();
            this.finalize();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    static class CallbackWrapper
    extends ISmartspaceCallback.Stub {
        private final Consumer<List<SmartspaceTarget>> mCallback;
        private final Executor mExecutor;

        CallbackWrapper(Executor callbackExecutor, Consumer<List<SmartspaceTarget>> callback2) {
            this.mCallback = callback2;
            this.mExecutor = callbackExecutor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onResult(ParceledListSlice result) {
            long identity = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.accept(result.getList()));
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    public static interface OnTargetsAvailableListener {
        public void onTargetsAvailable(List<SmartspaceTarget> var1);
    }
}

