/*
 * Decompiled with CFR 0.152.
 */
package android.app.smartspace;

import android.app.smartspace.ISmartspaceCallback;
import android.app.smartspace.SmartspaceConfig;
import android.app.smartspace.SmartspaceSessionId;
import android.app.smartspace.SmartspaceTargetEvent;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ISmartspaceManager
extends IInterface {
    public static final String DESCRIPTOR = "android.app.smartspace.ISmartspaceManager";

    public void createSmartspaceSession(SmartspaceConfig var1, SmartspaceSessionId var2, IBinder var3) throws RemoteException;

    public void notifySmartspaceEvent(SmartspaceSessionId var1, SmartspaceTargetEvent var2) throws RemoteException;

    public void requestSmartspaceUpdate(SmartspaceSessionId var1) throws RemoteException;

    public void registerSmartspaceUpdates(SmartspaceSessionId var1, ISmartspaceCallback var2) throws RemoteException;

    public void unregisterSmartspaceUpdates(SmartspaceSessionId var1, ISmartspaceCallback var2) throws RemoteException;

    public void destroySmartspaceSession(SmartspaceSessionId var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISmartspaceManager {
        static final int TRANSACTION_createSmartspaceSession = 1;
        static final int TRANSACTION_notifySmartspaceEvent = 2;
        static final int TRANSACTION_requestSmartspaceUpdate = 3;
        static final int TRANSACTION_registerSmartspaceUpdates = 4;
        static final int TRANSACTION_unregisterSmartspaceUpdates = 5;
        static final int TRANSACTION_destroySmartspaceSession = 6;

        public Stub() {
            this.attachInterface(this, ISmartspaceManager.DESCRIPTOR);
        }

        public static ISmartspaceManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ISmartspaceManager.DESCRIPTOR);
            if (iin != null && iin instanceof ISmartspaceManager) {
                return (ISmartspaceManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "createSmartspaceSession";
                }
                case 2: {
                    return "notifySmartspaceEvent";
                }
                case 3: {
                    return "requestSmartspaceUpdate";
                }
                case 4: {
                    return "registerSmartspaceUpdates";
                }
                case 5: {
                    return "unregisterSmartspaceUpdates";
                }
                case 6: {
                    return "destroySmartspaceSession";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ISmartspaceManager.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    SmartspaceConfig _arg0 = 0 != data.readInt() ? SmartspaceConfig.CREATOR.createFromParcel(data) : null;
                    SmartspaceSessionId _arg1 = 0 != data.readInt() ? SmartspaceSessionId.CREATOR.createFromParcel(data) : null;
                    IBinder _arg2 = data.readStrongBinder();
                    this.createSmartspaceSession(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    SmartspaceSessionId _arg0 = 0 != data.readInt() ? SmartspaceSessionId.CREATOR.createFromParcel(data) : null;
                    SmartspaceTargetEvent _arg1 = 0 != data.readInt() ? SmartspaceTargetEvent.CREATOR.createFromParcel(data) : null;
                    this.notifySmartspaceEvent(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    SmartspaceSessionId _arg0 = 0 != data.readInt() ? SmartspaceSessionId.CREATOR.createFromParcel(data) : null;
                    this.requestSmartspaceUpdate(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    SmartspaceSessionId _arg0 = 0 != data.readInt() ? SmartspaceSessionId.CREATOR.createFromParcel(data) : null;
                    ISmartspaceCallback _arg1 = ISmartspaceCallback.Stub.asInterface(data.readStrongBinder());
                    this.registerSmartspaceUpdates(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    SmartspaceSessionId _arg0 = 0 != data.readInt() ? SmartspaceSessionId.CREATOR.createFromParcel(data) : null;
                    ISmartspaceCallback _arg1 = ISmartspaceCallback.Stub.asInterface(data.readStrongBinder());
                    this.unregisterSmartspaceUpdates(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    SmartspaceSessionId _arg0 = 0 != data.readInt() ? SmartspaceSessionId.CREATOR.createFromParcel(data) : null;
                    this.destroySmartspaceSession(_arg0);
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(ISmartspaceManager impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static ISmartspaceManager getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements ISmartspaceManager {
            private IBinder mRemote;
            public static ISmartspaceManager sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ISmartspaceManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createSmartspaceSession(SmartspaceConfig config, SmartspaceSessionId sessionId, IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISmartspaceManager.DESCRIPTOR);
                    if (config != null) {
                        _data.writeInt(1);
                        config.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (sessionId != null) {
                        _data.writeInt(1);
                        sessionId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().createSmartspaceSession(config, sessionId, token);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifySmartspaceEvent(SmartspaceSessionId sessionId, SmartspaceTargetEvent event) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISmartspaceManager.DESCRIPTOR);
                    if (sessionId != null) {
                        _data.writeInt(1);
                        sessionId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (event != null) {
                        _data.writeInt(1);
                        event.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifySmartspaceEvent(sessionId, event);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestSmartspaceUpdate(SmartspaceSessionId sessionId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISmartspaceManager.DESCRIPTOR);
                    if (sessionId != null) {
                        _data.writeInt(1);
                        sessionId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().requestSmartspaceUpdate(sessionId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerSmartspaceUpdates(SmartspaceSessionId sessionId, ISmartspaceCallback callback2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISmartspaceManager.DESCRIPTOR);
                    if (sessionId != null) {
                        _data.writeInt(1);
                        sessionId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(callback2 != null ? callback2.asBinder() : null);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerSmartspaceUpdates(sessionId, callback2);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterSmartspaceUpdates(SmartspaceSessionId sessionId, ISmartspaceCallback callback2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISmartspaceManager.DESCRIPTOR);
                    if (sessionId != null) {
                        _data.writeInt(1);
                        sessionId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(callback2 != null ? callback2.asBinder() : null);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterSmartspaceUpdates(sessionId, callback2);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void destroySmartspaceSession(SmartspaceSessionId sessionId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISmartspaceManager.DESCRIPTOR);
                    if (sessionId != null) {
                        _data.writeInt(1);
                        sessionId.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().destroySmartspaceSession(sessionId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ISmartspaceManager {
        @Override
        public void createSmartspaceSession(SmartspaceConfig config, SmartspaceSessionId sessionId, IBinder token) throws RemoteException {
        }

        @Override
        public void notifySmartspaceEvent(SmartspaceSessionId sessionId, SmartspaceTargetEvent event) throws RemoteException {
        }

        @Override
        public void requestSmartspaceUpdate(SmartspaceSessionId sessionId) throws RemoteException {
        }

        @Override
        public void registerSmartspaceUpdates(SmartspaceSessionId sessionId, ISmartspaceCallback callback2) throws RemoteException {
        }

        @Override
        public void unregisterSmartspaceUpdates(SmartspaceSessionId sessionId, ISmartspaceCallback callback2) throws RemoteException {
        }

        @Override
        public void destroySmartspaceSession(SmartspaceSessionId sessionId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

