/*
 * Decompiled with CFR 0.152.
 */
package android.app.prediction;

import android.annotation.SystemApi;
import android.app.prediction.AppTargetId;
import android.content.pm.ShortcutInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import java.util.Objects;

@SystemApi
public class AppTarget
implements Parcelable {
    private final AppTargetId mId;
    private final String mPackageName;
    private final String mClassName;
    private final UserHandle mUser;
    private final ShortcutInfo mShortcutInfo;
    private final int mRank;
    public static final Parcelable.Creator<AppTarget> CREATOR = new Parcelable.Creator<AppTarget>(){

        @Override
        public AppTarget createFromParcel(Parcel parcel) {
            return new AppTarget(parcel);
        }

        public AppTarget[] newArray(int size) {
            return new AppTarget[size];
        }
    };

    @Deprecated
    public AppTarget(AppTargetId id2, String packageName, String className2, UserHandle user) {
        this.mId = id2;
        this.mShortcutInfo = null;
        this.mPackageName = Objects.requireNonNull(packageName);
        this.mClassName = className2;
        this.mUser = Objects.requireNonNull(user);
        this.mRank = 0;
    }

    @Deprecated
    public AppTarget(AppTargetId id2, ShortcutInfo shortcutInfo, String className2) {
        this.mId = id2;
        this.mShortcutInfo = Objects.requireNonNull(shortcutInfo);
        this.mPackageName = this.mShortcutInfo.getPackage();
        this.mUser = this.mShortcutInfo.getUserHandle();
        this.mClassName = className2;
        this.mRank = 0;
    }

    private AppTarget(AppTargetId id2, String packageName, UserHandle user, ShortcutInfo shortcutInfo, String className2, int rank) {
        this.mId = id2;
        this.mShortcutInfo = shortcutInfo;
        this.mPackageName = packageName;
        this.mClassName = className2;
        this.mUser = user;
        this.mRank = rank;
    }

    private AppTarget(Parcel parcel) {
        this.mId = parcel.readTypedObject(AppTargetId.CREATOR);
        this.mShortcutInfo = parcel.readTypedObject(ShortcutInfo.CREATOR);
        if (this.mShortcutInfo == null) {
            this.mPackageName = parcel.readString();
            this.mUser = UserHandle.of(parcel.readInt());
        } else {
            this.mPackageName = this.mShortcutInfo.getPackage();
            this.mUser = this.mShortcutInfo.getUserHandle();
        }
        this.mClassName = parcel.readString();
        this.mRank = parcel.readInt();
    }

    public AppTargetId getId() {
        return this.mId;
    }

    public String getClassName() {
        return this.mClassName;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public UserHandle getUser() {
        return this.mUser;
    }

    public ShortcutInfo getShortcutInfo() {
        return this.mShortcutInfo;
    }

    public int getRank() {
        return this.mRank;
    }

    public boolean equals(Object o) {
        if (!this.getClass().equals(o != null ? o.getClass() : null)) {
            return false;
        }
        AppTarget other = (AppTarget)o;
        boolean sameClassName = this.mClassName == null && other.mClassName == null || this.mClassName != null && this.mClassName.equals(other.mClassName);
        boolean sameShortcutInfo = this.mShortcutInfo == null && other.mShortcutInfo == null || this.mShortcutInfo != null && other.mShortcutInfo != null && this.mShortcutInfo.getId() == other.mShortcutInfo.getId();
        return this.mId.equals(other.mId) && this.mPackageName.equals(other.mPackageName) && sameClassName && this.mUser.equals(other.mUser) && sameShortcutInfo && this.mRank == other.mRank;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeTypedObject(this.mId, flags);
        dest.writeTypedObject(this.mShortcutInfo, flags);
        if (this.mShortcutInfo == null) {
            dest.writeString(this.mPackageName);
            dest.writeInt(this.mUser.getIdentifier());
        }
        dest.writeString(this.mClassName);
        dest.writeInt(this.mRank);
    }

    @SystemApi
    public static class Builder {
        private final AppTargetId mId;
        private String mPackageName;
        private UserHandle mUser;
        private ShortcutInfo mShortcutInfo;
        private String mClassName;
        private int mRank;

        @Deprecated
        @SystemApi
        public Builder(AppTargetId id2) {
            this.mId = id2;
        }

        @SystemApi
        public Builder(AppTargetId id2, String packageName, UserHandle user) {
            this.mId = Objects.requireNonNull(id2);
            this.mPackageName = Objects.requireNonNull(packageName);
            this.mUser = Objects.requireNonNull(user);
        }

        @SystemApi
        public Builder(AppTargetId id2, ShortcutInfo info) {
            this.mId = Objects.requireNonNull(id2);
            this.mShortcutInfo = Objects.requireNonNull(info);
            this.mPackageName = info.getPackage();
            this.mUser = info.getUserHandle();
        }

        @Deprecated
        public Builder setTarget(String packageName, UserHandle user) {
            if (this.mPackageName != null) {
                throw new IllegalArgumentException("Target is already set");
            }
            this.mPackageName = Objects.requireNonNull(packageName);
            this.mUser = Objects.requireNonNull(user);
            return this;
        }

        @Deprecated
        public Builder setTarget(ShortcutInfo info) {
            this.setTarget(info.getPackage(), info.getUserHandle());
            this.mShortcutInfo = Objects.requireNonNull(info);
            return this;
        }

        public Builder setClassName(String className2) {
            this.mClassName = Objects.requireNonNull(className2);
            return this;
        }

        public Builder setRank(int rank) {
            if (rank < 0) {
                throw new IllegalArgumentException("rank cannot be a negative value");
            }
            this.mRank = rank;
            return this;
        }

        public AppTarget build() {
            if (this.mPackageName == null) {
                throw new IllegalStateException("No target is set");
            }
            return new AppTarget(this.mId, this.mPackageName, this.mUser, this.mShortcutInfo, this.mClassName, this.mRank);
        }
    }
}

