/*
 * Decompiled with CFR 0.152.
 */
package android.app.blob;

import android.app.blob.BlobHandle;
import android.app.blob.BlobInfo;
import android.app.blob.IBlobStoreSession;
import android.app.blob.LeaseInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;

public interface IBlobStoreManager
extends IInterface {
    public static final String DESCRIPTOR = "android.app.blob.IBlobStoreManager";

    public long createSession(BlobHandle var1, String var2) throws RemoteException;

    public IBlobStoreSession openSession(long var1, String var3) throws RemoteException;

    public ParcelFileDescriptor openBlob(BlobHandle var1, String var2) throws RemoteException;

    public void abandonSession(long var1, String var3) throws RemoteException;

    public void acquireLease(BlobHandle var1, int var2, CharSequence var3, long var4, String var6) throws RemoteException;

    public void releaseLease(BlobHandle var1, String var2) throws RemoteException;

    public long getRemainingLeaseQuotaBytes(String var1) throws RemoteException;

    public void waitForIdle(RemoteCallback var1) throws RemoteException;

    public List<BlobInfo> queryBlobsForUser(int var1) throws RemoteException;

    public void deleteBlob(long var1) throws RemoteException;

    public List<BlobHandle> getLeasedBlobs(String var1) throws RemoteException;

    public LeaseInfo getLeaseInfo(BlobHandle var1, String var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBlobStoreManager {
        static final int TRANSACTION_createSession = 1;
        static final int TRANSACTION_openSession = 2;
        static final int TRANSACTION_openBlob = 3;
        static final int TRANSACTION_abandonSession = 4;
        static final int TRANSACTION_acquireLease = 5;
        static final int TRANSACTION_releaseLease = 6;
        static final int TRANSACTION_getRemainingLeaseQuotaBytes = 7;
        static final int TRANSACTION_waitForIdle = 8;
        static final int TRANSACTION_queryBlobsForUser = 9;
        static final int TRANSACTION_deleteBlob = 10;
        static final int TRANSACTION_getLeasedBlobs = 11;
        static final int TRANSACTION_getLeaseInfo = 12;

        public Stub() {
            this.attachInterface(this, IBlobStoreManager.DESCRIPTOR);
        }

        public static IBlobStoreManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IBlobStoreManager.DESCRIPTOR);
            if (iin != null && iin instanceof IBlobStoreManager) {
                return (IBlobStoreManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "createSession";
                }
                case 2: {
                    return "openSession";
                }
                case 3: {
                    return "openBlob";
                }
                case 4: {
                    return "abandonSession";
                }
                case 5: {
                    return "acquireLease";
                }
                case 6: {
                    return "releaseLease";
                }
                case 7: {
                    return "getRemainingLeaseQuotaBytes";
                }
                case 8: {
                    return "waitForIdle";
                }
                case 9: {
                    return "queryBlobsForUser";
                }
                case 10: {
                    return "deleteBlob";
                }
                case 11: {
                    return "getLeasedBlobs";
                }
                case 12: {
                    return "getLeaseInfo";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IBlobStoreManager.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    BlobHandle _arg0 = 0 != data.readInt() ? BlobHandle.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    long _result = this.createSession(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    String _arg1 = data.readString();
                    IBlobStoreSession _result = this.openSession(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    BlobHandle _arg0 = 0 != data.readInt() ? BlobHandle.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    ParcelFileDescriptor _result = this.openBlob(_arg0, _arg1);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    String _arg1 = data.readString();
                    this.abandonSession(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    BlobHandle _arg0 = 0 != data.readInt() ? BlobHandle.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    CharSequence _arg2 = 0 != data.readInt() ? TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(data) : null;
                    long _arg3 = data.readLong();
                    String _arg4 = data.readString();
                    this.acquireLease(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    BlobHandle _arg0 = 0 != data.readInt() ? BlobHandle.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    this.releaseLease(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    long _result = this.getRemainingLeaseQuotaBytes(_arg0);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    RemoteCallback _arg0 = 0 != data.readInt() ? RemoteCallback.CREATOR.createFromParcel(data) : null;
                    this.waitForIdle(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    List<BlobInfo> _result = this.queryBlobsForUser(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    this.deleteBlob(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    List<BlobHandle> _result = this.getLeasedBlobs(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    BlobHandle _arg0 = 0 != data.readInt() ? BlobHandle.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    LeaseInfo _result = this.getLeaseInfo(_arg0, _arg1);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IBlobStoreManager impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IBlobStoreManager getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IBlobStoreManager {
            private IBinder mRemote;
            public static IBlobStoreManager sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IBlobStoreManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long createSession(BlobHandle handle, String packageName) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBlobStoreManager.DESCRIPTOR);
                    if (handle != null) {
                        _data.writeInt(1);
                        handle.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        long l = Stub.getDefaultImpl().createSession(handle, packageName);
                        return l;
                    }
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IBlobStoreSession openSession(long sessionId, String packageName) throws RemoteException {
                IBlobStoreSession _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBlobStoreManager.DESCRIPTOR);
                    _data.writeLong(sessionId);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        IBlobStoreSession iBlobStoreSession = Stub.getDefaultImpl().openSession(sessionId, packageName);
                        return iBlobStoreSession;
                    }
                    _reply.readException();
                    _result = IBlobStoreSession.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParcelFileDescriptor openBlob(BlobHandle handle, String packageName) throws RemoteException {
                ParcelFileDescriptor _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBlobStoreManager.DESCRIPTOR);
                    if (handle != null) {
                        _data.writeInt(1);
                        handle.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ParcelFileDescriptor parcelFileDescriptor = Stub.getDefaultImpl().openBlob(handle, packageName);
                        return parcelFileDescriptor;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? ParcelFileDescriptor.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void abandonSession(long sessionId, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBlobStoreManager.DESCRIPTOR);
                    _data.writeLong(sessionId);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().abandonSession(sessionId, packageName);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void acquireLease(BlobHandle handle, int descriptionResId, CharSequence description, long leaseTimeoutMillis, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBlobStoreManager.DESCRIPTOR);
                    if (handle != null) {
                        _data.writeInt(1);
                        handle.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(descriptionResId);
                    if (description != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(description, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeLong(leaseTimeoutMillis);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().acquireLease(handle, descriptionResId, description, leaseTimeoutMillis, packageName);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releaseLease(BlobHandle handle, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBlobStoreManager.DESCRIPTOR);
                    if (handle != null) {
                        _data.writeInt(1);
                        handle.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().releaseLease(handle, packageName);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getRemainingLeaseQuotaBytes(String packageName) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBlobStoreManager.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        long l = Stub.getDefaultImpl().getRemainingLeaseQuotaBytes(packageName);
                        return l;
                    }
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void waitForIdle(RemoteCallback callback2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBlobStoreManager.DESCRIPTOR);
                    if (callback2 != null) {
                        _data.writeInt(1);
                        callback2.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().waitForIdle(callback2);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<BlobInfo> queryBlobsForUser(int userId) throws RemoteException {
                ArrayList<BlobInfo> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBlobStoreManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<BlobInfo> list = Stub.getDefaultImpl().queryBlobsForUser(userId);
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArrayList(BlobInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deleteBlob(long blobId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBlobStoreManager.DESCRIPTOR);
                    _data.writeLong(blobId);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().deleteBlob(blobId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<BlobHandle> getLeasedBlobs(String packageName) throws RemoteException {
                ArrayList<BlobHandle> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBlobStoreManager.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<BlobHandle> list = Stub.getDefaultImpl().getLeasedBlobs(packageName);
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArrayList(BlobHandle.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public LeaseInfo getLeaseInfo(BlobHandle blobHandle, String packageName) throws RemoteException {
                LeaseInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBlobStoreManager.DESCRIPTOR);
                    if (blobHandle != null) {
                        _data.writeInt(1);
                        blobHandle.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        LeaseInfo leaseInfo = Stub.getDefaultImpl().getLeaseInfo(blobHandle, packageName);
                        return leaseInfo;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? LeaseInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IBlobStoreManager {
        @Override
        public long createSession(BlobHandle handle, String packageName) throws RemoteException {
            return 0L;
        }

        @Override
        public IBlobStoreSession openSession(long sessionId, String packageName) throws RemoteException {
            return null;
        }

        @Override
        public ParcelFileDescriptor openBlob(BlobHandle handle, String packageName) throws RemoteException {
            return null;
        }

        @Override
        public void abandonSession(long sessionId, String packageName) throws RemoteException {
        }

        @Override
        public void acquireLease(BlobHandle handle, int descriptionResId, CharSequence description, long leaseTimeoutMillis, String packageName) throws RemoteException {
        }

        @Override
        public void releaseLease(BlobHandle handle, String packageName) throws RemoteException {
        }

        @Override
        public long getRemainingLeaseQuotaBytes(String packageName) throws RemoteException {
            return 0L;
        }

        @Override
        public void waitForIdle(RemoteCallback callback2) throws RemoteException {
        }

        @Override
        public List<BlobInfo> queryBlobsForUser(int userId) throws RemoteException {
            return null;
        }

        @Override
        public void deleteBlob(long blobId) throws RemoteException {
        }

        @Override
        public List<BlobHandle> getLeasedBlobs(String packageName) throws RemoteException {
            return null;
        }

        @Override
        public LeaseInfo getLeaseInfo(BlobHandle blobHandle, String packageName) throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

