/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.app.appsearch.AppSearchResult;
import android.app.appsearch.SearchResult;
import android.app.appsearch.SearchResultPage;
import android.app.appsearch.SearchSpec;
import android.app.appsearch.aidl.AppSearchResultParcel;
import android.app.appsearch.aidl.IAppSearchManager;
import android.app.appsearch.aidl.IAppSearchResultCallback;
import android.app.appsearch.internal.util.Preconditions;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.Log;
import java.io.Closeable;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class SearchResults
implements Closeable {
    private static final String TAG = "SearchResults";
    private final IAppSearchManager mService;
    private final String mPackageName;
    private final String mDatabaseName;
    private final String mQueryExpression;
    private final SearchSpec mSearchSpec;
    private final UserHandle mUserHandle;
    private long mNextPageToken;
    private boolean mIsFirstLoad = true;
    private boolean mIsClosed = false;

    SearchResults(IAppSearchManager service, String packageName, String databaseName, String queryExpression, SearchSpec searchSpec, UserHandle userHandle) {
        this.mService = Objects.requireNonNull(service);
        this.mPackageName = packageName;
        this.mDatabaseName = databaseName;
        this.mQueryExpression = Objects.requireNonNull(queryExpression);
        this.mSearchSpec = Objects.requireNonNull(searchSpec);
        this.mUserHandle = Objects.requireNonNull(userHandle);
    }

    public void getNextPage(Executor executor, Consumer<AppSearchResult<List<SearchResult>>> callback2) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback2);
        Preconditions.checkState(!this.mIsClosed, "SearchResults has already been closed");
        try {
            if (this.mIsFirstLoad) {
                this.mIsFirstLoad = false;
                long binderCallStartTimeMillis = SystemClock.elapsedRealtime();
                if (this.mDatabaseName == null) {
                    this.mService.globalQuery(this.mPackageName, this.mQueryExpression, this.mSearchSpec.getBundle(), this.mUserHandle, binderCallStartTimeMillis, this.wrapCallback(executor, callback2));
                } else {
                    this.mService.query(this.mPackageName, this.mDatabaseName, this.mQueryExpression, this.mSearchSpec.getBundle(), this.mUserHandle, binderCallStartTimeMillis, this.wrapCallback(executor, callback2));
                }
            } else {
                this.mService.getNextPage(this.mPackageName, this.mNextPageToken, this.mUserHandle, this.wrapCallback(executor, callback2));
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public void close() {
        if (!this.mIsClosed) {
            try {
                this.mService.invalidateNextPageToken(this.mPackageName, this.mNextPageToken, this.mUserHandle);
                this.mIsClosed = true;
            }
            catch (RemoteException e) {
                Log.e(TAG, "Unable to close the SearchResults", e);
            }
        }
    }

    private IAppSearchResultCallback wrapCallback(final Executor executor, final Consumer<AppSearchResult<List<SearchResult>>> callback2) {
        return new IAppSearchResultCallback.Stub(){

            @Override
            public void onResult(AppSearchResultParcel resultParcel) {
                executor.execute(() -> SearchResults.this.invokeCallback(resultParcel.getResult(), callback2));
            }
        };
    }

    private void invokeCallback(AppSearchResult<Bundle> searchResultPageResult, Consumer<AppSearchResult<List<SearchResult>>> callback2) {
        if (searchResultPageResult.isSuccess()) {
            try {
                SearchResultPage searchResultPage = new SearchResultPage(searchResultPageResult.getResultValue());
                this.mNextPageToken = searchResultPage.getNextPageToken();
                callback2.accept(AppSearchResult.newSuccessfulResult(searchResultPage.getResults()));
            }
            catch (Throwable t) {
                callback2.accept(AppSearchResult.throwableToFailedResult(t));
            }
        } else {
            callback2.accept(AppSearchResult.newFailedResult(searchResultPageResult));
        }
    }
}

