/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.ICancellationSignal;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.ArrayMap;
import android.util.DebugUtils;
import android.util.Log;
import com.android.internal.app.IVoiceInteractor;
import com.android.internal.app.IVoiceInteractorCallback;
import com.android.internal.app.IVoiceInteractorRequest;
import com.android.internal.os.HandlerCaller;
import com.android.internal.os.SomeArgs;
import com.android.internal.util.function.pooled.PooledLambda;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.Executor;

public class VoiceInteractor {
    static final String TAG = "VoiceInteractor";
    static final boolean DEBUG = false;
    static final Request[] NO_REQUESTS = new Request[0];
    public static final String KEY_CANCELLATION_SIGNAL = "key_cancellation_signal";
    IVoiceInteractor mInteractor;
    Context mContext;
    Activity mActivity;
    boolean mRetaining;
    final HandlerCaller mHandlerCaller;
    final HandlerCaller.Callback mHandlerCallerCallback = new HandlerCaller.Callback(){

        @Override
        public void executeMessage(Message msg) {
            SomeArgs args = (SomeArgs)msg.obj;
            switch (msg.what) {
                case 1: {
                    Request request = VoiceInteractor.this.pullRequest((IVoiceInteractorRequest)args.arg1, true);
                    if (request == null) break;
                    ((ConfirmationRequest)request).onConfirmationResult(msg.arg1 != 0, (Bundle)args.arg2);
                    request.clear();
                    break;
                }
                case 2: {
                    boolean complete = msg.arg1 != 0;
                    Request request = VoiceInteractor.this.pullRequest((IVoiceInteractorRequest)args.arg1, complete);
                    if (request == null) break;
                    ((PickOptionRequest)request).onPickOptionResult(complete, (PickOptionRequest.Option[])args.arg2, (Bundle)args.arg3);
                    if (!complete) break;
                    request.clear();
                    break;
                }
                case 3: {
                    Request request = VoiceInteractor.this.pullRequest((IVoiceInteractorRequest)args.arg1, true);
                    if (request == null) break;
                    ((CompleteVoiceRequest)request).onCompleteResult((Bundle)args.arg2);
                    request.clear();
                    break;
                }
                case 4: {
                    Request request = VoiceInteractor.this.pullRequest((IVoiceInteractorRequest)args.arg1, true);
                    if (request == null) break;
                    ((AbortVoiceRequest)request).onAbortResult((Bundle)args.arg2);
                    request.clear();
                    break;
                }
                case 5: {
                    boolean complete = msg.arg1 != 0;
                    Request request = VoiceInteractor.this.pullRequest((IVoiceInteractorRequest)args.arg1, complete);
                    if (request == null) break;
                    ((CommandRequest)request).onCommandResult(msg.arg1 != 0, (Bundle)args.arg2);
                    if (!complete) break;
                    request.clear();
                    break;
                }
                case 6: {
                    Request request = VoiceInteractor.this.pullRequest((IVoiceInteractorRequest)args.arg1, true);
                    if (request == null) break;
                    request.onCancel();
                    request.clear();
                }
            }
        }
    };
    final IVoiceInteractorCallback.Stub mCallback = new IVoiceInteractorCallback.Stub(){

        @Override
        public void deliverConfirmationResult(IVoiceInteractorRequest request, boolean finished, Bundle result) {
            VoiceInteractor.this.mHandlerCaller.sendMessage(VoiceInteractor.this.mHandlerCaller.obtainMessageIOO(1, finished ? 1 : 0, request, result));
        }

        @Override
        public void deliverPickOptionResult(IVoiceInteractorRequest request, boolean finished, PickOptionRequest.Option[] options, Bundle result) {
            VoiceInteractor.this.mHandlerCaller.sendMessage(VoiceInteractor.this.mHandlerCaller.obtainMessageIOOO(2, finished ? 1 : 0, request, options, result));
        }

        @Override
        public void deliverCompleteVoiceResult(IVoiceInteractorRequest request, Bundle result) {
            VoiceInteractor.this.mHandlerCaller.sendMessage(VoiceInteractor.this.mHandlerCaller.obtainMessageOO(3, request, result));
        }

        @Override
        public void deliverAbortVoiceResult(IVoiceInteractorRequest request, Bundle result) {
            VoiceInteractor.this.mHandlerCaller.sendMessage(VoiceInteractor.this.mHandlerCaller.obtainMessageOO(4, request, result));
        }

        @Override
        public void deliverCommandResult(IVoiceInteractorRequest request, boolean complete, Bundle result) {
            VoiceInteractor.this.mHandlerCaller.sendMessage(VoiceInteractor.this.mHandlerCaller.obtainMessageIOO(5, complete ? 1 : 0, request, result));
        }

        @Override
        public void deliverCancel(IVoiceInteractorRequest request) {
            VoiceInteractor.this.mHandlerCaller.sendMessage(VoiceInteractor.this.mHandlerCaller.obtainMessageOO(6, request, null));
        }

        @Override
        public void destroy() {
            VoiceInteractor.this.mHandlerCaller.getHandler().sendMessage(PooledLambda.obtainMessage(VoiceInteractor::destroy, VoiceInteractor.this));
        }
    };
    final ArrayMap<IBinder, Request> mActiveRequests = new ArrayMap();
    final ArrayMap<Runnable, Executor> mOnDestroyCallbacks = new ArrayMap();
    static final int MSG_CONFIRMATION_RESULT = 1;
    static final int MSG_PICK_OPTION_RESULT = 2;
    static final int MSG_COMPLETE_VOICE_RESULT = 3;
    static final int MSG_ABORT_VOICE_RESULT = 4;
    static final int MSG_COMMAND_RESULT = 5;
    static final int MSG_CANCEL_RESULT = 6;

    VoiceInteractor(IVoiceInteractor interactor, Context context, Activity activity, Looper looper) {
        this.mInteractor = interactor;
        this.mContext = context;
        this.mActivity = activity;
        this.mHandlerCaller = new HandlerCaller(context, looper, this.mHandlerCallerCallback, true);
        try {
            this.mInteractor.setKillCallback(new KillCallback(this));
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Request pullRequest(IVoiceInteractorRequest request, boolean complete) {
        ArrayMap<IBinder, Request> arrayMap = this.mActiveRequests;
        synchronized (arrayMap) {
            Request req = this.mActiveRequests.get(request.asBinder());
            if (req != null && complete) {
                this.mActiveRequests.remove(request.asBinder());
            }
            return req;
        }
    }

    private ArrayList<Request> makeRequestList() {
        int N = this.mActiveRequests.size();
        if (N < 1) {
            return null;
        }
        ArrayList<Request> list = new ArrayList<Request>(N);
        for (int i = 0; i < N; ++i) {
            list.add(this.mActiveRequests.valueAt(i));
        }
        return list;
    }

    void attachActivity(Activity activity) {
        this.mRetaining = false;
        if (this.mActivity == activity) {
            return;
        }
        this.mContext = activity;
        this.mActivity = activity;
        ArrayList<Request> reqs = this.makeRequestList();
        if (reqs != null) {
            for (int i = 0; i < reqs.size(); ++i) {
                Request req = reqs.get(i);
                req.mContext = activity;
                req.mActivity = activity;
                req.onAttached(activity);
            }
        }
    }

    void retainInstance() {
        this.mRetaining = true;
    }

    void detachActivity() {
        Request req;
        int i;
        ArrayList<Request> reqs = this.makeRequestList();
        if (reqs != null) {
            for (i = 0; i < reqs.size(); ++i) {
                req = reqs.get(i);
                req.onDetached();
                req.mActivity = null;
                req.mContext = null;
            }
        }
        if (!this.mRetaining) {
            reqs = this.makeRequestList();
            if (reqs != null) {
                for (i = 0; i < reqs.size(); ++i) {
                    req = reqs.get(i);
                    req.cancel();
                }
            }
            this.mActiveRequests.clear();
        }
        this.mContext = null;
        this.mActivity = null;
    }

    void destroy() {
        int requestCount = this.mActiveRequests.size();
        for (int i = requestCount - 1; i >= 0; --i) {
            Request request = this.mActiveRequests.valueAt(i);
            this.mActiveRequests.removeAt(i);
            request.cancel();
        }
        int callbackCount = this.mOnDestroyCallbacks.size();
        for (int i = callbackCount - 1; i >= 0; --i) {
            Runnable callback2 = this.mOnDestroyCallbacks.keyAt(i);
            Executor executor = this.mOnDestroyCallbacks.valueAt(i);
            executor.execute(callback2);
            this.mOnDestroyCallbacks.removeAt(i);
        }
        this.mInteractor = null;
        if (this.mActivity != null) {
            this.mActivity.setVoiceInteractor(null);
        }
    }

    public boolean submitRequest(Request request) {
        return this.submitRequest(request, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean submitRequest(Request request, String name) {
        if (this.isDestroyed()) {
            Log.w(TAG, "Cannot interact with a destroyed voice interactor");
            return false;
        }
        try {
            IVoiceInteractorRequest ireq;
            if (request.mRequestInterface != null) {
                throw new IllegalStateException("Given " + request + " is already active");
            }
            request.mRequestInterface = ireq = request.submit(this.mInteractor, this.mContext.getOpPackageName(), this.mCallback);
            request.mContext = this.mContext;
            request.mActivity = this.mActivity;
            request.mName = name;
            ArrayMap<IBinder, Request> arrayMap = this.mActiveRequests;
            synchronized (arrayMap) {
                this.mActiveRequests.put(ireq.asBinder(), request);
            }
            return true;
        }
        catch (RemoteException e) {
            Log.w(TAG, "Remove voice interactor service died", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Request[] getActiveRequests() {
        if (this.isDestroyed()) {
            Log.w(TAG, "Cannot interact with a destroyed voice interactor");
            return null;
        }
        ArrayMap<IBinder, Request> arrayMap = this.mActiveRequests;
        synchronized (arrayMap) {
            int N = this.mActiveRequests.size();
            if (N <= 0) {
                return NO_REQUESTS;
            }
            Request[] requests = new Request[N];
            for (int i = 0; i < N; ++i) {
                requests[i] = this.mActiveRequests.valueAt(i);
            }
            return requests;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Request getActiveRequest(String name) {
        if (this.isDestroyed()) {
            Log.w(TAG, "Cannot interact with a destroyed voice interactor");
            return null;
        }
        ArrayMap<IBinder, Request> arrayMap = this.mActiveRequests;
        synchronized (arrayMap) {
            int N = this.mActiveRequests.size();
            for (int i = 0; i < N; ++i) {
                Request req = this.mActiveRequests.valueAt(i);
                if (name != req.getName() && (name == null || !name.equals(req.getName()))) continue;
                return req;
            }
        }
        return null;
    }

    public boolean[] supportsCommands(String[] commands2) {
        if (this.isDestroyed()) {
            Log.w(TAG, "Cannot interact with a destroyed voice interactor");
            return new boolean[commands2.length];
        }
        try {
            boolean[] res = this.mInteractor.supportsCommands(this.mContext.getOpPackageName(), commands2);
            return res;
        }
        catch (RemoteException e) {
            throw new RuntimeException("Voice interactor has died", e);
        }
    }

    public boolean isDestroyed() {
        return this.mInteractor == null;
    }

    public boolean registerOnDestroyedCallback(Executor executor, Runnable callback2) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback2);
        if (this.isDestroyed()) {
            Log.w(TAG, "Cannot interact with a destroyed voice interactor");
            return false;
        }
        this.mOnDestroyCallbacks.put(callback2, executor);
        return true;
    }

    public boolean unregisterOnDestroyedCallback(Runnable callback2) {
        Objects.requireNonNull(callback2);
        if (this.isDestroyed()) {
            Log.w(TAG, "Cannot interact with a destroyed voice interactor");
            return false;
        }
        return this.mOnDestroyCallbacks.remove(callback2) != null;
    }

    public void notifyDirectActionsChanged() {
        if (this.isDestroyed()) {
            Log.w(TAG, "Cannot interact with a destroyed voice interactor");
            return;
        }
        try {
            this.mInteractor.notifyDirectActionsChanged(this.mActivity.getTaskId(), this.mActivity.getAssistToken());
        }
        catch (RemoteException e) {
            Log.w(TAG, "Voice interactor has died", e);
        }
    }

    void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        String innerPrefix = prefix + "    ";
        if (this.mActiveRequests.size() > 0) {
            writer.print(prefix);
            writer.println("Active voice requests:");
            for (int i = 0; i < this.mActiveRequests.size(); ++i) {
                Request req = this.mActiveRequests.valueAt(i);
                writer.print(prefix);
                writer.print("  #");
                writer.print(i);
                writer.print(": ");
                writer.println(req);
                req.dump(innerPrefix, fd, writer, args);
            }
        }
        writer.print(prefix);
        writer.println("VoiceInteractor misc state:");
        writer.print(prefix);
        writer.print("  mInteractor=");
        writer.println(this.mInteractor.asBinder());
        writer.print(prefix);
        writer.print("  mActivity=");
        writer.println(this.mActivity);
    }

    private static class KillCallback
    extends ICancellationSignal.Stub {
        private final WeakReference<VoiceInteractor> mInteractor;

        KillCallback(VoiceInteractor interactor) {
            this.mInteractor = new WeakReference<VoiceInteractor>(interactor);
        }

        @Override
        public void cancel() {
            VoiceInteractor voiceInteractor = (VoiceInteractor)this.mInteractor.get();
            if (voiceInteractor != null) {
                voiceInteractor.mHandlerCaller.getHandler().sendMessage(PooledLambda.obtainMessage(VoiceInteractor::destroy, voiceInteractor));
            }
        }
    }

    public static class Prompt
    implements Parcelable {
        private final CharSequence[] mVoicePrompts;
        private final CharSequence mVisualPrompt;
        public static final Parcelable.Creator<Prompt> CREATOR = new Parcelable.Creator<Prompt>(){

            @Override
            public Prompt createFromParcel(Parcel in) {
                return new Prompt(in);
            }

            public Prompt[] newArray(int size) {
                return new Prompt[size];
            }
        };

        public Prompt(CharSequence[] voicePrompts, CharSequence visualPrompt) {
            if (voicePrompts == null) {
                throw new NullPointerException("voicePrompts must not be null");
            }
            if (voicePrompts.length == 0) {
                throw new IllegalArgumentException("voicePrompts must not be empty");
            }
            if (visualPrompt == null) {
                throw new NullPointerException("visualPrompt must not be null");
            }
            this.mVoicePrompts = voicePrompts;
            this.mVisualPrompt = visualPrompt;
        }

        public Prompt(CharSequence prompt) {
            this.mVoicePrompts = new CharSequence[]{prompt};
            this.mVisualPrompt = prompt;
        }

        public CharSequence getVoicePromptAt(int index) {
            return this.mVoicePrompts[index];
        }

        public int countVoicePrompts() {
            return this.mVoicePrompts.length;
        }

        public CharSequence getVisualPrompt() {
            return this.mVisualPrompt;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(128);
            DebugUtils.buildShortClassTag(this, sb);
            if (this.mVisualPrompt != null && this.mVoicePrompts != null && this.mVoicePrompts.length == 1 && this.mVisualPrompt.equals(this.mVoicePrompts[0])) {
                sb.append(" ");
                sb.append(this.mVisualPrompt);
            } else {
                if (this.mVisualPrompt != null) {
                    sb.append(" visual=");
                    sb.append(this.mVisualPrompt);
                }
                if (this.mVoicePrompts != null) {
                    sb.append(", voice=");
                    for (int i = 0; i < this.mVoicePrompts.length; ++i) {
                        if (i > 0) {
                            sb.append(" | ");
                        }
                        sb.append(this.mVoicePrompts[i]);
                    }
                }
            }
            sb.append('}');
            return sb.toString();
        }

        Prompt(Parcel in) {
            this.mVoicePrompts = in.readCharSequenceArray();
            this.mVisualPrompt = in.readCharSequence();
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeCharSequenceArray(this.mVoicePrompts);
            dest.writeCharSequence(this.mVisualPrompt);
        }
    }

    public static class CommandRequest
    extends Request {
        final String mCommand;
        final Bundle mArgs;

        public CommandRequest(String command, Bundle args) {
            this.mCommand = command;
            this.mArgs = args;
        }

        public void onCommandResult(boolean isCompleted, Bundle result) {
        }

        @Override
        void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
            super.dump(prefix, fd, writer, args);
            writer.print(prefix);
            writer.print("mCommand=");
            writer.println(this.mCommand);
            if (this.mArgs != null) {
                writer.print(prefix);
                writer.print("mArgs=");
                writer.println(this.mArgs);
            }
        }

        @Override
        String getRequestTypeName() {
            return "Command";
        }

        @Override
        IVoiceInteractorRequest submit(IVoiceInteractor interactor, String packageName, IVoiceInteractorCallback callback2) throws RemoteException {
            return interactor.startCommand(packageName, callback2, this.mCommand, this.mArgs);
        }
    }

    public static class AbortVoiceRequest
    extends Request {
        final Prompt mPrompt;
        final Bundle mExtras;

        public AbortVoiceRequest(Prompt prompt, Bundle extras) {
            this.mPrompt = prompt;
            this.mExtras = extras;
        }

        public AbortVoiceRequest(CharSequence message, Bundle extras) {
            this.mPrompt = message != null ? new Prompt(message) : null;
            this.mExtras = extras;
        }

        public void onAbortResult(Bundle result) {
        }

        @Override
        void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
            super.dump(prefix, fd, writer, args);
            writer.print(prefix);
            writer.print("mPrompt=");
            writer.println(this.mPrompt);
            if (this.mExtras != null) {
                writer.print(prefix);
                writer.print("mExtras=");
                writer.println(this.mExtras);
            }
        }

        @Override
        String getRequestTypeName() {
            return "AbortVoice";
        }

        @Override
        IVoiceInteractorRequest submit(IVoiceInteractor interactor, String packageName, IVoiceInteractorCallback callback2) throws RemoteException {
            return interactor.startAbortVoice(packageName, callback2, this.mPrompt, this.mExtras);
        }
    }

    public static class CompleteVoiceRequest
    extends Request {
        final Prompt mPrompt;
        final Bundle mExtras;

        public CompleteVoiceRequest(Prompt prompt, Bundle extras) {
            this.mPrompt = prompt;
            this.mExtras = extras;
        }

        public CompleteVoiceRequest(CharSequence message, Bundle extras) {
            this.mPrompt = message != null ? new Prompt(message) : null;
            this.mExtras = extras;
        }

        public void onCompleteResult(Bundle result) {
        }

        @Override
        void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
            super.dump(prefix, fd, writer, args);
            writer.print(prefix);
            writer.print("mPrompt=");
            writer.println(this.mPrompt);
            if (this.mExtras != null) {
                writer.print(prefix);
                writer.print("mExtras=");
                writer.println(this.mExtras);
            }
        }

        @Override
        String getRequestTypeName() {
            return "CompleteVoice";
        }

        @Override
        IVoiceInteractorRequest submit(IVoiceInteractor interactor, String packageName, IVoiceInteractorCallback callback2) throws RemoteException {
            return interactor.startCompleteVoice(packageName, callback2, this.mPrompt, this.mExtras);
        }
    }

    public static class PickOptionRequest
    extends Request {
        final Prompt mPrompt;
        final Option[] mOptions;
        final Bundle mExtras;

        public PickOptionRequest(Prompt prompt, Option[] options, Bundle extras) {
            this.mPrompt = prompt;
            this.mOptions = options;
            this.mExtras = extras;
        }

        public PickOptionRequest(CharSequence prompt, Option[] options, Bundle extras) {
            this.mPrompt = prompt != null ? new Prompt(prompt) : null;
            this.mOptions = options;
            this.mExtras = extras;
        }

        public void onPickOptionResult(boolean finished, Option[] selections, Bundle result) {
        }

        @Override
        void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
            super.dump(prefix, fd, writer, args);
            writer.print(prefix);
            writer.print("mPrompt=");
            writer.println(this.mPrompt);
            if (this.mOptions != null) {
                writer.print(prefix);
                writer.println("Options:");
                for (int i = 0; i < this.mOptions.length; ++i) {
                    Option op = this.mOptions[i];
                    writer.print(prefix);
                    writer.print("  #");
                    writer.print(i);
                    writer.println(":");
                    writer.print(prefix);
                    writer.print("    mLabel=");
                    writer.println(op.mLabel);
                    writer.print(prefix);
                    writer.print("    mIndex=");
                    writer.println(op.mIndex);
                    if (op.mSynonyms != null && op.mSynonyms.size() > 0) {
                        writer.print(prefix);
                        writer.println("    Synonyms:");
                        for (int j = 0; j < op.mSynonyms.size(); ++j) {
                            writer.print(prefix);
                            writer.print("      #");
                            writer.print(j);
                            writer.print(": ");
                            writer.println(op.mSynonyms.get(j));
                        }
                    }
                    if (op.mExtras == null) continue;
                    writer.print(prefix);
                    writer.print("    mExtras=");
                    writer.println(op.mExtras);
                }
            }
            if (this.mExtras != null) {
                writer.print(prefix);
                writer.print("mExtras=");
                writer.println(this.mExtras);
            }
        }

        @Override
        String getRequestTypeName() {
            return "PickOption";
        }

        @Override
        IVoiceInteractorRequest submit(IVoiceInteractor interactor, String packageName, IVoiceInteractorCallback callback2) throws RemoteException {
            return interactor.startPickOption(packageName, callback2, this.mPrompt, this.mOptions, this.mExtras);
        }

        public static class Option
        implements Parcelable {
            final CharSequence mLabel;
            final int mIndex;
            ArrayList<CharSequence> mSynonyms;
            Bundle mExtras;
            public static final Parcelable.Creator<Option> CREATOR = new Parcelable.Creator<Option>(){

                @Override
                public Option createFromParcel(Parcel in) {
                    return new Option(in);
                }

                public Option[] newArray(int size) {
                    return new Option[size];
                }
            };

            public Option(CharSequence label) {
                this.mLabel = label;
                this.mIndex = -1;
            }

            public Option(CharSequence label, int index) {
                this.mLabel = label;
                this.mIndex = index;
            }

            public Option addSynonym(CharSequence synonym) {
                if (this.mSynonyms == null) {
                    this.mSynonyms = new ArrayList();
                }
                this.mSynonyms.add(synonym);
                return this;
            }

            public CharSequence getLabel() {
                return this.mLabel;
            }

            public int getIndex() {
                return this.mIndex;
            }

            public int countSynonyms() {
                return this.mSynonyms != null ? this.mSynonyms.size() : 0;
            }

            public CharSequence getSynonymAt(int index) {
                return this.mSynonyms != null ? this.mSynonyms.get(index) : null;
            }

            public void setExtras(Bundle extras) {
                this.mExtras = extras;
            }

            public Bundle getExtras() {
                return this.mExtras;
            }

            Option(Parcel in) {
                this.mLabel = in.readCharSequence();
                this.mIndex = in.readInt();
                this.mSynonyms = in.readCharSequenceList();
                this.mExtras = in.readBundle();
            }

            @Override
            public int describeContents() {
                return 0;
            }

            @Override
            public void writeToParcel(Parcel dest, int flags) {
                dest.writeCharSequence(this.mLabel);
                dest.writeInt(this.mIndex);
                dest.writeCharSequenceList(this.mSynonyms);
                dest.writeBundle(this.mExtras);
            }
        }
    }

    public static class ConfirmationRequest
    extends Request {
        final Prompt mPrompt;
        final Bundle mExtras;

        public ConfirmationRequest(Prompt prompt, Bundle extras) {
            this.mPrompt = prompt;
            this.mExtras = extras;
        }

        public ConfirmationRequest(CharSequence prompt, Bundle extras) {
            this.mPrompt = prompt != null ? new Prompt(prompt) : null;
            this.mExtras = extras;
        }

        public void onConfirmationResult(boolean confirmed, Bundle result) {
        }

        @Override
        void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
            super.dump(prefix, fd, writer, args);
            writer.print(prefix);
            writer.print("mPrompt=");
            writer.println(this.mPrompt);
            if (this.mExtras != null) {
                writer.print(prefix);
                writer.print("mExtras=");
                writer.println(this.mExtras);
            }
        }

        @Override
        String getRequestTypeName() {
            return "Confirmation";
        }

        @Override
        IVoiceInteractorRequest submit(IVoiceInteractor interactor, String packageName, IVoiceInteractorCallback callback2) throws RemoteException {
            return interactor.startConfirmation(packageName, callback2, this.mPrompt, this.mExtras);
        }
    }

    public static abstract class Request {
        IVoiceInteractorRequest mRequestInterface;
        Context mContext;
        Activity mActivity;
        String mName;

        Request() {
        }

        public String getName() {
            return this.mName;
        }

        public void cancel() {
            if (this.mRequestInterface == null) {
                throw new IllegalStateException("Request " + this + " is no longer active");
            }
            try {
                this.mRequestInterface.cancel();
            }
            catch (RemoteException e) {
                Log.w(VoiceInteractor.TAG, "Voice interactor has died", e);
            }
        }

        public Context getContext() {
            return this.mContext;
        }

        public Activity getActivity() {
            return this.mActivity;
        }

        public void onCancel() {
        }

        public void onAttached(Activity activity) {
        }

        public void onDetached() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(128);
            DebugUtils.buildShortClassTag(this, sb);
            sb.append(" ");
            sb.append(this.getRequestTypeName());
            sb.append(" name=");
            sb.append(this.mName);
            sb.append('}');
            return sb.toString();
        }

        void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
            writer.print(prefix);
            writer.print("mRequestInterface=");
            writer.println(this.mRequestInterface.asBinder());
            writer.print(prefix);
            writer.print("mActivity=");
            writer.println(this.mActivity);
            writer.print(prefix);
            writer.print("mName=");
            writer.println(this.mName);
        }

        String getRequestTypeName() {
            return "Request";
        }

        void clear() {
            this.mRequestInterface = null;
            this.mContext = null;
            this.mActivity = null;
            this.mName = null;
        }

        abstract IVoiceInteractorRequest submit(IVoiceInteractor var1, String var2, IVoiceInteractorCallback var3) throws RemoteException;
    }
}

