/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Dialog;
import android.app.SearchManager;
import android.app.SearchableInfo;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.view.ActionMode;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.AutoCompleteTextView;
import android.widget.Filterable;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.SearchView;
import android.widget.TextView;

public class SearchDialog
extends Dialog {
    private static final boolean DBG = false;
    private static final String LOG_TAG = "SearchDialog";
    private static final String INSTANCE_KEY_COMPONENT = "comp";
    private static final String INSTANCE_KEY_APPDATA = "data";
    private static final String INSTANCE_KEY_USER_QUERY = "uQry";
    private static final String IME_OPTION_NO_MICROPHONE = "nm";
    private static final int SEARCH_PLATE_LEFT_PADDING_NON_GLOBAL = 7;
    private TextView mBadgeLabel;
    private ImageView mAppIcon;
    private AutoCompleteTextView mSearchAutoComplete;
    private View mSearchPlate;
    private SearchView mSearchView;
    private Drawable mWorkingSpinner;
    private View mCloseSearch;
    private SearchableInfo mSearchable;
    private ComponentName mLaunchComponent;
    private Bundle mAppSearchData;
    private Context mActivityContext;
    private final Intent mVoiceWebSearchIntent;
    private final Intent mVoiceAppSearchIntent;
    private String mUserQuery;
    private int mSearchAutoCompleteImeOptions;
    private BroadcastReceiver mConfChangeListener = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.intent.action.CONFIGURATION_CHANGED")) {
                SearchDialog.this.onConfigurationChanged();
            }
        }
    };
    private final SearchView.OnCloseListener mOnCloseListener = new SearchView.OnCloseListener(){

        @Override
        public boolean onClose() {
            return SearchDialog.this.onClosePressed();
        }
    };
    private final SearchView.OnQueryTextListener mOnQueryChangeListener = new SearchView.OnQueryTextListener(){

        @Override
        public boolean onQueryTextSubmit(String query) {
            SearchDialog.this.dismiss();
            return false;
        }

        @Override
        public boolean onQueryTextChange(String newText) {
            return false;
        }
    };
    private final SearchView.OnSuggestionListener mOnSuggestionSelectionListener = new SearchView.OnSuggestionListener(){

        @Override
        public boolean onSuggestionSelect(int position) {
            return false;
        }

        @Override
        public boolean onSuggestionClick(int position) {
            SearchDialog.this.dismiss();
            return false;
        }
    };

    static int resolveDialogTheme(Context context) {
        TypedValue outValue = new TypedValue();
        context.getTheme().resolveAttribute(17957076, outValue, true);
        return outValue.resourceId;
    }

    public SearchDialog(Context context, SearchManager searchManager) {
        super(context, SearchDialog.resolveDialogTheme(context));
        this.mVoiceWebSearchIntent = new Intent("android.speech.action.WEB_SEARCH");
        this.mVoiceWebSearchIntent.addFlags(0x10000000);
        this.mVoiceWebSearchIntent.putExtra("android.speech.extra.LANGUAGE_MODEL", "web_search");
        this.mVoiceAppSearchIntent = new Intent("android.speech.action.RECOGNIZE_SPEECH");
        this.mVoiceAppSearchIntent.addFlags(0x10000000);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Window theWindow = this.getWindow();
        WindowManager.LayoutParams lp = theWindow.getAttributes();
        lp.width = -1;
        lp.height = -1;
        lp.gravity = 55;
        lp.softInputMode = 16;
        theWindow.setAttributes(lp);
        this.setCanceledOnTouchOutside(true);
    }

    private void createContentView() {
        this.setContentView(0x1090101);
        this.mSearchView = (SearchView)this.findViewById(16909410);
        this.mSearchView.setIconified(false);
        this.mSearchView.setOnCloseListener(this.mOnCloseListener);
        this.mSearchView.setOnQueryTextListener(this.mOnQueryChangeListener);
        this.mSearchView.setOnSuggestionListener(this.mOnSuggestionSelectionListener);
        this.mSearchView.onActionViewExpanded();
        this.mCloseSearch = this.findViewById(16908327);
        this.mCloseSearch.setOnClickListener(new View.OnClickListener(){

            @Override
            public void onClick(View v) {
                SearchDialog.this.dismiss();
            }
        });
        this.mBadgeLabel = (TextView)this.mSearchView.findViewById(16909401);
        this.mSearchAutoComplete = (AutoCompleteTextView)this.mSearchView.findViewById(16909409);
        this.mAppIcon = (ImageView)this.findViewById(16909400);
        this.mSearchPlate = this.mSearchView.findViewById(16909408);
        this.mWorkingSpinner = this.getContext().getDrawable(17303466);
        this.setWorking(false);
        this.mBadgeLabel.setVisibility(8);
        this.mSearchAutoCompleteImeOptions = this.mSearchAutoComplete.getImeOptions();
    }

    public boolean show(String initialQuery, boolean selectInitialQuery, ComponentName componentName, Bundle appSearchData) {
        boolean success = this.doShow(initialQuery, selectInitialQuery, componentName, appSearchData);
        if (success) {
            this.mSearchAutoComplete.showDropDownAfterLayout();
        }
        return success;
    }

    private boolean doShow(String initialQuery, boolean selectInitialQuery, ComponentName componentName, Bundle appSearchData) {
        if (!this.show(componentName, appSearchData)) {
            return false;
        }
        this.setUserQuery(initialQuery);
        if (selectInitialQuery) {
            this.mSearchAutoComplete.selectAll();
        }
        return true;
    }

    private boolean show(ComponentName componentName, Bundle appSearchData) {
        SearchManager searchManager = (SearchManager)this.mContext.getSystemService("search");
        this.mSearchable = searchManager.getSearchableInfo(componentName);
        if (this.mSearchable == null) {
            return false;
        }
        this.mLaunchComponent = componentName;
        this.mAppSearchData = appSearchData;
        this.mActivityContext = this.mSearchable.getActivityContext(this.getContext());
        if (!this.isShowing()) {
            this.createContentView();
            this.mSearchView.setSearchableInfo(this.mSearchable);
            this.mSearchView.setAppSearchData(this.mAppSearchData);
            this.show();
        }
        this.updateUI();
        return true;
    }

    @Override
    public void onStart() {
        super.onStart();
        IntentFilter filter2 = new IntentFilter();
        filter2.addAction("android.intent.action.CONFIGURATION_CHANGED");
        this.getContext().registerReceiver(this.mConfChangeListener, filter2);
    }

    @Override
    public void onStop() {
        super.onStop();
        this.getContext().unregisterReceiver(this.mConfChangeListener);
        this.mLaunchComponent = null;
        this.mAppSearchData = null;
        this.mSearchable = null;
        this.mUserQuery = null;
    }

    @UnsupportedAppUsage
    public void setWorking(boolean working) {
        this.mWorkingSpinner.setAlpha(working ? 255 : 0);
        this.mWorkingSpinner.setVisible(working, false);
        this.mWorkingSpinner.invalidateSelf();
    }

    @Override
    public Bundle onSaveInstanceState() {
        if (!this.isShowing()) {
            return null;
        }
        Bundle bundle = new Bundle();
        bundle.putParcelable(INSTANCE_KEY_COMPONENT, this.mLaunchComponent);
        bundle.putBundle(INSTANCE_KEY_APPDATA, this.mAppSearchData);
        bundle.putString(INSTANCE_KEY_USER_QUERY, this.mUserQuery);
        return bundle;
    }

    @Override
    public void onRestoreInstanceState(Bundle savedInstanceState) {
        if (savedInstanceState == null) {
            return;
        }
        ComponentName launchComponent = (ComponentName)savedInstanceState.getParcelable(INSTANCE_KEY_COMPONENT);
        Bundle appSearchData = savedInstanceState.getBundle(INSTANCE_KEY_APPDATA);
        String userQuery = savedInstanceState.getString(INSTANCE_KEY_USER_QUERY);
        if (!this.doShow(userQuery, false, launchComponent, appSearchData)) {
            return;
        }
    }

    public void onConfigurationChanged() {
        if (this.mSearchable != null && this.isShowing()) {
            this.updateSearchAppIcon();
            this.updateSearchBadge();
            if (SearchDialog.isLandscapeMode(this.getContext())) {
                this.mSearchAutoComplete.setInputMethodMode(1);
                if (this.mSearchAutoComplete.isDropDownAlwaysVisible() || this.enoughToFilter()) {
                    this.mSearchAutoComplete.showDropDown();
                }
            }
        }
    }

    @UnsupportedAppUsage
    static boolean isLandscapeMode(Context context) {
        return context.getResources().getConfiguration().orientation == 2;
    }

    private boolean enoughToFilter() {
        Filterable filterableAdapter = (Filterable)((Object)this.mSearchAutoComplete.getAdapter());
        if (filterableAdapter == null || filterableAdapter.getFilter() == null) {
            return false;
        }
        return this.mSearchAutoComplete.enoughToFilter();
    }

    private void updateUI() {
        if (this.mSearchable != null) {
            this.mDecor.setVisibility(0);
            this.updateSearchAutoComplete();
            this.updateSearchAppIcon();
            this.updateSearchBadge();
            int inputType = this.mSearchable.getInputType();
            if ((inputType & 0xF) == 1) {
                inputType &= 0xFFFEFFFF;
                if (this.mSearchable.getSuggestAuthority() != null) {
                    inputType |= 0x10000;
                }
            }
            this.mSearchAutoComplete.setInputType(inputType);
            this.mSearchAutoCompleteImeOptions = this.mSearchable.getImeOptions();
            this.mSearchAutoComplete.setImeOptions(this.mSearchAutoCompleteImeOptions);
            if (this.mSearchable.getVoiceSearchEnabled()) {
                this.mSearchAutoComplete.setPrivateImeOptions(IME_OPTION_NO_MICROPHONE);
            } else {
                this.mSearchAutoComplete.setPrivateImeOptions(null);
            }
        }
    }

    private void updateSearchAutoComplete() {
        this.mSearchAutoComplete.setDropDownDismissedOnCompletion(false);
        this.mSearchAutoComplete.setForceIgnoreOutsideTouch(false);
    }

    private void updateSearchAppIcon() {
        Drawable icon2;
        PackageManager pm = this.getContext().getPackageManager();
        try {
            ActivityInfo info = pm.getActivityInfo(this.mLaunchComponent, 0);
            icon2 = pm.getApplicationIcon(info.applicationInfo);
        }
        catch (PackageManager.NameNotFoundException e) {
            icon2 = pm.getDefaultActivityIcon();
            Log.w(LOG_TAG, this.mLaunchComponent + " not found, using generic app icon");
        }
        this.mAppIcon.setImageDrawable(icon2);
        this.mAppIcon.setVisibility(0);
        this.mSearchPlate.setPadding(7, this.mSearchPlate.getPaddingTop(), this.mSearchPlate.getPaddingRight(), this.mSearchPlate.getPaddingBottom());
    }

    private void updateSearchBadge() {
        int visibility = 8;
        Drawable icon2 = null;
        String text = null;
        if (this.mSearchable.useBadgeIcon()) {
            icon2 = this.mActivityContext.getDrawable(this.mSearchable.getIconId());
            visibility = 0;
        } else if (this.mSearchable.useBadgeLabel()) {
            text = this.mActivityContext.getResources().getText(this.mSearchable.getLabelId()).toString();
            visibility = 0;
        }
        this.mBadgeLabel.setCompoundDrawablesWithIntrinsicBounds(icon2, null, null, null);
        this.mBadgeLabel.setText(text);
        this.mBadgeLabel.setVisibility(visibility);
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        if (!this.mSearchAutoComplete.isPopupShowing() && this.isOutOfBounds(this.mSearchPlate, event)) {
            this.cancel();
            return true;
        }
        return super.onTouchEvent(event);
    }

    private boolean isOutOfBounds(View v, MotionEvent event) {
        int x = (int)event.getX();
        int y = (int)event.getY();
        int slop = ViewConfiguration.get(this.mContext).getScaledWindowTouchSlop();
        return x < -slop || y < -slop || x > v.getWidth() + slop || y > v.getHeight() + slop;
    }

    @Override
    public void hide() {
        if (!this.isShowing()) {
            return;
        }
        InputMethodManager imm = this.getContext().getSystemService(InputMethodManager.class);
        if (imm != null) {
            imm.hideSoftInputFromWindow(this.getWindow().getDecorView().getWindowToken(), 0);
        }
        super.hide();
    }

    @UnsupportedAppUsage
    public void launchQuerySearch() {
        this.launchQuerySearch(0, null);
    }

    @UnsupportedAppUsage
    protected void launchQuerySearch(int actionKey, String actionMsg) {
        String query = this.mSearchAutoComplete.getText().toString();
        String action2 = "android.intent.action.SEARCH";
        Intent intent = this.createIntent(action2, null, null, query, actionKey, actionMsg);
        this.launchIntent(intent);
    }

    private void launchIntent(Intent intent) {
        if (intent == null) {
            return;
        }
        Log.d(LOG_TAG, "launching " + intent);
        try {
            this.getContext().startActivity(intent);
            this.dismiss();
        }
        catch (RuntimeException ex) {
            Log.e(LOG_TAG, "Failed launch activity: " + intent, ex);
        }
    }

    public void setListSelection(int index) {
        this.mSearchAutoComplete.setListSelection(index);
    }

    private Intent createIntent(String action2, Uri data, String extraData, String query, int actionKey, String actionMsg) {
        Intent intent = new Intent(action2);
        intent.addFlags(0x10000000);
        if (data != null) {
            intent.setData(data);
        }
        intent.putExtra("user_query", this.mUserQuery);
        if (query != null) {
            intent.putExtra("query", query);
        }
        if (extraData != null) {
            intent.putExtra("intent_extra_data_key", extraData);
        }
        if (this.mAppSearchData != null) {
            intent.putExtra("app_data", this.mAppSearchData);
        }
        if (actionKey != 0) {
            intent.putExtra("action_key", actionKey);
            intent.putExtra("action_msg", actionMsg);
        }
        intent.setComponent(this.mSearchable.getSearchActivity());
        return intent;
    }

    private boolean isEmpty(AutoCompleteTextView actv) {
        return TextUtils.getTrimmedLength(actv.getText()) == 0;
    }

    @Override
    public void onBackPressed() {
        InputMethodManager imm = this.getContext().getSystemService(InputMethodManager.class);
        if (imm != null && imm.isFullscreenMode() && imm.hideSoftInputFromWindow(this.getWindow().getDecorView().getWindowToken(), 0)) {
            return;
        }
        this.cancel();
    }

    private boolean onClosePressed() {
        if (this.isEmpty(this.mSearchAutoComplete)) {
            this.dismiss();
            return true;
        }
        return false;
    }

    private void setUserQuery(String query) {
        if (query == null) {
            query = "";
        }
        this.mUserQuery = query;
        this.mSearchAutoComplete.setText(query);
        this.mSearchAutoComplete.setSelection(query.length());
    }

    public static class SearchBar
    extends LinearLayout {
        public SearchBar(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        public SearchBar(Context context) {
            super(context);
        }

        @Override
        public ActionMode startActionModeForChild(View child, ActionMode.Callback callback2, int type) {
            if (type != 0) {
                return super.startActionModeForChild(child, callback2, type);
            }
            return null;
        }
    }
}

