/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.FastPrintWriter;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;

public abstract class PropertyInvalidatedCache<Query, Result> {
    private static final int NONCE_UNSET = 0;
    private static final int NONCE_DISABLED = 1;
    private static final int NONCE_CORKED = 2;
    private static final int NONCE_RESERVED = 3;
    private static final String[] sNonceName = new String[]{"unset", "disabled", "corked"};
    private static final String TAG = "PropertyInvalidatedCache";
    private static final boolean DEBUG = false;
    private static final boolean VERIFY = false;
    private static final boolean DETAILED = false;
    @GuardedBy(value={"mLock"})
    private long mHits = 0L;
    @GuardedBy(value={"mLock"})
    private long mMisses = 0L;
    @GuardedBy(value={"mLock"})
    private long[] mSkips = new long[]{0L, 0L, 0L};
    @GuardedBy(value={"mLock"})
    private long mMissOverflow = 0L;
    @GuardedBy(value={"mLock"})
    private long mHighWaterMark = 0L;
    @GuardedBy(value={"mLock"})
    private long mClears = 0L;
    @GuardedBy(value={"sCorkLock"})
    private static final HashMap<String, Long> sInvalidates = new HashMap();
    @GuardedBy(value={"sCorkLock"})
    private static final HashMap<String, Long> sCorkedInvalidates = new HashMap();
    private static boolean sEnabled = true;
    private static final Object sCorkLock = new Object();
    @GuardedBy(value={"sCorkLock"})
    private static final HashMap<String, Integer> sCorks = new HashMap();
    @GuardedBy(value={"sCorkLock"})
    private static final HashSet<String> sDisabledKeys = new HashSet();
    @GuardedBy(value={"sCorkLock"})
    private static final WeakHashMap<PropertyInvalidatedCache, Void> sCaches = new WeakHashMap();
    private final Object mLock = new Object();
    private final String mPropertyName;
    private volatile SystemProperties.Handle mPropertyHandle;
    private final String mCacheName;
    @GuardedBy(value={"mLock"})
    private final LinkedHashMap<Query, Result> mCache;
    @GuardedBy(value={"mLock"})
    private long mLastSeenNonce = 0L;
    private boolean mDisabled = false;
    private final int mMaxEntries;

    public PropertyInvalidatedCache(int maxEntries, String propertyName) {
        this(maxEntries, propertyName, propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyInvalidatedCache(final int maxEntries, String propertyName, String cacheName) {
        this.mPropertyName = propertyName;
        this.mCacheName = cacheName;
        this.mMaxEntries = maxEntries;
        this.mCache = new LinkedHashMap<Query, Result>(2, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                int size = this.size();
                if ((long)size > PropertyInvalidatedCache.this.mHighWaterMark) {
                    PropertyInvalidatedCache.this.mHighWaterMark = size;
                }
                if (size > maxEntries) {
                    PropertyInvalidatedCache.this.mMissOverflow++;
                    return true;
                }
                return false;
            }
        };
        Object object = sCorkLock;
        synchronized (object) {
            sCaches.put(this, null);
            if (sDisabledKeys.contains(this.mCacheName)) {
                this.disableInstance();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mLock;
        synchronized (object) {
            this.mCache.clear();
            ++this.mClears;
        }
    }

    protected abstract Result recompute(Query var1);

    protected boolean bypass(Query query) {
        return false;
    }

    protected boolean debugCompareQueryResults(Result cachedResult, Result fetchedResult) {
        if (fetchedResult != null) {
            return Objects.equals(cachedResult, fetchedResult);
        }
        return true;
    }

    protected Result refresh(Result oldResult, Query query) {
        return oldResult;
    }

    private long getCurrentNonce() {
        SystemProperties.Handle handle = this.mPropertyHandle;
        if (handle == null) {
            handle = SystemProperties.find(this.mPropertyName);
            if (handle == null) {
                return 0L;
            }
            this.mPropertyHandle = handle;
        }
        return handle.getLong(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableInstance() {
        Object object = this.mLock;
        synchronized (object) {
            this.mDisabled = true;
            this.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disableLocal(String name) {
        Object object = sCorkLock;
        synchronized (object) {
            sDisabledKeys.add(name);
            for (PropertyInvalidatedCache cache : sCaches.keySet()) {
                if (!name.equals(cache.mCacheName)) continue;
                cache.disableInstance();
            }
        }
    }

    public void disableLocal() {
        PropertyInvalidatedCache.disableLocal(this.mCacheName);
    }

    public boolean isDisabledLocal() {
        return this.mDisabled || !sEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result query(Query query) {
        long currentNonce;
        block22: {
            Result cachedResult;
            block23: {
                Result refreshedResult;
                long l = currentNonce = !this.isDisabledLocal() ? this.getCurrentNonce() : 1L;
                while (true) {
                    if (currentNonce == 1L || currentNonce == 0L || currentNonce == 2L || this.bypass(query)) {
                        if (!this.mDisabled) {
                            Object object = this.mLock;
                            synchronized (object) {
                                int n = (int)currentNonce;
                                this.mSkips[n] = this.mSkips[n] + 1L;
                            }
                        }
                        return this.recompute(query);
                    }
                    Object object = this.mLock;
                    synchronized (object) {
                        if (currentNonce == this.mLastSeenNonce) {
                            cachedResult = this.mCache.get(query);
                            if (cachedResult != null) {
                                ++this.mHits;
                            }
                        } else {
                            this.clear();
                            this.mLastSeenNonce = currentNonce;
                            cachedResult = null;
                        }
                    }
                    if (cachedResult == null) break block22;
                    refreshedResult = this.refresh(cachedResult, query);
                    if (refreshedResult == cachedResult) break block23;
                    long afterRefreshNonce = this.getCurrentNonce();
                    if (currentNonce == afterRefreshNonce) break;
                    currentNonce = afterRefreshNonce;
                }
                Object object = this.mLock;
                synchronized (object) {
                    if (currentNonce == this.mLastSeenNonce) {
                        if (refreshedResult == null) {
                            this.mCache.remove(query);
                        } else {
                            this.mCache.put(query, refreshedResult);
                        }
                    }
                }
                return this.maybeCheckConsistency(query, refreshedResult);
            }
            return this.maybeCheckConsistency(query, cachedResult);
        }
        Result result = this.recompute(query);
        Object object = this.mLock;
        synchronized (object) {
            if (this.mLastSeenNonce == currentNonce && result != null) {
                this.mCache.put(query, result);
            }
            ++this.mMisses;
        }
        return this.maybeCheckConsistency(query, result);
    }

    public void disableSystemWide() {
        PropertyInvalidatedCache.disableSystemWide(this.mPropertyName);
    }

    public static void disableSystemWide(String name) {
        if (!sEnabled) {
            return;
        }
        SystemProperties.set(name, Long.toString(1L));
    }

    public void invalidateCache() {
        PropertyInvalidatedCache.invalidateCache(this.mPropertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invalidateCache(String name) {
        if (!sEnabled) {
            return;
        }
        Object object = sCorkLock;
        synchronized (object) {
            Integer numberCorks = sCorks.get(name);
            if (numberCorks != null && numberCorks > 0) {
                long count = sCorkedInvalidates.getOrDefault(name, 0L);
                sCorkedInvalidates.put(name, count + 1L);
                return;
            }
            PropertyInvalidatedCache.invalidateCacheLocked(name);
        }
    }

    @GuardedBy(value={"sCorkLock"})
    private static void invalidateCacheLocked(String name) {
        long newValue;
        long nonce = SystemProperties.getLong(name, 0L);
        if (nonce == 1L) {
            return;
        }
        while ((newValue = NoPreloadHolder.next()) >= 0L && newValue < 3L) {
        }
        String newValueString = Long.toString(newValue);
        SystemProperties.set(name, newValueString);
        long invalidateCount = sInvalidates.getOrDefault(name, 0L);
        sInvalidates.put(name, ++invalidateCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void corkInvalidations(String name) {
        if (!sEnabled) {
            return;
        }
        Object object = sCorkLock;
        synchronized (object) {
            int numberCorks = sCorks.getOrDefault(name, 0);
            if (numberCorks == 0) {
                long nonce = SystemProperties.getLong(name, 0L);
                if (nonce != 0L && nonce != 1L) {
                    SystemProperties.set(name, Long.toString(2L));
                }
            } else {
                long count = sCorkedInvalidates.getOrDefault(name, 0L);
                sCorkedInvalidates.put(name, count + 1L);
            }
            sCorks.put(name, numberCorks + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uncorkInvalidations(String name) {
        if (!sEnabled) {
            return;
        }
        Object object = sCorkLock;
        synchronized (object) {
            int numberCorks = sCorks.getOrDefault(name, 0);
            if (numberCorks < 1) {
                throw new AssertionError((Object)("cork underflow: " + name));
            }
            if (numberCorks == 1) {
                sCorks.remove(name);
                PropertyInvalidatedCache.invalidateCacheLocked(name);
            } else {
                sCorks.put(name, numberCorks - 1);
            }
        }
    }

    protected Result maybeCheckConsistency(Query query, Result proposedResult) {
        return proposedResult;
    }

    public String cacheName() {
        return this.mCacheName;
    }

    public String queryToString(Query query) {
        return Objects.toString(query);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public static void disableForTestMode() {
        Log.d(TAG, "disabling all caches in the process");
        sEnabled = false;
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public boolean getDisabledState() {
        return this.isDisabledLocal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<PropertyInvalidatedCache> getActiveCaches() {
        Object object = sCorkLock;
        synchronized (object) {
            return new ArrayList<PropertyInvalidatedCache>(sCaches.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Map.Entry<String, Integer>> getActiveCorks() {
        Object object = sCorkLock;
        synchronized (object) {
            return new ArrayList<Map.Entry<String, Integer>>(sCorks.entrySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpContents(PrintWriter pw, String[] args) {
        long corkedInvalidates;
        long invalidateCount;
        Object object = sCorkLock;
        synchronized (object) {
            invalidateCount = sInvalidates.getOrDefault(this.mPropertyName, 0L);
            corkedInvalidates = sCorkedInvalidates.getOrDefault(this.mPropertyName, 0L);
        }
        object = this.mLock;
        synchronized (object) {
            pw.println(String.format("  Cache Name: %s", this.cacheName()));
            pw.println(String.format("    Property: %s", this.mPropertyName));
            long skips = this.mSkips[2] + this.mSkips[0] + this.mSkips[1];
            pw.println(String.format("    Hits: %d, Misses: %d, Skips: %d, Clears: %d", this.mHits, this.mMisses, skips, this.mClears));
            pw.println(String.format("    Skip-corked: %d, Skip-unset: %d, Skip-other: %d", this.mSkips[2], this.mSkips[0], this.mSkips[1]));
            pw.println(String.format("    Nonce: 0x%016x, Invalidates: %d, CorkedInvalidates: %d", this.mLastSeenNonce, invalidateCount, corkedInvalidates));
            pw.println(String.format("    Current Size: %d, Max Size: %d, HW Mark: %d, Overflows: %d", this.mCache.size(), this.mMaxEntries, this.mHighWaterMark, this.mMissOverflow));
            pw.println(String.format("    Enabled: %s", this.mDisabled ? "false" : "true"));
            pw.println("");
            Set<Map.Entry<Query, Result>> cacheEntries = this.mCache.entrySet();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpCacheInfo(FileDescriptor fd, String[] args) {
        try (FileOutputStream fout = new FileOutputStream(fd);
             FastPrintWriter pw = new FastPrintWriter(fout);){
            ArrayList<PropertyInvalidatedCache> activeCaches;
            if (!sEnabled) {
                pw.println("  Caching is disabled in this process.");
                return;
            }
            Object object = sCorkLock;
            synchronized (object) {
                activeCaches = PropertyInvalidatedCache.getActiveCaches();
                ArrayList<Map.Entry<String, Integer>> activeCorks = PropertyInvalidatedCache.getActiveCorks();
                if (activeCorks.size() > 0) {
                    pw.println("  Corking Status:");
                    for (int i = 0; i < activeCorks.size(); ++i) {
                        Map.Entry<String, Integer> entry = activeCorks.get(i);
                        pw.println(String.format("    Property Name: %s Count: %d", entry.getKey(), entry.getValue()));
                    }
                }
            }
            for (int i = 0; i < activeCaches.size(); ++i) {
                PropertyInvalidatedCache currentCache = activeCaches.get(i);
                currentCache.dumpContents(pw, args);
                ((PrintWriter)pw).flush();
            }
        }
        catch (IOException e) {
            Log.e(TAG, "Failed to dump PropertyInvalidatedCache instances");
        }
    }

    public static class AutoCorker {
        public static final int DEFAULT_AUTO_CORK_DELAY_MS = 50;
        private final String mPropertyName;
        private final int mAutoCorkDelayMs;
        private final Object mLock = new Object();
        @GuardedBy(value={"mLock"})
        private long mUncorkDeadlineMs = -1L;
        @GuardedBy(value={"mLock"})
        private Handler mHandler;

        public AutoCorker(String propertyName) {
            this(propertyName, 50);
        }

        public AutoCorker(String propertyName, int autoCorkDelayMs) {
            this.mPropertyName = propertyName;
            this.mAutoCorkDelayMs = autoCorkDelayMs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void autoCork() {
            if (Looper.getMainLooper() == null) {
                PropertyInvalidatedCache.invalidateCache(this.mPropertyName);
                return;
            }
            Object object = this.mLock;
            synchronized (object) {
                boolean alreadyQueued = this.mUncorkDeadlineMs >= 0L;
                this.mUncorkDeadlineMs = SystemClock.uptimeMillis() + (long)this.mAutoCorkDelayMs;
                if (!alreadyQueued) {
                    this.getHandlerLocked().sendEmptyMessageAtTime(0, this.mUncorkDeadlineMs);
                    PropertyInvalidatedCache.corkInvalidations(this.mPropertyName);
                } else {
                    long count = sCorkedInvalidates.getOrDefault(this.mPropertyName, 0L);
                    sCorkedInvalidates.put(this.mPropertyName, count + 1L);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleMessage(Message msg) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mUncorkDeadlineMs < 0L) {
                    return;
                }
                long nowMs = SystemClock.uptimeMillis();
                if (this.mUncorkDeadlineMs > nowMs) {
                    this.mUncorkDeadlineMs = nowMs + (long)this.mAutoCorkDelayMs;
                    this.getHandlerLocked().sendEmptyMessageAtTime(0, this.mUncorkDeadlineMs);
                    return;
                }
                this.mUncorkDeadlineMs = -1L;
                PropertyInvalidatedCache.uncorkInvalidations(this.mPropertyName);
            }
        }

        @GuardedBy(value={"mLock"})
        private Handler getHandlerLocked() {
            if (this.mHandler == null) {
                this.mHandler = new Handler(Looper.getMainLooper()){

                    @Override
                    public void handleMessage(Message msg) {
                        this.handleMessage(msg);
                    }
                };
            }
            return this.mHandler;
        }
    }

    private static class NoPreloadHolder {
        private static final AtomicLong sNextNonce = new AtomicLong(new Random().nextLong());

        private NoPreloadHolder() {
        }

        public static long next() {
            return sNextNonce.getAndIncrement();
        }
    }
}

