/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.RemoteAction;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Rational;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class PictureInPictureParams
implements Parcelable {
    private Rational mAspectRatio;
    private List<RemoteAction> mUserActions;
    private Rect mSourceRectHint;
    private Boolean mAutoEnterEnabled;
    private Boolean mSeamlessResizeEnabled;
    public static final Parcelable.Creator<PictureInPictureParams> CREATOR = new Parcelable.Creator<PictureInPictureParams>(){

        @Override
        public PictureInPictureParams createFromParcel(Parcel in) {
            return new PictureInPictureParams(in);
        }

        public PictureInPictureParams[] newArray(int size) {
            return new PictureInPictureParams[size];
        }
    };

    PictureInPictureParams() {
    }

    PictureInPictureParams(Parcel in) {
        if (in.readInt() != 0) {
            this.mAspectRatio = new Rational(in.readInt(), in.readInt());
        }
        if (in.readInt() != 0) {
            this.mUserActions = new ArrayList<RemoteAction>();
            in.readTypedList(this.mUserActions, RemoteAction.CREATOR);
        }
        if (in.readInt() != 0) {
            this.mSourceRectHint = Rect.CREATOR.createFromParcel(in);
        }
        if (in.readInt() != 0) {
            this.mAutoEnterEnabled = in.readBoolean();
        }
        if (in.readInt() != 0) {
            this.mSeamlessResizeEnabled = in.readBoolean();
        }
    }

    PictureInPictureParams(Rational aspectRatio, List<RemoteAction> actions2, Rect sourceRectHint, Boolean autoEnterEnabled, Boolean seamlessResizeEnabled) {
        this.mAspectRatio = aspectRatio;
        this.mUserActions = actions2;
        this.mSourceRectHint = sourceRectHint;
        this.mAutoEnterEnabled = autoEnterEnabled;
        this.mSeamlessResizeEnabled = seamlessResizeEnabled;
    }

    public PictureInPictureParams(PictureInPictureParams other) {
        this(other.mAspectRatio, other.mUserActions, other.hasSourceBoundsHint() ? new Rect(other.getSourceRectHint()) : null, other.mAutoEnterEnabled, other.mSeamlessResizeEnabled);
    }

    public void copyOnlySet(PictureInPictureParams otherArgs) {
        if (otherArgs.hasSetAspectRatio()) {
            this.mAspectRatio = otherArgs.mAspectRatio;
        }
        if (otherArgs.hasSetActions()) {
            this.mUserActions = otherArgs.mUserActions;
        }
        if (otherArgs.hasSourceBoundsHint()) {
            this.mSourceRectHint = new Rect(otherArgs.getSourceRectHint());
        }
        if (otherArgs.mAutoEnterEnabled != null) {
            this.mAutoEnterEnabled = otherArgs.mAutoEnterEnabled;
        }
        if (otherArgs.mSeamlessResizeEnabled != null) {
            this.mSeamlessResizeEnabled = otherArgs.mSeamlessResizeEnabled;
        }
    }

    public float getAspectRatio() {
        if (this.mAspectRatio != null) {
            return this.mAspectRatio.floatValue();
        }
        return 0.0f;
    }

    public Rational getAspectRatioRational() {
        return this.mAspectRatio;
    }

    public boolean hasSetAspectRatio() {
        return this.mAspectRatio != null;
    }

    public List<RemoteAction> getActions() {
        return this.mUserActions;
    }

    public boolean hasSetActions() {
        return this.mUserActions != null;
    }

    public void truncateActions(int size) {
        if (this.hasSetActions()) {
            this.mUserActions = this.mUserActions.subList(0, Math.min(this.mUserActions.size(), size));
        }
    }

    public Rect getSourceRectHint() {
        return this.mSourceRectHint;
    }

    public boolean hasSourceBoundsHint() {
        return this.mSourceRectHint != null && !this.mSourceRectHint.isEmpty();
    }

    public boolean isAutoEnterEnabled() {
        return this.mAutoEnterEnabled == null ? false : this.mAutoEnterEnabled;
    }

    public boolean isSeamlessResizeEnabled() {
        return this.mSeamlessResizeEnabled == null ? true : this.mSeamlessResizeEnabled;
    }

    public boolean empty() {
        return !this.hasSourceBoundsHint() && !this.hasSetActions() && !this.hasSetAspectRatio() && this.mAutoEnterEnabled != null && this.mSeamlessResizeEnabled != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PictureInPictureParams)) {
            return false;
        }
        PictureInPictureParams that = (PictureInPictureParams)o;
        return Objects.equals(this.mAutoEnterEnabled, that.mAutoEnterEnabled) && Objects.equals(this.mSeamlessResizeEnabled, that.mSeamlessResizeEnabled) && Objects.equals(this.mAspectRatio, that.mAspectRatio) && Objects.equals(this.mUserActions, that.mUserActions) && Objects.equals(this.mSourceRectHint, that.mSourceRectHint);
    }

    public int hashCode() {
        return Objects.hash(this.mAspectRatio, this.mUserActions, this.mSourceRectHint, this.mAutoEnterEnabled, this.mSeamlessResizeEnabled);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        if (this.mAspectRatio != null) {
            out.writeInt(1);
            out.writeInt(this.mAspectRatio.getNumerator());
            out.writeInt(this.mAspectRatio.getDenominator());
        } else {
            out.writeInt(0);
        }
        if (this.mUserActions != null) {
            out.writeInt(1);
            out.writeTypedList(this.mUserActions, 0);
        } else {
            out.writeInt(0);
        }
        if (this.mSourceRectHint != null) {
            out.writeInt(1);
            this.mSourceRectHint.writeToParcel(out, 0);
        } else {
            out.writeInt(0);
        }
        if (this.mAutoEnterEnabled != null) {
            out.writeInt(1);
            out.writeBoolean(this.mAutoEnterEnabled);
        } else {
            out.writeInt(0);
        }
        if (this.mSeamlessResizeEnabled != null) {
            out.writeInt(1);
            out.writeBoolean(this.mSeamlessResizeEnabled);
        } else {
            out.writeInt(0);
        }
    }

    public String toString() {
        return "PictureInPictureParams( aspectRatio=" + this.getAspectRatioRational() + " sourceRectHint=" + this.getSourceRectHint() + " hasSetActions=" + this.hasSetActions() + " isAutoPipEnabled=" + this.isAutoEnterEnabled() + " isSeamlessResizeEnabled=" + this.isSeamlessResizeEnabled() + ")";
    }

    public static class Builder {
        private Rational mAspectRatio;
        private List<RemoteAction> mUserActions;
        private Rect mSourceRectHint;
        private Boolean mAutoEnterEnabled;
        private Boolean mSeamlessResizeEnabled;

        public Builder setAspectRatio(Rational aspectRatio) {
            this.mAspectRatio = aspectRatio;
            return this;
        }

        public Builder setActions(List<RemoteAction> actions2) {
            if (this.mUserActions != null) {
                this.mUserActions = null;
            }
            if (actions2 != null) {
                this.mUserActions = new ArrayList<RemoteAction>(actions2);
            }
            return this;
        }

        public Builder setSourceRectHint(Rect launchBounds) {
            this.mSourceRectHint = launchBounds == null ? null : new Rect(launchBounds);
            return this;
        }

        public Builder setAutoEnterEnabled(boolean autoEnterEnabled) {
            this.mAutoEnterEnabled = autoEnterEnabled;
            return this;
        }

        public Builder setSeamlessResizeEnabled(boolean seamlessResizeEnabled) {
            this.mSeamlessResizeEnabled = seamlessResizeEnabled;
            return this;
        }

        public PictureInPictureParams build() {
            PictureInPictureParams params = new PictureInPictureParams(this.mAspectRatio, this.mUserActions, this.mSourceRectHint, this.mAutoEnterEnabled, this.mSeamlessResizeEnabled);
            return params;
        }
    }
}

