/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.RequiresPermission;
import android.app.IGameManagerService;
import android.content.Context;
import android.os.Handler;
import android.os.RemoteException;
import android.os.ServiceManager;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class GameManager {
    private static final String TAG = "GameManager";
    private final Context mContext;
    private final IGameManagerService mService;
    public static final int GAME_MODE_UNSUPPORTED = 0;
    public static final int GAME_MODE_STANDARD = 1;
    public static final int GAME_MODE_PERFORMANCE = 2;
    public static final int GAME_MODE_BATTERY = 3;

    GameManager(Context context, Handler handler) throws ServiceManager.ServiceNotFoundException {
        this.mContext = context;
        this.mService = IGameManagerService.Stub.asInterface(ServiceManager.getServiceOrThrow("game"));
    }

    public int getGameMode() {
        try {
            return this.mService.getGameMode(this.mContext.getPackageName(), this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_GAME_MODE")
    public int getGameMode(String packageName) {
        try {
            return this.mService.getGameMode(packageName, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_GAME_MODE")
    public void setGameMode(String packageName, int gameMode) {
        try {
            this.mService.setGameMode(packageName, gameMode, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_GAME_MODE")
    public int[] getAvailableGameModes(String packageName) {
        try {
            return this.mService.getAvailableGameModes(packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface GameMode {
    }
}

