/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.app.Activity;
import android.app.ActivityOptions;
import android.app.ActivityTransitionCoordinator;
import android.app.SharedElementCallback;
import android.content.Intent;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.ResultReceiver;
import android.transition.Transition;
import android.transition.TransitionListenerAdapter;
import android.transition.TransitionManager;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import com.android.internal.view.OneShotPreDrawListener;
import java.util.ArrayList;

public class ExitTransitionCoordinator
extends ActivityTransitionCoordinator {
    private static final String TAG = "ExitTransitionCoordinator";
    static long sMaxWaitMillis = 1000L;
    private Bundle mSharedElementBundle;
    private boolean mExitNotified;
    private boolean mSharedElementNotified;
    private ExitTransitionCallbacks mExitCallbacks;
    private boolean mIsBackgroundReady;
    private boolean mIsCanceled;
    private Handler mHandler;
    private ObjectAnimator mBackgroundAnimator;
    private boolean mIsHidden;
    private Bundle mExitSharedElementBundle;
    private boolean mIsExitStarted;
    private boolean mSharedElementsHidden;

    public ExitTransitionCoordinator(ExitTransitionCallbacks exitCallbacks, Window window, SharedElementCallback listener2, ArrayList<String> names, ArrayList<String> accepted, ArrayList<View> mapped, boolean isReturning) {
        super(window, names, listener2, isReturning);
        this.viewsReady(this.mapSharedElements(accepted, mapped));
        this.stripOffscreenViews();
        this.mIsBackgroundReady = !isReturning;
        this.mExitCallbacks = exitCallbacks;
    }

    @Override
    protected void onReceiveResult(int resultCode, Bundle resultData) {
        switch (resultCode) {
            case 100: {
                this.stopCancel();
                this.mResultReceiver = (ResultReceiver)resultData.getParcelable("android:remoteReceiver");
                if (this.mIsCanceled) {
                    this.mResultReceiver.send(106, null);
                    this.mResultReceiver = null;
                    break;
                }
                this.notifyComplete();
                break;
            }
            case 101: {
                this.stopCancel();
                if (this.mIsCanceled) break;
                this.hideSharedElements();
                break;
            }
            case 105: {
                this.mHandler.removeMessages(106);
                this.startExit();
                break;
            }
            case 107: {
                this.mExitSharedElementBundle = resultData;
                this.sharedElementExitBack();
                break;
            }
            case 106: {
                this.mIsCanceled = true;
                this.finish();
            }
        }
    }

    private void stopCancel() {
        if (this.mHandler != null) {
            this.mHandler.removeMessages(106);
        }
    }

    private void delayCancel() {
        if (this.mHandler != null) {
            this.mHandler.sendEmptyMessageDelayed(106, sMaxWaitMillis);
        }
    }

    public void resetViews() {
        ViewGroup decorView = this.getDecor();
        if (decorView != null) {
            TransitionManager.endTransitions(decorView);
        }
        if (this.mTransitioningViews != null) {
            this.showViews(this.mTransitioningViews, true);
            this.setTransitioningViewsVisiblity(0, true);
        }
        this.showViews(this.mSharedElements, true);
        this.mIsHidden = true;
        if (!this.mIsReturning && decorView != null) {
            decorView.suppressLayout(false);
        }
        this.moveSharedElementsFromOverlay();
        this.clearState();
    }

    private void sharedElementExitBack() {
        final ViewGroup decorView = this.getDecor();
        if (decorView != null) {
            decorView.suppressLayout(true);
        }
        if (decorView != null && this.mExitSharedElementBundle != null && !this.mExitSharedElementBundle.isEmpty() && !this.mSharedElements.isEmpty() && this.getSharedElementTransition() != null) {
            this.startTransition(new Runnable(){

                @Override
                public void run() {
                    ExitTransitionCoordinator.this.startSharedElementExit(decorView);
                }
            });
        } else {
            this.sharedElementTransitionComplete();
        }
    }

    private void startSharedElementExit(ViewGroup decorView) {
        Transition transition2 = this.getSharedElementExitTransition();
        transition2.addListener(new TransitionListenerAdapter(){

            @Override
            public void onTransitionEnd(Transition transition2) {
                transition2.removeListener(this);
                if (ExitTransitionCoordinator.this.isViewsTransitionComplete()) {
                    ExitTransitionCoordinator.this.delayCancel();
                }
            }
        });
        ArrayList<View> sharedElementSnapshots = this.createSnapshots(this.mExitSharedElementBundle, this.mSharedElementNames);
        OneShotPreDrawListener.add(decorView, () -> this.setSharedElementState(this.mExitSharedElementBundle, sharedElementSnapshots));
        this.setGhostVisibility(4);
        this.scheduleGhostVisibilityChange(4);
        if (this.mListener != null) {
            this.mListener.onSharedElementEnd(this.mSharedElementNames, this.mSharedElements, sharedElementSnapshots);
        }
        TransitionManager.beginDelayedTransition(decorView, transition2);
        this.scheduleGhostVisibilityChange(0);
        this.setGhostVisibility(0);
        decorView.invalidate();
    }

    private void hideSharedElements() {
        this.moveSharedElementsFromOverlay();
        if (this.mExitCallbacks != null) {
            this.mExitCallbacks.hideSharedElements();
        }
        if (!this.mIsHidden) {
            this.hideViews(this.mSharedElements);
        }
        this.mSharedElementsHidden = true;
        this.finishIfNecessary();
    }

    public void startExit() {
        if (!this.mIsExitStarted) {
            this.backgroundAnimatorComplete();
            this.mIsExitStarted = true;
            this.pauseInput();
            ViewGroup decorView = this.getDecor();
            if (decorView != null) {
                decorView.suppressLayout(true);
            }
            this.moveSharedElementsToOverlay();
            this.startTransition(this::beginTransitions);
        }
    }

    public void startExit(Activity activity) {
        int resultCode = activity.mResultCode;
        Intent data = activity.mResultData;
        if (!this.mIsExitStarted) {
            this.mIsExitStarted = true;
            this.pauseInput();
            ViewGroup decorView = this.getDecor();
            if (decorView != null) {
                decorView.suppressLayout(true);
            }
            this.mHandler = new Handler(){

                @Override
                public void handleMessage(Message msg) {
                    ExitTransitionCoordinator.this.mIsCanceled = true;
                    ExitTransitionCoordinator.this.finish();
                }
            };
            this.delayCancel();
            this.moveSharedElementsToOverlay();
            if (decorView != null && decorView.getBackground() == null) {
                this.getWindow().setBackgroundDrawable(new ColorDrawable(0));
            }
            boolean targetsM = decorView == null || decorView.getContext().getApplicationInfo().targetSdkVersion >= 23;
            ArrayList sharedElementNames = targetsM ? this.mSharedElementNames : this.mAllSharedElementNames;
            ActivityOptions options = ActivityOptions.makeSceneTransitionAnimation(activity, this, sharedElementNames, resultCode, data);
            activity.convertToTranslucent(new Activity.TranslucentConversionListener(){

                @Override
                public void onTranslucentConversionComplete(boolean drawComplete) {
                    if (!ExitTransitionCoordinator.this.mIsCanceled) {
                        ExitTransitionCoordinator.this.fadeOutBackground();
                    }
                }
            }, options);
            this.startTransition(this::startExitTransition);
        }
    }

    public void stop(Activity activity) {
        if (this.mIsReturning && this.mExitCallbacks != null) {
            activity.convertToTranslucent(null, null);
            this.finish();
        }
    }

    private void startExitTransition() {
        Transition transition2 = this.getExitTransition();
        ViewGroup decorView = this.getDecor();
        if (transition2 != null && decorView != null && this.mTransitioningViews != null) {
            this.setTransitioningViewsVisiblity(0, false);
            TransitionManager.beginDelayedTransition(decorView, transition2);
            this.setTransitioningViewsVisiblity(4, false);
            decorView.invalidate();
        } else {
            this.transitionStarted();
        }
    }

    private void fadeOutBackground() {
        if (this.mBackgroundAnimator == null) {
            Drawable background;
            ViewGroup decor = this.getDecor();
            if (decor != null && (background = decor.getBackground()) != null) {
                background = background.mutate();
                this.getWindow().setBackgroundDrawable(background);
                this.mBackgroundAnimator = ObjectAnimator.ofInt((Object)background, "alpha", 0);
                this.mBackgroundAnimator.addListener(new AnimatorListenerAdapter(){

                    @Override
                    public void onAnimationEnd(Animator animation) {
                        ExitTransitionCoordinator.this.mBackgroundAnimator = null;
                        if (!ExitTransitionCoordinator.this.mIsCanceled) {
                            ExitTransitionCoordinator.this.mIsBackgroundReady = true;
                            ExitTransitionCoordinator.this.notifyComplete();
                        }
                        ExitTransitionCoordinator.this.backgroundAnimatorComplete();
                    }
                });
                this.mBackgroundAnimator.setDuration(this.getFadeDuration());
                this.mBackgroundAnimator.start();
            } else {
                this.backgroundAnimatorComplete();
                this.mIsBackgroundReady = true;
            }
        }
    }

    private Transition getExitTransition() {
        Transition viewsTransition = null;
        if (this.mTransitioningViews != null && !this.mTransitioningViews.isEmpty()) {
            viewsTransition = this.configureTransition(this.getViewsTransition(), true);
            ExitTransitionCoordinator.removeExcludedViews(viewsTransition, this.mTransitioningViews);
            if (this.mTransitioningViews.isEmpty()) {
                viewsTransition = null;
            }
        }
        if (viewsTransition == null) {
            this.viewsTransitionComplete();
        } else {
            final ArrayList transitioningViews = this.mTransitioningViews;
            viewsTransition.addListener(new ActivityTransitionCoordinator.ContinueTransitionListener(){

                @Override
                public void onTransitionEnd(Transition transition2) {
                    ExitTransitionCoordinator.this.viewsTransitionComplete();
                    if (ExitTransitionCoordinator.this.mIsHidden && transitioningViews != null) {
                        ExitTransitionCoordinator.this.showViews(transitioningViews, true);
                        ExitTransitionCoordinator.this.setTransitioningViewsVisiblity(0, true);
                    }
                    if (ExitTransitionCoordinator.this.mSharedElementBundle != null) {
                        ExitTransitionCoordinator.this.delayCancel();
                    }
                    super.onTransitionEnd(transition2);
                }
            });
        }
        return viewsTransition;
    }

    private Transition getSharedElementExitTransition() {
        Transition sharedElementTransition = null;
        if (!this.mSharedElements.isEmpty()) {
            sharedElementTransition = this.configureTransition(this.getSharedElementTransition(), false);
        }
        if (sharedElementTransition == null) {
            this.sharedElementTransitionComplete();
        } else {
            sharedElementTransition.addListener(new ActivityTransitionCoordinator.ContinueTransitionListener(){

                @Override
                public void onTransitionEnd(Transition transition2) {
                    ExitTransitionCoordinator.this.sharedElementTransitionComplete();
                    if (ExitTransitionCoordinator.this.mIsHidden) {
                        ExitTransitionCoordinator.this.showViews(ExitTransitionCoordinator.this.mSharedElements, true);
                    }
                    super.onTransitionEnd(transition2);
                }
            });
            ((View)this.mSharedElements.get(0)).invalidate();
        }
        return sharedElementTransition;
    }

    private void beginTransitions() {
        Transition sharedElementTransition = this.getSharedElementExitTransition();
        Transition viewsTransition = this.getExitTransition();
        Transition transition2 = ExitTransitionCoordinator.mergeTransitions(sharedElementTransition, viewsTransition);
        ViewGroup decorView = this.getDecor();
        if (transition2 != null && decorView != null) {
            this.setGhostVisibility(4);
            this.scheduleGhostVisibilityChange(4);
            if (viewsTransition != null) {
                this.setTransitioningViewsVisiblity(0, false);
            }
            TransitionManager.beginDelayedTransition(decorView, transition2);
            this.scheduleGhostVisibilityChange(0);
            this.setGhostVisibility(0);
            if (viewsTransition != null) {
                this.setTransitioningViewsVisiblity(4, false);
            }
            decorView.invalidate();
        } else {
            this.transitionStarted();
        }
    }

    protected boolean isReadyToNotify() {
        return this.mSharedElementBundle != null && this.mResultReceiver != null && this.mIsBackgroundReady;
    }

    @Override
    protected void sharedElementTransitionComplete() {
        this.mSharedElementBundle = this.mExitSharedElementBundle == null ? this.captureSharedElementState() : this.captureExitSharedElementsState();
        super.sharedElementTransitionComplete();
    }

    private Bundle captureExitSharedElementsState() {
        Bundle bundle = new Bundle();
        RectF bounds2 = new RectF();
        Matrix matrix = new Matrix();
        for (int i = 0; i < this.mSharedElements.size(); ++i) {
            String name = (String)this.mSharedElementNames.get(i);
            Bundle sharedElementState = this.mExitSharedElementBundle.getBundle(name);
            if (sharedElementState != null) {
                bundle.putBundle(name, sharedElementState);
                continue;
            }
            View view = (View)this.mSharedElements.get(i);
            this.captureSharedElementState(view, name, bundle, matrix, bounds2);
        }
        return bundle;
    }

    @Override
    protected void onTransitionsComplete() {
        this.notifyComplete();
    }

    protected void notifyComplete() {
        if (this.isReadyToNotify()) {
            if (!this.mSharedElementNotified) {
                this.mSharedElementNotified = true;
                this.delayCancel();
                if (this.mExitCallbacks.isReturnTransitionAllowed()) {
                    this.mResultReceiver.send(108, null);
                }
                if (this.mListener == null) {
                    this.mResultReceiver.send(103, this.mSharedElementBundle);
                    this.notifyExitComplete();
                } else {
                    final ResultReceiver resultReceiver = this.mResultReceiver;
                    final Bundle sharedElementBundle = this.mSharedElementBundle;
                    this.mListener.onSharedElementsArrived(this.mSharedElementNames, this.mSharedElements, new SharedElementCallback.OnSharedElementsReadyListener(){

                        @Override
                        public void onSharedElementsReady() {
                            resultReceiver.send(103, sharedElementBundle);
                            ExitTransitionCoordinator.this.notifyExitComplete();
                        }
                    });
                }
            } else {
                this.notifyExitComplete();
            }
        }
    }

    private void notifyExitComplete() {
        if (!this.mExitNotified && this.isViewsTransitionComplete()) {
            this.mExitNotified = true;
            this.mResultReceiver.send(104, null);
            this.mResultReceiver = null;
            ViewGroup decorView = this.getDecor();
            if (!this.mIsReturning && decorView != null) {
                decorView.suppressLayout(false);
            }
            this.finishIfNecessary();
        }
    }

    private void finishIfNecessary() {
        if (this.mIsReturning && this.mExitNotified && this.mExitCallbacks != null && (this.mSharedElements.isEmpty() || this.mSharedElementsHidden)) {
            this.finish();
        }
    }

    private void finish() {
        this.stopCancel();
        if (this.mExitCallbacks != null) {
            this.mExitCallbacks.onFinish();
            this.mExitCallbacks = null;
        }
        this.clearState();
    }

    @Override
    protected void clearState() {
        this.mHandler = null;
        this.mSharedElementBundle = null;
        if (this.mBackgroundAnimator != null) {
            this.mBackgroundAnimator.cancel();
            this.mBackgroundAnimator = null;
        }
        this.mExitSharedElementBundle = null;
        super.clearState();
    }

    @Override
    protected boolean moveSharedElementWithParent() {
        return !this.mIsReturning;
    }

    @Override
    protected Transition getViewsTransition() {
        if (this.mIsReturning) {
            return this.getWindow().getReturnTransition();
        }
        return this.getWindow().getExitTransition();
    }

    protected Transition getSharedElementTransition() {
        if (this.mIsReturning) {
            return this.getWindow().getSharedElementReturnTransition();
        }
        return this.getWindow().getSharedElementExitTransition();
    }

    public static class ActivityExitTransitionCallbacks
    implements ExitTransitionCallbacks {
        final Activity mActivity;

        ActivityExitTransitionCallbacks(Activity activity) {
            this.mActivity = activity;
        }

        @Override
        public boolean isReturnTransitionAllowed() {
            return true;
        }

        @Override
        public void onFinish() {
            this.mActivity.mActivityTransitionState.clear();
            this.mActivity.finish();
            this.mActivity.overridePendingTransition(0, 0);
        }
    }

    public static interface ExitTransitionCallbacks {
        public boolean isReturnTransitionAllowed();

        public void onFinish();

        default public void hideSharedElements() {
        }
    }
}

